META
key;value
description;District PB in Warszawa, Bielany
country;Poland
unit;Warszawa
district;Bielany
subunit;Bielany
instance;2024
num_projects;100
num_votes;5501
budget;5274211
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
16;750000;1913;Mniej betonu - więcej zieleni;environmental protection,public space,urban greenery;children,seniors;1;52.28079327711806;20.9426815737817
1468;500000;1907;Zielone płuca dla Bielan;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.276341200000005;20.948075206894508
1434;998000;1735;Doświetlenie przejść dla pieszych na całych Bielanach oraz oświetlenie przystanków tramwajowych: Aspekt, Reymonta, Piaski, Popiela, Bogusławskiego;public transit and roads,public space;children,seniors;1;52.280864208539036;20.937203019931708
13;980000;1657;Zielony budżet dla Bielan – 100 tys. kwiatów, przegląd i pielęgnacja istniejących nasadzeń;environmental protection,urban greenery;children,seniors;1;52.28010387703466;20.94214993689093
1624;500000;1560;Więcej zieleni - drzewa, krzewy i kwiaty na Bielanach;environmental protection,public space,urban greenery;children,seniors;1;;
702;875000;1232;Remont ścieżki rowerowej i chodnika wzdłuż Broniewskiego;public transit and roads,public space,sport;children,seniors;1;52.26873935059535;20.956520462350458
1700;990000;1209;Bezpłatne pływanie w wakacje oraz remont pomieszczeń na pływalni CRS Bielany;sport;children,seniors;0;52.28018755;20.9366167790739
443;85000;1146;Chronimy ptaki bielańskich parków i skwerów - konserwacja i zawieszenie nowych skrzynek lęgowych;environmental protection;;1;52.27808229910546;20.945599460930882
1510;800000;1109;Toaleta publiczna na Bielanach;environmental protection,public space,urban greenery;children,seniors;0;52.28816508084278;20.979337692260746
140;635000;1090;Więcej energooszczędnych latarni na Bielanach;environmental protection,public space;children,seniors;0;52.275187929839674;20.94991836595
265;932500;1069;Przyjazna Wólczyńska - szerokie chodniki tylko dla pieszych, ozdobne krzewy;public transit and roads,public space,urban greenery;children,seniors;0;52.280303045016325;20.92653274514305
982;249000;1025;Zakup nowości do bielańskich bibliotek;education,culture;children,seniors;1;52.2800205375;20.940646635135217
1;800000;1013;Bielany wygodne dla rowerzystów – stojaki, wiaty, podpórki, stacje naprawcze i warsztaty dobrego dbania o rower #bielanynarower;public transit and roads,public space;children,seniors;0;52.2813794897571;20.949408530927034
1451;150000;1013;Bielany dbają o zwierzęta;education,public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.28068102949185;20.966077203631933
1524;1050000;1012;Remont ścieżki rowerowej i chodnika na ul. Conrada;public transit and roads,public space;children,seniors;0;52.27343587436672;20.924363403155837
1322;250000;957;Rozbudowa monitoringu miejskiego na Bielanach;public space;children,seniors;0;;
776;130000;949;Zielone przystanki;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.28041944825287;20.945066450895297
1026;984000;948;Conrada (Brązownicza-Reymonta) - remont drogi dla rowerów;public transit and roads,public space,sport;children,seniors;0;52.271877696201145;20.92806994915009
1581;200000;944;Dziura po zimie sama nie zginie - remonty bielańskich ulic;public transit and roads,public space;children,seniors;0;;
1325;250000;925;100 nowych koszy na śmieci dla Bielan;public space;children,seniors;0;;
376;200000;910;Kawiarenka naprawcza zero waste. Nie wyrzucaj - napraw;education,environmental protection;children,seniors;0;52.273541439727495;20.950895547866825
1633;39350;896;Drzewa i krzewy przy ulicy Marymonckiej;environmental protection,public space,urban greenery;children,seniors;1;52.2822188437531;20.95723628997803
1559;250000;888;Park kieszonkowy przy ul. J. Conrada;education,environmental protection,public space,urban greenery;children,seniors;0;52.270843131188165;20.928648903495993
1698;502600;878;Bielany - w dobrej formie. Cykl bezpłatnych zajęć zumba, samoobrona, aqua-aerobic, siłownia, boks, fitness, tenis stołowy, badminton, gry zespołowe dla mieszkańców;sport;children,seniors;0;52.28018755;20.9366167790739
1328;950395;874;Zielona aleja spacerowa wzdłuż ul. Wólczyńskiej;public transit and roads,public space,urban greenery;children,seniors;0;52.28015783079021;20.928997993469242
1517;942500;872;Remont ścieżki rowerowej i chodnika - Broniewskiego;public transit and roads,sport;children,seniors;0;52.271190614542554;20.947429984375564
1441;91350;864;Koncerty, warsztaty, potańcówki na Bielanach;education,culture,welfare,sport;children,seniors;0;52.29054065;20.941679903968016
17;85300;861;Kino plenerowe;education,culture;children,seniors;0;52.2837994210485;20.950034752080686
774;350000;858;W kwiatów powodzi - Łąki bylinowe na Bielanach 2;education,environmental protection,public space,urban greenery;children,seniors;0;52.276341200000005;20.948075206894508
1482;130000;834;Ekologiczne wiaty przystankowe na Bielanach;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.2844874;20.9559862
192;360000;833;Remont placu zabaw na Starych Bielanach;education,culture,environmental protection,public space,sport,urban greenery;children,seniors;0;52.27890319706347;20.94972121179176
451;350000;811;Park Kieszonkowy przy Metrze Młociny;environmental protection,public space,urban greenery;children,seniors;0;52.29121131129703;20.932087898254398
373;21550;795;Kurs samoobrony dla kobiet;education,welfare,public space,sport;seniors;0;52.2878416;20.943563601911308
1526;303670;776;Zielone ulice Chomiczówki: Conrada, Bogusławskiego, Kwitnąca, Aspekt, M. Dąbrowskiej, Renesansowa, Brązownicza, Wólczyńska;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.27559182857143;20.925787928571427
1344;980000;773;Stare mogą więcej - zadbajmy o starodrzew wokół bielańskich szkół i przedszkoli;education,environmental protection,public space,urban greenery;children;0;52.284850757142856;20.93828847142857
1021;1050000;747;Conrada (Wólczyńska-Conrada 21) - remont drogi dla rowerów i chodnika;public transit and roads,public space,sport;children,seniors;0;52.27946394820291;20.923132896423343
174;600000;735;Odnowienie punktu widokowego przy polanie – przystępny dla mieszkańców Las Młociny;education,environmental protection;children,seniors;0;52.310787583866166;20.930002212262483
1347;480000;733;Niedaleko od szosy - zadbajmy o przydrożne bielańskie drzewa;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;;
24;83400;716;Drzewa na Romaszewskiego;urban greenery;children,seniors;0;52.2754767;20.9589158
129;600000;712;Miasteczko ruchu drogowego na Bielanach;education,public space;children;0;52.295462231849996;20.889472606089704
124;625000;709;Bezpieczny i komfortowy Park Olszyna;public transit and roads,public space,sport,urban greenery;children,seniors;0;52.2712520594648;20.9579711086212
268;75000;709;Poidło parkowe - Kępa Potocka;education,environmental protection,public space,sport,urban greenery;children,seniors;0;52.28796117865637;20.978417681324668
1509;150000;706;Zielona Chomiczówka - więcej kwitnących drzew, krzewów i bylin!;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.275057016194076;20.924278871250845
1604;386000;705;Aleje parkowe i zielone skwery Bielan-nowe chodniki zamiast przedeptów wraz z obsadzeniem ich szpalerami dużych drzew;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.277302725;20.943783175
984;35000;702;Audiobooki w bibliotece;education,culture;children,seniors;0;52.281532549999994;20.95534395
1119;700000;676;Naturalny plac zabaw w Lesie Młociny (Parku Młocińskim) - rewitalizacja;education,environmental protection,urban greenery;children,seniors;0;52.32011158208543;20.919206197099474
1314;700000;670;Zielone podwórko na Starych Bielanach;environmental protection,public space,urban greenery;seniors;0;52.280036965813;20.942142935711
1532;75000;652;Pętla Chomiczówka pełna zieleni;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.27768574432281;20.91753530742659
173;600000;642;Kładka i punkt widokowy – przystępny dla mieszkańców Las Młociny;education,environmental protection;children,seniors;0;52.31669062768948;20.92801094055176
741;750000;613;Dbamy o Park Olszyna;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;0;52.270356805124266;20.957893753366083
1332;201500;602;Wrzutnie na książki przy bielańskich bibliotekach;education,culture,public space;children,seniors;0;52.281633671428565;20.949578564678273
22;195000;601;Książkomat na Bielanach;education;children,seniors;0;52.2743676;20.9580197
1110;126500;581;Ocalmy stare lipy w Parku Młocińskim cz. 2;education,environmental protection,urban greenery;children,seniors;0;;
3;575000;555;Naturalny wybieg dla psów przy Stawach Kellera;public space;children,seniors;0;52.2774809042654;20.969166755676273
394;29000;546;Zajęcia stolarskie dla pań, dzieci i rodzin na Bielanach;education,culture,environmental protection;children,seniors;0;;
1359;160000;530;Bezpieczna ulica Kwitnąca - Cmentarz Wawrzyszewski - wyniesione przejście dla pieszych;public transit and roads,public space;children,seniors;0;52.27794179859362;20.92802810642752
1338;370000;527;Strefa fitness na Bielanach - Profesjonalna siłownia plenerowa ze zmiennym obciążeniem;education,public space,sport;children,seniors;0;52.27124357830981;20.958920717239383
1470;680000;525;Modernizacja placu zabaw przy Szkole Podstawowej nr 273;education,public space,sport,urban greenery;children,seniors;0;52.292406400000004;20.933871212014715
2;265000;517;Sobotnie targi wieczorowe z potańcówką przy Urzędzie Dzielnicy Bielany;culture;children,seniors;0;52.27599874046306;20.948756217694612
917;40000;505;Nowe miejsca parkingowe dla mieszkańców w miejscu postojów taksówek;public transit and roads,public space;seniors;0;52.276632562704066;20.93737125068191
988;22000;457;Zakup książek z dużymi literami;education,culture;children,seniors;0;52.2743676;20.9580197
1261;65000;430;Klasa pod chmurką w SP 80;education,public space,sport;children;0;52.27587845;20.931107026022552
834;100000;425;Boisko do siatkówki plażowej na Bielanach;sport;children,seniors;0;52.29582968248228;20.889645400421983
826;153500;395;Zieleń przy Marymonckiej odc. Przy Agorze- Dorycka;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.29680078733552;20.94324588775635
408;385000;391;Mała lekkoatletyka na Wrzecionie - modernizacja bieżni oraz piaskownicy do skoku w dal w Szkole Podstawowej nr 263 przy ul. Szegedyńskiej 11;sport;children,seniors;0;52.291509000000005;20.943169462811433
947;408000;377;Bezpłatne warsztaty na Bielanach dla dorosłych, młodzieży i dzieci – potańcówki, koncerty, gry miejskie, działania w przyrodzie, pikniki, zajęcia rozwojowe, sportowe, artystyczne i inne;education,culture,environmental protection,welfare,sport;children,seniors;0;52.2965987875;20.9221349107676
512;548000;374;LaLiga Wrzeciono - Modernizacja boiska do piłki nożnej w SP Nr 263 przy ul. Szegedyńskiej 11 w Warszawie;sport;children,seniors;0;52.2914882;20.942839821024357
586;74280;370;Snookerowa Szkoła. Snooker w Szkole Podstawowej nr 187;education,culture,sport;children;0;52.274108299999995;20.95667226927288
444;30000;359;Gry na konsole, muzyka i filmy w Mediatece Start-Meta;education,culture;children,seniors;0;52.2915095;20.9415614
1533;108000;357;Nowe przejście dla pieszych na Conrada;public transit and roads,public space;children,seniors;0;52.270789316671184;20.931379795074466
865;15500;352;Spektakle teatralne w Bibliotece dla Dzieci i Młodzieży Nr 26;education,culture;children;1;52.274381211092546;20.958137512207035
1384;100000;343;Street workout chomiczówka;education,culture,public space,sport;seniors;0;52.2775229977183;20.927547454048185
36;77760;342;Rowerowa Rewolucja;education,environmental protection,sport;children,seniors;0;52.278455870699545;20.949372971413794
1312;192770;341;SOS Ósmoklasisty - darmowe grupowe zajęcia przed egzaminem ósmoklasisty 2024;education,culture;children;0;52.286873799999995;20.956142492920932
1608;43380;328;Szachy na Bielanach;education,culture,public space;children;0;52.2722648;20.938762211830735
1330;146300;318;Park kieszonkowy przy ul. Horacego;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;0;52.28105051393566;20.928869247436527
382;490000;304;Plac zabaw u Powstańców - modernizacja placu zabaw przy SP nr 263;sport;children,seniors;0;52.2914882;20.942839821024357
223;43300;285;Bielańskie Lekcje Zdrowego Żywienia- warsztaty dla uczniów szkół podstawowych;education;children;0;52.27631675;20.94104957335483
733;8000;282;Klub Gier Wszelakich;culture;children;0;52.2848048373593;20.935649871826175
1295;179000;269;SOS Maturzysty - darmowe grupowe zajęcia przed maturą 2024;education;children;0;52.2869769;20.9559221558787
1388;140000;268;Poprawa bezpieczeństwa na wybiegu dla psów przy skrzyżowaniu Reymonta i Kasprowicza oraz warsztaty z behawiorystą na bielańskich wybiegach;education,welfare,public space;children,seniors;0;52.2826118;20.9401934
896;55000;262;Spotkania z psychologami i zakup książek o tematyce psychologicznej do Czytelni Naukowej nr II na Bielanach;education,culture;seniors;0;52.282954675;20.949809411780585
211;30000;247;Spotkania z pisarkami i pisarzami w bielańskich Bibliotekach;culture,public space;seniors;0;52.274999853649064;20.960243269873047
556;13500;242;Zajęcia Nordic Walking na Bielanach z instruktorem w Puszczy Kampinoskiej;education,sport;children,seniors;0;52.300396314518785;20.882477760314945
409;9200;196;W krainie zmysłów – książki i zabawki sensoryczne dla biblioteki;education,culture,public space;children;0;52.2711388;20.9500245
554;33160;189;Rodzinne warsztaty bliskości dla dzieci i dla dorosłych w Filii BOK Estrady 112;education,culture;children,seniors;0;52.300350798150056;20.882477760314945
867;9500;188;O Warszawie w Bibliotece. Warsztaty varsavianistyczne prowadzone przez licencjonowanego przewodnika po Warszawie w Bibliotece dla Dzieci i Młodzieży Nr 26;education,culture;children;0;52.274250325829954;20.958158969879154
995;33000;186;Moje hobby, moje pasje - książki i warsztaty w Bibliotece;culture;children,seniors;0;52.2743676;20.9580197
1416;210000;185;Impreza dla Mieszkańców Chomiczówki;culture,environmental protection,welfare,public space,sport;children,seniors;0;52.27552740486945;20.931281088996915
1706;60000;182;Tablice informacyjne o 100 letniej historii Lasku Bielańskiego dziś Lindego 1918-2018;education,culture,public space,urban greenery;children,seniors;0;52.289668;20.9498895
297;50000;180;Oddajmy chodnik pieszym - montaż stoperów parkingowych przy ul. Książąt Mazowieckich;public transit and roads,public space;children,seniors;0;52.30177670960399;20.930993556976322
584;10200;177;Fantastyczny Klub Hobbystyczny: darmowe gry planszowe, figurkowe, warsztaty plastyczne;culture;children;0;;
828;14670;173;Zdrowie i witalność dla każdego - Slow Jogging bieganie z uśmiechem;education,sport;seniors;0;52.28905757829016;20.948824882507328
863;20500;167;Spotkania autorskie i warsztaty z ilustratorami w Bibliotece dla Dzieci i Młodzieży Nr 26;education,culture;children;0;52.27427658497318;20.958158969879154
23;110000;166;Festyn Kultury Ukraińskiej;education,culture;children,seniors;0;52.274108299999995;20.95667226927288
568;95000;165;Rozwijamy talenty – zakup komputerów wraz z artystycznym oprogramowaniem do nowoczesnej pracowni dla dzieci i młodzieży w Mediatece Start – Meta;education,culture;children;0;52.2915095;20.9415614
550;4750;159;Nowe gry planszowe i edukacyjne w Filii BOK Estrady 112;education,culture;children,seniors;0;52.3003704;20.882582859447446
860;5200;149;Warsztaty origami w Bibliotece dla Dzieci i Młodzieży Nr 26;education,culture;children;0;52.274250325829954;20.958116054534916
1487;48800;119;Warsztaty rękodzieła artystycznego w Szkole Podstawowej nr 289;education,culture,public space;children,seniors;0;52.2722648;20.938762211830735
659;8300;52;Czytana przyroda - zakup kompletu wypoczynkowego i książek związanych z przyrodą i ekologią;education,culture,environmental protection,public space;children,seniors;0;52.3003704;20.882582859447446
VOTES
voter_id;vote;age;sex
15;1624,1119,1338,382,834,373,1698,174,1633,1468,22,192,376,1470,3;35;F
57;1470;39;M
68;192;36;M
69;1344,1,1325,826,1517,1021,1526,1524,1509,1026,1328,265,1559,1434,140;39;M
71;1581,995,173,211,1706,17,1119,1325,1,982,1332,1700,702,1698,1470;35;F
76;1624,774,451,1021,1322,1,1581,1328,174,16,1468,265,13,1434,140;32;F
84;512,451,1322,1325,1,129,982,1581,1344,834,1482,36,1700,373,1470;40;F
86;173,776,1482,1700,1698,733,174,860,16,1608,22,192,376,984,1510;35;M
101;192;41;F
108;550,1261,1416,1700,17,409,1608;36;F
113;1624,17,826,1322,1325,1,129,1581,512,834,1700,1633,1441,1434,1470;32;F
120;1470,1434;36;M
122;1470;33;F
130;1608,265,1700,1295,1332,1322,984,1312,556,659,554,947,550,129,834;40;M
142;1,982,394,192;11;F
164;550,733,1633,1608,1559,444,1510,1384,1604,451,1110,1581,1468,394,1470;38;M
173;174,860,16,865,1608,376,394,984,1451,1510,129,982,1698,22,192;42;F
176;173,776,834,1468,13,1706,1110,1581,1295,1482,1700,174,16,2,1470;42;M
202;1624,917,1325,1524,1347,702,1026,1328,373,16,265,1434,1510;28;F
205;984,22,1633,1698,211,1706,1322,826,982,556,867,863,860,865,586;63;F
214;1470;37;F
229;174,984,733,376,2,17,947,1581,512,1700,373,1698,16,1441,1470;47;F
235;1021,1517,1322,1325,1,129,211,1332,1524,988,702,1026,860,22,1434;49;F
239;1470;39;F
257;1509,13,16,1344,1330,776,1468,1698,373,1482,443,1338,451,1434,1384;33;M
272;1517,917,1021,1,1332,1524,1482,702,1026,1633,22,13,1451,1434,140;27;F
284;1624,1604,774,451,1322,173,443,1347,373,268,1468,13;27;F
298;1470;48;F
314;1533,1524,1532,1328,1359,268,174,265,1559,13,3,1434,1510,1384,140;36;F
315;451,917,1517,1624,1604,1322,1347,373,174,16,1468,1314,444,13,1434;27;F
333;1261,826,1322,982,1359,1633,1470,1700,373,1468,22,1441,554,444,1312;37;F
341;1517,451,443,1347,376,917,1021,1,1524,702,1026,1633,1451,1434,265;54;M
348;451,826,23,1581,1332,834,1388,1700,268,376,2,3,1470;49;F
349;1338,223,1119,1624,451,1416,23,211,834,192,376,2,1441,1314,13;40;M
350;1261;42;F
363;1021,451,1119,1517,1604,1624,174,16,1633,265,1559,1470,13,1434,1510;42;F
372;394,13,1510,776,834,36,124,702,1359,268,174,16,22,376,192;33;F
399;1021,1526,1261,1,1524,1509,1482,1532,1347,1026,1328,1468,376,13,1384;47;F
418;17,1338,1706,129,1388,124,1328,1698,174,1468,1441,3,1510,1384,586;15;M
431;1510,1332,173,982,584,733,22,376,1338,834,1698,1624,265,1328,1330;31;F
435;982,1700,702,1633,865,1470,444,1451,1434,1312,140,382,512,863,408;45;F
450;556,36,124,1700,702,1026,1698,268,192,1441,1470,408,1338,512,834;32;M
469;192;42;F
479;223,1021,1526,1416,1533,556,1524,1509,1532,1700,1026,373,1698,1359,1559;39;F
480;1344,443,124,1347,1698,828,24,16,1468,22,376,2,13,1434,140;34;F
507;265,917,1021,1509,451,1325,1581,443,776,1532,1328,16,1559,1451,140;33;M
538;1470;37;M
547;192;38;F
586;192;9;M
589;451,443,1482,36,1347,702,373,1698,174,16,376,265,1441,13,1434;35;F
626;1344,776,1328,733,1434,1510,774,443,1487,1347,702,373,16,376,13;34;F
655;173,556,36,174,192,394,1441,1470;47;F
663;1119,451,1261,376,394,1470;39;F
680;556,1524,1509,1328,1359,265;53;M
688;24,776,443,1581,1533,173,1110,1526,1624,1517,1021,1,1524,702,1026;35;F
718;17,451,1325,1,173,1344,776,1347,268,174,3,1434;35;F
738;1700,1698,174,2,1441,1470,408,451,1338,826,1322,382,129,173,512;54;F
754;1470;41;F
758;297,17,1119,451,1325,129,373,174,1470;36;F
765;1325,1700,1359,268,174,1434,140,265;48;M
769;1624,129,556,776,1482,1698,268,3;37;F
771;774,1325,1359,444,1441,1608,1330,17,1532,124,2,24,23,776,22;23;M
793;1604,1624,774,702,1524,173,1110,1,1119,1517;39;M
799;1119,451,173,1388,124,702,1026,268,174,16,1468,1559,3,13,1510;30;M
818;1021,982,776,373,1468,1526,1416,129,556,1524,1509,1532,1026,1359,1559;39;F
882;1517,1604,1624,297,584,1119,1330,451,1338,556,1700,394,1470,554,1312;29;F
942;394,1470;39;F
944;1624,1604,702,24,1344,443,1325,1322,917,1517,1314;42;M
945;1517,774,13,140,586,917;40;M
980;1581,982,1325,1344,1332,124,24,16,1468,376,13,140;39;F
988;1526,1524,776,1509,1482,1532,702,1026,1328,1359,1468,265,1559,1434,1384;18;M
1006;1468,1624,451,1021,1526,1533,173,1524,1532,702,1328,16,265,1559,1434;34;F
1017;554,1559,2,13,1314,1441,984,1510,586,1604,1624,1698,444,1434,192;40;F
1018;1416,443,1524,776,834,1347,373,16,192,265,444,3,1451,1510,1261;10;F
1019;776,1524,17,1482,36,1026,3,16,1633,1468,376,13,1434,140;24;M
1022;1533,1344,443,1524,776,834,373,16,1468,192,265,444,3,1451,1261;10;F
1046;1470;9;M
1051;451,826,741,1,1110,1344,443,1524,834,1347,702,1026,24,16,1468;30;F
1056;1416,1261;45;F
1073;1581,1322,1338,1261,1526,1524,1532,1328,265,1559,1470,1434,1510,1384,140;34;M
1080;174,16,1633,1468,1434,1624,774,1322,1706,741,1,124,24,13,192;38;F
1125;1624,1344,443,865,1434,1517,409,982,1332,702,1468,22,2;38;F
1158;223,568,1261,129,1344,443,776,1482,1698,373,174,16,865,22,394;38;F
1160;1624,451,1338,826,1706,1344,834,1700,1698,1468,1470;33;F
1164;1510,140,1526,1416,129,776,1532,1698,1559;42;F
1177;1322,741,1110,982,1581,1332,1347,24,1633,16,1314,3,1312,140,192;51;F
1184;584,1604,1624,1325,995,776,1487,733,16,1468,376,1434;47;F
1206;17,1119,223,451,1338,1,1110,982,1344,988,1700,268,16,192,376;32;F
1209;17,947,826,1322,1325,409,1344,1698,1441,984,129,982,1581,373,1470;36;F
1210;1604,1517,1021,1524,1509,702,1026,1328,265,1434;31;M
1230;211,1,1325,741,584,947,17,13,1517,129,1581,1698,174,1608,192;41;F
1234;1517,1021,1338,1,129,1524,36,1700,702,1026,1328,1698,265;36;M
1235;774,1624,1526,1325,1110,982,1344,443,776,1347,16,1468,13,1451,1434;43;F
1236;1470;4;F
1249;1470;36;F
1255;1338,826,741,1,1581,512,1524,1295,834,1700,373,1698,865,1441,408;36;F
1259;223,1604,774,1468,265,174,268,1359,1328,1487,1482,1509,443,173,1624;42;F
1273;443,776,373,16,13,1434,408,1021,1322,1,1532,1700,1026,1468,265;20;M
1276;1517,1021,741,1,173,1581,1524,36,124,702,1698,24,1468,1451;42;M
1287;1624,451,826,1322,1706,1,129,1581,896,1482,1700,373,1698,16,1470;33;F
1292;947,1338,776,1482,36,1468,1441,1434,1624,1,129,1700,16,1470,586;37;M
1303;1312,1510,17,917,1119,382,129,173,512,1700,1698,174,2,1441,1470;56;M
1304;223,550,444,1434,1384,408,1517,917,23,1581,1524,702,860,394,1510;39;M
1309;1470;38;F
1324;1021,1581,1524,129,834,1509,1532,1026,1328,16,1468,265,1559,13,1434;35;M
1330;1347,192,1434,16,1468,394,1314,1510,1110,982,1344,443,373,1698,1470;46;F
1331;1698,268,860,394,444,1451,140,443,1700,373,733,1434,1312,1510,1470;39;F
1332;192;44;F
1348;984,297,1624,1119,1021,1325,556,1332,1524,1700,1026,373,826,982,1470;38;F
1388;192;38;F
1390;774,1322,1581,1344,443,776,124,24,16,1468,22,192,13,1434,1510;38;M
1395;1110,1344,443,659,988,36,1700,702,268,16,192,376,1314,1451,1510;5;M
1411;947,129,982,1517,223,1330,451,1021,1,1524,702,1026,1328,265,1434;28;F
1412;451,1021,1526,1325,1,1533,1332,1482,1328,1359,192,265,1559,1434;36;M
1420;1470;8;F
1423;1624,17,568,1322,1325,129,173,1581,373,1698,174,1608,192;3;M
1489;1338,1,1344,1524,659,988,36,1700,268,16,192,376,1559,1314,1510;9;M
1522;1338,373,1384;32;M
1532;192,863,834,1347,702,1698,550,860,1468,865,1608,394,1441,13,140;8;F
1543;16,22,408,3,512;35;M
1555;1624,17,1517,1344,443,16,376,265,394,1314,1441,554,13,1451,192;37;M
1562;1526,223,1119,917,947,17,1698,268,828,1633,865,1314,1434,1510,192;38;F
1568;192;40;F
1569;382,1509,1487,1347,1026,373,828,733,865,1608,192,1559,1470,1312,408;39;M
1580;1119,1624,1470;65;F
1585;982,917,1119,1706,1325,173,1581,443,1468,265,1559,3,1451,1434,1510;58;F
1591;1517,1119,382,982,702,1026,1359,24,16;38;M
1592;1604,1624,36,1468,1559,1451,774,1110,1581,443,776,1482,24,1633,13;26;F
1603;1344,776,1451,1021,1700,1328,174,1470,13,1510,982,1434,451,16,265;32;F
1605;1624,1517,947,917,1338,1322,1,1581,1487,1700,702,1026,1441,1451,1434;16;M
1634;1344,268,16,1468,192,2,13,1451,443;40;F
1647;192;39;F
1650;174,451,1517,1624,1322,129,1581,702,1468,265,140,1434;18;F
1652;1698,1347,1344,1110,1517,774,1325,1,23,443,1332,776,1633,192;49;F
1668;192,1359,1509,443,129,1,1416,1322,1526,1261;36;F
1675;1332,776,863,1509,1700,1347,1026,1359,16,1468,2,1451,1434,140,1261;10;F
1686;1470;33;F
1716;1261;11;F
1729;451,826,1581,512,1295,776,1633,394,2,1441,1470,1434,1312,586;38;F
1745;1261,1344,1328,1312,1510,443,1700,1698,268,192,376,394,1451;59;F
1769;917,741,982,1344,443,867,896,988,124,1700,860,22,984,13,1451;47;F
1788;1604,741,1344,776,1482,1532,124,1347,1328,16,1633,1468,265,1559,13;60;F
1792;1482,1,17,1119,173,1581,512,1295,834,36,1700,702,16,192,1470;39;F
1809;584,1325,568,17,223,1338,512,1487,1700,1608,192,376,1470,394,1510;41;F
1822;1624,1604,1517,774,1338,1322,741,1325,1581,124,1487,1700,702,24,376;33;M
1832;1533,1581,1509,917,1604,1624,17,774,1330,451,776,1482,1328,1468,265;41;M
1840;702,1026,1328,174,24,16,1633,1468,376,394,1559,1441,984,3;37;F
1847;1470;11;M
1879;223,129,173,192;42;F
1883;192;40;M
1885;16,192,265;38;F
1897;1470;31;F
1906;192;28;F
1927;1330,947,17,1624,223,451,826,1322,382,1119,129,173,512,1468,1434;11;F
1929;1526,1416,1533,1524,1295,1509,36,1532,1700,1026,1698,1359,1451,1312,1384;40;F
1970;863,1487,1633,444,13,896,1332,1344,211,982,774,373,860,1468,192;45;F
1983;394,1487,23,995;39;F
2006;984,865,741,376,22,17,1,129,124,16,36,409,1332,982,586;3;M
2029;265;29;M
2099;192,586;5;M
2128;1470;41;M
2143;17,1119,129,173,1581,443,776,1482,702,1026,268,22,192,2,1434;35;F
2150;1608,2,1441,984,1451,1312,1604,17,1322,741,1332,124,24,16,22;57;F
2184;834,36,1698,174,16,1468,22,376,1441,1470,3,13,1451,1434,1510;25;F
2250;443,1330,776,1328,917,1021,265,1526,1509,1434,1532,550,1344,129,834;31;M
2254;1470,586;33;F
2265;451,1624,1328,1359,1633,16,1468,1608,297;29;M
2285;16,1,1332,268,550,24,1633,1468,1608,22,376,2,1314,984,1510;22;M
2353;1119,1604,1624,1434,1325,1,129,1581,443,1388,16,1468,376,1384,140;43;F
2374;1110,1,1624,451,1325,173,512,1581;17;M
2400;129,982,1581,988,1468,865,13,1119,451,1700,1698,16,1470,1434,1510;34;F
2411;382,129,211,173,867,776,863,1482,702,268,174,192,1470,1434,1510;8;F
2439;826,223,568,17,1330,1338,1110,173,1581,556,1359,174,1633,865,265;39;F
2447;1517,1026,1451,586;62;M
2483;1330,1325,1332,22,1559,1,13,1344,268,394,174,173,1110,297,1119;42;F
2488;1021,1526,1261,1322,1325,129,982,1524,1509,1532,702,1026,1359,1559,13;44;F
2490;268,741,774,1524,124,1624,1526,1533,1509,17,1468,1559,13,1434,1510;29;M
2529;1604,774,1110,1581,776,1347,1468,13,140,451,1325,1482,1388,16,376;36;F
2563;917,1581,741,129,211,982,443,1332,896,124,1700,373,1698,268,1451;52;F
2566;1434,1119,409,1581,512,1524,1700,192,444,451,382,982,16,1470,408;40;F
2585;1470,444,3,1312,586;25;M
2590;408,917,1604,451,826,1581,512,1344,1524,1700,1026,1314,1470,13,1312;42;F
2608;995,556,1332,1295,867,863,896,988,1698,860,22,376,394,984,1510;60;F
2609;512,1698,917,1119,382,1,129,173,1700,174,2,1441,1470,444,408;73;F
2624;659,995,173,451,1624,297,1110,443,556,1698,268,376,265,394,1451;52;F
2627;192;37;F
2630;192;30;F
2634;124,1347,1328,174,24,16,1633,1468,192,265,1559,1314,13,1434,140;67;F
2657;1261,265;66;F
2689;17,947,776,124,373,1698,1359,1468,394,2,1441,444,3,1451,1434;29;F
2700;774,917,1604,1624,1328,16,376,1325,1,1698,1468,265,13,3,1434;48;F
2707;1517,1322,1,1332,1700,702,1328,1698,174,1468,265,13,1434,1510,140;36;F
2742;741,1021,1624,1322,1325,1524,776,1026,24,1468,16,1517,1,702,13;43;M
2758;1624,917,1325,512,1700,860,1468,444,1434,16;42;M
2768;140,733,776,1604,1624,1312,1451,268,17,297,1482,1700,174,1468,192;38;F
2784;1524,1328,376,1314,1451,140,17,1517,451,1533,776,373,192,1441,1510;14;F
2791;1344,173,1,1325,1706,1322,826,451,1119,774,174,1633,376,1624,1517;31;M
2799;443,1482,192,1470,13,1110,1344,268,1347,24,16,376,1633,1314,1468;51;F
2867;265,174,1604,1624,1330,1322,1325,173,1388,1359,16,1468,13,1434,1510;15;F
2892;1468,1482,1322,1330;61;F
2928;702,16,1026,443,1328,1314,13,1526,1524,1624,1604,1,1110,1344,1468;36;M
2937;1524,776,1482,124,702,1328,174,24,16,1633,1468,1559,1441,13,1434;24;M
2956;394,13,1,129,174,192;40;F
2982;1021,1526,1533,1581,1524,1509,1532,1026,1328,1359,265,1559,1441,1384,140;27;F
2987;268,828,550,733,174,24,860,16,1633,1468,865,1608,22,192,586;14;M
2998;192,1451,1312,1510,776,1295,512,1581,173,129,382,826,451,917,1624;8;M
2999;556,1332,1524,1295,867,776,834,36,1468,1608,1314,1441,3,1451,1510;15;M
3003;741,1325,1533,1581,1509,16,1330,1532,124,1633,1468,1559,1314,1434,140;46;F
3040;451,444,1434,1119,1322,409,1110,173,834,373,1698,174,1468,1312,394;44;F
3046;1470;16;F
3047;16,140,1624,451,1110,173,174,13,1468,1328,776,1581,1,1482,265;51;F
3063;1470;15;M
3115;1295,896,1487,733,22,1441,1312,1482,1026,373,1359,16,1608,1384,265;35;F
3139;192;29;F
3152;1517,1021,1,1524,702;39;M
3160;1532,702,1328,1604,1434,265;38;M
3162;776,512,774,917,1517,1624,1468,16,1700,36,1482,1332,129,826,1119;31;M
3175;1021,1330,1261,1524,1328,1359,265,1434;41;F
3192;1119,382,1,129,173,512,124,1700,702,1328,174,192,444,984,408;44;F
3218;1624,1119,173,776,174,1434,1330,1338,834,1328,376,265;35;F
3221;1470;17;F
3242;22,13,140,451,1322,1325,129,776,124,3;34;M
3256;1119,1322,129,173,834,1347,1700,1328,550,174,1468,265,554;45;M
3259;140,1322,382,982,373,1119,1700,1441,1332,1325,512,451,297,223,16;32;M
3286;1,776,16,1698,1338,947,443,13,124,1344,741,1526,774,24,1468;40;M
3359;1330,1021,1524,1328,1359,265,1261,1434;8;F
3396;1700,1328,373,24,16,265,192;38;F
3436;1325,129,173,512,1344,1482,1700,268,733,16,1633,192,376,1451,1312;10;M
3460;192;7;F
3480;1330,451,774,917,1624,17,1021,1,776,702,1328,268,1468,265,2;33;F
3481;1510,586,23,394;46;M
3482;982,834,174,1359,268,265,13,1624,774,1330,1322,1706,1332,1328,1468;39;F
3499;733,584;29;M
3514;702,1026,1698,174,24,16,1633,1468,265,1314,1441,13,1451,1434,140;34;F
3522;1338,1261,1322,1700,1470,1434;68;F
3529;129,826,917,451,1295,776,1700,268,1633,192,376,1451,1312,1510,408;39;M
3533;192;48;M
3566;382,512,556,834,1700,702,1026,1698,373,828,1633,1468,1451,1384,408;18;F
3576;1332,373,1698,828,16,17,223,1,982,896,268,22,376,984,1510;25;F
3615;1330,451,1021,1526,1338,1325,1524,1328,1359,265,444;33;F
3624;140,776,1261,451,1119,947,1517,1624,223,17,1021,1,984,1510,265;39;M
3630;1624,1517,917,451,1581,443,124,16,1468,192,3,13,1434,1451,1510;32;F
3674;192;78;F
3696;192;63;M
3698;917,297,1517,1,129,1524,1532,1328,1359,24,16,1468,1434,124,265;18;M
3700;1533,584,297,451,1330,1119,947,173,1110,1332,1700,1328,1441,265,554;34;F
3719;192;86;F
3724;984,1451,774,1110,659,988,22,444,1338,702,1026,382,1700,192,1470;41;M
3726;1119,173,16,192,1314,1441,1434,174,1322,129,443,124,268,2,1510;35;F
3731;1261;27;F
3744;443,1344,1,1325,917,1604,1624,17,1322,741,124,1314,1441,13;28;F
3749;984,409,988,982;60;F
3753;702,1021,1517,917,774,23,1533,556,776,1482,373,828,16,1468,297;40;M
3764;173,1581,1325,1482,174,16,1633,1468,376,2,13,1451,1434,1510,140;58;M
3771;1509,1482,16,1581,1533,129,1325,1526,774,1359,265,1559,1314,13;48;M
3772;16,192;45;M
3789;1,1526,1021,1624,1322,1325,129,1332,702,1314,192,1510,140;34;M
3809;192,1347,702,512,1021,1119,947,1517,1624,1706,1524,1700,1698,1468,1470;45;M
3812;451,1325,174,1482,776,1581,1322,1119,140,17,173,16,1468,1510,1434;36;M
3826;1328,1359,828,1468,1434,1322,409,982,211,1332,863,988,373,1698,865;39;F
3830;13,1468,24,1359,776,443,1533,1021,1526,1524,1509,1532,1026,16,1559;33;M
3846;982,867,988,1700,702,373,1468,376,394,2,1441,984,13,140,1624;54;F
3855;1322,1119,223,774,982,1344,1332,776,1482,373,268,16,1633,1468,376;42;F
3898;211,1325,1624,1451;30;F
3933;1021,1526,1325,1533,1524,1700,1026,1359,268,16,1468,265,1559,1434,1510;33;M
3986;1119,1517,1624,173,1581,36,124,1347,702,1026,174,24,16,1633,265;40;M
4029;2,1624,297,584,1119,568,451,1325,1110,129,834,36,1698,733,444;25;M
4050;1510,173,451,774,297,1119;42;F
4054;834,1700,1470;43;F
4059;1470;17;F
4063;1470;17;F
4106;1,451,917,297,1344,776,1509,702,16,1468,394,1559,13;24;M
4118;1517,1021,1524,1482,702,1026,16,1468,192,1559,1470,13,1434,140,1384;35;M
4127;36,702,373,1698,174,16,265,394,1314,1441,140,173,451,297,1434;30;F
4159;1624,1021,1526,1322,1533,1524,1509,1532,1700,1026,16,1468,13,1559,1434;22;M
4160;1533,1026,24,173,1581,124,702,174,16,192,1314,3,13,1434,140;29;M
4173;702,1328,1026,24,16,1633,1468,192,1314,3,13,1451,1434,140,265;23;F
4186;192;44;M
4196;1434,1510,1416,1338,1021,947,1624,17,451,826,1322,1328,373,1698,2;48;F
4206;1698,16,394,444,13,376,984,1451,1624,297,17,584,774,443,896;43;F
4207;140,1322,1328,265;51;F
4211;124,1347,702,24,16,1468,13,1451;51;M
4214;1624,741,1110,776,1482,1347,702,1026,24,16,1633,1468,1314,13,1451;31;F
4261;192;43;M
4273;1581,1524,776,1509,1532,1328,1026,24,16,1468,265,1559,1314,13,1451;49;F
4301;443,741,1338,124,140;40;M
4306;1451,297,1624,1119,451,826,1,129,1581,173,443,174,16,1633,13;37;M
4313;443,1524,776,1509,1532,702,1026,1328,1359,1468,265,1314,13,1451,140;51;M
4324;1119,917,1517,1624,1344,1524,1700,1026,1328,265,1314,13,1434,1510,140;43;F
4345;982,1482,1700,702,1698,1633,1441,13,1434,443,984,1332,776,1510,268;38;M
4360;1604,1021,1526,173,1581,776,1482,1509,1328,1359,16,265,13,1434,1384;59;F
4362;1322,741,1295,834,1487,1314,3,13,140,1470,1441,16,1698,1700,124;43;M
4378;1026,1328,24,16,1468,13,774,17,1604,1624,373,268,1633,3,1510;43;F
4418;1608,192,1312,1698,1441,1451,443,1470;45;F
4437;584;33;M
4463;1330,1559,1604,1624,1110,1482,1633,1468,1526,826,1344,443,1509,1532,16;48;F
4474;1526,1021,917,451,1330,1119,1604,1624,265,1510,192,1559,1314,1470,13;43;F
4482;443,1332,376,586;56;M
4491;1624,297,1119,826,173,512,1700,1328,550,174,444,984,13,1434,140;35;M
4546;211,995;42;F
4547;451,1322,443,834,124,1328,1359,174,16,192;46;M
4551;1261,1482,1533,1524,1509,1532,1359,174,1468,1608,1559,1441,13,1451,1434;43;F
4573;1021,124,1434,409,982,867,896,988,22,394,554,984,947,1328,265;37;F
4574;867,1332,223,1119,17,1624,1470;44;M
4591;1526,1322,741,124,24,1384,140;47;F
4611;443,776,36,1026,16,1468,1451,140,1624,1517,1,741,124,702,24;44;F
4612;1624,1517,1119,1021,1,129,173,1524,702,1026,1328,16,1468,265,1441;39;F
4622;1624,1604,1517,1325,1581,1524,834,1532,1468,1559,1441;31;F
4651;774,1119,1322,1706,1325,1110,1344,443,776,1359,16,265,13,1451,1328;37;M
4667;512,1322,1526,17,1434,1312,1510,917,1119,129,173,1581,174,16,192;37;F
4675;917,1325,1,173,1482,1700,1698,174,1633,1608,394,13,1434,1510,140;49;F
4680;1517,17,917,741,982,1581,834,124,702,24,16,865,1441,1510,140;35;F
4681;211,2,947,1332,124,394,1441,192,1698;37;F
4695;16,1633,1468,774,297,1624,1110,173,1344,443;52;F
4712;774,1526,982,1332,1328,1359,984;37;M
4748;568,1517,1604,1322,741,124,1700,1698,24,16,192,394,1314,1510;34;F
4846;192,1325,1700,16,1451,140;40;M
4848;1470;45;F
4926;1624,443,1347,702,1026,1328,174,16,1633,1468,265,1314,3,13,1451;31;F
4957;192;34;F
4965;896,828,373,1325,1482,268,1119,17,451,443,1388,1559,1451,376,2;47;F
4974;23,1344,443,1347,1633,13,17,1338,776,16,1468,376,2;27;F
4980;1604,1325,982,1332;46;F
4993;1524,1624,297,1604,1517,774,1119,1,173,776,1482,702,1026,268,1510;45;M
5037;17,917,1322,1325,1581,124,1700,1608,1441,1510,140,586;39;M
5042;409,982,995,1295,867,863,1698,865,984,1434,1510,741,129,124,192;29;F
5125;17,211,1332,36,702,373,16,22,2,1441,984,13,1451,1510,140;43;F
5142;741,982,1581,776,988,124,373,24,16,444,984,13,1434,1510,140;39;F
5143;1110,174,1434,1119,1,129,173,1700,702,16,1468,265,140;40;F
5152;834,1328,550,265,1434,140;46;M
5161;1021,1526,173,1581,1524,1509,702,1026,1328,550,174,1468,265,1451,1434;28;F
5193;16,24,1119,774,223,1338,1325,1110,124,268,733,1468,1608,376,1451;46;F
5223;1608,394,554,863,376,444,984,140,1322,982,1295,860,865,3,586;65;F
5243;1624,1604,1533,192,1517,1021,1,173,1524,1510,1434,268,394,702,1026;31;F
5296;13,140,1322,173,124,1700,1698,16,1633,2,1510,982,174,1312,192;45;F
5311;1,982,995,1581,1509,1532,1026,22,376,1559,444,984,13,1510,1384;35;M
5317;451,1026,1559,1314,444,3,1384,140,1509,1328,13,982,265,1434,776;37;M
5375;826,451,1330,917,1604,1624,24,16,1468,1633,1559,1314,13,733,584;36;M
5404;1325,1526,1624,774,741,1344,443,776,1509,124,1347,16,1468,13,1451;53;F
5440;124,702,373,24,16,1468,1608,22,376,1314,1441,984,1451,140,586;45;F
5445;17,1332,867,776,1482,124,1608,394,1441,554,444,1434,1510,586;36;M
5480;17,917,1119,1526,1322,129,173,1581,512,174,16,192,1434,1312,1510;29;M
5510;1441,265,16,1359,1698,776,1344,1119,947,1330,1322,129,1328,376,1434;32;F
5518;776,1347,1328,24,16,1633,1468,1314,1434,1510,1624,13,3,1451,140;24;M
5547;1344,586;23;F
5614;1517,741,1482,124,702,1338,451,1624,268,3,1434,1510;29;F
5618;1434,1312,140,17,1517,947,223,1021,1261,1,1524,834,1700,1026,1359;47;F
5666;17,129,1517,124,702,444,984,382,408,451,173,512,1700,192,1119;43;M
5677;1314,1468,1633,1524,1344,1517,1604,297,1119,451,741,129,192,1434,174;36;F
5699;1624,17,1517,741,1,1581,834,124,1700,702,174,24,1468,1441,13;48;F
5728;1110,192;48;M
5759;1624,774,451,1,443,1347,1328,268,16,1633,1468,1384,1451;36;M
5778;1604,1624,1451,297;32;F
5793;1482,1532,702,1347,1328,1468,1314,1312,1510,1330,451,129,1344,24,16;41;F
5796;1633,1314,13,1510,1338,774,1517,1322,1325,1581,1344,1482,124,1434,140;37;M
5861;995;40;F
5878;1021,451,1119,1624,129,1468,265,554,1434;43;F
5888;13,1451,444,376,22,1468,16,1347,1482,776,1332,982,1325,451,774;27;M
5891;584,733;44;M
5897;124,24,16,1434,140,1624,1604,1517,774,1322,1325,1,702,1468,13;40;F
5898;1624,1526,1261;40;F
5913;1110,1,297,223,451,982,556,988,373,174,865,1608,394,444,984;48;F
5975;16,828,1328,1347,1509,443,1344,982,1338,1526,451,774,947,1517,1624;38;M
6021;17,947,1021,1416,1524,834,1700,1026,1698,16,1559,265,1441,1434,140;39;F
6062;584,733;22;M
6070;376,17,584,947,451,1325,1,129,173,1328,550,265,394;38;F
6071;1416,1384;36;M
6086;408,984,1441,1468,550,1509,1332,1533,1110,1325,1624,443,988,1434,1510;38;M
6105;1322,741,1110,1581,443,776,1388,124,1347,24,1468,13,1451,1434,140;31;F
6116;776,1295,173,451,223,1119,917,297,1325,1110,1700,268,1451,1434,1510;29;F
6122;1338,1,129,173,1700,1026,1328,1698,174,265;41;F
6179;1119,1581,443,1295,988,1482,1700,16,3,1312,1330,982,173,1328,265;41;F
6182;741,995,988,24,265,124,1338,443,896,1021,982,1,1434,1510,140;35;M
6194;1021,1,173,443,268,550,733,174,1468,22,1451,1434,1119,129,1332;36;F
6203;16,776,1624,1604,1517,1510,1482,1388,1347,1325,774,192,24,3,1633;37;M
6216;1624,1604,1026,1328,1468;41;M
6229;1325,917,1624,173,1388,16,741,124,24,1468,984,3,13,1434,140;32;M
6258;1526,451,1509,16,1633,1468;48;M
6293;702,1328,373,828,860,1633,1608,192,394,1441,444,984,1434,1510,140;23;M
6298;192;41;F
6308;192;43;F
6309;1633,860,3,13,1312,586,1624,17,1325,268,982,1581,265,1328,1295;39;F
6321;1325,512,1700,373,1698,408;33;F
6329;192;12;F
6358;1,1698,268,828,1468,1608,394,1441,554,1510,1384,408,17,556,373;46;F
6364;834,1,129,512,443,1482,1700,373,1698,1359,265,2,444,1451,1434;43;F
6368;1517,1604,297,1581,834,1700,1698,1359,1468,1608,1451,1312,1510,1384,1261;12;M
6375;13,1624,1344,1347,1026,16,451,173,1524,36,1700,174,702,1,1517;36;F
6379;1517,1021,16,174,702,1119,1338,173;36;M
6380;584,733;43;M
6391;409,1526,1332,1524,988,1532,1700,1026,1468,22,1559,984,13,1434,140;34;F
6408;1110,173,1344,1524,776,1482,124,1328,373,1468,1608,265,394,554,1434;39;F
6424;16,1468,22,13,140,1624,1517,1322,1325,1,982,443,1332,702,1434;40;M
6426;1441,174,1698,373,173,1322,1338,1330,1119,917,947,1604,297,1624,451;48;F
6450;1347,1700,1482,834,173,1021,1517,1533,1110,1322,1526,1624,1119,1581,1524;42;F
6460;129,1434,1470;45;F
6467;741,124,702,24;31;M
6511;1470;39;F
6551;1470;18;M
6616;1470,586;36;F
6634;1624,774,1526,1110,1344,776,1509,1482,1532,1700,1347,24,16,1468,22;40;F
6638;1524,1451,373,1698,1441,1624,1021,1581,1347,1328,268,174,1468,265,13;54;F
6641;192;59;M
6671;1604,451,1325,982,173,443,776,988,1347,174,1633,1468,13,1451,140;36;M
6715;917,17,124,834,776,1524,1581,129,1338,1261,1700,1314,1470,1384,140;47;M
6740;1624,1604,1322,741,1325,1581,124,24,1434;28;F
6741;1706,443,1388,1328,16,3,1451,1434,1510,140;48;M
6753;173,17,140,124,702,376,1434,1517,1,982,1332,1700,373,24,22;27;M
6755;1470;15;F
6809;1344,1482,1388,373,16,1451,1510,376,733,1700,776,443,173,1,1325;40;F
6812;1338,1021,917,1517,17,1624,1604,774,1322,741,124,1698,24,1468,1451;43;F
6832;982;79;F
6849;1624,223,129,1524,834,408,1517,1021,512,702,1026,373,1698,1470,586;43;M
6862;733,584;27;M
6900;1434,1581,1604,1624,24,16,297,1517,917,774,826,1,1110,1347,1633;52;F
6912;1434,1624,1604,1517,774,1295,1700,1328,265,984,13,1510,1330;74;F
6914;265;32;M
6915;1314,140,1624,1604,774,451,826,443,776,24,1633,1468,265,16,13;40;F
6945;1344,1700,16,24,124,1434;29;F
6952;774,1330,1021,1526,23,1533,1524,776,834,1328,268,24,376,1559,1510;21;M
6954;1604,774,129,173,1344,443,776,36,1388,376,394,1624,1441,1451;48;F
6987;867,774,947,17,1624,297,741,443,863,124,373,1698,1468,865,1451;48;F
6990;174,1633,22,1441,13,1312,947,1706,982,995,1332,1700,16,1468,394;40;F
6995;1332,896,988,1482,394,1559,174,22,265,444,984,3,1451,1434,1510;35;M
7024;982,1624,1604,774,1322,1295,1700,702,16,1633,1468,192,1314,3,13;40;F
7077;1,1295,373,16,3,1312,140,394;36;F
7103;1470;45;F
7109;1322,1,173,556,1524,1388,223,828,174,16,2,1441,444,1698,1700;51;F
7113;451,1325,995,1581,984,1510,917,741,1332,124,1388,268,24,22,3;34;F
7131;947,1510,1624,774,556,776,1509,373,1698,16,1468,22,1441,13,1434;56;F
7140;774,1388,3,1451,1470;18;F
7143;1470;51;F
7178;1624,297,1604,774,1119,451,1706,1,1110,173,174,16,1468,13,1434;47;F
7181;1470;38;M
7185;1624,774,451,826,1325,173,443,776,174,24,16,1633,1468,13,1434;29;F
7202;443,174,140,1624,826,1322,1,776,1482,1359,16,1633,1468,1559,13;15;M
7245;140,826,124,373,1624,1322,1581,443,1633,1468,192,265,1470,3,13;37;M
7254;1110,1559,1482,265,1533,1119,1700,1532,1509,16,451,776,174,173,297;24;F
7273;1468,1633,1328,776,1344,1581,1624,451,1322,896,1482,373,265,394,1451;43;F
7276;17,1119,1325,173,1581,776,174,3;50;F
7285;702,1328,268,24,1633,776,1344,451,1325,1559,1314,1510,1604,1119,16;34;F
7301;584,1517,1624,1604,1330,451,702,1328,265,1470,1119,129,1332,865,22;39;F
7329;451,1330,1526,1322,1110,1509,1347,1328,1468,13,140;41;F
7360;451,1524,776,1482,1347,702,1026,1328,174,24,16,1468,265,13,1434;33;M
7367;1330,1328,1470;48;M
7382;192;38;F
7395;23,1532,1470,1510,1021,129,1533,1524,1559,1700,1509,1526,1261,1416,1384;49;F
7416;1517,1119,1581,1524,1295,36,1532,702,16,586;45;F
7455;1119,982,1332;40;M
7469;192;9;M
7495;512,408,1624,24,16,1330,451,1526,1509,1532,1021,1533,1524,1026,1559;47;M
7502;1328,265;40;M
7518;192;11;M
7559;192;39;M
7590;17,1517,451,1021,1526,1581,1524,702,1026,268,16,376,265,13,1434;31;F
7606;1441,1434,173,17,451,265,1344,776,1470;34;F
7616;1110,443,1332,1700,702,22,192,1559,1624,1451,1359,1468,1314,140,1434;24;M
7621;1338,36,268,1384;47;M
7655;1261,1119,376,394;36;F
7658;1700,702,1698,1468,1441,586,741,124,1487,24,376,394,2,3,1451;28;F
7675;1119,1325,173,1581,443,776,1482,174,13,16,192,2,1441,1314,1470;46;F
7705;223,774,17,394,1314,984,1451,140,776,863,988,1700,373,22,192;45;F
7713;1517,17,1624,1482,702,268,2,1441,13,1434;35;F
7730;1517,1021,1526,443,1524,834,1388,1700,1347,702,1026,24,16,1468,3;34;M
7739;1581,173,1325,1322,1338,1021,223,568,1119,947,17,451,1330,1434,3;33;M
7794;1021,1526,1416,1533,443,1509,1532,16,1468,1559,984,13,1384;35;M
7813;192;12;M
7815;1698,408,512,834,1700;35;F
7823;741,1532,1509,1624,1604,774,1526,173,1482,1328,16,1468,2,1314,13;36;M
7829;192;45;F
7863;1325,1706,223,1624,1119,1261,1322,409,982,1581,1344,443,1332,988,1700;36;F
7890;192;44;F
7892;1698,1624,17,1119,1416,556,1295,1532,373,828,265,947,1330,1261,1328;48;F
7898;1604,1700,268,1624,917,774,223,1325,129,1698,24,16,1633,1468,192;40;F
7912;774,451,1526,1322,1325,776,834,1388,16,394,1,129,1328,1468,13;44;F
7927;192;45;M
7932;1624,1526,1261,982,1581,834,1509,1532,373,1698,1633,1608,1559,2,1441;51;F
7989;1624,373,1698,16,13,1510,1344,834,268,1633,192;42;F
8004;1624,17,1517,741,1325,982,1581,443,124,1700,1698,24,16,1441,13;35;F
8026;982,192;35;F
8040;1624,776,1700,1347,1581,129,1325,223,917,1698,16,1468,192,376,394;43;F
8126;995;48;M
8153;1470;12;F
8158;865,984,444,3,1434,1510,408,17,917,1119,1338,173,1581,834,174;41;F
8179;1470;9;M
8200;982,733,24,13,1700,1338,586,2,373,984;44;F
8209;451,1322,1325,776,268,16,1633,1559,1434,1510;36;M
8210;451,1624,774,826,1110,443,776,1388,1347,268,174,1633,1468,376,3;47;F
8245;917,1261,1,1700,1026,1470,1510;65;M
8297;1470;36;F
8305;1384,3,376,828,1698,124,1338,1322,1325,1388,1359,1451,1434;36;F
8338;211,1332,1700,16,1633,265,2,1314,444,13,1312,140,408,192;45;M
8352;451,1332,1295,16,1314,13,1434,1312,982,192;42;F
8356;1470;38;F
8415;741,1,173,443,124,1468,702,373,1698,268,174,16,192,1451,1434;41;F
8432;702,1026,1359,1330,451,1338,173,834,174,1468,1559,1021,1328,265,1384;28;M
8458;982,373,1698,865,22,984,1434;15;F
8472;982,776,988,1482,1700,1328,1359,860,16,1633,865,1314,22,265,586;59;F
8507;774,1624,451,1021,1526,1325,1468,1604,1434,16,13,1328,265,776;45;M
8545;24,1468,13,774,223,1,1325,741,917,129,982,1700,268,1633,192;42;M
8558;1110,173,1344,443,776,1388,1347,268,174,1633,1468,376,3,13,1451;81;F
8584;947,1110,36,268,550,556,1524,828,733,1468,1510,1384,1559,376,192;35;M
8585;826,16,1633;40;M
8601;1706,1325,1332,1524,1509,1347,1026,1468,1451,1434,1510,1526,1322,982,1533;62;F
8602;776,1482,1468,1021,1526,1,1533,1524,1509,1532,1026,1359,265,13,1434;30;M
8626;451,1698,1470;35;M
8627;988,550,22,265,984,3,1338,834,586,1517,1021,1,1524,702,1026;48;M
8636;1344,1347;43;F
8661;129,173,174,865,192,1559,1384,1328,265;37;F
8673;1295,1312;19;M
8678;947,17,1325,129,1698,1330,1021,1338,1322,1700,1328;43;F
8688;1624,17,826,1295,1482,373,16,1468,1608,1441;18;F
8697;1470,586;28;F
8723;826,1021,917,1624,774,451,1322,1325,211,140,265,16,1482,1347,1328;33;M
8728;1322,826,129,211,995,1332,1482,1698,16,1633,376,1441,1312,140,192;29;F
8738;865,36,988,1332,23,1384,17,774,1119,1338,741,1110,173,1559,1261;43;F
8747;1325,1110,1344,776,1482,1347,702,1434,1451,13,265,1468,1633,16,1328;31;F
8774;192,394,1559,451,917,1581,1524,554,1119,1700,702,1698,373,865,376;33;F
8776;1,1322,129,1581,1332,1388,1700,1698,373,1359,192,265,1314,13,1434;40;F
8788;1328,1524,1325,1322,1517,1624,1330,1338,834,1700,373,1698;9;F
8805;223,1322,741,1325,982,1700,1347,702,268,174,444,24,1633,1468,192;11;M
8817;1119,394,917,173,1,865,409,995,1332,984,982,22,586;39;F
8819;192;13;F
8836;1330,451,1328,22,265,1441,1434,1312,140;51;F
8861;17,917,826,129,982,896,1482,1347,1698,16,1468,376,1312,140,192;59;F
8880;1344,1295,1482,702,268,1468,984,1434,140,17,741,443,124,22,444;35;F
8883;1332,867,1347,268,265,13,140,1510,297,917,1026,702,1524,1021,1517;24;M
8890;1,223,917,297,1119,451,1322,1325,512,1700,373,174,1468,22,1470;61;F
8895;1119,1261,1322,1,129,443,1332,1524,1295,1509,1700,373,16,1312,1384;43;F
8912;984,865,741,376,22,17,1,129,124,36,16,409,1332,982,586;9;M
8940;17,1581,443,1700,1468;32;F
8945;1624,917,1322,1581,1468,1314,1434;39;F
8999;1482,1698,192,394,984,1451,1,1434,376,1624,1322,129,1388,124,373;12;M
9006;265,1330,1328,1633,1559,13;48;M
9026;451,1322,1325,1,129,173,512,834,373,174,1468,22,1470,444,140;11;M
9033;1581,1524,1322,702,1347,173,556,36,1,1026,174,1468,265,1559,13;44;M
9043;376,36,1119,394,917,173,1,865,995,409,1332,984,982,22,586;6;F
9069;1524,867,863,1482,1532,1608,1468,140,865,13,1510,211,1322,1624,17;51;F
9077;896,1332,1581,995,17,947,1119,1,129,556,1700,373,1698,174,865;38;F
9121;1624,1482,1347,702,1359,268,24,16,1633,1468,376,13,1451,1434,140;70;M
9130;192;49;F
9145;192;42;F
9153;1604,1322,556,1509,124,1487,373,1698,16,1468,1559,2,13,1434,140;49;F
9216;1517,1700,1698,1434,1312,408,1470,586;38;F
9228;373,1604,774,1338,1325,1,1110,1344,443,1482,1388,1347,1633,376,3;33;F
9233;1604,774,1526,173,443,1359,376,1434,1559,174,1328,1532,1509,1416,265;48;M
9259;1468,22,140,2,16,1,774,1325,1581,443,124,376,394,1559,1510;47;F
9270;1470,586;38;F
9274;1482,1344,774,917,826,443,1347,1328,265,1451,140,1624,1604,1526,1434;65;F
9275;995,1332,776,988,834,1700,1698,733,174,1608,22,13,984,376,192;24;F
9279;17,776,1347,702,1026,1328,1698,174,1468,22,265,2,1314,1441,1434;37;F
9303;192,586;10;M
9313;409,1,917,1624,17,774,1344,988,834,443,1526,1509,1482,1532,1451;42;F
9329;1344,834,1509,1633,1517,1322,443,1524,1347,702,1026,1698,1468,1434,1384;33;M
9336;1,129,1581,1482,36,124,702,16,1468,2,1314,13,1451,1434,140;43;M
9364;826,1325,1,173,1581,443,1524,834,1482,36,733,1314,1510,174,16;29;F
9366;1434,1604,451,1026,1328,1624,1517,1021,1526,1533,1524,702,16,1468,265;39;M
9373;1330,265,1328,702,36,1524,443,173,1,1322,1021,774,1517,1604,1624;12;F
9398;451,1330,1322,1328,702,16,1468,1581,443,1332,1359,268,265,1434,1510;39;M
9400;826,1322,1706,1110,1482,1700,1347,702,16,1633,1468,13,1451,1434,140;26;F
9402;376,17,741,1,124,1295,826,1700,702,1026,1633,265,394,984,13;33;F
9420;1470;18;F
9421;1604,1624,774,451,826,1706,1325,1110,1581,1700,16,1633,1468,13,1434;27;M
9432;1451,140,382,982,1332,124,268,24,1470,129,451,17,984,444,586;32;F
9466;995,1559,13,1698,702,1524,1338,451,17,1021,16,1468,22,376,1434;29;F
9515;1021,140,1434,1468,16,451,1526,1325,1533,1581,1332,1524,776,1509,1026;23;M
9521;1110,1624,451,1119,774,1325,173,443,867,776,988,174,1468,376,13;24;F
9534;129,1581,443,1482,1700,702,373,1359,24,16,265,1314,1434,1510,140;41;F
9542;1624,774,1021,1526,129,443,1524,1509,1026,16,1468,1559,1314,13,1434;34;F
9549;834,1338,451,223,192,174,173,140,124,13,36,24,16,1700,741;19;M
9583;1021,451,1517,1624,1524,776,702,1026,1559,265,13;36;M
9625;1416,409,982,211,1332,1295,863,988,1698,860,865,22,1559,984,1384;40;F
9638;1434,1510,451,774,1624,741,1325,1,1482,124,24,16,1468,2,13;33;M
9662;1325,129,173,1700,1328,174,2,1312,776,1468,16,1314,1330,13,1;41;F
9670;1026,174,1468,1451,1434;37;M
9683;1021,741,1325,1110,1524,1509,1468,1434,1510,1,982,1344,1332,1700,702;46;F
9690;265,1330,512,1524,1468,13,140,408,1624,1517,1021,702,1026,16,1434;40;M
9695;1700,124,1021,947,1517,1338,834,702,394;39;F
9719;1441,1468,1633,1698,1347,867,995,173,982,1110,409,826,1322,1119,1624;37;F
9724;947,1624,1604,568,451,1021,512,1347,702,1328,24,16,376,1510,140;22;M
9735;13,124,1,129,173,174,2,3;32;F
9742;1,1344,512,1468,408,1624,1517,741,982,1524,896,1700,702,1026,586;46;M
9763;1314,13,140,1332,1624,297,1344,776,1347,1468;46;M
9783;373,826;42;F
9800;1526,1322,1325,1416,1,1581,1509,702,1328,1698,174,16,1468,265,1434;27;M
9904;124,1532,23,774,1624,443,776,896,1482,702,16,2,13,1451,586;35;F
9927;1322,1700,828,2,1434,17,1604,947,917,1295,865,192,376,1312,140;40;F
9946;586,408,1434,1700,834,988,1325,1322,1119,774,550,1559,1470,554;32;M
9960;1119,16,586;32;F
9972;1026,265;40;F
10002;16,1633,1468,1314,1434,1451,776;67;F
10033;451,1,129,1110,556,776,1482,1532,1359,268,16,376,1559,3,1510;35;F
10064;568,584,1624,1604,17,947,774,1119,1261,173,982,1416,1509,373,1698;43;F
10069;1322,1325,1,1581,702,1026,373,16,1468,376,265,1559,1441,13,1434;28;M
10120;451,1509,1482,36,1517,1624,774,1021,1,129,443,1524,702,1026,1559;48;M
10142;1517,36,1624,451,1021,1581,1524,1700,702,1026,268,16,265,394,1470;34;M
10144;1517,1322,982,1347,1344,1332,1482,124,1698,702,16,1468,1441,984,13;48;F
10149;173,774,776,1624,1526,1322,443,24,1633,16,1468,265,13,1434,140;32;M
10156;826,586;54;M
10271;1700,129,1021,1604,1624,1330,451,1322,1325,1581,1328,265,1559,1359,1468;45;F
10296;1533,2,3,1624,17,1526,1416,443,1509,1532,373,1559,1451,1510,140;37;F
10301;16,1633,1468,1559,2,13,140,1322,1338,774,1624,451,1,1434,376;24;F
10307;382,1314,1470,1384,1119,1330,451,1338,741,1325,129,173,512,174,192;31;F
10315;16,1633,1624,1517,774,1,512,1344,1524,896,1700,702,1468,13,408;47;F
10321;124,1700,702,1314,1434,1510,1384,1624,1119,1338,173,776,174,1633,192;42;M
10333;17,1119,1,1110,173,443,1698,394,13,1451,776,174;28;F
10337;1021,1261,1524,1700,702;37;F
10339;1325,451,1330,1388,124,1347,702,1026,1328,1359,174,265,1559,1451,1434;33;F
10351;1119,451,1338,826,1322,173,1581,776,1482,1470;29;F
10400;1517,1021,1325,1,1344,1524,702,16,1633,1468,265,13,1434,1510,140;44;M
10405;1468,1451,1434,1312,1510,140,129,982,443,776,702,373,1698,24,192;45;F
10419;1,1533,1524,36,702,1026,1328,373,24,16,1633,1468,265,1559,1510;31;F
10453;1517,774,1021,512,1344,1524,896,1700,702,1026,1468,16,1633,13,408;19;F
10468;896,173,1322,1325,443,834,373,1698,1359,174,265,1451,1434,1510,1384;21;F
10476;1581,1510,376,17,1344,443,1388,124,1700,1698,733,192,444,3,1451;35;M
10507;556,443,1110,129,1,17,1388,1700,1347,702,16,1468,1559,265,13;38;F
10550;1517,1338,741,409,1332,702,24,124;34;M
10567;1322,741,1416,1295,16,865,376,36,1517,947,124,1700,1698,1441,586;36;F
10582;1119,451,774,1261,1110,1344,1026,1328,24,1608,265,1314,1470,1434,1510;38;F
10584;13,1451,1468,443,1344,1581,1322,1261,1526,223,774,1624,1359,16,1559;34;F
10600;556,1328,550,192,265,1470,554,174,1344,1119,1021,982,1295,834,947;42;F
10668;124,1388,702,373,828,174,16,1468,192,265,3,13,1451,1434,140;28;F
10672;1624,774,451,826,1325,982,443,776,1482,24,16,1633,1559,140,13;39;F
10703;3,1384,1119,451,1526,1332,1509,1359,174,1559,1441;36;F
10708;984,586,1510,1608,865,988,659,382,947,1261,129,268,373,982,1332;35;F
10712;1604,774,1322,1344,16,1468,13;44;F
10729;774,1021,1338,1,129,1328,556;42;F
10757;1526,129,124,268,17,1261;34;F
10762;1322,1441,13,1510;28;F
10766;1700,1608,1559,1328,1388,1482,776,409,917,1330,1325,1359,265,1451,1434;31;F
10767;1524,995,1338,129,1581,124,586,394;37;M
10774;1624,1604,451,1021,1526,1322,129,1524,1026,1328,16,1468,265,444,1434;38;F
10775;917,776,443,1388,268,1633,3,140;31;F
10782;16,13,1451,1434,1510,140;30;M
10791;1322,1526,1021,1624,16,917;29;M
10792;17,584,776,988,550,733,1468,22,376,2,1441,444,1451,13,1434;30;M
10823;556,173,982,1322,826,947,17,373,268,174,865,1441,1434,1698;45;F
10829;2,1332,1700,1328,16,1468,1608,22,376,265,1441,13,1434,1510,140;46;F
10839;1261,1559;38;M
10841;1344,1581,1110,1325,1322,1517,297,917,1119,451,826,129,173,1359,174;34;F
10851;1604,512,1347,1434,408,1517,826,1524,1700,1338,702,1359,297,1581,192;41;M
10860;584,733;31;M
10862;1021,1526,1581,1509,1698,1359,16,1468,192,376,1559,554,13,1384,140;71;F
10877;774,192,394;40;F
10886;17,1,1581,1524,1482,1532,702,1026,1451;35;M
10896;1261,1559;35;F
10920;1533,1026,1021,1509,1384,1416,1261;37;F
10935;268,1347,129,1,1325,1624,451,1706,512,1344,443,174,1470;35;M
10943;1633,192,408,1119,129,1344,556,1328,550,174,16,265,1314,1470,554;8;F
10952;1624,17,1517,741,443,1482,124,24,16,1468,376,1314,1451,1434,140;32;F
10966;173,1581,1295,776,1509,36,1700,174,376,265,1470,3,1451,1434,1510;37;F
10968;17,1517,1581,834,702,16,192,1314,1441;26;M
10969;1624,1322,1388,124,1325,443,24,3,1434,586;39;F
11010;1524,776,834,1509,1532,1388,702,1026,1328,16,1468,265,1559,13,1434;32;F
11057;1119,451,443,774,129,982,1581,1344,1328,1698,16,265,444,1434,1470;37;F
11063;1517,1624,917,741,1,1110,36,124,1700,1698,174,24,1468,376,1434;37;F
11097;1526,1325,173,1509,1482,1532,1347,1328,174,1633,1468,265,1559,1434,1510;20;M
11202;1344,24,16,1119,774,1468,865,1608,192,1470,586,382,512,1700,408;40;F
11260;13,1604,1624,947,1325,1,1581,1482,1698,828,1633,394,1441,1451,1510;32;F
11286;776,36,1328,1624,1604,1517,124,1347,1468,702,1,443,741,24,13;35;F
11305;373,211,947,774,1526,556,1524,896,1509,1698,828,550,733,376,554;25;F
11331;1624,17,741,1,24,1468,1559,3,140,1434,917,1517,702;30;M
11335;17,1470,1451;42;F
11344;1532,1700,373,174,1633,1359,24,16,1468,265,1559,1314,13,1451,1434;17;M
11369;1261,1416,982,443,1026,1384,1559,917,1119,1021,1526,1110,1524,1509,1532;43;M
11372;1021,1322,1325,702,1026,174,1468,1510,556,173,834,129,1;45;M
11421;1328,373,265,1434;30;F
11442;1517,1328,702,1359,24,1434,1533,173,1,741,1330,451,1604,297,265;26;M
11621;1581,443,124,1700,1434,1510;65;M
11637;1533,1700,1359,1624,1338,1325,1416,211,982,1328,1468,1434,1312,1384;42;F
11699;741,1021,451,1330,917,17,1604,1624,24,1468,1559,3,13,1451,586;26;F
11718;1119,1526,826,1314,13,1451,741,1624,24,16;49;F
11722;917,1322,129,1581,124;30;M
11735;382,1604,1,1325,1322,1338,223,1119,917,568,1021,1470,1434,1384,1261;42;F
11762;774,1517,1624,1604,917,741,1,129,1581,556,776,1482,124,702,24;48;F
11767;268,24,16,1633,1468,376,394,1559,2,1314,1441,13,1451,1510,140;29;F
11790;1581,1526,826,451,1624,129,16,1434;32;F
11803;1119,1330,451,741,443,1482,1347,268,3,13,1510;41;M
11816;17,265,1624,947,1338,1322,1325,982,995,1509,1700,1468,13,1434,1312;42;M
11827;776,1509,1532,1388,1026,1328,373,1468,16,22,265,394,1441,1470,444;48;F
11833;1700,586;38;F
11850;451,1021,16,1468,1624,1517,702,1328,174,265,1434;40;M
11866;1110,1509,702,1624,1517,1330,988;38;F
11892;1624,702,1,36,1347,373,16,1633,1468,192,376,1314,2,1451,1434;30;F
11901;1021,1604,1330,1532,1559,1328,265;70;F
11912;1581,173,1526,1021,1330,568,1261,129,1328,1359,265,394,1559,1510,1384;36;F
11916;1509,124,1510,1624,774,1119,268,16,1468,3;34;F
11917;733;47;M
11929;774,443,1322,1325,409,1482,1388,1328,1698,1468,376,1526,1451,265,124;32;F
11958;1338,1,834,1482,174,16,1633,1468,192,1314,554,984,13,140,408;34;F
11993;741,124,268,265,1510;30;M
12003;1338,774,1110,1509,124,1468,265,1624,1517,1,1344,1524,16,13,1510;25;F
12008;1119,1330,451,741,443,1482,1347,268,13,1510,3;73;F
12036;173,982,1,1322,451,1119,774,17,1624,1325,1110,373,1698,174,13;53;F
12078;1344,17,1119,1330,451,741,443,1482,1347,268,3,13,1510;78;M
12086;1624,1110,1344,443,124,24,16,1633,13,586;44;F
12110;1,1533,16,13,1526,776,1509,1517,1021,1524,1532,1700,702,1026,1559;31;F
12140;23,984,192;42;F
12182;192;52;M
12189;192;59;F
12202;1021,1338,826,129,1524,36,124,702,1026,1359,376,265,1,140,1533;44;M
12229;1468,192;45;M
12245;297,826,1322,1325,129,982,1581,1332,174,16,1468,192,394,984,1510;38;M
12251;2,192,1698,1517,982,1344,443,556,1332,776,1388,1347,702,174,1451;51;F
12259;1532,1347,702,1026,1698,16,1468,1608,22,376,1559,1314,13,1434,1384;31;F
12287;124,22;53;M
12317;13,173,834,174,1468,1441,1451,1510,17,1517,1119,451,1,1110,140;40;F
12319;741,1322,1338,1604,1624,1468,22,13,1451,1434,140,1517,702,982,1332;27;F
12373;13,774,1119,1517,1604,1624,776,702,1026,1328,16,1468,265,1559,1434;38;M
12394;1338,1119,1517,17,741,129,124,702,373,1698,16,1608,13,1451,1434;29;F
12410;1,1533,1524,1509,1532,1026,1328,1359,268,24,16,1468,265,1559,1434;30;M
12442;1524,1581,23,409,1322,917,1604,1624,1517,223,1,1295,702,554,1312;27;F
12508;741,1526,1021,774,1517,1604,1624,1347,702,1026,24,16,1468,3,13;48;F
12545;1110,1119;34;M
12568;741,1524,265,1,1322,1330;33;M
12573;16,1468,1559,1441,1314,1451,1510,140,947,2,1110,1344,1347,3;30;F
12577;774,443,16;31;F
12596;268,1468,376,2,13,1624,17,947,917,1332,124,1698,733,16,22;36;F
12598;1526,1322,1524,1509,1532,1026,1359,1434;42;M
12613;1325,1581,988,1700,268,2,1314,13,1451,1312,140,586;54;M
12644;1261,129,1524,1509,1700,1026,1698,1359,265,1559,444,1451,1434,1510,1384;36;F
12685;3,1434,140,1604,1624,1325,1581,443,776,1482,268,16,1633,1468,192;43;M
12708;1347,1344;58;F
12717;774,1468,16,24,982,1330,443,867,394,1698,373,1487,995,947,1451;27;F
12782;1325,1526,1330,1604,1624,774,451,826,776,1482,1633,1468,1559,13,140;28;F
12791;568,774,947,584,1261,556,834,702,1328,550,376,265,394,1470,554;45;F
12808;408,1314,550,1359,1328,1026,702,1347,1700,1532,988,659,443,1325,1517;29;F
12820;1633,22,988,1332,995,982,409,1624,1470,984,211,826;38;F
12827;1416,409,982,995,211,1332,1295,863,988,860,865,22,1559,984,1384;14;F
12831;1524,1470,173;41;F
12874;1532,1359,24,16,265,984,13,982,129,741,1526,1021,451,17,1604;34;M
12882;1509,36,1700,16,1468,13,1434,140,1517,451,1021,1,1524,702,1026;49;M
12887;265,451,1526,1,1261,1559,984,1026,702,1524,1581,982,129,1021,1517;50;M
12895;1517,1021,129,982,1581,1524,702,1026,984,1559,1261,1,1526,451,265;19;M
12898;1517,129,982,1581,1524,702,1026,1021,984,451,1261,1,1526,1559,265;12;F
12959;1510,586,17,1416,1581,834,1700;24;M
12964;1,17,1509,1532,1026,1698,1434,1021,1526,1322,982,1533,1524,865,1559;38;F
12980;1624,451,1706,1,1524,268;32;F
12991;394,13,1510,1624,297,1119,451,1110,173,174,140;42;F
12993;1517,1021,1322,1,1524,1295,988,702,16,1608,265,140;45;M
13008;1526,1261,1533,1532,124,1026,860,16,192,265,444,1524,1700,1359,1559;37;M
13041;1581,1110,1416,741,1526,1021,917,947,1322,1325,409,1533,1700,1698,1384;39;F
13042;776,834,1700,1698,1633,394,1434,129,988,1482,268,376,3,1451,1510;52;F
13044;409,982,995,1332,1295,863,988,1509,373,1698,865,22,1559,984,1384;2;F
13070;297,1110,173;32;M
13087;1330,1624,1517,443,776,1482,16,1633,1468,394,1559,1314,3,13,1451;30;F
13103;1624,1322,1,1524,896,1482,1026,1328,1633,1468,265,13,1451,1434,140;31;M
13140;1295,867,1416,409,982,211,995,1332,863,988,1698,865,1559,984,1384;18;M
13158;22,1332,24,982,124,17,192,774,741,1119,1314,1338,1434,702,1510;36;F
13182;1581,1604,16,1468,394,13,3,1517,1295,124,702,1434,1312,140,586;33;F
13185;1524,867,1532,1026,1328,373,1698,1359,1468,376,394,1559,1441,1434,1384;40;F
13187;17,1700,373,1698,1441;56;F
13198;1581,834,550,265,394,947,1441;45;F
13202;1322,1526,1021,947,17,1533,1524,1509,1532,702,1026,865,1559,1434;4;F
13212;1581,443,1524,1295,124,1700,702,1698,268,174,1468,192,13,1312,1510;43;F
13213;741,451,1624,774,1322,1325,1110,776,1347,1468,376,13,1451,443,1482;49;F
13225;1347,124,988,443,1344,1581,211,23,1110,1,741,1451,1434,140,896;33;F
13238;1509,1532,124,1700,1633,1604,1624,443,1581,1347,24,16,1468,13,1451;28;M
13253;774,1624,173,174,13,265,1468,16,1328,1325,1526,917,1434,1700,1261;32;F
13260;1119,129,1581,1359,1328,1330,1322,1434;46;M
13319;1119,1624,1526,1,129,1110,1524,1509,1532,1700,1328,265,13;40;F
13343;443,776,1482,124,1347,1359,16,1633,192,265,394,2,1441,13,1434;46;M
13366;1347,1325,1322,826,451,1604,16,1633,2,1434,1581,13,1451,1510,140;33;F
13401;774,1526,1261,1325,443,1524,776,834,1509,1328,1359,376,265,13,140;42;M
13432;1517,1,1524,124,702;19;M
13461;776,1482,36,702,1026,24,16,1633,1468,376,3,13,1434,1312,140;40;F
13492;265,702,1328,1434;35;M
13525;1347,702,16,1468,376,1451,1624,13,1434,1524,443,774,1,1026,1526;49;F
13583;1119,451,1532,1110,1344,1,1026,1608,24,268,512;24;M
13595;556,776,265,1261;46;F
13627;1624,1604,774,741,1325,443,776,1509,1559,1470,265;27;M
13734;1482,1581,129,1,1325,1526,1021,917,1624,451,173,1532,1698,1470,1434;30;F
13754;554,556,129,1624,17,947,1021,1322,834,373,1698,550,733,1468,1441;18;F
13759;1533,834,1509,1532,1700,1359,268,550,16,265,1559,1441,444,1510,1384;18;M
13805;451,774,1624,1468,1441,1510,1604,1517,1119,1,129,173,124,192,1314;36;F
13811;741,124,24,376,2,1441,13,140,1451;34;M
13819;826,1482,1347,1633,1468,192,1314,1470,1624,774,451,1344,776,13,16;39;F
13835;1510,1581,140,774,1325,443,556,373,1698,1359,16,1441,1470,3,1434;30;F
13845;1604,1624,1330,451,1482,1328,1468,265,1559,741,584,733,16,865,376;37;M
13871;1517,1624,741,1344,36,124,1700,702,24,16,376,2,984,13,140;26;F
13899;1524,1026,1468,140,1384,1624,1526,1416,1509,1532,1359,1533,1559,1441,1434;33;M
13901;1328,265,1524,702,1359,2,1441,3,1434,1510,173,1026;29;F
13902;1581,451,1322,1325,1468,1434,1532,1509,1624,1604,1517,1526,1533,1524,1559;18;M
13909;1322,1581,776,124,1700,1026,174,376,984,140,1347,1344,1110,1119,297;39;M
13919;140,1325,1517,1021,1322,1524,36,1026,16,1633,1468,1559,1314,1434,3;38;M
13934;584,1517,17,947,23,211,373,1698,828,733,22,376,2,1441,13;24;F
13973;129,173,409,982,1325,1338,774,1119,1110,995,1388,268,984,3,1434;47;F
13988;776,1468,826,1119,774,1322,24,1633,13,16,451,1344,174,173,297;24;M
14000;702,1347,443,1526,988,1388,1532,1509,1559,13,1026,1110,982,1524,1021;38;F
14027;451,982,211,863,1359,444,733;48;M
14059;16,1517,17,1119,1021,1325,1110,173,1524,1295,1026,268,174,376,2;26;F
14156;1338,223,1119,947,17,1441,1470,586;38;F
14163;774,451,443,16,1468,13,586;51;F
14165;774,1,23,982,995,443,776,988,1482,1698,268,1633,1441,984,1510;70;F
14185;1021,774,1624,1517,1322,776,1482,1700,702,1026,373,16,1468,13,1434;44;F
14210;1517,774,1,1332,988,36,1700,702,24,376,394,1559,1314,984,1510;38;F
14224;1532,1468,1624,1604,1526,1322,129,1581,443,1509,16,1633,1434,140,192;46;M
14254;865,192,268,17,1510,140;53;M
14256;1434,373,1325,1,1624,1344,1468,1517,1524,702,1026,1482,982,16,1510;39;M
14288;192;75;F
14307;265;31;F
14328;776,1524,173,1338,1119,774,1604,1624,1517,1325,1,1581,702,373,16;35;F
14347;373,16,376,2,1482,867,1332,23,129,1,1624,268,192,917,1510;35;F
14408;1312,2,17,917,1451,192;37;F
14411;1633,1526,1604,1624,22,13,1110,1325,443,1332,1509,1347,16,1468,982;42;F
14477;376,1608,1468,16,174,1698,373,1482,1581,173,1110,947,1624,394,1441;26;F
14516;826,917,947,17,1604,23,982,1581,988,1388,373,1441,1451;60;F
14550;1482,1698,1468,1510,1624,382,1706,129,512,1388,1700,192,1451,1312,408;65;F
14565;124,1468,865,22,1441,1633,394;47;M
14579;1624,774,1526,1110,443,776,1509,1532,1347,1328,16,1468,1559,13,1451;36;F
14596;451,1330,1325,1581,443,776,1509,1328,1359,16,1468,265,13,1434,1510;71;F
14621;1344,23,451,1624,774,1325,1110,443,3,1388,1468,16,394,1441,1510;33;F
14659;1532,1347,13,140,17,23,443,776,1482,268,1468,1559,3,1510,1434;38;M
14680;17,1021,982,1482,1328,1359,16,376,265,2,1314,1441,13,1434,1510;59;F
14689;917,1119,982,995,1533,1581,36,16,22,13,1434;22;F
14693;741,1526,1110,1344,443,1509,826,1347,702,1026,24,1468,1633;41;M
14695;1624,1325,173,174;80;M
14738;1261;34;F
14758;1700,1328,1698,265,1559,1441;23;F
14759;24,834,776,1524,1581,1110,1325,1322,826,774,917,1517,451,16,13;29;M
14794;586;50;F
14810;1604,702,1624,1517,1322,1581,1482,16,1468,376,1314,1441,13,1434,1510;39;F
14894;1330,173,1581,443,776,1328,1359,174,16,376,265,13,1434,1510,140;71;M
14906;409,982,1581,443,776,988,124,702,373,444,984,13,1451,1434,140;66;F
14908;192;55;F
14910;1517,1021,1524,702,1026;29;M
14962;174,1434,444,1470,1700,774,826,382,1706,1325,129,512,124,24,408;39;F
14971;1338,1322,1,776,988,373,1698,1359,268,1468,265,1441,1434,1510,140;35;F
15020;1624,1119,1706,1470,13,1434,140;33;M
15035;702,265,24,1482,1698,13,1325,1581,443,1524,896,373,16,1468,1451;25;F
15037;1325,1509,1532,984,13,1434,140;38;F
15042;124,1698,373,394,1312,1624,1332,776,1700,702,865,192,376,2,140;43;F
15059;443,1624,1517,1021,1526,1338,982,1533,1524,1700,702,1026,1698,1468,1451;22;F
15066;1581,1325,1322,774,1517,1604,1624,917,1,129,702,265,1314,13,1451;65;F
15098;1624,443,268,24,16,1468,13,1451;35;F
15163;1533,1344,1468,1559,1314,1470,1434,1510,1624,917,1322,129,982,1700,22;72;F
15250;1604,17,774,1706,1110,1344,867,1441,1451;33;F
15281;1624,223,451,1325,741,982,1581,988,124,373,444,984,13,1451,1434;66;M
15322;173,828,16,1468,865,1608,192,265,394,1441,984,1312,1633,1482,1510;30;F
15345;1604,1110,173,443,556,1524,776,1509,1482,1532,702,1026,24,16,1468;54;F
15376;140,1509,1524,443,129,1322,1526,1021,223,1532,1700,1026,1359,1559,1434;46;M
15390;1624,774,1330,1322,1706,982,1332,834,1328,1359,268,174,1468,265,13;13;F
15426;917,982,1332,988,22,1470,1434;65;F
15467;1624,17,1322,1021,451,173,1524,702,1026,1328,1633,1468,265,1559,13;22;M
15469;982,211,1332,988,444,984;61;F
15488;988,896,1344,129,1110,1624,297,1604,1322,741,443,1388,24,3,1451;51;F
15520;1624,451,1,23,443,556,1700,1347,702,1468,984;44;F
15521;373,1510,828,17,1344,863,988,1347,733,860,1633,865,376,394,984;47;F
15535;1624,774,1330,1322,1706,982,1332,834,1328,1359,268,174,1468,265,13;9;F
15537;17,1526,1261,1338,1524,1328,373,1698,1468,265,1434,408,586;36;F
15561;1604,1624,17,1416,451,1526,1509,1532,1359,16,1468,1559,1451,1434,1510;53;F
15562;586;36;F
15569;586;36;F
15573;584,733;47;M
15640;1604,1517,1330,451,1,1533,1344,1359,268,16,1559,1314,1434,1510,586;36;M
15677;586;68;M
15692;13,702,1026,24,192,1,982,1344,443,1347,373,268,1633,1468,3;43;M
15695;867,863,896,1700,1328,1698,828,16,265,2,1312,982,1344,1347,1468;42;F
15716;17,982,211,995,1332,1524,896,988,1026,702,865,22,376,444,984;36;F
15719;129,1441,586;36;F
15732;297,173,1533,1510,1624,1344,443,268,16,1633,1468,2,3,1451,192;36;F
15741;1026,1021,1533,265,1434;42;F
15788;17,1624,947,774,1322,1416,129,1581,1295,776,1700,1328,1468,2,1441;49;F
15805;140,13,917,774,568,1581,1698,16,1468,984,1604,982,443,988,124;73;F
15820;13,1434,140,556,1698,192,265,394,1312,586;39;F
15950;1470,1434,408,741,982,659,863,896,174,192,376,265,984,1510,586;42;F
15958;1441,1332,443,947,451,1700,828,1698;39;F
15997;512,1509,1482,1700,1698,1312;24;F
16009;1604,1517,917,1526,1322,1325,1581,1344,1482,1388,1347,1633,1468,1451;34;F
16077;223,1021,741,129,124;36;M
16116;124,1509,982,1706,774,1624,1330,1338,1322,1524,1482,265,1328;69;M
16121;443,1325,1526,1021,1119,584,1624,917,774,568,1322,1,733,376,265;24;F
16122;1470;34;F
16175;17,982,995,1344,1332,863,988,373,268,1633,192,376,394,984,3;15;F
16192;451,1330,1624,1119,1526,1416,443,1532,1347,24,16,1468,865,1608,1559;48;F
16217;776,1330,1332,1338,1328,1325,1322,1434,265;36;M
16230;1441,984,1451,140,1624,17,1325,982,211,995,1332,988,702,1434,13;34;F
16233;1344,982,1416,1526,223,17,947,1261,1698,376,394,2,1441,444,984;45;F
16252;947,17,1624,1517,774,741,1,1581,443,1524,702,2,13,140,192;50;F
16262;1706,1,988,1633,1451,443,1347,1388,1021,1509,1532,1526,1559,1026,265;63;F
16345;1604,1624,776,124,1468,1451,586;37;M
16364;1328;32;F
16367;1581,443,1295,834,1482,124,373;45;M
16388;1624,16,1470;41;F
16426;982,1468,1332,1624,1322,1706,443,124,741,1434,1,17,376,1344,13;20;M
16434;373,1434;57;M
16453;1604,774,1119,1110,1581,1524,896,834,1482,702,1359,16,1468,1608,376;38;F
16484;1,1110,1533,1524,702,1026,16,1468,376,984,1434,1510,140,1344,1347;32;M
16485;1526,1328,192,1021,265;38;F
16550;2,1314,1698,1700,124,173,129,1,1325,1322,1338,451,1119,1517,192;33;F
16569;17,1338,1700,2,1441,1434,140;21;M
16585;1524,776,1509,1532,702,268,24,16,1633,1468,22,1314,13,1510,140;34;F
16635;1604,741,1581,443,776,1482,124,702,24,1468,140;52;F
16638;1604,1517,1021,1526,1332,1524,1509,1532,702,1026,1328,733,16,22,1434;31;F
16646;1533,1524,702,1359,174,1468,265,1559,3,13,1451,1434,1510,140,1328;37;M
16663;917,1604,1624,1322,896,1482,268,16,13,1434,1510;22;M
16665;1624,1604,451,1338,1,124,1328,265,1330,982;41;F
16683;17,1119,451,826,1110,173,512,268,174,1633,1468,3,1451,1434,140;36;M
16724;1581,556,776,1482,124,1328,373,1698,16,22,376,1314,1441,13,1451;49;F
16772;1604,17,1322,1325,1,1581,776,1700,1698,16;38;M
16815;1604,1468,174,1347,1700,1295,1332,443,1344,173,1706,1624,297,1119,1110;41;F
16829;1330,211,1388,1328,1698,1468,376,265,1441;49;F
16874;1470;46;F
16885;586,947,223,129,896,988,124,1700,1698,24,1468,376,1441,13,1312;39;F
16891;1470;11;M
16917;1322,1325,1026,1328,24,16,1633,1468,192,1314,140,1581,1338,13,1434;36;M
16921;1470;7;M
16948;1470;17;M
16949;1470;43;F
16953;1344,24,1633,1624,1517,774,1325,1,1347,702,268,1468,3,13,1510;54;M
16969;556,211,982,17,1524,867,863,988,1487,1700,1698,550,860,1608,865;50;M
17020;1608,1470;47;F
17032;1608,1470;9;M
17039;16,1468,13,1526,774,1624,1451,376,1026,702,443,1524,1,1021,1517;42;F
17045;1470;25;M
17055;1470;10;F
17064;17,2,917,1624,1604,1021,1322,1325,1,1581,1633,265,1559,1510,1328;33;F
17068;1470;4;F
17112;223;47;M
17175;834,1624,1110,173,1344,443,268,1322,1700,16,1468,13,1434,140,1510;22;M
17188;828,24,860,16,1468,13,1451,1434,1384,947,568,223,1338,1325,1;42;M
17217;297,1624,1517,774,741,1434,1451,13,1559,702;20;M
17232;917,1526,129,982,1533,1524,1026,1328,265,1559,1441,1434;38;F
17320;1312,1434,13,1295,451,1604,1624,1517,774,1021,1,1524,702,1026;51;F
17324;776,443,1,741,774,17,1604,1624,1700,1347,24,16,1468,2,13;30;F
17370;1,1581,776,1509,1482,1532,36,24,16,1633,1468,265,1384,140,13;13;M
17394;1581,1322,129,982,988,702,268,16,1633,22,376,984,13,1451,140;74;F
17421;917,1526,129,982,1533,1524,1026,1328,265,1559,1441,1434;10;F
17425;1517,917,1021,1338,1416,1,173,1581,1524,1482,36,1700,702,1026,174;19;F
17426;1517,917,451,1021,1325,1581,512,1524,124,702,1026,1359,174,3,408;30;M
17427;1517,917,1021,1416,173,1524,834,36,1700,702,1026,1359,174,1608,265;14;M
17444;451,1314,1510,776,1344,774,24,1624,1604,826,1509,16,1468,192,13;67;F
17454;1314,13,1434,1624,1604,774,826,982,1581,1482,1633,586;61;F
17537;223,917,1526,129,982,1533,1524,1026,1328,265,1559,1441,1434;8;F
17552;451,774,917,584,1624,826,1706,1581,1700,1698,268,1468,22,265,1510;39;F
17605;1517,917,741,1524,702;33;M
17643;982,1344,1509,1482,1532,1698,16,1468,2,140,917,1325,776,22,376;17;F
17645;17,1021,1526,1261,1416,129,865,1533,1524,1700,1509,1532,1026,1359,1559;45;F
17651;16,1468,265,174,1559,1110,1338,1526,451,774,1604,1344,776,3,13;62;F
17675;741,223,947,17,584,211,995,124,1347,550,733,16,1468,2,1441;27;M
17689;947,1325,556,988,1388,394,1510,586,23,373,22,376,2,13,1451;24;F
17721;917,409,1328,373,265,140,586;36;M
17737;1,1524,36,1700,702,1026,174,1468,192,376,2,1314,1441,1470,1384;37;M
17747;584,1517,1,1509,1487,1700,1347,1468,865,22,376,394,1314,982,192;41;F
17750;1470,1384,1119,451,826,382,1706,1509,1700,1468,192,1441,13,1451,1510;32;F
17776;947,1119,211,995,443,834,394,1314,917,774,373,268,828,174,192;52;F
17777;1325,1338,774,1624,947,1581,124,1700,373,1698,268,865,394,2,1441;56;F
17786;17,451,826,129,834,1700,408,1470;36;F
17793;586,1322,2,1119,129,982,443,36,124,702,24,1468,376,394,140;42;M
17799;826,741,1325,1110,173,1581,1524,776,124,702,1026,268,174,16,1633;25;M
17802;1338,124,741,140;43;F
17848;1338,947,1624,1698,1468,865,1441,1434,140,223,1322,982,1700,586,192;49;F
17856;776,1325,982,1581,443,1332,988,376,394,2,984,13,1451,774,1330;53;F
17857;834,1328,373,394,1441,584,1604,1581,1482,1700,702,192,1470,1451,1434;50;F
17871;1624,17,774,568,1,982,1344,443,863,1700,16;28;F
17878;1,982,1524,1509,1482,702,1026,140,1119,1700,1434,1526,1328,265,1261;41;M
17937;988,1119,1604,1624,17,774,1,982,174,1633,376;57;F
17939;586,394,1441,554,444,984,947,129,211,1581,867,223,568,17,860;38;F
17944;774,451,1021,1,443,556,1524,659,702,1026,550,1468,265,554,13;35;F
17967;129,124,702,373,1698,24,1468,1608,192,394,1470,1434,1510,408,586;44;F
17968;1608,1312,297,1526,23,1110,1344,443,1524,776,1532,1482,1559,1434,1451;24;F
17969;1021,1533,1524,1532,1700,1026,1328,1698,1359,174,16,1468,265,1559,1434;38;M
18015;443,1468,1451,1624,917,1581,776,1482,1347,16;27;F
18016;1509,1532,124,1347,1328,24,16,1633,1468,1559,1314,3,13,1451,586;10;M
18018;1624,297,1604,1517,1021,741,1325,1,443,1524,124,702,1026,373,1698;37;M
18054;1624,774,1295,1388,268,1633,1468,22,192,376,3,13,1434,1312,140;71;F
18057;995,982,741,1322,1526,1517,863,124,1328,373,1698,1026,265,223,1021;35;F
18061;443,1624,774,741,1344,1110,776,1509,1347,268,24,16,1633,1468,13;53;M
18110;129,1347,702,828,24,16,1633,1468,22,192,1314,1441,140,17,376;46;F
18115;988,1624,1119,568,1,409,982,211,995,863,268,865,444,984,1510;37;F
18162;13,444,268,1624,1119,1330,451,1261,982,443,1332,896,174,1441,984;37;F
18166;17,1119,1322,409,776,1700,1698,268,22,376,394;43;F
18171;1624,1517,1,1524,36,1328,860,24,16,1633,22,554,984,3,1510;46;F
18218;1451,17,1119,223,173,1295,174,1470;42;F
18226;17,1021,1526,1509,1532,1328,174,265;35;M
18248;1524,24,16,1633,13,774,1526,1110,443,776,1509,1347,1624,1468,1451;46;M
18271;1624,1322,1706,129,2,1314,1470,13,1451,1434;12;F
18325;1359,16,1441,1470,554,1434,1510,1384,1,129,1533,834,1328,550,265;41;F
18346;1624,17,1517,774,451,1,1110,173,1581,776,1482,702,268,1633,1468;48;F
18368;17,1338,409,988,1698,268,1119,1416,1581,1559,1441,1524,1700,1026;20;M
18369;1470;44;F
18372;584,17,1604,947,917,1325,1,776,1487,1698,16,3;35;F
18376;17,451,129,1344,1295,863,1482,1312,1510,1261,211,1328,373,376,394;43;F
18389;1526,1021,36,1532,702,1026,1328,1359,24,1633,16,1468,265,1559,1434;25;M
18400;550,554,1470;41;F
18426;982,1533,1344,1332,1524,1509,1532,1347,1359,865,22,265,1559,984,1434;36;F
18452;1119,741,129,982,1482,1700,702,268,16,444,984,13,1510,140,408;35;F
18514;1700,834,867,556,1110,1325,1322,223,774,17,741,124,1698,24,192;42;F
18535;1451,3,376,22,995,1624,947,223,741,129,776,1388,1700,24,192;12;F
18551;1338,995,982,1332,268,828,174,16,1624,22,192,376,1314,984,1451;33;F
18623;1517,17,1325,1,1524,1332,988,702,1328,1698,16,1441,444,984,1510;42;M
18627;860,211,173,995,1524,863,988,702,174,1119,982,1332,268,865,1510;36;M
18664;3,17,917,1338,1524,896,1532,1347,1700,1328,1698,1468,1559,1314,1384;24;M
18689;1526,1604,1624,774,1330,451,982,1509,1532,16,1468,376,1559,1314,140;44;F
18695;1119,1110,1700;47;F
18706;1517,947,1021,1,173,1524,36,1700,1328,174,16,1608,192,1470,1510;42;M
18714;1119,947,741,409,129,982,1332,1295,896,865,1608,22,192,984,586;;F
18736;1295,984,554,865,268,1332,982,129,947;6;F
18750;17,917,1,409,982,1581,1332,863,834,860,1633,865,394;46;F
18758;702,1026,268,24,860,16,1633,192,394,1314,1441,3,13,1451,1434;42;F
18761;17,140,13,1698,774;48;F
18770;1487,192,984,865,988,1332,947,982,409,129,1700,554,1434,1510;3;M
18828;1604,1624,1517,1325,776,1482,1347,1698,268,174,16,1468,3,13,1510;24;M
18850;1119,1110;51;M
18858;1517,1604,1338,1322,1524,1700,1347,1468,265,1325,1,556,36,16,1434;51;F
18888;1434,1344,174,1468,1470,1581,173,23,129,1325,382,451,1119,512,408;43;F
18898;1325,1624,947,1338,1,982,1509,1700,1698,1359,265,1441,13,1312,1384;18;F
18908;947,17,1338,1322,1325,982,1524,1509,1700,1359,1698,1441,1434,1312,1384;13;M
18921;1026,268,16,1633,3,1434,140,1624,223,1322,1,129,1581,1332,394;41;F
18933;1021,1119,1517,173,1533,1332,1524,1700,702,1026,1559,3,1451,1510,982;22;F
18971;36,1532,268,1468,865,192,376,1559,554,13,1451,1510,1388,1441,947;32;F
18978;1468,22,382,512,373,268,140,408,1524,1026,16,13,1434,1021,1325;33;M
18989;1624,1328,16,1441;38;F
19035;192;34;F
19039;741,896,124,1700,702,1698,268,24,16,865,192,2,1441,554,13;27;F
19041;192;42;F
19077;1295,451,568,774,947,1604,1624,917,1581,1344,16,192,1314,1434,140;40;F
19084;192;10;M
19100;1510,451,1338,1533,556,834,1700,1698,733,265;50;F
19119;1434,13,828,373,1026,834,1332,556,173,982,129,1,1330,223,774;52;F
19180;741,173,1332,124,1700,174,865,2,554,947,982,995,1698,394,1441;38;F
19202;1581,1344,443,1388,1700,1347,268,174,24,16,1633,1468,192,3,13;41;M
19254;1509,1482,1532,1347,702,1328,16,1633,1559,1314,1441,1451,1384,140,1468;24;F
19262;1347,1434,834,1633,1468,373,17,1332,140,1604,1344,443,268,16,376;34;F
19273;1344,1347,16,1470,1510,13,1451;54;F
19328;1624,1468,24,17,16;46;M
19363;1434,1470,1700,834,1524,1581,129,1325,1322,826,1021,917,17;38;M
19417;23,1110,1482,1532,174,1451,1510,1517,774,1,443,16,1468,2,1441;28;F
19424;1110,1325,741,826,1526,1330,451,1517,1604,1624,443,1482,702,1559,3;26;F
19454;13,140,1482,1509,776,1581,1526,917,1604,1532;26;F
19485;1510,13,3,1468,1633,16,174,173,1524,36,702,1026,1517,1021,1;32;F
19492;1517,1021,1322,1328,1359,265,1434,1312,1510,140;45;F
19518;1700,451,1021,1526,1322,443,556,1524,1347,1328,1468,376,265,1559,1434;50;M
19580;1314,1441,1451,1384,211,409,1,1338,451,223,192,129,265,1559,554;41;F
19604;1517,1,23,443,1524,1388,702,1026,1328,265,3,1451;50;M
19613;140,1510,1434,13,16,1604,1322,23,1633,1468,1624,1517,1,702;27;M
19614;995,1441;53;F
19635;1,1517,13,947,124,982,733,451,16,443,1021,1434,1328,265,1330;32;M
19662;741,1,173,36,124,1347,702,24,1633,1468,1441,3,13,1451,140;32;F
19666;947,1700,1328,17,1021,1526,1261;44;F
19676;24,373,1347,124,1482,443,982,1110,1325,741,1322,917,17,1604,1624;22;F
19682;1624,1700,774,451,173,1524,776,1347,1328,268,174,16,376,265,1510;35;F
19720;1624,297,1517,774,1021,1524,702,1026,373,268,16,1633,1468,3,1434;32;M
19726;451,1021,1526,1322,443,556,1524,1700,1347,1328,1468,376,265,1559,1434;51;M
19736;1110,867,1482,373,828,174,16,1633,376,394,2,1441,554,984,13;54;F
19766;1624,1700,24,1468,16,896,1325,1322,982,1332,444,984,22;33;M
19793;1624,1604,17,1517,1021,1526,702,22,984,1510,1328,1332,173,982,1261;42;F
19840;1581,733,2,1441,1633,192;35;F
19888;1110,173,776,1482,1347,1698,268,174,24,16,1468,22,376,2,3;52;F
19898;774,741,1325,1533,776,1482,1347,16,1468,22,13,1451,1510,140,124;33;M
19909;1261;36;F
19965;1581,995,173,982,1,1325,223,1119,917,947,1624,1526,1261,129,1328;33;F
19981;192;48;M
19984;1559,22,984,444,1322,1325,982,1332,896,16,1468,24,1700,1624;31;M
19996;1468,24,1347,1532,1325,1526,774,1624,451,826,1110,443,16,1633,3;36;F
20004;13,3,1468,1633,16,1026,36,776,1524,443,173,1,1604,1624,268;24;F
20019;376,13,1451,140,223,774,17,1624,1526,1261,1325,1482,373,1698,1434;51;F
20064;1624,1526,1261,1509,1347,1328,1359,24,16,265,2,1441,13,1434;50;F
20110;24;30;F
20123;1533,1344,443,1524,702,1328,1359,174,16,1633,1468,265,13,1451,1434;27;F
20151;1604,1581,1344,443,1332,1347,373,268,16,1468,22,376,13,1510,140;34;M
20309;140,1468,1633,16,702,776,1332,1110,1322,826,451,1,129,1344,1482;40;F
20316;1,741,917,1624,451,443,1388,1347,268,16,1633,1468,444,3,1451;31;M
20322;1261,1,982,556,1332,1524,867,1700,1698,1359,22,984,1451,1434,140;43;F
20324;988,1482,550,733,1633,1604,1110,16,1468,376,1624,774,451,826,443;73;M
20344;1510,140,1338,1322,265,129;38;F
20356;947,982,443,1332,776,1698,268,1633,1468,376,1441,13,3,1451,1510;32;F
20389;24,1347,36,1482,834,776,1110,1322,1624,774,1,1344,443,16,192;43;F
20407;1344,774,451,1110,443,1347,373,16,1468,3;54;F
20453;1322,982,1581,451,1524,776,1532,1026,16,1468,1559,1021,1509,1434,265;41;M
20509;1434,1624,1384,1119,223,451,1322,1325,173,443,1698,268,828,556,1338;35;F
20582;1526,1261,1416,129,1581,1482,1510,917,1509,1532,1700,1559,1470,1434,1384;26;M
20602;1384,1261;39;F
20630;16,1624,17,1119,451,1322,1581,1295,1328,174,865,265,1441,13,1434;37;F
20642;1322,988,24,22,376,444,1510,1338,1698,409,982,984,741,124;32;F
20645;1347,702,1328,1698,1359,1468,22,192,376,265,1559,13,1434,1510,140;73;F
20687;995;60;F
20693;1261;43;F
20757;1604,17,774,982,1026,1698,947,1119,451,129,23,995,1700,865,586;31;F
20787;1624,1517,1526,1322,741,443,776,702,1026,268,16,1468,265,1314,1434;26;M
20825;17,1261,1021,129,1524,1509,1532,1700,1026,1328,1359,265,13,1434,1384;41;F
20830;1468,22,1441,3,1451,1434,1510,140;36;F
20888;774,1468,1604,140,1624,1517,1482,124,702,24,741,443,776,16,13;36;F
20915;1624,776,124,1347,24,1468,140,741,443,1434,1,13,1344,16,36;34;M
20921;192;10;M
20925;451,265,268,2,1441,947,1,1388,1487,1338,556,373,1698,376,394;45;F
20940;1110,23,1325,982,1416,1332,1524,776,1532,1347,702,1026,373,1698,1559;41;F
20996;867,1338,451,1119,17,129,173,556,1328,1359,174,265,1559,1314,1470;40;F
20997;1526,1325,776,1604,1509,16,1559,1510,1119,451,1330,443,1700,1359,1434;16;M
21043;1344,1347;40;F
21047;1347,1344;39;M
21081;17,1517,947,129,173,1344,988,265,1559,2,1441;33;F
21205;1604,917,1119,382,512,1698,1470;38;F
21221;129,1581,1295,1482,1700,1328,373,550,376,265,1470,554,3,1451,1312;36;F
21258;268,13,1451,1510,1344,451,984,1,512,408,382,982,16,173,297;31;F
21281;1517,1624,1338,741,1325,834,1388,124,1700,702,24,1468,376,3,13;29;F
21428;444,24,917;23;M
21486;774,1706,443,776,2;87;M
21639;1451,776,265;38;F
21712;1510,13,3,1441,1314,16,124,1,982,443,896,702,1698,828,24;40;F
21726;13,1517,451,1021,1526,1,1581,1524,1509,1532,702,1026,1328,1359,265;27;M
21752;1604,1119,451,1325,982,211,443,1482,1347,16,22,2,1314,1441,13;44;F
21813;1021,1328,1510,1344,1119,443,1330,265;41;M
21814;17,1119,451,826,129,173,1581,1388,1700,174,22,192,1470,3,1451;46;F
21826;1509,1482,1328,268,376,265,1451,140,1510,1581,1624,774,1325,1344,1468;42;F
21830;1344,13,1526,774,1517,741,1338,443,124,702,1468,394,1451,24,16;31;F
21852;13,1524,16,1347,1532,1509,443,1344,1581,1533,1526,1021,774,1604,1624;44;F
21882;741,1110,982,1332,174,16,1468,451,443;32;F
21883;124;18;M
21925;1604,1021,1526,443,1524,1509,1532,1026,1559,13,1434,140;53;M
21959;1384,1559,265,1468,1509,1338,1526,1624,1330,1328;61;M
22024;1026,1517,1021,1524,702,1328,268,1468,265,1434;30;F
22070;1314,1441,3,1451,140,834,776,1581,1,1325,741,1624,1517,173,124;29;F
22102;443,1347,1451,1482,1026,1314,774,741,776,140,1,1624,16,1468,13;36;F
22107;1624,1119,409,124,373,24,16,1468,865,192,394,1441,1470,13;29;F
22120;174,1441,554,140,1624,774,1119,451,409,173,776,2,3,13,1451;27;F
22130;1624,451,1110,443,1347,16,1633,1468,1559,13;29;F
22149;1517,1604,1624,982,1581,776,702,24,16,1633,192,1559,13,1434,140;31;F
22194;584,1119,988,1487,733,22,376,1314,1470,3,13,1312,408,586,865;41;F
22205;1517,17,1604,1624,774,1021,173,1533,834,1509,373,174,16,13;26;F
22218;16,1604,1322,1110,776,1624,451,1526,741,1344,443,1509,24,1468,140;30;M
22268;982,451,1119,774,1624,1604,1517,1,129,173,702,192,1314,1470,1434;37;F
22288;1559,1328,1524;30;F
22312;1624,17,373,1698;41;F
22317;1110,774,17,1604,1624,223,1325,776,16,376,1451,13,1434,1510,140;32;F
22336;1434,1510,140,1624,1604,1517,17,1,173,702,1698,1314,13,1451;25;F
22351;17,451,1021,1526,173,1524,702,1026,174,16,265,1559,2,13,1434;29;F
22363;373,1532,988,1295,1581,982,409,584,733,16,1510;24;F
22394;776,1509,1532,1347,1328,24,16,1633,1468,376,265,1559,2,1314,13;35;F
22424;1482,1532,124,16,1434,140,1517,1021,741,1,1524,702,1026,24,1510;41;M
22436;1021,982,265,1434;47;F
22437;1338,826,1110,982,173,995,1332,1524,124,373,1698,16,1633,1468,1559;26;F
22475;702,1482,1533,1416,741,1526,1021,17,1524,776,1509,1532,1347,16,1559;32;F
22545;1434,1633,1347,867,1344,173,982,1110,1706,1322,826,1119,297;43;F
22552;1,1344,702,828,394,223,268,192;41;F
22567;1482,1509,776,1344,826,451,1330,774,1624,376,3,1434,1451,1388,443;20;F
22589;1119,409,982,867,702,16,394,1441,984;39;F
22596;22,1470,586,984,1441,1608,268,1332,1344,982,1295,394,1312;35;F
22665;1604,774,1526,1322,1325,443,1524,1509,1532,1328,1359,16,1468,265,1559;50;F
22708;16,1559,444,1434,17,1526,1416,1524,1509,1532,1487,1359,1608,1470;38;M
22733;1624,1330,1119,451,1338,826,1325,129,1524,834,124,1700,1328,1359,1559;36;M
22756;1624,1517,774,1330,451,702,1328,16,1468,265,13,1434;37;M
22819;826,1,512,834,1700,1468,1384,451,1338,16,192,265,1441,1470,1434;35;F
22884;776,867,1524,1332,984,1526,917,1517,1624,1698,1468,1559,1441,13,1434;26;F
22887;1261,1509,1532,1347,1026,1328,1359,1468,265,1559,13,1434,140;39;F
22911;1470,13,1434,586,1624,17,947,223,1,1700,1328,265,1510,1441,1314;38;F
22914;1347,373,16,1468,1608,192,265,1314,1470,554,13,1434,1312,1510,140;27;F
22922;776,1509,1532,192,1510,1517,1604,917,1581,1347,1026,1434,16,394,13;39;M
23015;129,223,774,947,23,443,556,867,1295,1388,373,1698,3,1451,1312;63;F
23028;1624,1,982,268,16,1468,265,1314,1441,984,3,13,1434,1510,140;31;F
23079;1482,124,1347,702,13,1517,129,1344,16,1468,865,192,394,1314,1441;36;F
23155;896,1698,550,733,1470,984,584,774,409,443,988,268,192,1434,1510;26;F
23168;774,947,584,17,1,1524,1700,1698,828,192,265,2,1314,1441,1510;25;F
23208;776,1482,36,1347,1633,1468,13,1451,17,512,373,1441,554,984,1312;35;M
23235;1328,1532,776,774,947,1604,1624,1517,1526,1509,36,702,16,865,2;34;F
23299;129,1517,774,1325,982,443,124,702,16,1633,1468,192,13,1434,140;50;M
23321;1533,1509,1532,1359,1524,1559;33;F
23380;1633,1482,947,1624,774,1119,451,1110,173,443,174,16,376,1347,1344;52;F
23384;1451,129,1,173,174,2,3,13;28;F
23516;1532,376,1559,3,1510,1526,1325,1509,1359,16,1468,265,13,1451,1434;58;F
23544;373,268,24,1633,394,1559,1314,1624,774,451,443,776,16,1468,13;35;F
23556;174,1384,140,741,982,211,1344,443,124,373,268,22,394,3,1451;40;F
23595;1026,1359,174,1559,13,1510,140,1624,1526,1,265,1434,1328,1261,1021;39;M
23602;1110,1581,1295,896,1482,36,16,1633,1468,1608,394,1314,1441,554,13;43;F
23614;1698,1468,192,1470,408,223;30;F
23645;1328,451,1624,1604,1526,741,1325,1110,1581,1344,1509,1532,1347,1468,140;43;F
23668;917,1119,223,1706,1325,1110,896,373,268,174,376,394,554,3,1510;31;F
23684;774,1604,1624,568,1322,1325,443,1388,1698,1633,192,394,1441,1451,1510;38;F
23691;140,984,444,1314,265,16,1328,36,834,1332,1,741,1261;10;M
23733;1026;31;M
23792;834,1026,373,268,24,376,265,1559,1314,1441,444,13,1451,140,1510;27;F
23806;1,1325,1706,1330,1119,917,947,1517,17,1604,1624,129,1581,834,36;47;M
23808;451,173,1524,1482,702,1328,1026,174,16,13,1510,1384,140,826,297;27;M
23864;1624,1526,443,1328,16,1468,265,1434,140,1261;9;M
23874;1347,1434,13,1624,1322,1325,982,443,1332,1700,16,1468,22,1314,984;65;M
23886;451,1021,1,1388,702,1026,16,1338,1524,834,1328,268,174,265,3;41;F
23895;1510,443,1344,776,1295,268,17;36;F
23943;1322,774,1110,1347,1633,1468,140,451,1526,1344,443,24,16,13,1451;33;F
23948;1604,223,17,451,741,1,409,1295,124,1468,192,1441,3,1510,1633;33;F
23957;586;59;M
23961;1314,1451,1434,1510,140,408,17,451,826,1581,512,1698,174,192,1441;29;F
23990;1624,1604,947,774,741,1698,24,16,1633,1468,2,1441,13,1510,17;30;F
23993;1624,776,741,23,1509,1532,1347,24,16,1633,1468,265,554,13,140;37;M
24032;192;58;M
24038;1,1325,451,1328,174,16,1633,1468,865,192,265,1559,1314,13,1510;37;F
24079;774,1604,1624,17,947,1526,1416,1,173,1509,1532,1700,174,16,1434;40;F
24122;223,173,556,1332,867,373,828,174,376,1559,917,1021,1526,1026,265;41;F
24137;1021,1322,1533,1524,1700,1026,1328,1359,1608,192,265,1559,1441,13,586;38;F
24153;568,17,223,1344,443,896,1482,373,1698,1633,376,394,2,1441,13;32;F
24260;1510,373,834,995,129,1325,1119,223,451,1322,36,1700,376,1470,140;15;F
24328;947,1517,17,297,1322,1581,443,702,1026,1359,174,394,1441,1434,140;31;F
24334;13,1559,376,1468,16,1347,1509,443,1344,173,826,1526,451,774,1624;29;F
24344;1581,776,988,1482,124,1700,702,268,24,16,1468,376,394,1434,140;53;F
24407;1509,443,556,1359,265,1559,1384,1021,1526,1524,1532,1026,1328,1698,1434;42;F
24417;1624,1526,1021,1533,1509,1532,1026,1328,1359,268,1468,265,1559,1451,1434;30;F
24448;1434,1624,1322,1325,982,443,1332,1700,16,1468,22,1314,984,140,1510;61;F
24455;1468,1434,373,2,1441,17,947,451,1,1533,1344,1524,1509,702,1026;37;F
24497;1624,1021,1526,443,556,1524,1509,1532,1026,1328,1698,265,1559,1434,1384;69;F
24530;982,211,995,1344,443,776,896,1700,22,1441,1451,17,1332,373,16;24;F
24536;36,443,1,1338,1021,774,1517,1624,24,16,1633,1468,1559,13,1434;44;F
24539;1416,1509,1532,373,1359,1434,586;44;F
24693;1026,376,3,1451,140,774,1021,1524,867,16,1633,13,1517,1,1312;27;F
24704;1604,17,1322,1526,36,1119,1624;25;F
24720;129,834,17,1119,1330,173,1581,512,1700,1328,1359,174,265,408,1434;32;M
24769;1344,1624,1,1332,1347,702,268,16,1468,22,1559,3,13,1451,140;28;M
24778;1581,982,1295,988,1700,2,984,1,1325,1338,451,947,1328,265,1384;23;F
24826;16,865,192,376,394,1314,1312,1510,947,1322,1325,1698,1441,1451,586;32;F
24844;1470;44;M
24850;1624,1604,1526,1,1344,1347,16,1468,265,1434;33;F
24889;443,1322,1338,451,917,1517,1604,1624,741,1325,1110,1388,124,373,24;30;F
24910;1624,826,1581,556,776,373,268,16,1468,1559,1314,13,1434;49;F
24918;1624,17,917,1021,443,988,1700,24,1468,3,1451,1510,408;24;M
24943;1322,1482,16,265,1470,1510,1119,1325,124,1700,1468,192,3,1434,140;44;F
24984;223,1700,373,1698,865,896,36,394,1312,1338,586;46;F
24986;1624,1021,1526,129,1509,1532,1700,1026,1328,16,265,1559,13,1384,140;44;F
25008;17,1119,1330,129,173,1581,512,834,1700,1328,1359,174,265,1434,408;32;F
25019;1344,776,834,124,1700,1347,702,16,1468,192,1470,1451,1434,1510,140;4;M
25052;1604,774,1482,1532,1451,1314,1468,24,776,826,451,1624,16,1633,1510;27;M
25071;3,586;13;M
25182;1322,741,1416,129,834,124,1700,702,1026,174,192,1434,1312;39;F
25185;917,129,1359,192,1312,1384;38;M
25197;1330,1021,826,1,1533,1524,1700,1328,1359,265,1314,13,1434;41;F
25234;22,834,512,129,1325,1322,451,1119,1470;32;F
25260;192;52;F
25269;1338,223,297,1624,1119,451,1322,129,512,1482,373,1468,22,376,1470;10;M
25283;192;44;M
25319;1517,1021,1,129,443,1524,1388,702,1026,1328,13;64;F
25431;1700,1581,129,1325,451,1119,1470;24;F
25433;702,1026,1517,297,1119,1706,1,1110,995,1581,443,1332,268,733;31;M
25435;1624,297,1,129,1533,1581,1295;50;M
25436;1624,826,774,24,16,1633,1468,1608,22,1314,3,984,13,1434,140;18;M
25535;1517,1,1524,1328,1468,982,140,1624,297,1344,268,16,376,265,13;18;F
25540;774,1624,297,1517,1325,1,443,896,702,1328,268,733,1468,376,1434;23;F
25583;1325,1624,774,826,1322,1388,1581,1482,1347,1633,1468,265,13,140,1434;20;F
25605;1328,16,1468,13,140;47;M
25624;586;58;M
25681;995,173,129,1338,1,409,982,443,1332,867,896,988,1482,1700,22;34;F
25693;223;67;F
25697;13,1510,1604,1559,1526,1434,1026,1021,776,1608,1524,1322,1325,1581,1533;29;M
25720;16,376,17,584,1021,1533,1524,1532,1700,1026,394,13,1451,1434,1384;39;F
25727;1119,1526,1325,1524,1509,1532,1388,1026,1328,1468,265,1559,13,1434,1312;35;F
25737;443,917,1604,1624,947,774,1338,1322,1344,550,16,13,409,896,982;46;F
25750;826;12;M
25779;1470;61;F
25800;1470;71;M
25833;1470;9;M
25836;268,1325,741,1322,917,1517,702,1026,174,24,1468,192,444,984,13;5;M
25843;24,16,3,1451,140,1624,917,774,451,173,443,1700,373,1468,13;32;F
25850;1624,1021,1526,1416,1533,1524,1509,1532,1700,1026,1359,265,1559,1434,1384;31;F
25878;1026,702,1347,24,1633,1468,265,13,1314,16,17,917,129,192,376;52;M
25912;192,568,1295,659,988,828,550,860,865,1608,1470,1312,984,982,556;39;F
25923;1026,268,1624,1604,1517,1119,1325,1524,834,1700,702,1441,444,1510,192;17;M
25924;16,1,1624,1517,917,774,451,173,443,702,174,1468,2,13,1510;38;M
25971;211,776,1624,1604,1517,1330,451,1021,1526,1524,702,1026,1328,1359,24;32;M
26030;1604,17,1706,741,1,129,982,443,988,1700,268,24,984,1434;39;M
26043;1119,1110;53;F
26053;451,1026,1314,1559,702,1347,1482,1581,741,1021,1330,1322,586;41;M
26104;192,860,1434,1517,917,223,1338,1322,741,129,1581,124,702,1698,1468;38;F
26117;1434,140,223,1338,1325,1524,1517,917,995,1581,1698,124,702,192,1384;38;M
26135;223,995,556,982,863,733,860,1608,192,376,1312;40;F
26137;192,17,443,373,733,1608,376,2,3,1312;46;F
26160;1261;57;F
26170;982,173,1581,834,1700,268,550,733,16,22,376,1314,984,444,140;38;M
26171;982,1332,988,1482,1700,373,1698,174,16,1468,22,2,444,984,1434;50;F
26180;917,1706,129,776,1482,268,174,1510;32;M
26190;17,1470,947,774,443,268,1510,451,741,995,863,1487,394,554,373;57;F
26199;173,1700,373,174,1470,1312,297;49;M
26207;1468,1581,947,1517,17,1604,1332,1388,733,376,394,984,867,1700,2;44;F
26215;23,211,982,995,443,1332,863,896,988,860,865,22,444,984,586;46;F
26224;586,1021,16,265,394,1470,408;34;F
26251;1700,1347,1026,1698,1633,1608,1314,13,1510,1468,982;39;F
26261;1604,1624,17,741,776,1700,1347,1441,140,1510,124,16,1468,13,1434;57;M
26322;443,409,741,1110,23,982,211,995,863,896,988,22,984,1451,586;45;M
26340;451,1322,173,1524,702,1026,1328,1359,174,1468,265,1559,13,1434,408;41;M
26360;1261;29;F
26384;741,409,211,982,23,863,896,988,860,865,22,444,984,1451,586;12;F
26392;947,223,451,826,741,1,1110,776,1509,1482,24,16,1468,265,1559;37;M
26393;1482,1633,22,265,1451,1510,140,451,1261,984,3;29;M
26422;917,1517,1604,1624,17,1322,741,1581,124,702,24,16,1468,1434,1312;47;F
26444;17,1312,586,408,1698,373,1700,1119,1470,865,124,741,917,192,1434;38;F
26454;1624,140,1510,13,702,1581,1434;29;M
26476;1325,173,373;49;M
26493;1624,1517,1325,702,1468,192,1451,1434,140;15;M
26494;1517,451,1322,173,1524,702,1026,1328,1359,174,1468,265,1559,13,1434;40;F
26500;16,24,1328,1482,1532,1509,776,443,1526,1468,265,13,1434,1384,140;22;F
26515;1344,1110,1482,443,1624,1604,774,1347,16,13,1468,1328,1532,1509,1526;50;F
26533;17,774,1322,741,1581,776,1482,124,702,24,16,1468,192,13,1434;13;M
26536;1325,741,451,1517,1524,896,36,124,702,16,1468,865,376,1434,586;43;F
26576;140,1322,1325,129,23,1482,373,16,1633,1608,376,1441;51;M
26582;1434,1261;58;F
26621;702,733,828,24,376,1451,1510,1322,409,982,1608,1559,444,984,1384;41;M
26650;17,451,409,1332,373,268,733,22,376,2,1441,3,1451,1312,1510;21;F
26686;984,1434,1533,834,124,192,1517,1021,1,129,1524,1700,702,1026,444;9;F
26700;1624,982,1451,17,774,741,23,173,443,1482,1468,444,13,1434,586;15;M
26702;1517,1,1533,556,1524,124,1487,702,24,1608,22,394,1559,586;43;F
26805;1261;47;M
26808;1487,702,1026,1698,174,394,1312,1510,1517,1322,1,129,173,373,1608;38;F
26814;13,140,1325,1021,451,774,1517,1604,1624,1,1524,16,1441,1434,1510;49;M
26820;1021,1526,1322,1325,1416,129,443,1524,1509,1532,1026,1328,1468,13,140;46;F
26838;1261;7;M
26888;13,16,174,1347,776,1581,173,1322,1624,1119,982,1700,373,1698,984;79;F
26922;129,1700;41;M
26935;568,409,982,867,863,860,865,192,444,984;38;F
27069;568,409,982,867,863,860,865,192,444,984;38;M
27092;568,409,982,867,863,860,865,192,444,984;64;F
27124;568,409,982,867,863,860,865,192,444,984;9;M
27147;568,409,982,867,863,860,865,192,444,984;7;M
27163;568,409,982,867,863,860,865,192,444,984;5;M
27176;568,409,982,867,863,860,865,192,444,984;1;M
27179;17,917,774,826,1325,1581,1524,1347,702,1026,16,1633,13;29;F
27185;1119,568,409,982,867,863,860,865,192,444,984;36;M
27199;826,124,1347,702,1026,1328,24,16,1633,1468,265,1559,1314,13,1434;33;M
27202;1700,586,1698,1624,1338,1322,741,129,982,124,373,16,865,22,1434;40;F
27203;1325,1338,776,733,376,584,17,409,22,1332,995,211,982,863,896;25;F
27227;173,408,1434,382,1700,451,1581,512,1524,1328,174,1470,1510,16,265;40;M
27243;1624,1468,451,1344,1110,826,1633,1,1524,1026,1559,741,1517,702,16;27;M
27294;1119,1021,1322,173,1026,702,1328,1633,265,1559,984,1434,1510,451,297;48;M
27324;124,24,16,1633,1468,13;30;M
27327;1509,1344,1526,1330,1624,1468,1633,443,1110,774,16,394,1559,1314,13;30;F
27349;16,1434;23;M
27362;776,1482,124,373,268,1633,16,1468,376,13,1434,1510,1384,140,586;18;F
27376;947,1,1581,1510,129,982,211,556,1524,1700,702,1026,1698,265,394;38;F
27387;443,776,1388,16,265,3,1451,1026,702,36,129,1524,1,1021,1517;51;M
27404;444,556,1322,223;41;F
27480;1322,1581,443,867,834,1482,1698,733,16,22,1441,1451,13,1434,140;45;F
27558;451,982,173,1332,896,988,1347,1026,1328,373,22,376,265,984,140;26;F
27564;1509,834,1332,1533,211,982,1416,947,17,1559,1441,984,1526,1532,1700;25;F
27663;1604,451,1021,1526,1325,1,1110,173,1524,1532,1700,1347,1026,702,265;37;M
27676;1517,741,124,702,24,1434,586;45;M
27733;1451,1624,1517,774,741,1581,896,988,1482,1608,394,376,1510,140,586;23;F
27770;1517,741,1325,129,1581,36,124,702,1470;46;M
27779;1624,1344,1468,1328;33;F
27844;1470,13,1434,1347,1509,1524,1344,512,1581,409,1526,1119,947,1517,1624;33;F
27864;1359,1328,1700,1509,1533,211,1416,1325,1338,1322,947,1624,1434,1384,1312;63;F
27888;982,1526,1604,1624,741,1325,1532,24,16,1633,1468,265,1559,1314,13;30;M
27896;1532,174,917,1533,556,1332,1487,1700,1698,16,1608,1559,984,1434,1312;43;F
27933;1524,17,1330,1021,1325,1700,1026,1698;31;F
27936;1434;34;M
27937;1330,1119,774,1624,1604,451,1325,1698,268,1468,376,13,1434;45;F
27975;982,1533,776,988,1509,1532,702,1026,373,1359,16,1559,984,13,1434;5;M
27991;584,733;40;F
28030;211,1700,584,1,982,1332,733,444,984,1312;44;F
28081;36,702,16,1468,376,1338,1,129,173,995,1344,443,1332,1434,1510;41;F
28092;1633,174,1482,1344,173,1110,1,1325,1119,1517,192,13,1510;37;M
28139;1524,1517,1624,451,443,174,16,1633,1468,1559,13,1434,1510,140,408;43;M
28168;774,1,982,443,1482,1700,702,1026,373,1698,174,1633,22,265,1441;41;F
28169;1322,741,1110,1344,776,1700,1624,774,1388,1698,1633,1468,140,3,1434;36;F
28194;1338,826,776,1328,16,13,1451,1604,1624,917,1325,1524,1482,3,140;32;M
28228;556,1517,17,1021,1581,702,1524,1026,373,1698,1359,265,1441,1451,1434;39;F
28229;1526,1416,1559,1510,2,1314,1441,1470,3,1434,1312,1384,140,408,586;41;M
28233;1328,16,13,1434,1482,174,140,451,1021,1,173,1524,834,1026,265;38;M
28292;1344,1509,1026,373,1314,1434;42;F
28301;16,774,1,1110,1344,659,1347,1359,268,828,192,376,394,1314,1434;30;M
28311;1295,776,192,1470,140,1322,982,917,568,1325,1581,1532,1700,265;36;F
28320;192;47;F
28345;1314,1434,1604,1624,741,1325,1388,124,16,1468,13,3,1451,1510,140;24;M
28393;774,1624,1604,17,1517,1021,1325,1,129,1524,702,16,376,13,1434;44;M
28401;1581,556,1509,1482,373,1359,16,1468,22,376,1559,3,1451,1434,140;36;F
28473;1470;39;F
28483;1470;41;F
28513;1470;9;M
28627;1295,124,1700,1698,24,16,1633,1468,1608,984,3,1434,1312,586,140;31;F
28642;24,741,982,863,124,373,1698,860,865,1608,1441,444,984,586;40;F
28677;192;29;F
28732;917,451,1581,1700,24,16,1633,1468,1434,140,192;27;M
28797;584,223,129,556,1295,834,373,550;46;M
28828;124,702,24,16,1633,1468,265,1559,1314,1441,3,1451,1510,140;31;M
28862;586;42;F
28979;586;46;F
29000;1487;26;F
29003;982,988;78;F
29080;1524,1533,1509,1532,702,13,1026,1451,1434,1384;42;F
29086;1470;53;M
29112;1322,223,1119,774,1604,1624,1517,917,741,1325,129,1344,863,124,24;38;F
29130;1526,1416,1533,1509,1026,373,1359,16,1468,1559,1441,13,1451,1434,1384;42;F
29184;17,1338,173,1,776,1482,1700,1328,1698,268,1633,376,13,1451,1510;43;F
29189;1624,1526,1110,443,174,1633,16,1468,376,774,1344,1347,13,1451,394;48;F
29191;129,1624,1517,917,741,1325,1581,443,124,702,24,192,1434,1510,140;42;M
29215;982,443,1441,984,1451;73;M
29219;1344,1604,1434,982,1110,1119,1624,774,1330,443,1328,1468,265,2,1451;50;F
29294;140,776,443,1325,1322,1517,917,1,129,173,1332,1524,1388,124,3;38;F
29336;1325,1021,1,1524,1026,16,1517,1533,702,1468,376,1559,444,1434,13;32;M
29352;1261;54;F
29359;988,1332,982;59;M
29367;1526,1261,1532,1700,1359,1470,984,1434;40;F
29420;1633,1604,1624,1338,1322,1,1581,443,702,174,16,1468,22,1314,13;24;M
29426;982,1021,1526,1261,1322,1524,776,896,1509,1532,702,1026,1559,984,1434;71;F
29430;982,1698,16,22,444,1510,23,443,988,1482,1700,24,865,394,1451;74;F
29488;173,1581,1700,1328,1698,550,174,16,1468,22,265,1441,1470,554,13;47;F
29501;774,1119,568,982,1700,865,444,1470,860,443,512,1706,382,451,408;39;F
29557;1261;37;F
29560;443,36,1434,451,1706,776,1,828,1698,16,373,1700,947,13,733;26;M
29561;16,984,1434,373,1624,17,1526,1509,1532,1026,1359,1559,3,1384,140;32;F
29583;1706,1338,1325,443,776,1388,268,16,1468,1441,3,13,1451,1510,140;37;F
29613;917,1581,1434;45;M
29616;373,1700,1532,512,1581,17,917,1526,1261;37;F
29623;1416,268,192,1441,36,451,1533,1581,1700,1359,1434,1261;38;M
29644;17,584,1026,1359,1261;41;M
29705;1026,1524,265,1510,297,1517,1119,451,1322,1706,1,1110,173,702,174;64;M
29720;774,223,451,1021,443,265,394,1559,1526,1261,1509,1532,1700,1468,13;39;F
29722;1604,774,1021,1110,1344,124,1434,297,1517,1,1533,1524,702,1026,1633;28;M
29766;1624,1604,774,1330,451,826,776,1482,1347,1328,24,16,1633,1468,13;29;F
29783;140,1604,17,1338,1322,211,1533,1581,776,1482,1700,373,1698,1359,16;41;F
29790;1261;45;M
29811;1261,1532,550,733,1517,1,834,1509,1700,1314,129,1533,1524,1026,865;45;F
29850;947,1325,1,129,896,36,1698,860,865,192,376,394,2,1441,13;36;F
29851;860,867,863,865;55;F
29852;1325,1021,297,1517,1624,124,1347,702,1026,174,24,16,1468,22,1434;41;M
29857;140,1,129,982,173,1332,268,1434,1510;45;M
29867;1517,1338,36,834,702,1700,408,1322,1482,1026,16,1633,1468,1451,3;44;M
29879;13,1510,140,1581,1,1325,1526,17,1434,1468,1532,1509,1524,1332,1261;48;F
29904;1322,129,1332,36,1388,376,1624,1,443,373,22,1633,3;36;F
29916;265;36;M
29919;826,776,702,1633,16,1624,774,223,1,36,376,394,1314,554,13;59;M
29951;1261,917,1119,982,1533,1332,1532,1700,702,1026,1328,1359,265,1559,1434;39;M
29965;1325,1338,223,1604,988,1482,373,1510,1,982,1332,702,1698,22,376;25;F
29982;1624,16,1633,13;31;M
30051;17,774,1119,1261,586;41;F
30058;1119,1604,1624,834;29;F
30073;408;45;M
30081;17,1021,1261,1338,1,1533,1700,702,1026,1328,1698,1359,1468,865,265;38;F
30088;1581,2,1604,1517,917,1021,702,1026,1328,1698,1359,265,1314,1434,140;41;F
30136;1604,741,1325,129,1110,982,211,702,373,268,22,394,1314,1434,140;28;M
30145;1482,1700,1347,174,16,1633,1468,865,140,408,1119,1322,129,512,1434;48;M
30154;1325,443,702,268,733,16,1633,1468,1608,376,394,1314,3;34;F
30156;1624,1526,1524,1347,1026,1328,24,16,1468,1517,702,265,1559,13,140;49;M
30167;1261;49;F
30219;1517,1524,776,702,1026,1698;43;F
30228;1700,1698;39;M
30268;192,1517,702,174;50;M
30302;865,394,554,1532,211,982,1,22,984,1526,1261;41;F
30303;1416,1325,1322,17,1261;41;F
30304;268,1700,1698;22;M
30326;1706,1322,451,1119,1624,1338,1482,174,16,1633,382,1581,512,1700,408;40;F
30331;174,1698,1328,1700,1,1119,947,17,826,382,512,834,2,1441;30;F
30338;556,1322,774,1604,1624,1325,451,382,512,373,1698,1608,408;44;F
30348;1110,1325,1322,1119,17,1604,1624,774,1526,1509,1468,376,1441,3,13;28;F
30352;512,408,382;36;F
30371;408,512,1533,1517,382;31;F
30375;512,408,382;35;F
30380;223,1700,1698;62;M
30381;1021,1322,917,1517,1581,1524,834,36,1388,702,1026,1359,1451,1434,1510;43;F
30383;1470;46;F
30391;1524,36,1347,702,1026,16,1633,265,1470;37;M
30403;1524,1021,917,947,1526,1261,443,1532,1347,702,1026,1359,1468,1608,1434;51;F
30407;1322,129,173,512,556,1700,1608,376,382,408;38;F
30422;1314;27;F
30425;1509,984,13,1021,1526,1261,1322,982,1524,776,1532,702,1026,1559,1434;76;M
30429;1470;36;M
30455;1325,1,129,982,1344,1468,22,984,17,443,1332,1608,394;45;F
30465;1526,1416,1509,1532,1441,984,13,1384,1261,1325,1581,1700,1328,865,1559;36;F
30472;1021,1330,1524,988,702,1026,1359,1434,774,982,1332,1328,22,265,984;45;F
30480;408,1517,947,129,1524,988,702,1698,24,865,192,1441,1470,13,1434;36;F
30520;1517,1526,1261,1524,702,982,896,1509,1532,1026,373,16,1559,984,1434;43;F
30532;1470;36;F
30535;1468,13,140,1624,1517,451,1021,1322,1325,741,1,1524,1026,702,16;25;M
30545;1470;9;F
30558;1581,1322,1338,982,1328,550,174,860,1633,1468,444,1434,733,1119,1332;37;F
30559;1470;14;F
30569;451,1470;11;M
30575;443,23,1604,1624,129,1,982,16,1700,1581,444,984,512,1470,408;43;F
30593;1325,1624,1604,774,1526,1110,443,776,1509,1347,1328,1468,13,1451,140;73;M
30620;1624,1119,1110,173,382,512,408;41;F
30622;584,17,1624,1517,774,223,1322,1,982,443,1347,702,1633,1468,13;54;M
30650;140,1434,13,1468,16,1532,1509,1524,1332,982,1322,1261,1021,1604,1624;16;M
30686;1526,1261,982,1524,896,1509,1532,1700,1026,1359,16,22,1559,984,1434;43;M
30719;17,1325,982,443,124,1468,376,1451,1;32;F
30722;1119,17,1338,174,1470;49;F
30736;1470;45;F
30753;512,1344,1700,268,174,24,16,1468,192,3,1451,408,568,1322,382;36;F
30772;17,23,834,36,1700,1347,1698,16,1633,1468,376,2,1314,1441,13;28;M
30786;1633,1468,1608,1434,140,382,1119,512,1344,834,1700,192,1314,1470,408;48;F
30792;16,13,1451,1328,1624,1526,443,1468;43;F
30800;1328,373,16,1468,376,1441,13,1451,1434,1312,443,211,982,1416,1526;14;F
30803;382,512,408;35;F
30833;1470;38;F
30849;1325,129,776,1482,1347,1026,826,1021,1517,1,1524,702,16,1633,1468;24;M
30874;408,382,512;48;F
30907;376,1314,1434,1517,451,23,512,443,1524,776,1482,702,268,1451,1510;31;F
30908;1517,774,1325,1,443,776,1482,1347,702,24,16,1468,376,444,1434;38;F
30918;917,17,1624,1604,443,776,1532,1328,1359,268,16,1468,265,1451,1510;53;F
30941;192;25;F
30949;1261,1700,1698;57;M
30956;1581,834,24,1633,741,1524,124,268,1434,140,17,1517,1,1026,702;33;M
30957;1700,512,382,408;53;M
30965;17,774,1261,1322,1325,982,211,867,1388,16,1468,1441,13,1451,1312;46;F
30969;17,211,443,867,1328,1359,24,265,1441,1451,1510,1434;57;M
30974;173,1468,1434,1624,1517,451,1021,1524,776,1482,1026,268,16,1510,140;32;M
30986;129,1698,1608,22,2,984,568,451,1322,382,512,1700,1470,444,408;35;F
31043;1347,1482,776,1344,1581,1,1624,1604,774,1322,382,741,512,124,408;52;F
31047;1470;27;F
31063;1470;24;M
31075;1470;4;F
31081;1470;;F
31090;1470;51;F
31094;192;31;F
31103;1470;25;M
31114;1470;25;F
31125;1470;3;M
31146;17,917,129,512,408,1581,1698,382,1700;37;F
31165;984,1581,982;59;M
31170;2,1700,1698,586;58;F
31183;988,1295,1325,1706,223,568,373,1359,733,265,394,1559,2,1441,1451;31;F
31189;1700,1698;52;M
31207;451,1468,265,443,1470;37;M
31212;1517,1021,1526,1533,1524,1700,702,1026,1359,265,1559,1434,1261;41;F
31240;443,1532,1026,1633,1468,1559,1451,13,1434,1482,1517,776,702,268,16;48;F
31252;1322,22,192,1441,140,947,443,776,1482,1700,376,1451,1434,408,512;13;M
31254;22,2,451,1322,382,129,512,1700,1698,16,1608,1470,984,444,408;10;M
31261;947,211,1332,1700,16,1624,17,1,1581,36,1487,1698,22,2,1441;33;F
31282;1119,741,1325,1110,1581,443,1344,1347,702,1026,268,3,1604,16,1510;32;F
31292;1608,1468,16,24,1347,124,776,1344,211,741,1604,1624,863,1482,1700;45;M
31295;1322,382,129,512,1700,1698,733,16,1608,22,2,1470,444,984,408;6;M
31318;1338,1110,129,17,268,443,776,1388,1468,1608,3,1451,1434,1384,140;37;F
31320;13,774,382,512,1700,408;37;F
31339;568,1322,382,129,512,1700,1698,16,1608,22,2,1470,444,984,408;42;M
31382;443,1700,3,1451,1624,1517,1533,867,776,1482,702,265,13,1510,140;28;F
31413;129,1325,1322,17,512,1700,1698,174,860,1441,1470,554,1434,408,1312;27;F
31444;1624,17,774,451,1330,702,1026,1328,16,1468,265;42;M
31451;1261;54;F
31457;1517,17,1604,297,1624,1338,1322,1325,1581,512,1700,373,1698,16,1468;27;F
31460;1388,702,268,174,3,1434;33;M
31462;860,733,268,1359,1388,834,988,1295,1332,1110,1325,1322,451,223,297;49;F
31487;444,394,776,129,774,1119,1325,826,382,512,1700,408;7;M
31506;1338,173,1581,1344,776,1509,1482,1700,268,174,16,1633,1468,13,1451;31;M
31533;444,512,774,1119,826,382,129,776,1700,394,408;4;F
31537;1624,1526,1110,1344,443,776,1509,1532,1347,1328,24,1633,1468,1559,1434;49;F
31545;512,382,408;50;F
31554;947,36,376,2,1441,444,984;55;M
31563;1698,24,174,1468,1441,1434,140,741,1,1524,1482,124,376,2,1451;42;F
31565;382,512,408,586;37;F
31567;702,24,13,140,3,1451,1434,1322,1325,1344,443,124,16,1468,192;33;M
31580;1325,917,1581,776,124,268,24,1633,376,3,13,1434,1510,140,586;49;F
31595;917,382,1325,1581,512,443,1700,268,174,1633,984,1451,586;37;F
31630;512,1624,1517,1021,1322,129,1581,443,1524,124,1700,702,265,1470,140;44;F
31670;451,1021,1322,1700,265;34;F
31707;776,917,741,1325,1,443,36,124,268,1633,3,13,1510,140,586;60;M
31710;1322,774,1,443,702,1026,1468,16,1633,2,1441,13,1451,1434,1510;27;F
31711;1698,1434,265;32;F
31744;1581,776,1509,1482,1347,373,1359,174,16,13,1434,1510,140,1706,1322;37;F
31765;1110,774,1330,451,1559,1624,1344,443,1509,1347,24,1633,1468,16,13;34;F
31781;1322,382,1581,512,1434,408;61;F
31783;917,173,265;37;M
31800;24,863,124,702,1026,1698,733,860,865,741,984,1312,13,140,586;39;F
31801;1604,1347,1468,444,984,1624,17,451,1322,1581,1700,1441,382,512,408;49;F
31816;1624,1698,1633,1468,586;38;M
31839;1344,896,834,1482,36,1532,124,1700,702,1026,174,1633,1468,1608,586;42;M
31936;1441,1451,140,1,741,1706,1338,1021,1517,1624,774,1526,776,1509,13;68;F
31961;1482,36,1347,16,24,1633,1468,13,1517,774,223,741,124,702,408;47;F
32020;129,1700,1698,174,865,1470;40;F
32051;444,1441,1608,1468,174,1698,17,1604,1624;24;M
32133;1468,13,1451;61;F
32163;451,1330,382,1581,512,408;37;F
32172;1698,16,865,192;39;F
32180;774,1517,17,1604,297,1624,1509,702,1026,16,1468,1559,1314,1434,1384;33;M
32181;1416,834,1700,1026,373,1698,1359,1468,265,1559,1441,984,1434,1384,1261;38;M
32196;13,1510,140,1624,1604,17,1706,741,1325,1344,443,867,776,1482,124;61;F
32220;1434,1470,586;40;M
32222;982,1110,1624,774,1119,451,1322,173,1359,16,265,1559,13,1434,140;33;F
32231;1624,192;43;F
32240;774,1468,265,1581,443,826,1434,1312,1624,1322,129,1295,1328,373,376;51;M
32244;451,1325,1,16,265;29;M
32268;568,17,947,1604,1021,1526,1416,1524,834,1509,1700,1026,984,1384,1261;35;F
32280;1624,1119,1581,443,1509,702,1026,24,16,1633,376,984,13,1434,140;37;F
32281;1338,1,1110,1344,443,1524,1347,702,1026,1468,3,1451,1624,17,1517;56;F
32288;376,140,1328,1344,173,568,1119,451,896,834,1700,174,265,554,984;42;F
32314;568,826,1700,16,444,13,408;36;F
32333;394,140,917,1325,129,1581,556,988,1487,373,268,16,376,3,1434;41;F
32381;826,382,1581,512,1026,1633,1468,1608,1698,1441,408,394,1624,1700;52;F
32397;568,1261,741,409,550,1608,1559,984,444,1470,865,863,982,1119,192;43;F
32416;297,13,1510;25;M
32454;1261;43;F
32464;1698,860,1468,865,1441,1434,1624,1526,1533,512,1700,1359,1261,382,408;40;F
32465;223,774,947,1517,1119,1021,1526,1416,1,1344,1524,1509,1026,265,1384;42;F
32467;1021,174,373,173,1322,1517,1330,129,1524,702,1328,192,265,13,1434;51;M
32469;1604,1624,917,1526,443,1509,16,1468,376,265,13,1330,1344,1347,1328;66;F
32482;451,1332,1482,1700,1468,22,1434,1312,584,17,297,1624,733;24;M
32499;1624,451,826,982,1700,174,16,1633,444,13,1434,408;5;M
32503;917,702,1698,376,1434,192;62;M
32516;1359,16,265,1559,13,1434,1624,1021,1526,1338,1261,1524,1509,1532,1026;43;F
32561;1026,1,140,1359,376;21;M
32580;1261;52;F
32586;1119,223,776,1314,192;43;F
32609;268,1359,1533,173,1021,1434,1517,1604,1,129,1332,1524,36,702,1026;49;F
32614;586,1517,1021,1526,129,1524,1509,1532,702,1026,444,984,1434,1510,1261;49;M
32636;192;42;F
32644;1328,265,1526,1581,1509,1700,1698,1434,17,1441,1559,947,223,1312,1261;47;F
32651;192;44;M
32653;17,1332,1295,373,22,376,1470,1261;57;F
32661;23,741,223,1517,1604,1624,1322,382,1325,702,16,1468,1441,13,1434;35;F
32667;192;14;M
32673;1509,733,17,947,1416,1533,1532,373,1698,376,394,1559,1441,1384,1434;47;F
32686;1633,13,443,826,1526,1624,1347,702,1026,451,1517,1468,382,512,408;55;M
32696;1021,1526,1416,1524,1509,1532,1026,1328,865,265,394,1559,1441,1451,1384;71;F
32718;1441,13,1451,140,1624,17,826,896,1482,1698,733,16,1633,22,376;25;F
32772;917,774,1344,443,776,36,174,16,2,1434,140,1581,1700,1698,1441;36;F
32806;124,586;31;M
32812;192,1314,826,1468,702,129,1110,1322,1517,17,13,1344,1434,16,1700;41;F
32818;36,776,1533,173,1526,1021,947,1624,1416,1,1524,1509,265,1359,1026;64;F
32832;774,1526,1706,1559,1482,776,451,1624,13;52;M
32846;1119,1338,826,23,173,1581,863,1700,192,382,512,408;32;F
32873;982,1,1322,1119,947,1517,1624,382,512,408;29;F
32877;13,22,192,984,1510,408,1604,917,741,1325,129,982,1581,443,1332;37;F
32878;382,408,512;40;F
32885;741,982,1344,896,124,1347,702,1698,373,24,860,16,1468,865,13;35;F
32902;382,512,1470;46;F
32903;550,1700,834,1524,512,1581,23,129,1,1338,1261,584,382,408,586;65;F
32907;947,1119,568,223,382,512,408;44;F
32915;774,1526,1261,982,443,1332,1509,1532,1700,1347,1698,265,13,1384,140;45;F
32932;995,173,1325,1322,382;38;F
32935;1633,16,1698,1581,1624,1604,1517,223,826,382,512,408;32;F
32937;512,382,408;44;F
32940;917,1322,408,512;46;F
32946;984,382,512;30;F
32963;17,512,36,124,1700,702,268,733,1633,1468,376,2,1441,1470,1434;15;M
32969;129,409,1338,1261,1119,917,17,1604,1624,1325,1700,947,382,512,408;32;F
32971;1624,1604,382,1700,1314;41;F
32987;1119,451,826,382,1325,173,1581,512,1524,36,1608,1451,1312,140,408;37;F
32998;268,192;41;F
33001;382,512,408;40;F
33020;1441,776,444,982,512,382,408;37;F
33026;36,1524,173,129,1,1322,1624,265,1261;41;F
33029;408,512;35;M
33030;1524,173,1021,17,36,1328,174,1468,265;44;M
33041;512,382;36;M
33048;584,917,741,1325,1,1581,124,1700,733,22,192,2,1314,1441,13;37;F
33049;382,512,408;32;F
33050;1517,1604,1624,1700,124,1482,834,776,1295,382,512;38;F
33053;382,1698,408,512;38;F
33059;1526,1416,1524,1509,1532,1026,1359,16,1468,265,1559,2,1441,13,1384;34;F
33075;1482,1325,774,826,1322,1581,443,556,896,1388,376,13,1451,1510,140;68;F
33084;192;49;F
33096;382,512,1328,408;39;F
33103;382,512,408;42;F
33115;1624,17,192,1325,1,173,1344;42;F
33131;556,1295,1700,373,1359,268,828,174,16,1510;51;F
33132;382,512,408;60;F
33143;173,1434,140,13,3,1441,1608,268,1700,1388,834,129,223,917,17;15;F
33168;1700,1325,382,512,408;44;F
33175;382,512,1700,408;52;M
33181;1604,1517,451,1021,1,1524,702,1026,1328,16,1468,265,13,1434,140;49;M
33182;382,512,408;9;M
33190;1328,140,1624,451,1322,741,443,174,1359,16,1633,1468,1559,1434,13;39;F
33192;36,268,192,774,3,140,1517,443,556,1524,776,1388,174,702,984;47;F
33201;741,1119,382,1110,982,512,1344,24,16,865,1608,192,1470,408,586;8;M
33204;382,512,408;31;F
33245;1700,1581,129,382,512,408;55;F
33257;568,223,1261,1416,129,1700,1026,373,1468,394,1559,554,13,1451,1312;44;F
33260;382,408,512;13;M
33262;1295,865,1608,1434,140,947,568,1581,1700,1441,1312,1261,129;44;F
33275;1581,1344,1328,174,1633,1434,1510,1624,917,451,382,776,1468,265,1451;36;F
33295;1468,1314,13,1526,17,1261,982,1581,1328,22,192,265,554,1434,1510;39;F
33299;1344,1021,1604,1526,982,1524,1434,265,1468,1328,1026,702,1700,1532,1509;37;F
33301;1700,1295,982,1325,568,16,1468,394,444,1510,1322,382,129,512,408;40;F
33335;1021,1,1524,834,36,382,408,512;48;M
33339;863,982,1325,1119,17,1604,1624,568,741,1581,1388,124,702,24,3;31;F
33342;512,382,408;8;F
33348;451,1338,1110,867,863,22,192,984,1706,741,982,211,1332,896,988;39;M
33353;129,1416,917,382,982,512,1532,1359,16,1468,1441,1451,1434,1384,408;46;F
33390;17,1322,382,1110,512,443,1388,373,1698,16,1441,3,1451,1434,408;43;F
33400;1322,1510;44;F
33404;382,512,408;45;M
33433;1312,1510,17,1338,382,1,129,512,1524,834,702,1468,22,1470,408;46;F
33442;1328,1524,1526,1021,1261,1322,1416,1509,1359,1468,1434;51;F
33446;451,1119,1,23,1524,1482,1388,1487,702,174,24,1559,2,3,13;48;M
33469;451,16,984,13,1434,917,774,1325,268,1633,1468,1510,17,1338,741;28;M
33496;1328,265,1470,1434,1322,382,741,173,512,1332,124,1700,702,174,192;41;F
33500;1110,741,826,774,1624,1604,1581,443,1332,1347,1532,1322,451,1526,1510;57;F
33507;1533,1700,16,1608,265;36;M
33521;174,828,373,1328,1509,1325,1021,17,451,382,1706,512,1700,1698,408;45;F
33541;1359,174,1434,1517,1021,1,1524,702,1026;45;M
33573;1524,896,1700,1026,1359,16,17,584,947,917,1119;44;M
33579;1624,917,1119,382,1110,512,834,1633,1470,1451,408;47;M
33581;1119,1021,1338,1524,1509,1532,1026,265,1559,1441,140,584,733;37;M
33582;1517,1021,1,1524,36,1347,702,1026,16,13;34;M
33633;1581,834,1509,1700,373,733,16,984,376,394,1441,3,382,512,408;36;F
33638;1604,451,826,443,982,896,1328,140,17,774,776,1482,1698,2,1441;49;F
33660;512,1344,1700,1608,984,1434,1510,1604,947,1119,129,1698,865,1441,1470;53;F
33669;36,1261;49;F
33670;1451,3,1441,1633,1698,1700,1388,982,1706,192;36;F
33672;1026,1312,1384,1021,1526,1261,1,982,211,1698,1468,265,1559;43;F
33675;1581,1700,702,140,1526,173,1524,1509,1532,1026,174,16,1468,1559,1434;39;M
33699;1468,192,1624,1470,1524,129,1110,1344,443,1119,1,1700,702,16,13;44;F
33703;947,568,1526,409,1581,988,550,192,394,1312,1510,408,451,1261,1700;33;F
33736;13,17,451,826,1,443,776,1482,1700,1698,16,376,1441,1434,1510;24;M
33745;1559,1434,3;37;M
33769;382,512,408;46;F
33774;741,1295,124,1026,373,1312,140,16,1468,13,1,1700,702,1698,1434;46;F
33804;1325,1322,1338,1624,1604,1119,451,1,1110,173,1344,443;58;F
33808;776,1119,443,1532,13,1510,741,1517,1021,1524,702,1026,1468,1344,1559;40;F
33816;373,192,1451,1434,1510;47;F
33828;382,512,408;42;F
33830;1624,17,1119,223,382,512,1700,702,174,1468,408;40;F
33832;297,382,512;44;M
33852;1624;23;F
33858;1468,1344,982,16;43;F
33868;867,863,860,865;55;F
33879;1604,124,1581,211,1110,1322,917,17,1624,982,173,556,174,24,1451;49;F
33896;382,129,512,1698,394,408;47;F
33908;1441,984,408,556,1332,1338,512,382,988,1698,733,36,1322,373,394;51;F
33928;382,512,408;40;M
33932;1119,1604,1624,1700,1347,16,1468,265,1314,1451,13,1434,1312,1510,140;34;M
33954;124,24,22,376,1451,140,373,1624,774,1338,211,16,947,17,741;41;M
33963;22,373,1261;32;F
33975;1524,1532,702,1026,2,1441;47;M
33992;1261,1533,1359,1608,1434,1510,140;43;F
34046;1517,1526,1021,1,1524,776,1482,36,702,1026,13,1510;23;M
34057;1347,1510,1624,1119,451,1338,826,1110,443,988,1633,1468,1470,13,1451;63;F
34079;1526,1,129,1524,1532,1700,1026,1359,174,265,1434,1510,192,1559,444;40;F
34087;586,192,376,1434,1312,140,1510,1604,584,1119,568,451,394,1700,1698;44;F
34132;23,223,947,1604,16,192,2,1295,1322,1338,774,917,1325,129,1581;36;F
34149;776,1532,1700,1347,1026,1359,174,1526,1524,1509,1468,265,13,1434,1312;43;F
34162;982,211,1332,988,22,444,984;93;F
34176;834,373,828,860,1441,3,17,774,896,268,376,2;33;F
34184;1510,984,268,776,982,1322,1604,1624;80;M
34208;1604,451,1338,443,776,1482,1532,1359,1510,17,173,373,1698,376,1434;34;F
34225;1608,774,1604,1624,1119,382,741,512,1344,1700,24,192,1470,408,586;8;M
34238;192;44;F
34267;13,774,1,129,1581,1344,1295,776,1700,373,1451,17,1468,444,192;44;F
34269;702,268,1388,16,3;32;F
34286;1261,1338,192,1441;40;F
34304;1526,36,702,1026,1328,1359,265;63;F
34387;1510,1517,443,741,1624,776,124,702,1468,1,24,16,13,1434,140;35;M
34405;16,268,1700,1532,443,568,1624,17,774,1338,1347,1468,444,13,1451;52;F
34416;382,512,408;41;F
34423;192;48;M
34492;409,1119,1338,129,36,174,192,376;39;M
34509;192,586;47;F
34518;1322,1347,1468,1510,140,1451,16,268,443,1581,1706,982;69;M
34522;1517,1021,1533,1524,1388,124,1026,702,24,16,1468,1314,3,1434,1384;20;M
34524;702,408,174,16,1633,1468,444,1510,1624,1604,1517,774,1119,1322,382;38;F
34538;1322,1581,1524,1532,124,702,1026,1328,16,265,13,1434;71;M
34569;1604,1624,1517,917,774,1325,1338,1526,1021,129,834,36,1698,16,1384;45;F
34607;223,382,129,512,443,1700,1559,1384,408;43;F
34627;1325,1,173,443,1524,776,834,1482,36,1532,702,1026,1328,1359,265;45;M
34644;13,192,1559,1510,1517,1700,1524,1509,702,1026,1328,1359,268,1468,265;48;F
34654;17,211,1533,988,1532,733,16,192,2,1314,1441,13,1451,1434,140;81;F
34663;192;48;M
34670;124,1026,1328,376,1441,13,1468,1509,1332,443,211,982,741,1322,1526;58;F
34674;863,124,1487,1700,828,702,1698,376,408,1441,444,17,373,865,394;46;F
34675;451,1330,1325,982,1533,1344,988,1700,1384,1322,23,1581,17,16,1510;37;M
34689;192,1559,1624,297,1330,451,1021,1325,1,1524,1026,268,16,13,1510;37;M
34692;192;22;M
34694;1633,1322,1325,173,174,776,1482,2,443,1510,1517,1021,1,1524,702;40;M
34702;173,741,1624,774,1526,1706,23,982,443,988,1509,1532,1347,16,1633;45;F
34703;451,826,1325,1581,16,1470;40;M
34715;192;10;M
34718;382,512,408;47;M
34730;947,584,1604,1624,17,774,1344,443,1347,268,1441,1510;61;F
34766;211,1533,1524,1509,1532,124,268,733,865,22,376,1559,1441,444,984;23;M
34773;129,173,1581,1526,1344,556,1509,1347,1328,1559,1441,1434,984,17,982;56;F
34808;1021,1526,1416,129,1533,1344,1524,1509,1532,1347,1026,1359,1559,1434,1384;35;F
34828;382,512,408;19;M
34832;1470;42;M
34838;13,1451,1434,774,223,1700,373,1698,16,1633,394,382,512,1312,408;50;F
34865;140,1624,1517,982,1332,988,702,1026,16,1468,1559,984;44;F
34884;1526,1325,129,1581,1332,1509,1532,1698,1359,268,1468,1559,1434,140,586;35;M
34889;1026,1633,586;42;F
34899;1624,1604,1517,1021,741,1,1344,1524,776,702,1026,174,16,1468,13;35;M
34904;834,1482,373,733,2,1441,1470,444,140,1328,1434,947,1700,1581,1261;47;F
34916;917,1526,1604,1021,776,1509,1524,1533,1532,265,1026,1559,1434;6;F
34929;1021,1416,834,865,1526,1524,1509,1532,1700,1026,1359,1559,1434,1384,1533;37;F
34930;1624,297,1119,451,1322,1110,173,1295,174,1468,1314,1441,554,1451;43;F
34940;1384,124,702,408,17,947,774,1338,382,512,1700,733,394,1312;49;F
34943;1332,173,1706,382,17,297,1624,140,1633,702,834,23,1,1325,1517;46;M
34965;1322,1325,1581,1524,776,1509,1532,1700,1026,1359,1468,1261,1526,13,140;17;F
34972;22,1510,140,1624,774,1526,982,1533,776,1509,1532,1359,1559,1434,1384;35;F
34997;408,1517,382,512;47;F
35010;1482,192,394,1559,2;45;F
35026;512,173,1,1325,1322,1526,17,1517,1261,1416,1524,1026,265,1434,140;40;F
35046;1517,382,512;20;F
35052;1347,1698,828,174,16,1633,444,1517,1119,223,1338,826,1,129,1581;36;F
35053;554,451,774,1119,1468,1559,1344,982,1330,17,834,988,1328,1359,268;47;F
35058;1510,140,408,382,512;48;F
35063;1468,13,1624,1604,1517,741,1,443,556,124,702,16,376,1451,1510;53;F
35075;1509,776,1110,826,1330,16,774,1526,1468,1451,1624,1604,451,265,1328;53;M
35077;1624,741,1110,173,124,24,1468,3,1451;36;M
35095;129,373,1698,733,394,408,586;31;F
35120;1510,140,173,982,409,1,1322,826,1021,568,1119,917,1517,192,984;45;M
35121;982;65;M
35138;408,586,17,1517,1,1581,512,896,834,124,702,1608,22,1441,1434;32;M
35153;1624,1451,129,1344,1482,36,1347,268,16,1468,376,394,444,1510;42;F
35155;1119,173,174,1468,1434,741,124,1325,1510,1322,192,1581,24,1517,702;38;M
35194;1604,1021,1119,1624,1517,1344,1524,1509,1700,702,1026,268,1468,1559,1314;20;M
35196;1532,1026,1434,1021,1526,1524,1482,1533;34;F
35209;1482,776,1,1468,1384,1524,1338,1119,1517,1604,1624,382,512,1700,408;41;F
35213;124,733,2,1441,13,1451;30;F
35218;982;42;F
35219;443,16,1468,140;66;F
35235;13,1526,1322,1,1110,1581,867,834,1700,1698,1608,22,265,1451,1510;48;F
35241;1261;41;F
35242;173,512,408;46;F
35246;741,192;44;F
35253;1451,1581,1026,1434,140,268,1021,1524,702,24,1517,443;32;M
35288;982,867,863,896,860,865;69;F
35342;917,1332,124,1347,268,1633,376,2,984,3,13,1434,1510,140,586;9;M
35351;1517,1021,17,1526,1261,1416,1524,1509,1532,1026,2,1441,1470,1434,586;50;M
35364;443,1510,1633,733,268,124,1388,776,1110,129,1325,826,1330,584,17;22;M
35370;1526,223,1261,1322,1416,129,1344,1509,1700,1359,1468,394,13,1434,1384;43;F
35377;1470;44;F
35381;1624,774,1344,443,776,1482,1347,16,1633,1468,1314,3,13,1451,1510;24;F
35398;584,1338,995,733,865,1608,22,1559,444,984,1384;40;M
35400;1624,774,1322,982,1344,776,988,1482,22,1314,1441,140;60;F
35414;1021,1526,1261,129,1700,1608;39;F
35416;174,702,1524,512,1581,1,1325,1322,1624,1359,834,265;36;M
35433;268,17,1338,1706,982,867,988,1482,1698,1468,376,1441,3,13,1510;52;F
35467;124,1608,376,1559,2,1441,444,984;34;M
35488;1261;29;F
35505;17,947,1119,1,409,982,1581,702,373,1698,1468,192,394,1441,554;28;F
35513;1517,917,1325,129,1110,1344,1524,702,268,1384,1510,16,1633,1468,3;39;M
35525;382,512,268,408,17,1119,1330,173,1295,174,1312;41;F
35538;776,1482,124,1700,1698,828,16,22,376,2,1441,3,1451,1510,140;35;F
35559;550,1559,984,554,192,860,988,223,409,982,1332,863,1608,22,865;35;F
35577;584,982,995,1533,268,733,1559,1441,444,984,1451,1434,408,17,451;34;M
35605;129;39;M
35609;173,834,1482,1700,174,1468,265,1470,382,512,3,1434,1510,140,408;41;F
35620;982,1312,373,1322,1119,826,1581,556,1295,988,828,1510,1604,451,1325;44;F
35637;1624,1604,1322,741,1,776,1482,124,16,1468,2,1441,13,1510,140;50;F
35641;192,586;43;F
35653;1524,129,741,1119,1624,1,173,1344,36,1698,174,1468,1314,1441,13;49;F
35658;17,1624,741,1581,124,24;72;F
35663;1510,1026,1347,776,1524,1581,1416,1021,1526,129,1509,1532,265,1559,1434;41;F
35678;1624,1119,1,1344,1700,16,1633,1468,865,192,265,394,2,1314,1441;40;F
35699;1526,1509,1604,1021,265;48;F
35705;24,16,1633,1468,22,211,982,1110,1325,741,1322,774,1517,1604,1624;61;F
35714;1325,1633,376,394,3;35;F
35717;1347,192,1517,1338,1706,741,124,702,24,1468;37;M
35792;373,268,174,16,1633,1468,22,376,265,1441,444,13,1451,1434,1510;39;F
35828;1533,512,1700,1026,1559;42;F
35832;382,512,408;42;M
35866;223,741,192;38;M
35894;3,1451,1,192,17,1119,129,23,834,1388,373,16,376,394,2;43;F
35897;1470;49;F
35903;1624,1325,1700,826,382,1581,512,408;43;M
35916;451,1261,1338,1524,1026,1559,1434;46;F
35932;223,982,1581,1295,896,988,373,828,733,1608,376,394,2,13,1510;49;F
35944;1388,1487,1700,1698,174,16,1633,1468,22,376,265,394,2,1314,1470;42;F
35950;443,1110,1325,1322,1330,1338,741,1533,1700,1347,1359,24,1633,1559,1314;24;M
36007;192;13;F
36063;1,1119,584,988,1487,860,865,22,394,1314,984,1510;42;F
36136;382,512,408,586;48;F
36141;1110,173,776,834,22,376;40;F
36160;382,512,408;12;F
36196;376,265,1314,1312,140,741,776,863,1482,1700,16,192,2,1510,1384;31;F
36198;409,1581,1700,1698,865;40;F
36203;124,702,1698,828,174,24,16,1468,376,265,1314,13,1451,1434,140;39;F
36226;1470;8;F
36242;1470;6;F
36247;1470;43;F
36256;1470;34;F
36267;1470;39;M
36273;1470;9;M
36275;408,382,512;46;F
36337;1509,373,1698,1624,1526,1325,443,1524,1468,376,1559,1441,3,13,1451;32;F
36342;16,1441,1624,1338,1322,1325,982,1581,1332,1347,1698,1468,13,1434,140;49;F
36352;1624,1700,1698,16,1633,1468,192;46;F
36354;834,1700,1328,1384,1526,1261,1322,1416,702,1026,1359,265,1559,1434,140;42;M
36372;1470;71;F
36376;774,1604,1624,1517,1021,1526,741,1,1344,1524,124,702,1026,1328,1434;37;F
36389;124,702,1026,24,16,1468,1608,192,1314,1470,984,13,1434,1510,140;29;F
36404;1434,140,1608;50;M
36417;774,1119,1021,1524,1509,1700,1026,1328,1359,1633,16,1468,265,1559,1434;44;F
36419;1581,1700,1328,550,733,140,1510,1470,554;38;F
36423;1526,774,947,1698,1468,192;64;F
36426;1482,129,1,1325,1526,1021,451,556,1328,373,550,265,1441,1470,554;38;F
36533;741,1,982,1533,1524,124,702,1026,24,16,22,192,1559,1434,140;30;F
36547;1119,451,382,512,1700,174,1470,1314,408;40;M
36561;741,24,16,1468,17,917,982,211,1332,1328,22,265,1441,1434,1510;62;F
36584;1470;17;F
36596;1470;13;F
36600;1581,1487,140,16,13;68;F
36614;1517,1325,1482,124;50;M
36636;1517,917,702,24,1633,1624,774,1388,16,1468,376,192,265,1314,3;46;M
36638;702,1328,1359,1468,1510,140,1624,917,1261,16,265,1559,13,1434;42;M
36642;1261;39;M
36645;1470,3,1434,1510,1451,984,550,373,443,982,917,947,223,1700,1698;28;F
36666;444,1700,382,512,408;40;F
36682;1119,774,1517,1624,17,223,1416,1,1509,36,865,2,3,13,1434;36;F
36688;1119,1604,1624,1322,443,776,834,1347,268,16,1633,1468,13,1434,586;28;F
36691;554,984,1312,1261,550,865,1608;39;F
36708;1517;42;M
36716;1706,1325,1581,1344,443,1482,1347,373,1698,268,16,1633,1451,1434,1510;34;F
36771;1338,982,1581,834,36,1532,1700,702,1026;36;F
36800;1,1526,1021,1524,1509,1532,1700,1026,1328,1698,174,265,1559,917,1261;38;F
36823;984,982,1509,1261;42;M
36844;776,129,1322,774,17,1604,1517,451,1021,1325,982,1524,1388,1700,702;47;F
36865;1517,1,129,1524,776,1482,36,1700,1026,702,586;46;M
36878;896,1482,373,268,1468,865,376,2,1441,984,3,13,1451,1312,1510;18;F
36908;1470;64;F
36919;1624,774,1119,1322,1110,443,776,268,16,376,3;47;F
36953;1470;49;M
36960;1434,1026,702,1524,1021,1517;44;M
36989;1470;70;F
37009;1470;13;F
37020;1470;10;M
37038;1470;6;M
37044;1470,1482,36,1700,1328,1698,16,1468,265,1559,1314,444,13,1434,140;36;M
37059;1698;51;M
37110;1314,1434,1510,140,451,826,1706,1325,1,1581,834,124,22,376,394;43;F
37118;1332,22,376,1451,409,982,268,984;34;F
37181;776,1624,774,1119,451,1325,173,174,192,13,140;41;M
37210;776,1581,173,1110,1,1325,1706,1322,826,451,774,947,17,1604,1624;35;F
37227;1698;24;F
37251;741,982,443,863,896,1700,1347,24,16,1468,394,984,13,1451,1434;52;F
37281;917,1624,1517,741,1332,124,702,373,24,1468,22,376,13,1434,140;28;F
37286;1328,373,1698,550,733,24,1608,865,1633,860,1468,376,265,1559,984;38;F
37298;394,376,22,124,834,1581,1,1325,1706,826,451,140,1510,1434,1314;41;M
37300;1325,1261,1322,702,1026,373,1359,860,265,1441,3,1451,1434,1384,140;10;F
37302;1517,1021,1526,1261,1,1581,1524,1509,702,1026,1328,1608,265,140,586;38;M
37316;17,947,568,129,1295,174,865,1441,1312,1470;15;M
37318;1261;39;F
37341;1517,1325,1,702,1026,1468,1434,192;48;M
37343;1517,1021,1526,1261,1,1581,1524,1509,702,1026,1328,1608,265,140,586;38;F
37345;1524,1581,1,1261,1526,1517,1509,702,1026,1328,1608,265,140,586;9;F
37349;1517,1021,1261,1,1581,1524,1509,702,1026,1328,1468,1608,265,140,586;5;M
37350;1451,1338,192;38;F
37366;1624,1347,1328,1468,192,1344,451,1119,1604,1698,16,376,394,1559,554;50;F
37372;17,1338,1322,741,1325,1581,124,24,16,1468,3,1451;29;F
37376;1338,1533,1509,1532,1434,1510,1384,1700,1698;48;M
37387;1624,1322,741,1581,1388,124,174,16,3,1434;29;F
37458;1110,741,451,774,1604,1624,776,1509,1347,16,1468,13,1559,1532,1526;45;M
37479;1524,443,702,1026,1581,192,1434;45;M
37480;1510,1322,1338,1119,1517,1624,947,741,129,124,702,16,1468,192,586;48;F
37520;1517,1624,13,984,394,192,22,865,702,1332,443,1344,982,1451,1510;38;F
37579;741,173,834,124,1700,702,16,1468,192,1312,586;12;F
37581;584,1517,297,1,1581,1700,1698,1441,1470,444,984,1322,382,512,408;13;M
37589;1434,1347,24,776,443,1581,1110,1,741,826,1526,774,917,1517,1604;50;F
37600;17,1517,382,512,408;46;F
37634;826,741,1325,1416,1581,1532,124,1700,373,984,129,173,702,16,1441;40;M
37644;863,1581,1604,1624,774,826,1706,129,1110,982,1344,1482,1468,1314,13;50;F
37659;774,1119,982,173,556,174,192,1441,1470,984,1021,1261,129,1700,394;37;F
37686;1700;16;M
37750;443,896,1347,24,16,1468,13,1434,140,1624,1517,774,1322,776,702;43;F
37754;17,1119,1344,733,265,1526,36,947,917,1330,173,1581,443,13,1434;55;M
37759;297,917,24,1510;39;M
37788;1322,1332,1295,373,554,984,1312,265,223,13,659,550,556,834,129;40;F
37802;265;37;M
37823;1517,1532,1026,1359,16,376,1559,1384,1524,1581,1533,1,1526,1021,1509;26;M
37845;1470;38;F
37868;1510,1384,1517,17,297,1624,1325,1,1524,702,1347,1026,1633,265,408;28;M
37890;1581,776,1388,1347,373,1468,3,13,1322,1325,1,1533,1524,1328,265;42;F
37900;1624,774,451,1,1509,1700,268,174,265,1559,1470,13,1434,1510,140;32;F
37910;129,268,2,13,1434,1633;35;M
37920;382,512,408;52;F
37955;382,1,1110,16,1608,265,408;35;M
37958;265,1510,1312,1434,1700,1332,1581,129,1325,1322,1526,1021,451,1330,373;34;F
38026;3,1434,1322,1517,17,1325,129,2,1441,1451;44;F
38033;1388,1604,1624,1325,265,1110,129,1344,443,373,733,1468,1328,173,774;45;F
38065;1441,13,1624,17,774,1119,982,1344,443,1332,1532,1347,1526,1509,1261;39;F
38079;211,556,988,268,174,1510,394,984,1388,1328,1698,22,376,265,1434;46;M
38096;1338,223,774,17,1624,443,1347,373,1698,16,376,2,984,13,1312;53;F
38179;17,1261;42;F
38234;1510,982,1698,1119,1604,1517,1526,1261,1322,1533,1532,1359;34;F
38287;1322,1325,129,1581,896,988,834,373,1698,860,22,2,1441,1434,192;43;M
38317;1261;48;F
38321;1261;77;M
38329;1517,1604,1119,451,1021,1,129,173,1581,1524,702,1026,1328,174,1470;34;F
38336;774,1624,1119,382,741,982,1344,512,1700,24,1608,192,1470,408,586;42;M
38385;1359,268,24,174,16,1633,1468,1470,13,1510,1706,702,265,1434,192;44;M
38409;23,774,1330,1526,1322,129,1388,1328,265,1559,2,3,13,1434,1510;59;F
38422;265,1526,1261,1700,1434;38;F
38428;265,1261,1524,1700,444;40;M
38488;129,1295,1487,1700,1698,865,1468,376,1470,1312,140,223,1344,443,1441;42;F
38507;1517,1119,1021,741,1344,443,1524,776,1532,702,1026,1468,1559,13,1510;44;M
38572;1624,1604,1344,16,1468,192,586;47;F
38600;1470;40;M
38648;1325,1581,1524,1604,1624,1517,1021,124,702,1026,1468,1559,1314,140,1434;39;F
38688;1434,443,1624,1021,1524,1633,16,24,702,124,776,741,451,774,1517;24;M
38706;382,1706,1581,512,1700,408;40;M
38720;1261;45;F
38756;1517,1,129,702,1524,382,408,512;38;F
38788;373,1700,834,173,1110,1322,1338,451,1119,1470;37;F
38801;568,1119,917,947,584,17,1604,1624,223,382,512,1700,865,1451,408;36;F
38807;586;26;F
38811;173,1700,373,1359,174,16,1470,1312,1510;12;M
38819;173,1026,776,1482,1347,1624,1517,1322,1332,124,702,24,16,1468,140;49;M
38830;3,1510,1021,1261,586;35;F
38968;174,16,1559,1314,13,1434,140,451,1325,1482,1468,3,1451,382,512;46;F
39004;702,1517,1021,1509,1526,1261;43;M
39027;211,129,409,1325,1119,568,1604,584,451,776,988,1482,865,1608,1261;58;F
39038;443,376,984,1119,173,1608,1698,174,444,3,1451,382,512,408,586;61;F
39112;584,826,1517,1624,1325,1,1524,702,268,1608,376,3;28;M
39116;1700,1698,1517,702,1468,1624,13,774,192,223,1110,896,373,860,394;45;F
39160;984,584,982,988,22,192;44;F
39187;982,376,1559,1441,1434,1325,1322,1338,1119,917,1624,451,1021,1526,1261;42;F
39205;1416,1526,1021,947,1344,1524,1295,1487,376,394,1559,1441,1451,1312,1384;39;F
39206;1509,702,1026,373,24,16,1633,1468,192,1314,3,1434,1517,1624,443;35;F
39216;382,512,408;46;F
39233;1510,834,776,17,1261;43;F
39246;1021,17,1624,1441,1524,1026,451,947,1,702,373,1698,376,265,1451;34;F
39278;129,1110,174,1451,1434,382,512,408;11;F
39307;17,1624,297,1604,1330,1119,451,129,173,1332,834,1700,373,1328,265;41;F
39324;982,1700,373,1468,22,984,13,1434,382,512,408;13;M
39348;1468,1312,443,995,1,1416,947,1021,1526,1261,1344,834,1487,1026,1441;13;F
39409;1517,1026,192,1021,512,1470,408,1533,1700,702,16;39;F
39418;1624,17,1526,1338,834,1698,1524,1700,13,1434,140,192;13;F
39423;1624,1604,1517,1021,1526,1344,443,1524,1532,1700,702,1026,1434,1261,1359;45;M
39442;451,1330,1604,1624,774,982,443,776,988,1482,174,1468,984,13,586;46;F
39449;584,947,1119,1261,1,129,982,1509,16,394,2,1441,444,3,1434;39;F
39459;917,1706,1325,129,173,1581,512,443,1700,373,268,174,586;36;M
39469;550,24,1633,192,265,1470,13,17,1468,1608,1441,1434,1510,1384,1325;27;F
39505;1434,1581,896,834,1509,1482,1388,1698,16,1468,376,1441,3,1451,373;20;F
39681;129,982,1524,1328,265,984,1434,1510,140;48;M
39697;828;24;M
39710;1624,1604,774,826,443,1509,1347,1328,16,1633,1468,1314,984,13,1451;46;F
39717;1533,1295,1700,1026,1359,1468,265,1559,1451,1434,1312,140,1021,1526,1261;40;F
39771;1510,1434,3,1328,702,1026,124,1524,1581,1110,1,1526,1021,1517,1604;32;M
39792;584;70;F
39860;741,982,1344,988,702,24,16,1633,1468,192,1559,1314,984,13,1451;33;F
39878;223,409,896,1509,1026,702,1517,1021,1526,1261,1524;44;M
39888;1384;36;M
39906;17,1344,443,896,550,733,13,1434,1510;24;F
39931;917,1526,1509,1328,1026,1698,1359,265,1559,1314;41;F
39951;17,741,1624,24,16,1468,13,1451,982,443,776,1482,124,1700,268;29;M
39988;1325,1,173,443,556,36,124,1700,373,1698,268,174,1468,192,1510;37;F
40025;1624,1604,1119,776,1482,16,1468,192,1314;42;F
40042;1261;40;F
40092;1451,917,1581;46;F
40096;1344,834,1347,16,1559,1261,1526,1509,1532,1700,13,1468,1451,1434,1312;44;F
40153;1633,1468,376,394,2,984,140,408,1624,741,268,174,24,16,586;39;F
40181;1261;44;M
40207;1698;54;F
40227;1,982,702,1026,1359,265,1559,1517,1526,1021,1524,36,1434,1451,1261;41;F
40228;947,129,1581,1119,1338,1261,1416,1608,1312;38;M
40231;1344,268,1624,1517,1021,1526,1524,702,174,13,140,1026,1328,265,1434;33;M
40233;1526,982,995,1524,988,1532,1359,733,22,376,1559,984,13,1434,1510;38;F
40239;443,1532,1359,268,1559,13,1434;55;M
40246;1698,586;18;F
40267;13,1021,1526,1533,1581,834,1328,1359,1468,192,265,1559,1314,1434,1384;36;M
40302;24,13,140,1517,1119,1338,741,129,173,1524,36,124,1026,702,1434;42;M
40310;1,1021,1517,297,556,1524,702,373,1698,733,1468,376,394,1434,1510;32;F
40386;192;26;F
40388;265,1328,1451,741,1608,984,1700,1517,1526,1,1524,702,1026,1021,129;45;F
40389;1119,129,16,1468,444,1510,13;38;F
40443;1624,982,1581,988,124,702,373,16,1468,444,984,13,1451,1510,140;71;F
40458;173,1581,1344,443,834,1698,174,394,1470,554,444,1312,1510,586,408;19;M
40473;1517,1706,1338,1416,512,1698,1470,1624,1604,1434,1526,1021,1533,1700,1026;18;M
40547;1581,1119,129,16,1468,444,13,1510;9;M
40649;268,1347,1482,776,1344,1119,1509,443,173,1110,1706,826,1624,1604,774;56;F
40712;17,584,947,995,834,1698,733,16,1468,865,22,376,1441,444,984;23;M
40728;17,1470,1325,129,1698,16,1434,1624,826,1322,1,1581,512,1441,408;43;M
40739;1624,1604,1,1581,443,1347,1468;40;F
40744;1344,1532,1026,373,1359,1633,16,1468,865,376,265,394,13,1434,1261;38;F
40751;1328,1359,265,1559,1470,1021,1526,1604,1119,1325,1,1581,1468,1434,550;32;M
40762;568,1706,1510,140,984,982,22,1,995,1332,896,268,1468,3,1434;45;F
40773;1332,17,1,1325,1482,1347,268,16,1468,376,265,1314,554,1451,140;44;M
40775;1338,1322,1,1581,1524,834,1700,1698,174,2,1359,1487,1295,1026,1608;45;F
40779;1698,268,865,22,2,3,774,584,17,1624,223,373,16,1330,1451;26;F
40794;828,394,917,1338,1322,1325,1,1581,3,140,1388,1604,124,1468,1624;50;F
40902;1526,1261,1,129,1533,1700,1328,1698,1359,265,1559,1510,1384,140;39;F
40904;1624,17,1338,443,776,1482,268,1633,3,1451,1510;32;M
40956;408,382,512;37;F
40967;1261,1509,1533,1532,1559,1434,1312,1384,586;38;F
41019;1624,451,1322,1581,443,1532,3,13,1347,826,1509,16,1633,1468,265;33;M
41030;1328,1359,268,174,1468,1434,1510,140,1517,917,1021,1261,1533,1524,1700;35;M
41129;382,512,408;6;M
41149;382,512,408;8;M
41166;382,512,408;11;F
41181;17,1,1021,382,1416,1533,1581,1524,1532,1700,1026,1559,1314,1441,1384;13;F
41187;382,512,408;13;M
41206;382,512,408;38;M
41217;1608,192;67;F
41218;1604,1526,1706,1325,211,1524,896,988,1482,1328,1698,1468,265,1510,1330;51;F
41222;1110,741,1338,1119,17,451,173,776,36,124,702,16,1633,1468,1510;35;M
41236;17,774,223,451,1344,443,1700,1347,373,16,376,13;42;F
41254;1604,1624,17,741,982,1581,124,1698,1441,13,140,1608;23;F
41263;1312,1441,834,776,1581,173,1322,1517,1261;46;M
41327;776,1482,1388,1633,865,1624,1604,826,443,982,988,444,984,3,1451;31;F
41341;826,1624,1119,741,173,776,834,36,16,1633,1314,3,1451,586;10;F
41350;1434,1624,265,1604,1517,774,1526,1,1581,1347,702,1328,1359,16,13;27;M
41355;776,1347,1026,1359,24,16,1633,1468,376,408,140,1608,22,2,1314;25;M
41362;1344,1332,2,140,1482,1700,1347,1359,1441,13,1624,17,1328,376,265;67;F
41394;568,917,1517,1510,896,1700,140,1434,376,1,776,1482,702,16,265;24;M
41402;16,1482,826,896,1388,1624,982,211,443,988,1633,984,444,3,1451;27;M
41440;1295,776,988,1509,1482,1532,124,1700,373,16,1468,394,1559,1312,1261;40;F
41484;1347;50;F
41528;1451,13,1559,376,1468,16,1482,776,443,1344,1110,741,774,1604,1624;24;M
41541;174,1608,1314,1451,1347,1468,1359,297,1434,1517,1021,1,1524,36,702;31;F
41557;1624,1526,1110,1509,776,1482,16,376,394,1451,1510,947,1338,1330,1328;30;F
41606;1434,140,1119,129,1581,16,1468,444,13,1510;39;M
41609;1510,1416,1325,826,1338,1604,1517,774,1526,1322,1328,373,376,265,3;31;F
41621;947,774,129,556,1441,1261;46;F
41629;1119,129,1581,16,1468,444,13,1434,1510,140;4;M
41641;1470;63;F
41650;1470;31;M
41658;1470;8;M
41667;1470;6;M
41677;1470;2;F
41716;1482,1624,1325,1,982,702,1328,24,16,1633,1468,265,13,1434,1510;37;F
41722;297,1604,1322,1325,982,173,1332,776,1482,1532,1328,1468,1,22;32;M
41749;1624,774,173,1344,443,556,1509,1532,828,174,16,1468,22,1559,13;60;F
41763;834,774,1604,741,1110,173,896,124,1700,373,174,24,376,394,1510;37;F
41805;1517,376,1,23,16,1451,988,702,1698,268,733,1633,1314,3,1510;33;F
41814;1344,776,1468,1510,140,1328,1624,741,1325,982,24,16,13,1434,124;34;M
41928;774,17,1416,982,1533,556,1509,1532,124,1026,1559,13,1434,1510,1384;56;F
41974;1517,982,1524,1509,1532,702,1026,265,1559,1434,140,451,1021,1526,1261;44;F
41980;1470;28;F
41988;1624,774,1021,1526,1,173,1524,776,1509,265,586;33;M
41994;1470;29;M
41997;1470,1295,1524,382,1261,568,1119,1021,1110,982,443,129,3;44;F
42044;776,1509,1482,1532,1700,1347,702,1026,1328,1359,174,16,1468,265,1559;38;F
42055;1470;24;F
42058;376,265,297,17,1517,1322,1,982,1700,1328,1441,444,13,1434,140;47;M
42065;373,1344,988,1347,1698,1468,17,124,1388,443,16,376,3,1434,140;25;F
42075;1325,982,1332,776,1482,124,1700,373,24,16,1633,1468,376,984,13;41;F
42098;1328,265;40;M
42137;265,451,1524,1633,192,140,408,1,129,1700,702,1026,1468,13,1434;44;F
42148;1261;41;M
42176;22,129,584,917,826,1325,1581,988,408,586,373,1698,733,394,1470;43;F
42240;556,896,1482,124,1347,373,1698,174,24,16,1468,2,1441,1451,1434;41;F
42242;1624,1604,1517,1526,1322,1509,1532,1347,1328,1633,1608,1468,1559,1434;30;M
42243;568,382,512,408;46;F
42244;192;12;F
42263;192;8;M
42270;1026,1517,774,1021,1524,702,16,265,1314,1510;48;F
42283;192;41;M
42311;1604,17,826,776,1482,1700,702,1698,24,16,1633,394,1559,1314,13;24;F
42316;1624,1526,1261,443,1524,1532,1026,1359;41;M
42331;382,512,408;10;M
42346;173,1026,1388,124,129,3;32;M
42352;17,917,1526,1533,1524,1482,1532,1026,140;49;M
42354;1314,1559,1468,174,443,1581,173,1110,741,451,1119,1517,1604,1624,13;46;M
42366;1624,917,1526,1322,1581,1532,1359,2,1441,1510,568,988,1416,982,867;75;M
42381;741,129,1110,982,173,1344,867,373,268,174,865,1608,192,1559,984;39;F
42411;1,982,1332,1482,124,1700,702,1026,16,1468,192,376,1510,140,1434;39;F
42413;1261,1344,1524,1347,702,1026,1328,1359,16,1468,265,1559,1314,1434,140;41;F
42454;382,512,408;23;F
42506;1604,1517,1524,1509,1532,1468,3,1451,1434;31;M
42511;129,834,1344,556,550,659;27;M
42524;917,1021,1526,1322,1416,982,1524,867,988,1509,1532,1026,2,1441,1510;74;F
42544;451,1119,1517,17,1624,1,23,1344,408,982,1332,174,984,444,192;46;F
42589;1581,917,1517,297,1624,17,451,826,1322,982,702,268,16,1468,376;27;M
42616;17,1526,1261,1416,1,1509,1482,1532,1026,373,1698,1359,16,394,13;50;F
42627;1604,1700,373,1434,13,774,1624,17,129,24,16,1468,1517,741,702;22;M
42655;13,1510,1624,1604,774,1119,451,826,1,982,173,1581,1332,1633,192;50;M
42656;444,211,1581,1359,1021,1322,1325,982,1533,1524,1026,1328,265,394,984;49;M
42658;1344,1332,1295,659,1470,1451,1312,1624,129,988,124,702,373,733,24;31;F
42685;443,556,1524,896,834,36,1700,702,1026,373,1698,828,174,1434,192;42;F
42687;1261;37;F
42719;1021,917,774,1624,584,451,982,1581,36,702,373,1468,444,1451,1510;15;M
42722;1322,1119,1517,947,129,211,863,124,702,1328,1698,16,265,2,1441;73;F
42730;982,1524,776,988,834,1509,1482,702,1026,1328,265,376,1359,1698,373;33;F
42743;443,776,1347,1434,1624,1468,16,1608,741,124,24;33;F
42755;1533,1434,1624,1604,774,451,1526,826,1706,1532,1328,265,556,1700,1698;37;F
42763;1451,192,984,3;47;F
42765;1330,774,1526,1322,1325,409,982,443,988,1509,1532,1468,13,1434;37;F
42773;834,988,863,173,409,1,223,1021,982,1581,1328,550,265,394,554;45;F
42800;741,1325,1,982,173,1344,124,1700,174,16,1468,1314,13,1434,140;51;F
42810;3,984,192;9;F
42830;409,23,173,1026,1328,860,192,1470,140,1624,1261,982,867,896,988;43;F
42833;192;54;M
42873;512,1110,223,268,1470,1312,408,382;47;F
42878;834,1021,917,1517,382,409,982,512,1524,702,865,1608,984,1434,408;45;F
42884;1338,1517,1604,1624,917,741,443,24,16,1468,1608,13,1434,140;42;M
42961;1604,1517,917,1,1524,1482,702,774,443,776,268,1633,376,394,1510;41;F
42996;129,556,1295,776,36,124,1700,702,373,1698,268,1468,394,1510,586;43;F
43012;1322,451,1119,774,917,1624,1604,947,1325,1,1581,1524,1482,1026,16;33;F
43048;917,1517,1,1332,1604,774,443,776,1482,36,268,1633,1510,394,376;70;F
43100;1261;40;M
43132;1261;9;M
43162;1261;6;F
43175;1624,1,1110,173,1344,776,896,702,373,16,1468,1314,140,1451;45;F
43217;1604,297,917,1325,1,1581,776,1482,373,268,1470;34;F
43262;1509,1482,1532,124,1347,702,1026,1698,1359,24,16,192,1559,1434,140;33;F
43278;173,1325,1322,1330,774,1604,1624,17,451,1110,1328,1698,1468,265,1434;61;F
43305;192,586;46;F
43332;1021,741,1,124,1328,265,1517,1524,702,1026;36;M
43342;1388,124,1700,702,373,1608,865,192,376,394,2,3,1451,1312,140;9;F
43370;17,584,947,1526,1416,1026,376,1559,1509,1532,373,1698,828,733,1608;7;M
43373;443,1581,1325,1526,1330,774,1604,1624,1517,451,1021,1,1524,702,1026;40;M
43376;1698,174,1468,2,13,774,1441,1451,1434,140,1624,1533,1509,1532,1559;38;F
43381;1325,1624,1,1119,774,917,1517,1604,1700,1347,174,16,1468,1441,13;39;F
43391;1604,1509,1532,1359,268,1468,376,265,1559,1314,984,13,1434,1510,140;54;F
43394;373,174,16,1633,1468,1608,192,376,394,444,3,13,1451,1312,140;6;M
43450;1261,1344,443,1700,1347,373,1698,16,1468,865,192,376,394,1559,1434;42;F
43495;1700,1604,1119,1416,1470,1526,1021,1,129,1524,1026,1328,192,265,1559;37;M
43498;2,1441,1434,741,129,982,1581,556,124,373,1698,24,865,984,828;35;F
43542;1119,129,982,211,1533,1434,382,1698,512,1700,394,984,408;44;F
43548;1581,1468,1633,774,1624,451,826,443,409,982,373,22,16,13;46;M
43589;1604,774,1021,1325,1581,1328,1698,1359,174,265,2,1441,1470,13,1451;67;F
43612;1633,1608,1441,376,394,1338,17,917,1021,1,129,443,24,265,984;67;F
43613;451,443,776,1509,16,394,1314,13,1633,1624,774,1119,1110,1344,1347;65;F
43679;1482,776,1524,1344,1021,774,1604,1624,1509,1532,1526,1,1581,13,1468;24;F
43680;140,1510,776,1482,586,16,1468,192,394,554,1312,568,1325,23,1295;27;M
43709;1517;36;M
43799;1119,1110;47;M
43814;373,394,1314,13,1451;46;F
43818;947,1119,129,1344,36,268,192,394,1559,1441,1470,1451,1261,1384,408;39;F
43828;1700,1698,550,733,860,16,1633,192,376,984,1312,1482,1441,1608,22;41;F
43837;382;28;F
43848;1441,1470;32;F
43862;1119,917,1581,1328,265;46;M
43867;1325,1344,1633,3,1,443,1510,776,17,36,702,373,268,1434,376;46;F
43874;1434,982,129,1325,1322,1312,586,917,1332,1295,16,1468,22;17;F
43906;1261;31;F
43937;1119,988,174,376,265;54;M
43979;1119,382,512,834,1700,408;29;F
44019;1468,140,776,1604,1517,1434,1026,1532,16,443,36,451,265,982,1332;35;M
44027;1026,373,16,22,265,1559,1021,1,173,443,1524,1532,1344,1347;38;F
44053;1451,140,1604,1624,1325,1110,173,1700,174,1470;50;F
44080;982,995,556,1524,1532,1359,1559,1434,1021,1526,1261,1509,1026,984,1384;38;F
44081;1624,1110,1344,443,776,834,1347,268,174,24,1633,1468,3,13,1451;30;F
44100;1604,451,1526,129,443,1524,776,1509,1347,1328,16,1468,265,13,1434;33;F
44147;1624,1517,1325,443,1524,1532,702,1026,1698,1359,1633,1468,1559,1314,1451;46;F
44153;568,947,17,1330,1322,1706,1581,556,1388,373,1698,376,2,1441,1451;36;F
44186;1581,776,1347,140,1624,982,1344,443,896,702,24,16,1468,1314,1451;45;F
44194;1700,702,1026,16,1468,1608,376,394,2,1434,13,556,36,1441,223;41;F
44210;1526,223,568,774,896,1487,373,1698,376,394,554,1434,1312,1510;40;F
44214;1604,1700,192;42;F
44227;776,982,1325,1322,917,947,1624,17,1581,1482,702,24,13,1510;32;M
44261;1624,1021,1526,1416,1533,1524,1509,1532,1700,1026,1468,1559,1434,1384,140;46;M
44282;834,443,1581,173,1325,1524,776,1526,1261,1533,1509,1532,1434,1510,140;47;F
44286;1482,1700,1026,1359,16,1633,22,1559,2,1441,1451,1434,1510,1384,140;29;F
44331;1624,17,774,1,1581,443,1532,124,268,16;24;F
44376;1,867,776,1482,1700,702,1026,373,16,1468,376,394,1441,984,140;29;F
44378;1328,373,268,24,1633,1110,982,1344,443,776,1347,1468,265,394,1559;26;F
44394;1261;53;F
44415;1261;47;F
44445;834,1388,1700,1698,828,16,22,1441,1510,17,1,373,268,3,1451;64;F
44459;584,1517,17,1624,774,1,443,1332,702,3,268;31;F
44503;17,917,1325,982,211,1581,1332,896,988,1388,22,2,984,1451,586;67;F
44532;17,451,1698,265,1434,1441;27;F
44585;443,1482,1347,702,1328,1698,16,1468,22,376,265,984,13,1451,140;23;F
44649;1110,774,23,1344,443,988,1509,1347,1328,24,16,1633,1468,984,1451;40;F
44687;1119,568,223,394,1261;48;F
44688;1021,1532,1261;42;F
44696;1526,1261,1509,1328,1359,265,1559,1434,1384;39;F
44704;17,947,1119,1261,129,1332,1295,373;43;F
44711;1344,1347,140,1624,451,1559,1517,1021,1526,1524,702,1026,1328,1359,265;46;M
44730;1119,1526,1359,1533,1434,1261,659,988,984,376,982,1332;38;F
44731;1261;42;F
44752;265,1698,1624,1451,13,1314,1468,1633,1347,443,1344,826,774,947,16;37;F
44802;1532,373,1559,1434,1524,1295,1509,1700;40;F
44809;1110,1021,1330,1119,774,1604,1624,1526,1261,1344,1359,1468,265,13,1434;43;F
44818;917,1325,1416,173,1532,16,1468,1559,1261;49;M
44826;1624,917,1021,1526,1261,173,1533,1524,834,1509,1026,1559,1532;39;F
44852;1482,776,129,982,22;74;M
44878;1604,1517,1338,1,443,556,1524,702,174,16,1468,1314,13,1434,586;36;F
44928;451,1328,265,1510;32;F
44949;1524,16,192,984;33;F
45011;451,1325,1581,988,1328,373,265;26;F
45018;1322,1325,1482,124,16,1468,376,1451;23;F
45025;1451,1510,1624,774,1322,443,776,1482,1359,174,24,16,1468,265,1328;37;M
45052;451,1110,1581,776,268,860,1468,265,394,2,1314,3,13,1434,140;29;F
45071;1434,3,376,733,373,1388,36,834,988,896,1581,1,17,584,1338;31;F
45120;1441,1295,982,1322,774,1604,22,2,1434,1624,947,373,265,394,192;41;F
45125;1526,1021,917,1322,1581,443,1509,1532,702,1026,16,1468,1559;44;M
45150;17,982,211,1332,988,22,984;65;F
45169;1441,1468,297,947,776,373,554,444,13,1312,586;23;M
45226;1510,1434,1468,896,776,1332,1581,1110,1338,223,1624,1526,1344,443,1509;73;F
45232;17,443,1482,124,373,828,174,24;47;F
45263;443,556,1524,776,1509,1482,16,1468,376,265,1314,13,1451,1434,1510;51;F
45308;1261;52;F
45328;268,173,1510;27;M
45332;1517,1021,1338,1706,1,443,1524,776,702,1026,1633,1314,1434,1510,140;65;F
45339;1416,702,1332,1359,1021,1526,1533,1524,1509,1532,1700,1026,865,1559,1434;61;M
45345;947,1119,223,451,1261,1110,173,174;56;F
45360;1261,659,988,22,394,3,140,1706,409,443,896,373,16,1314,1451;33;F
45376;1624,36,124,1347,373,1698,268,733,1633,22,1441,984,1434,1510,586;35;F
45378;1604,1517,1388,988,1509,1482,1347,702,1344,1325,1706,1633,1468,265,13;27;M
45382;1021,1526,1533,1332,1524,1509,1532,1700,702,1026,1698,1359,865,1559,1434;58;F
45547;1604,917,1330,451,1322,1325,129,1533,1581,1328,1359,733,265,13,1434;34;M
45548;16,373,776,1344,1,741,17,1468,24,376,984,13,1451,1510,140;30;F
45563;1325,1021,1338,982,917,947,1517,1581,1332,1524,702,1026,22,1441,1510;27;M
45640;1604,1624,917,1322,1482,1388,124,702,24,16,1468,376,3,1451,1434;31;F
45653;1,982,1322,1338,451,1119,917,584,173,1533,1581,265,1559,1434,1384;58;M
45693;1332,268,1359,373,733,174,16,192,394,2,13,1451,140,586;9;M
45708;1347,1468,140,1624,774,741,443,556,1332,124,1698,24,376,394,13;30;F
45718;917,1526,1322,982,211,1332,776,988,1509,1698,733,1468,1559,984,1434;53;F
45722;1021,1338,1322,1532,1700,1328,265,1526,1533,1524,1026,1359,1559,1434,1384;1;F
45739;1526,1,982,1344,443,1487,1532,1347,16,1468,1608,376,1559,13,140;11;M
45783;984,1314,1559,394,376,1624,451,1338,443,896,988,373,1698,1468,1451;23;F
45840;1604,774,1338,129,1482,1359;61;F
45859;774,1482,373,376,1510;23;F
45885;1021,1322;47;M
45892;1325,1532,1388,1026,1698,1359,265,1470,1451,140,1533,17,1322,443,1434;30;F
45906;1347,373,1559,1468,24,1526,1624,1517,1021,1,1524,702,1026,16,265;36;M
45909;1451,3,16,776,1581,982,129,1,1325,1434,1510,140;52;M
45963;265,776,1330,451,1325,982,1482,1328,16,22,1559,3,13,1451,140;40;M
45980;828;52;M
45998;1021,702,1328,1517,1330,376,265;48;F
46020;1624,826,1110,129,1344,776,1482,1347,702,1633,376,1314,13,1451,1510;31;M
46036;1344,776,174,1633,1468,394,2,140,376,22,16,17,443,373,1451;33;F
46059;211,173,988,1509,1532,1700,702,1026,1698,1359,376,394,17,1526,1261;41;F
46095;1434,140,1633,1700,1581,451,826,1,129,776,1482,16,1441,1470,13;19;F
46200;1624,774,1344,443,1347,268,1468;48;M
46210;1624,1322,1706,174,1633,22,376,1314,3;31;F
46219;2,13,982,17,1624,1517,774,1322,1325,1,268,16,1468,1314,1510;65;F
46221;1700,268,1468,376,394,2,13,1451,1434,1510,140,1119,382,512,408;29;F
46225;1261;53;M
46296;174,22,376,265,1559,1314,173,16,17,1110,1624,444,984,443,982;32;F
46302;1325,776,896,1482,1624,982,211,443,863,988,1633,865,444,984,1451;56;M
46334;1434,834,36,1700,1328,1698,828,1468,865,265,2,1314,1441,984,13;29;F
46380;774,1338,1110,443,776,1347,702,24,1468,13,1451,982,741,124,373;36;F
46418;17,1312,409,995,443,1295,988,1388,373,733,860,554,3,1451,1434;21;F
46464;741,173,1344,124,1347,268,24,1633,1468,22,192,984,13,1434,1510;37;F
46466;1468,192,13,1624,297,1110,443,863,1524,1510,1021,1026;67;M
46473;1325,1,1524,776,1482,1026,702,1328,16,1633,192,265,1559,1314,13;38;F
46483;443,1604,1517,774,1021,1322,947,1338,741,23,373,1698,828,16,1451;33;F
46484;1604,1559,1532,1526,1524,1509,1468,1434,1026,1021,917,776,774,702,13;57;M
46521;1624,1434,1314,24,702,1388,834,982,1325,917;46;M
46559;1624,17,584,568,1325,173,443,1295,988,1388,1700,16,13,1434,1451;22;M
46562;1261,1119,1021,1526,1344,1524,1509,1532,702,1026,1328,376,265,1559,1434;42;F
46571;1261;40;F
46598;1468,2,13,1451,1434,1510,17,947,1261,1608,22,1559,1441,984,1384;48;F
46640;947,917,1338,1261,1416,1581,834,1509,1359,1559,2,1441;53;F
46656;1338,1325,1581,443,834,1482,828,192,376,1314,13,1434,140,1698;42;F
46664;394;26;M
46683;1624,1604,451,1,556,1524,988,1026,22,265,1434,140,984,982;51;F
46690;1,129,1581,1524,1509,36,1532,124,702,1359,1533,1026,1468,1559,1441;36;M
46701;774,1510,174,702,867,1517,1604,1624,741,1,1581,124,24,16;40;M
46714;1470;32;F
46720;17,1559,1261,1384;39;F
46721;1581,1295,776,1509,1482,1532,1608,1434,1698,376,265,1559,1441,1470,1312;70;F
46764;1624,774,1325,1482,373,16,1468,1451,140,1261;28;F
46781;1604,1526,1261,1524,834,1509,1532,1026,1468,13,1434;44;F
46789;1314,702,1388,1482,1509,776,443,982,1325,568,917,1604,1624,140;40;F
46796;982,140,1434,265,22,1026,988,1524,556,1,451,1604,1624,984;55;M
46810;1119,1328,1510,1517,1624,451,1526,1325,443,1524,702,733,1559,265,1434;32;F
46823;36,1338,1581,982,1325,741,917,124,702,24,1468,1441,13,1434,140;35;M
46831;1,982,988,1509,1482,1532,1026,1468,1608,22,265,984,1451,1434,140;19;F
46859;297,1119,1706,173,174,1388;41;M
46877;382,512,408;44;F
46881;568,982,995,1332,867,863,988,1700,828,1633,1608,22,444,984,586;71;M
46883;1021,1526,1261,1524,1700,1026,1698;43;F
46997;1517,1,1524,1026,702;32;M
47001;774,1322,982,1332,776,1482,124,702,24,1633,3,13,1434,741;28;M
47044;382,512,1700,408;68;F
47067;223;51;F
47088;1510,1434,1468,1026,702,124,1482,776,1524,826,1517,1624,1322,1325,1;49;M
47097;1325,1581,1344,1509,1532,1700,1347,1026,1328,24,1698,1633,1468,1470,1434;36;F
47112;1344,129,1338,382,1470,223,451,23,512,1700,1698,1633,1468,192,408;36;F
47136;1119,568,451,1325,982,173,1533,1581,1524,1026,1328,174,1468,265,1434;32;M
47143;223,17,1604,1624,451,826,1581,16,1633,1441,13,1434,1451,140,1314;21;M
47158;776,863,1700,702,865,1384,1509,408,512,382,1524,1533,1532,1026,1559;39;F
47175;17,223,1416,1328,1698,1359,265,2,1441;45;F
47182;1581,1509,1532,1698,1359,860,865,376,1559,2,1441,1451,1434,1510,1384;61;F
47260;774,223,982,988,174,865;82;M
47296;17,584,409,982,211,995,867,659,863,896,988,733,860,984,444;26;F
47302;451,382,36,1700,16,1468,1470,408;38;M
47328;1468,1470,1110,1330,451,1517,1624,1434,13,1026,1700,1509,1526,1532,1559;37;M
47382;586;43;F
47394;982,659,863,896,36,373,1559,984,1312,828,774,1261,556,192,376;71;M
47403;1482,776,451,774,1624,1119,1330,129,1110,1328,16,865,192,265,1441;34;F
47432;1359,828,22,443,1482,376,23,211,1332,988,1110,776,1633,265,1261;47;F
47473;376,265,1441,1451,140,1517,774,1021,1,23,443,1524,702,1328,2;46;F
47485;13,1441,265,1468,16,1698,1328,1026,702,1524,129,1322,1021,1330,1517;44;F
47501;741,1706,774,1624,1338,1322,1344,1295,1468,1441,1451,1434,1312,140,408;65;F
47506;1330,1624,774,451,1344,443,1482,1347,268,16,1468,1559,1314,13,1451;74;F
47516;828,550,1470,554,1451,774,1119,1261,1344,1295,192,376,1559,444,1312;63;F
47517;22,192,1314,1441;32;F
47528;1624,1026,826,982,1524,1700,702,174,16,1468,376,265,444,1434,408;42;M
47626;568,382,1533,512,1332,988,16,22,192,265,1470,1434,1510,140,408;32;F
47630;947;46;F
47633;443,1332,867,776,1482,124,1347,373,1698,16,1468,2,1441,1451,1510;38;F
47636;17,1338,1322,211,834,394,408,382,512;46;F
47660;1338,1700,373,1698;46;F
47666;1322,1624,1338,1706,1608,140,1325,741,826,451,1330,1119,917,173,124;43;M
47704;1322,776,1532,1347,702,1325,268,3,16,265,140,1328,1468,1434,13;26;M
47717;1526,568,1608,1441,444,1700,982,382,408;11;F
47718;865,192,376,1559,1261;64;F
47725;1624,584,982,443,1332,550,733,1633,22,192,1470,984;40;F
47733;223,444,860,865,1261;39;M
47820;1624,1,1344,443,776,988,1482,1388,1700,702,268,16,1314,13,1510;23;M
47902;1526,1325,1110,173,1533,1581,1524,1509,1532,1700,174,1559,1384,1510,1434;40;F
47929;982,1332,1524,988,1026,702,1328,265,984;46;M
47941;1119,1524,1532,1700,1559,17,1021,1533,1026;45;F
47947;1328,1581,982,409,451,223,1624,947,774,1330,865;40;F
47973;1533,373,265,2,1441,1261;42;F
47988;1482,24,1624,443,776,1347,1328,174,16,1468,22,13,1434,1510,140;50;F
47994;373,192,1338,1698;21;F
48025;1330,268,16,1559,774,1295,13,1312,451,826,988,1700,1633,1510,408;37;F
48069;444,774,568,1330,776,1328,265,1470,451,443,1509,1532,1559,13,1384;39;F
48072;774,982,1344,1332,988,1384,223,1559;45;F
48147;1509,1328,1451,1434,1261;51;F
48167;1581,1328,550,265,1470,554,140;39;F
48188;265,3,1510,1325,774,947,1332,373,376,394,1624,451,1526,1468,586;27;F
48200;1581,1604,1325,1110,173,776,1482,1700,1347,174,1633,16,376,13,1451;33;F
48229;776,1509,1532,1347,702,1026,1328,16,265,1559,1021,1517,24,1633,22;29;M
48243;16,24,174,917,947,1517,17,1604,1624,1468,1608,192,2,13,1434;42;M
48321;741,1110,1344,443,659,1487,373,1698,24,16,1468,22,140,394,13;57;F
48338;22,865,1441,984,1510,444,1532,834,896,1332,995,211,982,1325,17;27;F
48382;1700,268,174,1468,22,443,1338,1332,1,982,36,741,1517,702,140;16;F
48415;24,16,1633,1468,376,265,1314,1451,36,1624,774,1,1524,1482,13;31;F
48487;982,1510,268,1604,1517,1021,1533,1524,834,1532,1026,1328,1359,265;48;M
48504;1526,1,1581,1332,1328,865,22,1434,1261,129,1700,265,1608;37;F
48523;1261,1533,1509,1359,1434;36;F
48527;36,1700,16,394,1470,13,1434,140,408,586;41;F
48541;1509,1482,1532,36,1026,1328,373,268,174,16,265,1559,1441,13,1384;48;F
48547;373,1359,24,1468,376,1325,1581,776,1698,16,394,13,1451,1434,1510;36;F
48564;1338,1,982,512,776,1700,1328,1698,373,16,1468,1441,1470,444,408;39;M
48586;1330,917,1624,451,1021,826,1322,129,1581,556,373,1698,16,265,13;45;F
48594;1451,1510,140,984,444,124,988,1581,982,1325,741,774,1517,1604,1624;72;F
48595;1312,140,223,1119,173,512,1581,550,16,865,394,1434,1470,984,408;43;F
48596;1624,1517,1021,1524,36,1388,702,1026,3,13,1451,1384;49;M
48612;13,1434,1510,140,17,1322,1325,1,129,1581,1344,268,1633,22,586;38;F
48638;17,568,409,982,211,995,1332,867,863,988,984,444,860,865,22;32;F
48650;192,394,1559,1314,1441,1470,554,13,1451,1434,1312,1510,140,408,586;35;F
48662;554,556,834,129,550;39;F
48704;1509,1532,1700,1468,22,376,394,1559,1441,444,984,13,1451,1434,1384;48;F
48709;140,586,1624,947,1526,1416,129,1533,556,1509,1700,373,1698,1359,828;64;F
48717;1416,1,1581,443,776,1509,1482,36,1532,702,268,1468,376,17,982;24;F
48736;1328,1312,140,1021,1261,1322,409,982,1332,1700,1026,1359,265,984,1434;41;F
48766;1388,1347,1026,1328,268,174,24,16,1633,1468,265,1314,13,1451,1434;39;F
48779;776,1700,1698,1359,376,394,2,1314,3,13,1451,1434,1510,1384,140;57;F
48890;17,1322,1344,1434;67;F
49065;774,1451,1624,23,1581,776,550,16,1468,1314,554,1434,1510,451,192;41;F
49087;1021,1295,1524,1509,1532,1359,1559,1451,1434,1510,1261;46;F
49097;1261;36;M
49105;1021,1509,1532,1468,1526,1451,17,3,1434,1416,1700,1026,373,1698,1441;42;M
49124;1624,1604,1119,1526,1325,1,982,173,13,1468,1470,1434,451;37;M
49156;1261;10;F
49169;1261;8;F
49183;982;40;M
49197;982;76;F
49203;741,917,1604,1624,17,124,373,1698,1608,2,1314,1441,13,1434,586;30;F
49212;1261;6;F
49279;995,1581,896,1441,568,982,211,1332,867,988,1608,22,444,984,1451;73;F
49302;1532,173,1517,124,1700,1510,140,1434,265,1328,1026,702,1524,1,1021;41;M
49317;1532,373,1451,1510,834,863,1608,1416,982,867,659,394,586,1441,1261;40;F
49351;774,867,451,13,1347,1434,1110,1,443,3,268,373,1359,1384,1532;45;F
49361;1624,774,451,23,1581,776,550,16,1468,192,1314,554,1451,1434,1510;43;M
49366;1021,1322,443,1524,1532,1700,1026,373,174,16,1468,265,1559,13,1510;76;F
49371;17,1624,741,982,556,1700,1698,24,394,376,984,13,1434,1312,140;49;F
49381;1332,1509,1532,1700,1347,1026,1698,1468,22,1559,13,1451,1434,1384,140;74;F
49422;17,1509,1359,451,1021,1526,1261,1416,1524,1026,16,265,1559,2,1434;43;F
49427;1312,984,444,733,982,1700;13;M
49451;1700,733,444,984,1312;11;M
49455;1021,1328,265;31;M
49496;297,774,1526,988,1509,1633,24,268,1347,1532,443,1110;41;M
49518;1700,733,444,984,1312;46;M
49535;1434,1026,702,1532,834,776,1524,512,1581,1533,129,1325,1322,1021,1517;27;M
49544;1434;52;M
49573;124,174,586,917,1322,741,409,556,867,988,373,1698,22,1510,140;61;F
49633;741,1325,409,1110,982,1581,443,988,124,373,16,444,984,13,1510;65;M
49656;140,1624,774,741,1344,443,776,1482,124,702,24,16,1468,1314,13;37;F
49673;1517,774,451,1021,826,1322,1,23,443,1524,776,1700,702,1026,16;54;M
49683;1325,741,982,1581,443,988,124,268,16,1468,444,984,3,13,1451;53;F
49692;129,17,1261;41;F
49745;443,1325,1624,1517,774,1526,982,1332,1524,1347,1026,702,1468,22,13;35;F
49771;1332,1524,1026,17,1526,1261,1416,982,867,373,1698,1359,22,1559,1434;47;F
49782;17,1517,173,776,1482,702,16,1468,13,1338,741,124,22,24,586;41;F
49784;995,3,1451,984,444,1633,860,268,988,896,863,443,211,982,826;54;F
49798;451,1026,1328,16,22,1468,702,443,1325,1526,774,1517,1624,982,1332;39;M
49829;1451,1434,1624,17,1526,1261,1416,1509,1532,1026,373,1359,1559,1470,140;44;M
49855;1624,1517,774,1119,1338,741,173,1482,702,22,24,16,1468,13,586;11;F
49860;408,382,512;40;F
49880;17,1624,1604,774,1119,1338,741,124,702,174,24,16,1468,13,586;46;M
49897;860,867,863,865;20;F
49921;1344,774,1604,1624,947,129,1581,1332,1509,1532,1347,16,1468,13,1434;62;F
49966;268,733,584,1517,568,451,382,1332,834,1487,1700,1559,1470,1384,1261;33;M
49971;1388,373,568,1322,1706,1581,512,382,129,982,1700,16,3,1434,408;46;F
49997;702,1524,1325,1322,1338,1517,1021,1,982,1332,22,376,1434;40;F
50005;584,947,774,741,988,124,1347,702,373,24,16,1633,1468,376,394;40;F
50022;512,408,1700,382;39;F
50087;1119,1330,451,1110,443,268,1633,376,1559;44;F
50099;1434,1338,1325,1482,24,13,556,376,1624,774,1322,443,776,16,1468;51;F
50117;1608,586,834,17,1434;27;M
50136;556,192,451;35;F
50142;1526,16,22,984,774,982,443,1332,1509,1532,1559,13;60;F
50164;1434,140,444,22,1468,741,1517,17,896,1700,1487,373,1608,984,1451;9;F
50176;1261;8;F
50192;1261;5;F
50207;1261;42;F
50209;1295,1509,394,2,13,1451,1526,1344,443,896,1487,1698,828,1468,376;51;F
50213;776,1482,16,1468,2,1441,947,1322,982,1332,1700,22,376,444,1434;39;F
50236;382,1338,223,1119,17,1581,556,863,1698,828,865,2,1441,984,586;48;F
50249;1581,1624,774,1021,1526,1338,1,982,173,16,1633,1468,22,265,1559;46;F
50258;1524,556,867,1026,1633,1624,1517,982,1347,702,733,1468,376,2,1441;31;F
50366;774,556,1700,373,268,376,394,2,1441,586;72;F
50386;1532,1700,1026,1468,22,1434;50;F
50397;1261;42;F
50425;917,1517,1021,1524,1700,702,1026,268,174,16,1468,1559,13,1434,1510;27;M
50514;17,1604,1624,1517,451,1322,1325,1110,1344,776,1482,16,1468,376,13;29;F
50524;16;26;M
50529;1388,1468,2,1434,1451,13,22,17,1322,741,124,24;30;F
50566;174,297,1119,451,1325,1,1482,1700,702,1026,16,1468,1110,173;29;M
50579;1624,1604,1526,1344,443,1509,1482,1347,702,1026,1328,16,1468,1559,3;40;F
50604;1110,16,1119,451,443,17,982,1332,1517,1700,1441,297,1,1468,13;23;F
50622;512,382,129,443,834,36,1700,702,373,1698,268,174,1633,192,408;27;F
50644;1524,1509,1532,1026,1359,24,16,1633,1468,265,1559,13,1434,1384,140;38;M
50675;1624,297,1517,774,1119,826,1,1581,1328,16,376,13,140,451,702;39;F
50694;192;8;M
50722;192;4;M
50731;774,1624,982,1581,1332,1295,988,1468,22,444,984,13,1434,1510,140;70;F
50756;984;27;M
50783;1624,1325,896,22,984;22;F
50794;1261,1325,1,1608;54;M
50795;192;35;M
50818;1026,297,17,741,451,1322,1,1110,834,733,174,1468,16,13,1434;25;M
50856;1,1325,1706,1338,1526,451,774,1624,1604,1119,1322,1110,173,268,174;40;F
50862;1119,1510,443,1482,268,1633;34;M
50909;376,265,1314,1434,13,1451,1633,1322,443,16,22,140,173,174,297;30;F
50970;451,1021,1338,826,1322,1,1524,36,1388,1700,702,1026,268,3,1451;30;F
50976;1261,1119,1604,1517,1021,1322,1,1110,1533,1344,443,1332,1524,1347,1434;33;F
51077;1624,1517,1526,1261,129,1533,1509,1482,702,13;36;M
51086;568,1338,409,982,995,1332,867,988,1509,550,860,1633,22,1559,984;36;M
51101;1581,828,394,702,373,1698,22,2,917,1,1332,36,124,1470,586;38;F
51109;1119,1,129,1581,1344,776,1482,1388,268,174,192,2,1314,13,1510;41;M
51149;124,702,268,24,16,1633,1468,1608,376,444,13,1434,1312,1510,586;41;F
51169;24,741,124,17,22,13,1451,1434,2,1322,1468,1388;56;M
51197;584,733;42;M
51212;124,947,1021,1517,1338,1524,36,702,1026,373,1698,16,376,2,1451;40;F
51226;13,17,1322,741,1388,124,24,1468,22,2,1434,1451;59;F
51249;1328;39;M
51286;24,13,1510,1517,774,451,23,16,1468,2,3;38;M
51299;1532,947,1604,1624,17,917,223,1322,1325,173,1581,443,1509,2,1451;71;F
51339;1261;31;F
51388;1624,451,826,1110,1344,1347,1328,1633,1559,1314,13,1524,1509,1468,1434;27;M
51404;1700,1359,1510,1559;32;F
51416;776,268,16,17,774,1706,1110,211,1328,1698,1468,265,1441,13,1510;71;F
51442;988,36,1388,702,394,17,917,1338,741,124,373,24,16,3,1451;34;F
51450;297,1581,394,917,1021,1344,443,1524,1532,1026,1328,373,1359,265,1559;35;F
51503;1509,1526,1021,17,16,265,394,1559,1441,984,13,1434,1510,140,1384;59;M
51511;23,982,1533,1581,1344,443,1524,1347,1468,13,1624,1325,1700,1510,140;61;M
51528;1624,1451,1434,1581,1110,1322,223,774,702,16,22,376,394,1559,13;31;F
51530;584,1,982,1581,1533,1344,443,1332,776,1482,1347,444,984,13,1434;37;F
51547;1517,265,443,451,1451,1325,1,512,1482,124,702,24,16,376,1510;29;F
51555;443,1510,1517,451,1021,1325,1,1524,1509,702,1026,1328,16,265,13;27;F
51603;865,1559,444,984,13,1532,1509,863,1332,982,1526,1700,16,1468,22;37;F
51689;512,382,408;38;M
51699;1604,1624,1328,16,1633,1468,376,265,1559,13,1451,1434,140,1510,1384;41;F
51712;702,22,13,1624,1517,1322,1325,982,1332,776,1482,1698,16,1468,1441;50;M
51760;741,1581,776,1482,1388,124,702,1026,24,1468,3,13,1451,1434,140;27;M
51782;1434;37;M
51797;1344,1,702,741,16,1026,13,1434;54;F
51812;17,1624,1604,1517,223,1325,1,867,776,702,1633,1468,1314,1441,1451;40;F
51861;265,1468,1633,16,173,1,451,1517,1624,1338,1330,1328;81;M
51876;1322,826,1338,1021,1517,1604,1624,774,1,982,443,1633,1468,13,1510;44;F
51890;1482,1700,268,1468,13,1434,1119,1624,297,451,173,1344,443,16,776;45;F
51891;774,1338,382,129,1110,1581,512,373,268,16,1468,13,1451,1510,408;44;F
51909;376,733,828,1338,584;35;M
51911;828,16,1633,1468,13,1451,1510,1325,140,1624,1344,1295,1347,1698,268;58;F
51922;774,1330,982,173,1581,867,1359,16;41;M
51926;947,774,1526,1322,1325,443,776,1509,550,1468,1441,1434,394,554,13;44;F
51930;1026,1332,556,982,1110,1706,1517,1021,1338,741,1524,124,702,828,22;49;F
51934;443,13,140,988,1330,451,774,1322,1,776,1359,1633,16,1468,1510;12;F
51936;382,512,1312;13;F
51941;1468,16,776,1624,1604,451,1526,1338,1328,1330;66;F
51944;1624,382,512,1559,1441;36;F
52005;13,1322,1581,776,1347,1700,702,1328,268,24,1633,16,1468,22,140;15;M
52034;1119,451,129,1533,1524,1532,1559;38;F
52093;982,1344,443,373,174,24,1468,1441,13,1451,192,741,173,867,124;40;F
52112;1261;38;F
52116;1261,1,1533,1344,443,1295,1509,1026,1359,828,733,865,376,265,1451;43;F
52119;1261;1;F
52133;3,408,1434,1604,1532,1700,702,1026,373,1698,16,192,1314,1470,984;31;F
52184;1021,1533,409,23,982,211,1332,1524,1026,1359,16,1559,1314,1434,140;37;F
52185;774,443,1344,174,16,1468,1608,376,1314,1441,3,1451,1434,1384,140;33;F
52206;1604,1517,1526,1,1533,1524,1509,1347,702,1026,1359,16,1468,1559,1434;68;M
52221;947,568,223,1338,1322,1698,22,394,1441,1434;38;F
52228;702,1026,1328,1359,1468,265,1434,1451,1347,1482,776,1581,917,1604,297;31;F
52231;1517,774,1322,1,1581,1524,896,834,1347,702,1026,16,1633,1468,13;22;F
52251;1468,1604,17,917,1526,982,443,1509,1532,1328,373,1698,265,13,1434;48;F
52271;223;44;F
52307;1416,1509,1261;43;M
52368;512,1261;43;F
52406;1624,1700,1026,1328,1468,1526,1325,1698,1359,1441,1434,1524,1482,1532,373;46;F
52431;947,1021,1325,1,129,982,1581,1524,834,1532,702,1026,394,1441,984;42;F
52432;1295,988,834,1509,1482,1532,1347,1698,22,1559,444,984,1384,408,140;39;F
52475;917,1624,1,1344,443,1388,1347,16,1468,376,2,3,13,1451;32;F
52502;1624,1322,129,982,443,556,1295,776,1698,268,16,1468,1451,1312,1510;37;F
52533;741,1706,451,1330,1604,1624,1526,1533,1509,1532,16,1468,1314,13,1434;47;F
52539;860,1633,865,192,376,394,1559,2,1470,444,984,1451,1312,408,586;49;M
52562;443,1524,896,1526,1338,1295,834,1509,1532,1700,1026,373,1698,1468,1434;22;F
52573;586;39;F
52606;917,1322,982,36,1700,550,1633,22,376,2,1441,444,984,13,1434;32;M
52628;1,774,1509,13,1384,1526,173,1359,1604,1330,1338,443,1328,265,1434;45;M
52641;223,584,1604,947,568,1338,1322,1325,1,1698,16,394,1451,408,917;32;F
52654;1604,17,1322,741,443,124,24,376,265,2,13,1451,1510,140;52;M
52657;586;32;M
52664;174,16,192,265,1533,1532,1359,1026,1559,1261,1700,1314,1312,1434,1510;44;F
52749;211,982,1700,1332,867,776,863,988,1347,24,16,1633,22,13,984;42;M
52752;174,586;41;M
52758;556,702,1328,268,174,1633,1468,265,13,1624,741,173,443,124,24;28;F
52764;1633,1468,1608,22,2,1314,1441,1470,3,13,1451,1434,1510,140,586;56;M
52777;1624,826,382,512,1700,1698,174,1633,408;30;F
52833;1526,1532,174,1559,1434,1021,129,1524,1026;42;M
52850;1328,1434,1624,265;4;F
52854;1434,265;33;F
52861;129,982,211,995,1533,1344,443,1524,1509,1532,702,1026,373,394,1559;44;F
52863;1700,776,1581,1325,1706,1021,1119,1624,16,1559,1314,408,140,1510,1434;30;M
52890;1604,1434,140,1384,1510,1322,1706,1581,896,1700,373,1698,1359,1468,376;35;M
52902;1482,1532,702,1026,373,1698,1359,268,1468,376,1559,2,1441,1451,1434;36;F
52914;1295,373,1359,16,2,1441,444,1510,1021,826,1533,1581,776,124,1451;28;F
52999;1338,13,1314,376,1468,1633,16,24,1482,1509,443,1344,173,741,1624;34;M
53004;1441,1470,554,444,984,3,13,1451,1434,1312,1510,1384,140,408,586;21;M
53021;1509,774,1021,1526,1533,1524,1532,702,1026,1328,1359,265,1559,13,1434;46;F
53026;1624,451,1328,16,1434,1359,1468,1119,173,1344,174,865,22,1559,1441;33;F
53044;1517,1021,1,1581,1524,834,702,1026;34;M
53074;376,1434,1510,1468,192,1,1110,23,1344,776,1347,702,16,2,1441;41;F
53078;1261;39;M
53092;297,774,1526,1322,409,1110,23,982,211,1344,1332,1295,776,896,988;41;F
53101;1517,1021,1526,1,1533,1581,1524,1509,36,1532,1700,702,1026,1468,1559;34;F
53109;1312,1325,382,1526,1517,1624,13,265,1468,16,1524,1581,1322,1021,1261;51;M
53136;1706,23,982,211,173,1332,22,192,1510;38;F
53141;265;15;F
53165;1700,268,24,1338,741,1344,443,1332,124,16,1468,22,376,13,1451;47;F
53197;129,1533,1524,1559,1470;35;M
53203;1698,1524,1021,1517,828,702,1026,1328,16,376,265,1314,13,1624,408;37;M
53209;1517,1021,1526,1,1332,1524,1509,1532,702,1026,1328,1698,828,1468,1559;40;F
53212;1332,22,129,995,1700,1608,192,860,211,982;10;F
53244;129,1524,1312,1384,173,1295;37;F
53273;173,443,1509,1482,702,373,268,24,1468,1633,192,1470,1434,1312,140;60;F
53274;16,741,863,373,1698,13,1700,223,1624,409,1295,1509,865,554,1312;77;F
53283;265;47;M
53306;1312,1322,451,1021,1526,1416,982,1533,556,1524,1509,1482,1532,1468,1559;39;F
53307;1624,1604,1517,1330,1434,1328;55;M
53333;1526,1322,129,1533,1524,1509,1700,702,1026,16,1468,1559,13,1434,1384;35;M
53377;1526,1524,1517,1434,1322,995,568,444,1338,24,16,22,984,982,988;52;F
53386;1624,1604,17,917,774,451,826,129,1332,1700,1470,408,512,1482,36;65;F
53404;1338,1624,1021,1026,373,584,17,1332,733,776,1451,1526,443,1532,1559;27;F
53486;124,24,16,140,173,1322,1624,1604,741,1698,1510,2,1338;40;F
53507;982,1322,568,1451,1434,1325,988,1388,1314,1510,896,16,376,774,129;27;F
53523;1325,1,1533,1581,443,1509,702,1026,1328,1359,268,24,16,1468,265;30;F
53534;774,1261,1526,1468,1434,1510;44;F
53536;1581,1524,1026,1559,1384,1021,1261,1338,1,834,124,702;27;M
53574;584,382,512,1700,550,408;39;F
53615;1517,1021,1526,1338,1416,173,1524,1509,1532,702,1026,16,1559,2,1441;50;F
53710;1624,211,982,860,192;4;M
53731;1706,1332,1608,1338,1517,1325,1,702,1633,13,1510;49;M
53738;1261;16;F
53740;297,1110,1344,443,1332,776,1482,1347,16,22,376,1451;47;F
53741;17,776,834,36,1328,828,550,376,265,394,1441,3,1451,1384,140;35;F
53742;382;45;F
53747;1261;45;F
53759;1261;44;M
53775;1021,1526,1261;47;F
53803;16,1510,1524,174,1559,1434,1451,140,451,1325,129,23,173,443,776;31;F
53911;1344,1532,1633,1434,13,1347,1509,1524,982,1526,1021,1624,1328,16,1468;23;F
53912;1,1624,17,1325,896,373,1698,16,1468,394,984,13,1451,1510,586;52;F
53914;1332,124,1700,1633,1468,22,13;38;F
53919;1526,443,776,174,1468,192,1470,13,1434,1624,1119,451,1330,1328,265;40;F
53968;24,265,173,1624,1119,1330,451,1526,1581,443,1328,16,192,1470,1434;41;M
54078;1624,774,1110,443,1388,1468,3;55;F
54106;17,1624,1021,1325,1524,1532,1026,16,1434,1384;41;F
54116;451,1021,1,1700,1347,702,1026,1328,1633,1468,265,13,1451,1434,1510;30;M
54120;1624,733,174,16,1633,1468,376,265,1559,1314,1441,3,13,1451,1312;24;F
54153;1532,268,16,376,394,13,1434,1384,1604,917,1119,1524,776,702,1026;53;F
54201;982,1332,24,22,444,1434,17,129,373,1698,174,394,1441,554,1510;38;F
54209;24,16,1633,1468,192,1314,1559,140,1119,774,17,1624,22,444,13;40;F
54225;1330,451,1322,1325,16,554,1434,129,192,1559,1470;27;M
54229;1388,702,1026,268,174,16,376,1314,13,1451,1434,1510,1384,140,586;52;M
54243;1330,13,17,1526,1338,1325,1,1344,443,776,1359,1328,1468,1451,1434;37;F
54265;1119,223,741,409,129,982,1332,1295,988,860,865,22,1441,1312,984;6;F
54272;1344,265,13,1706,1633,16,1482,1434,1533,1509,1700,1532,174,173,297;26;M
54282;223,409,129,982,173,1332,659,988,36,174,22,394,1441,444,984;11;F
54318;1700,174,3,1434,1510,408,512,1706,826,1119,1517,382;31;M
54326;1468,1559,1451,1434,1510,1384,947,1338,1325,896,834,1700,1698,16,1441;28;M
54330;568,1021,1344,443,863,834,1328,1468,265,554,444,984,13,1434,1604;38;F
54336;828,550,733,1698,1026,1532,1509,1524,1322,1526,1021,584;34;M
54337;741,1604,1624,443,1388,124,268,16,1633,1468,140,1434,1451,3,192;46;M
54393;1624,1119,223,451,129,1110,173,1700,174;38;F
54482;382;32;F
54520;917,947,584,17,1261,1325,1416,373,1698,733,376,394,1441,444,1451;23;F
54551;17,917,1526,1416,1533,1524,834,1509,1532,124,1700,22,1559,13,1384;18;F
54562;1526,1416,1533,1524,1509,1532,1026,1468,1559,13,1434,1312,140,1384,586;75;F
54566;917,1517,17,584,947,1119,1261,1416,129,1524,1532,1698,1608,394,1441;34;F
54590;984,1517,1468,1347,1344,1325,982,776,741,702,129,124,24,13,1314;55;F
54595;1119,1517,1441,865,1468,16,373,1604,1624,1325,129,1581,834,36,124;39;M
54601;1624,1021,1526,129,443,1524,1509,1532,1700,702,1026,1608,394,1434,1261;11;M
54656;776,988,1509,1026,1441,1261,1416,1533,1524,1532,376,394,1559,2;45;F
54661;17,451,826,1325,129,1581,834,1700,373,16,1468,192,376,1470,140;44;F
54671;1624,17,1322,173,834,1482,1026,1328,1359,174,1261;42;M
54718;2,13,1510,140,443,1532,1434,1,1524,702,1026,1517,1021,1526,1261;15;M
54763;776,988,1482,1532,124,1347,702,1698,24,16,1633,192,1468,1314,13;37;F
54820;17,568,776,1700,373,1510,140,774,1,23,982,1295,22,13,1451;34;M
54885;1314,1470,1119,382,129,173,192;39;F
54945;982;76;F
54995;1624,947,1119,223,451,1338,826,1325,129,1581,443,1295,1700,1698,586;51;F
55002;1322,741,124,16,1468,22,192,1559,1314,1510;35;M
55008;1517,947,223,1581,1295,1470;47;F
55009;826,982,1110,1332,268,917,1581,443,1388,1347,373,13,1451,140;50;F
55037;192;31;M
55062;1526,1509,702,1026,1608,1517,1021,1261,129,1524;47;F
55093;1624,1517,774,982,443,776,124,702,24,16,376,1559,1451,1510,140;22;M
55105;1581,16,1434;32;M
55107;741,1526,1021,774,1604,1624,1517,917,1322,1581,702,16,265,1451,1434;24;F
55144;1624,17,947,451,1416,982,211,1332,1509,1359,2,1441;32;F
55160;129,1261;44;F
55231;17,1338,741,1,982,1344,124,376;39;M
55291;16,1347,1700,36,1482,896,776,1295,1344,512,1110,1325,1119,140,586;44;F
55302;1325,1295,1332,896,776,988,36,124,1487,1700;51;M
55311;702,1026,1328,1359,265,1322,1325,1347,13,1517,1330,1021,1526,1524,1468;46;M
55342;1532,174,1314,1624,1338,1524,1347,702,24,16,1633,1468,13,1510,140;32;M
55345;917,1517,1526,1325,1581,1524,776,36,124,1026,1698,16,1468,408,1384;39;M
55357;373,554;26;F
55362;1604,1517,1021,1338,1322,1325,1,443,1524,1482,1026,702,373,3,1451;28;M
55374;1328,36,1524,1344,1533,1110,1,1325,1021,223,774,1261,265,394,1312;42;F
55375;1524,1344,1533,1,1325,1322,774,1021,1624,1261,1328,265,394,1434,1312;13;M
55377;1581,443,776,1347,702,174,24,16,1633,1468,265,394,1559,13,1434;44;M
55398;1026,16,1468,702,1482,1524,1,826,1021,451,1517,1604,297,776,1624;21;M
55408;17,1332,982;23;F
55411;1532,1700,1026,1328,1698,1359,16,1468,1559,1441,984,13,1434,1510,140;58;M
55414;394,3,1451,211,1526,443,1524,1509,16,1510;42;F
55423;917,947,1624,1526,1325,1,982,1332,1524,16,1559,1441,1510,1384,140;34;F
55428;1119,17,1359,1700,1388,776,512,1706,826,451,1633,1468,376,444,408;19;M
55429;1624,1517,129,982,1482,24,1468,984,443,702,16,1451,140;47;M
55458;394,1441,554,1510,1384,1325,568,17,1624,947,1119,1338,1322,129;41;F
55483;1451,1510,1698,140,24,1344,982,988,1434,13,124,741,702,443,1;23;F
55488;1581,1482,1328;76;F
55491;702,268,1510,3,1633,192;66;M
55511;776,268,174,382,826,512,1119,17,297,1624,1482,1700,702,408,265;51;M
55552;443,1509,1482,1532,702,1026,268,24,16,13,1451,1434,140;55;F
55563;1021,1322,1325,1581,443,1524,1509,1388,702,1026,268,16,1468,13,1434;29;M
55571;3,13,1509,443,1581,982,382,826,1624,1604,917,774,1119,1526,1261;49;F
55575;1347,1026,1359,268,16,1633,1468,265,1559,1451,1434,140;62;F
55603;774,1119,1509,1482,140,1510,1434,13,373,1624,917,173,776,1347;53;F
55611;1624,774,826,741,1110,1344,776,1509,24,1526,443,1532,16,1468,13;52;F
55635;1524,1021,1517,1,1344,1700,702,1026;53;M
55672;1338,1,982,1332,1482,36,1700,702,1698,16,1468,376,13,1510,140;24;M
55752;1434,1468,13,140,1510,16,1524,1026,1021;62;F
55833;444,408,826,451,1119,382,1706,1325,173,512,776,1482,1700,174,1633;50;F
55875;24,1434,1624,1604,774,23,1482,16,1468,13,1451,1510,1581,443,1633;56;F
55888;17,1021,741,556,124,1026,1533,1559,1510;24;F
55926;774,1021,1468,376,1559,1451,1384,1526,1338,1524,1509,1532,702,1026,1698;27;F
55965;1624,1698,268,1526,1325,1533,1532,1359,376,1559,2,3,1451,1434,1510;44;F
55973;1526,826,1322,741,1110,3,13,774,1604,1624,1344,443,1347,1468,1451;36;F
55974;917,1533,443,776,1532,1359,16,376,140;44;M
55977;1517,1325,174,16,1633,1468,13,1510;55;M
56049;1021,1322,1,173,1581,1524,36,1700,702,1026,174,1468,1559,1434,1384;51;M
56089;1384,17,129,1344,556,1524,988,36,702,1328,1698,1359,174,265,1312;37;F
56118;1021,1359,13,1119,1330,451,1325,1,1533,1532,192,265,1559,1434,1510;37;F
56151;1295,863,988,36,373,828,1441,984,129,982,173,1344,556,174,1312;37;M
56153;1604,1624,451,1526,443,776,1509,1482,1532,1347,1328,24,16,1633,1559;48;F
56158;3,1451,1434,1510,140,984,17,947,223,741,982,1332,1487,865,1441;37;F
56164;1624,17,947,568,223,1330,1338,1,1581,1700,1328,373,1698,376,265;28;M
56174;1624,17,947,568,223,1330,1338,1,1581,1700,1328,373,1698,376,265;29;F
56190;17,1517,917,1338,741,173,776,36,124,1700,702,24,1441,1451,1510;44;M
56195;1624,741,1325,124,1700,24,16,376,1434,140;23;F
56201;211,863,774,1119,1325,1110,982,173,443,174,865,1314,13,1451,1434;59;M
56292;1624,1330,1322,1325,1110,1581,1524,1482,1509,1347,1468,1559,1314,1434,1384;23;M
56395;1119,1,1110,982,173,1581,443,1482,1700,1441,140,834,1698,174,394;60;F
56426;659,394,984,443,3,1110,24;41;F
56433;192,1322,409,129,1482,1468,22,376,17;44;M
56520;1517,568,1526,1338,1322,982,995,1524,988,24,16,22,444,984,1434;24;M
56540;1517,568,1526,1338,1322,982,995,1524,988,24,16,22,444,984,1434;16;F
56611;1624,1517,451,741,124,702,1026,24,265,13,1434,140;31;M
56623;451,1322,173,1581,1482,1347,1328,174,16,1384;30;M
56624;24,265,3,1312,1624,774,1526,826,443,1509,373,1026,1470,408,1451;47;F
56654;1517,1604,1325,1624,917,1322,1581,776,1482,16,1633,1468,13,1434,140;32;M
56687;451,1526,1110,1581,443,1524,702,1026,1359,174,1468,1559;48;F
56714;988,1624,443,1526,16,1559,140,373,1451,896,984,568,982;20;F
56785;373,24,13,1510,1526,451,1624,1604,1110,443,1347,1698,16,1468,376;26;M
56787;702,860,1468,17,1338,1322,1700,1698,16,140,1624,741,124,586,24;40;F
56796;17,451,867,776,1700,1698,174,16,1468,2,1441,444,13,1451,1434;18;F
56811;13,1482,1468,776,443,1322,774,16,1624,376,556,24,1325,1338,1434;77;F
56837;1,1119,774,1330,1110,174,24,265;37;F
56892;223,1325,659,988,1359,192,1344,1482,1314,408,1608,1470,1700,382,512;49;F
56969;1328,1359,268,174,24,16,1633,1468,1559,2,1314,1441,13,1434,1510;42;M
56994;1322,1338,17,223,1700,702,22,2,1441;47;F
57014;443,1347,268,24,1468,13,774,1624,1517,1021,1,1524,702,1026,1510;43;F
57038;1624,1604,774,1021,1526,982,1524,776,1509,1532,1026,16,1468,1559,1434;58;M
57106;1624,1,129,982,512,1532,376,1347,1487,702,1468,16,1608,1559,1434;39;M
57159;1325,1110,1344,1332,702,13,586,22,17,1338,443,140,741,124,24;31;M
57184;1451,982,129,409,17,1604,1624,774,995,268,1633,16,586,13,1510;35;F
57191;13,1604,1624,917,774,982,1332,988,268,984,1526,1325,16,1434,1510;50;M
57195;1344,443,1482,1328,1633,1468,1451,1700,1624,1604,774,16,394,1314,13;29;M
57205;443,1332,1295,776,1700,1468,2,1434,1451,774,223,741,984,140;65;F
57210;1322,1328,265,3,1451;64;F
57273;1328,192,1559,1314,13,1624,1325,22,1451,223,982,1332,988,1388,984;36;F
57277;586,1338,223,1119,1021,1261,1533,1524,1700,702,1328,1359,408,1510,1384;47;F
57318;1624,1517,917,741,1325,988,124,702,268,16,1468,13,140,1322,982;39;F
57334;192,1314;41;F
57403;1624,1604,917,774,1526,1325,982,1332,988,268,16,984,13,1434,1510;50;F
57449;982,373,1608,1312,828,124,1295,443,23,1110,1322,1338,451,1119,584;34;M
57495;1533,1700,1509;37;M
57547;1261,917,1517,1119,451,1526,124,1700,1325,1524,702,1026,1359,1559,1384;15;M
57557;1533,776,1532,1026,1559;38;F
57578;1434,1624,947,1344,443,1332,988,1482,1347,733,16,1468,13,1510,140;45;M
57592;1700,1468,1510,1526,1322,1325,1,1581,556,702,1434,1021,1524,1026,265;52;M
57598;917,982,211,1110,1487,373,1359,865,2,1441,1434;60;M
57619;1517,1604,1021,1,702,1328,1559,1470,1330,13,776,16,1434,826,451;28;M
57656;129,702,16,1468,1624,1322,741,982,443,896,373,24,984,13;48;F
57663;1526,1322,1509,1328,16,1468,265,1314,1441,13;55;F
57676;17,443,124,867,896,988,1482,984,776,1517,982,1332,702,24,22;46;F
57692;1322,376,13,1451;24;F
57807;1026,192,140;12;M
57808;1517,1119,1330,826,1,1325,1110,776,702,1328,16,265,13,1434,451;26;M
57897;451,1344,982,568,896,1706,512,174,444,984,3;26;M
57904;702,1328,1359,16,1468,265,192,2,1559;10;M
57907;865,13,1110,23,982,1344,443,863,988,373,24,16,376,2,1451;38;M
57973;947,917,1,982,1700,373,1698,1359,265,1510;26;F
58064;834,1700,702,1328,1330,1706,1325,23,1344,373,174,22,265,13,408;50;M
58097;834,16,1633,1468,1608,3,1451,140,408;33;M
58112;1526,268,1468,1338,1416,982,1524,1509,1532,265,1441,1510,1384,140,408;41;M
58123;982;72;M
58128;584,774,1261,826,129,174,1608,1470,192;40;F
58152;1416,36,1700,1026,1441;39;M
58174;443,988,1347,1328,373,1359,174,16,1468,22,1441,13,1434,1510,140;51;M
58175;1524,1700,1434,1384,140,917,1021,1322,982,776,1509,1026,1328,265,1559;52;F
58187;1510,1119,1021,1322,1,129,1110,1344,1332,1524,1026,865,265,1434,1384;37;F
58196;1451,1332,1344,173,129,1624,774,1119,1,702,550,174,1633,443,297;34;M
58203;917,1604,774,1624,1325,1344,1328,24,1633,16,1468,1559,13,1434,140;27;F
58222;1322,741,36,16,896,124,1325,443,373,1698,24,1468,376,2,1510;33;F
58224;1633,140,1624,1604,1517,451,1322,1325,896,24,16,1468,1559,13,1434;33;M
58273;17,917,22,1559,2,984,1312,1510;36;F
58279;1510,140,1416,1532,2,1384,17,1526,1261,1322,129,1295,16,554,1312;16;M
58304;1624,124,1328,1359,24,1468,265,1451,1434,1604,1330,741,982,173,1332;69;F
58322;1533,995,409,1416,584,17,1119,1021,1526,1261,1322,1325,1,982,586;36;F
58337;1332,1510,1119,1110,23,982,173,556,896,373,828,174,192,394,2;42;F
58349;741,1526,1330,1119,1604,1624,1517,451,1021,1,173,1524,702,1026;39;M
58460;1524,24,16,1633,1314,1434,1624,297,1526,1021,1026,1328,1359,1468,265;24;M
58491;1526,1021,1604,265,1328;49;M
58496;1624,1322,1325,776,1482,124,24,1633,16;30;F
58536;23,223,776,896,1509,1482,1700,1347,1698,1359,24,16,1633,1468,192;24;M
58537;129,1021,17,1295,1700,373,265,1312;16;F
58540;1604,1624,1517,741,1,124,702,1633,16,1468;20;M
58555;1608,223,1624,1328,265;35;M
58591;1524,776,124,16,1468,140,1434;23;M
58608;1388,124,1347,373,1698,16,1633,1468,376,1441,984,3,13,1451,1510;27;F
58639;211,129,1322,1338,917,1624,1604,17,947,1581,556,1700,1698,2,1441;55;F
58647;1330,129,173,1482,1328,1359,16,265,1451;37;F
58653;1451,1510,3,1468,268,1482,1332,443,211,982,129,774,1604,1312,1624;43;F
58660;1517,1624,1119,1322,443,776,1524,1509,702,373,268,16,1633,1468,13;35;F
58667;988,1328,550,265;39;M
58697;1624,1517,741,129,173,1295,834,1700,24,1468,376,192,1312,1510,140;42;F
58731;1559,1434,140,1700,1524,1581,982,1325,1526,223,1517,1021,1261;40;M
58795;1509,1482,702,1359,1026,1698,16,1633,1468,1559,1624,1021,1524,1328,265;28;F
58852;774,1338,1322,173,443,1332,36,16,1468,1559,1451;27;F
58856;1526,1344,443,776,1509,1482,1532,1328,1359,268,16,1468,265,1559,13;54;F
58885;776,1482,140,1624,584,774,826,1706,129,1633,376,1314,13,1434,1510;39;M
58897;1,173,776,1482,36,124,702,16,1633,1468,2,1314,1441,13,1434;32;M
58913;1624,1332,1295,268,1468;55;M
58945;1468,1608,1510,1119,1322,268,550,733,444;32;M
58981;1517,1,1581,1524,1700,702,828,16,265;27;M
59013;13,1314,16,550,1328,1347,1532,1482,776,443,211,982,947,1604,1624;68;F
59084;1434,140,1517,1322,1325,863,1624,741,124,1700,702,1468,865,192,1510;34;F
59138;17,1604,1624,1338,443,834,1359,1559,3,1434,1451,1384;33;M
59170;1482,702,1026,1359,174,16,1633,192,265,1559,1314,13,1434,1510,140;43;F
59188;1633,834,124,1328,16,1468,1559,1451,17,1119,451,1325,1581,1700,1434;50;F
59199;16,265,702,1026,1021,917,1510;33;M
59203;1,451,774,1604,1624,1110,23,982,1332,268,24,16,1468,22,1510;35;F
59212;17,1604,1624,268,16,1468,192,1559,140,1330,1338,1322,1325,1332,1328;57;M
59295;1624,774,1110,173,1344,443,1700,1347,174,1468,1441,13,1451,1434,1510;48;F
59318;741,826,1517,1624,451,1,982,443,1328,1633,1468,192,376,1314,984;36;F
59402;1624,774,1119,23,173,556,1332,867,1700,828,174,192,2,1314,1510;6;M
59442;1581,451,1322,1325,1,982,173,1344,443,13,1524,1468,192,1314,1434;61;M
59455;1581,776,1482,16,1470,1434,774,1119,451,512,1524,1700,1026,1468,408;41;M
59519;995,1332,1700,828,16,1314,1441,1434,1347,1509,1482,443,1338,1624,947;25;M
59530;1509,1482,1532,1328,24,16,1633,1468,265,1559,1314,13,1510,1384,408;20;M
59557;1434,24,373,1347,124,443,1110,741,1322,451,774,947,584,1604,1624;27;F
59558;1624,1021,1322,129,1533,1581,1524,1532,1347,702,1328,1468,265;49;M
59599;140,1608,982,1338,265,1434,16,443,1328,1330,776,917,1604,451,1021;32;M
59640;1325,1,1581,1434,1624,1526,16,1344,140,1517,1338,408,443,702,376;33;M
59649;1526,1706,129,982,173,443,988,1482,1532,1700,174,16,192,1559,1434;76;M
59683;947,1325,1,1581,124,1359,1468,1338,129,896,1328,192,265,1434,140;36;M
59687;1468,1434,1517,741,129,982,211,124,1700,702,1698,24,16,394,13;43;F
59714;1338,1526,223,774,947,17,1604,297,1624,917,1325,129,1698,828,1441;36;F
59776;1468,376,1559,444,984,13,1451,1509,776,1524,443,1526,1021,982,1434;46;F
59811;1021,774,297,1624,17,1338,1322,741,1325,129,124,1698,828,2,1441;39;M
59813;1338,1517,1624,1524,1509,1388,268,828,1470,1604,1532,1700,1698,1559,1510;29;F
59823;192,1314,1470,1624,741,124,268,24,16,376,1559,984,444,13,140;35;M
59832;1509,1700,1468,265,1526,982,211,995,550,1559,1441,554,1434,13,140;67;F
59844;192,947,1119,1416,982,1533,1332,1524,1700,1698,1559,2,1441,554,984;40;F
59861;1021,1322,1706,1,1581,443,1524,776,1026,174,1468,192,1314,1434,140;63;M
59868;1604,1517,129,1509,1532,702,1026,1328,24,1633,1468,192,265,1559,1434;40;F
59870;268,1698,733,1322,1338,1119,917,17,22,376,1441,3,1451,776,702;25;F
59874;443,1509,1347,1328,24,16,1434,1624,774,1325,776,1633,1468,13,140;38;M
59883;1322,1325,1581,512,1524,1359,1470,1510,140,1533,16,1328,1021,1434,265;38;M
59994;376,22,24,373,1332,995,982,129,1261,1119,1517,140,1338,741,124;39;M
60010;451,16,774,1517,1604,1624,1468,376,13,702,174,265,394,1434,140;44;F
60016;584,1,1581,556,1332,834,124,373,1698,1468,1608,22,376,1441,984;42;F
60028;1261,223,211,1328,1338,584,443,556,867,373,1698,733,865,394;56;F
60055;297,1119,129,1110,1581,174;39;M
60094;984,1322,896,865,409,982,211,995,556,1332,863,988,22,444,1434;54;F
60129;124,265,1532,297,1517,1021,1,1533,1524,776,1482,1026,702,1359,1434;31;M
60155;1026,1468,192,1314,1604,1517,826,1,129,1524,36,702,16;39;M
60224;17,1338,512,867,834,36,1532,1700,733,16,22,1608,1698,1434,1384;23;M
60263;774,1261,1322,1325,1533,1347,1359,2,1314,1441,13,1451,1434,1312,1510;45;F
60274;192;47;F
60292;1532,1604,1482,1347,1633,1624,774,741,776,16,1509,124,24,1468,13;54;M
60299;173,834,124,268,174;58;M
60336;1021,382,1,1533,1524,1295,1509,1698,1470,13,1434;52;F
60339;774,1526;56;F
60355;776,896,834,1388,1700,1347,1359,828,16,865,265,1559,1441,13,1451;63;F
60370;1698,702,1700,1344,1581,1325,451,1119,17,947,223,826,776,1633,1559;39;F
60393;556,1524,1509,1532,1388,1700,1359,1468,22,265,1559,3,1451,1434,1384;54;F
60407;268,1698;38;F
60428;192;8;F
60438;1347,1482,17,1624,1338,1322,1581,776,124,16,1468,13,1510;22;F
60444;1510,1325,741,1119,1700,268,16,917,982,173,556,1388,1698,174,1434;40;F
60462;382,826,1021,451,1119,1624,1517,512,1524,1700,702,174,1633,13,408;54;M
60470;776,1021,129,1533,1524,1509,1532,1026,1434,1261;45;F
60472;1604,1517,1624,1347,702,1026,1468,1524,1509,1532,1633,1384,1110,1021,917;25;M
60476;192;6;M
60478;1624,826,1581,1295,1388,373,376,1314,1441,1312;62;M
60482;1468,1434,1510,1325,1526,1624,1604,1338,1322,741,1581,1482,1698,13,3;36;F
60511;1021,1526,1322,1110,982,556,1332,1509,1532,1026,16,1468,265,13,1434;45;M
60514;129,211,173,776,1482,1388,1700,373,1698,174,16,1468,376,444,13;45;F
60521;1482,1325,774,1624,982,268,16,1633,1468,13,1510;77;F
60533;1021,1119,947,1261,1533,1700,865;45;F
60551;373,223,211,124,22,995,988,947,860,741,1451,1487,1700,982,1332;41;F
60611;1434,867,860,409,982,211,995,1332,863,896,988,865,444,22,984;86;F
60626;1624,568,223,826,1295,1700,1314,1441,444,1312,917,1581,1388,373,376;47;M
60640;173,1581,556,1524,1700,1328,1468,394,1314,140,1388,1698,174,444,1434;44;F
60709;1604,451,1526,1581,1524,776,1509,1532,702,1026,1328,16,1468,265,13;36;F
60737;451,568,1119,17,1624,173,1533,1509,702,174,376,1559,1434,1384,140;46;M
60804;1624,774,1482,1325,982,16,1633,1468,3,13,1510;75;M
60858;1312,140,1468,865,1608,192;34;F
60883;995,1624,982,1322,223,1608,1325,1482,1700,1633,444,826,408,382,512;37;F
60930;1338,451;49;M
60957;1468,1482,1581,173,409,1,1338,451,223,774,917,1517,17,1604,1624;41;F
60962;23,211,995,867,896,733,1487,373,22,394,2,1314,984,140,1441;35;F
60976;917,1330,1581,174,382,192,1470,1434,408,173,443,451,1119,1706,512;35;M
60985;1624,16,1468,376,394,13,1451,140;43;F
61080;1359,13,174,173,1624,1330,1526,1347,1328,1468,265,984;32;M
61090;211,995,443,1482,13,982,1332,896,988,1509,22,1314,444,984,1451;42;F
61095;173,1581,556,1332,776,36,1700,828,174,16,1468,22,1314,13,1451;45;F
61110;1517,1,129,982,1332,3;35;M
61122;826,382,512,776,1700,373,1698,16,865,22,1441,1470,13,1434,408;39;F
61124;13,140,443,1581,1110,741,917,1604,1624,776,1468,22,17,16,982;31;F
61128;1624,17,702,376,1451,3;52;M
61152;1325,451,1624,1604,1526,443,1509,1532,1328,16,1468,1559,13,1451,1434;37;F
61155;826,1338,1517,1698,1332,373;31;F
61156;1261,1322,1524,834,1482,1532,1700,702,1026,1359,268,1559,1434,1312,1510;43;M
61186;16,1526,1700,1633,1624,1482,1468,1110,451,1347,982,443,1344,776,1314;44;F
61189;1517,1526,1581,1524,834,1509,1532,124,1700,1026,1328,174,1468,1559,13;29;M
61199;1330,834,1328,1359,174,16,1468,22,376,265,1559,3,1451,1434,1510;41;F
61207;443,776,988,1482,702,865,192,1314,13,982,1332,863,1700,22,984;39;F
61238;223,451,1322,1533,1524,1700,1328,1359,1633,1468,265,1559,1434,1510,140;37;F
61249;451,1328,265,1021,173,1524,1700,702,1026,174,1510,16,13,1,1119;33;M
61266;443,124,917,1322,1581,1434,1698,1482,373,16,2,1441,3,13,140;34;F
61289;1021,1261,1532,1026,1328,265,1434,1384,1359,1559,1451,268,1524,776,1509;31;F
61292;1533,173,1,1325,1322,1021,1119,1517,1604,1624,1328,1510,3,265,451;37;F
61295;451,1624,774,1021,1526,1110,173,1026,268,265,443,1532,1328;69;F
61312;1706,382,1261,1604,297,1119,1338,826,1325,982,173,1581,834,1700,865;52;F
61338;1624,1322,1325,1388,16,1468,265,13;55;F
61349;1482,1347,702,373,24,16,1633,1468,22,3,13,1451,1434,1510,140;62;F
61357;1604,1624,36,1700,702,1328,373,22,1441,984,13,17,1,211,982;48;F
61366;124,702,1026,268,1441,984,1434,382,1581,512,1524,1470,444,408;45;M
61396;140,1,16,1332,17,1344,174,1633,394,1434,1119,1700,409,982,1510;48;F
61397;1604,774,451,826,1110,173,1581,1344,1347,24,16,1633,1468,265,13;57;M
61414;1624,1604,17,947,1706,174,2,1441,13;55;F
61442;1,17,376;24;F
61472;741,124,1347,24,3,1451,586;56;M
61478;568,409,867,982,211,995,1332,863,896,988,860,865,22,444,984;48;F
61486;984,1468,1633,1451,16,1347,443,1581,211,982,1110,1325,1322,1604,1624;59;M
61514;1510,13,3,1468,16,174,268,1698,1347,1482,776,1325,1517,1624,1604;23;F
61525;1524,1509,1532,1328,373,1698,1468,376,265,1559,1441,13,1451,1510,586;36;F
61533;568,1119,451,1524,1532,1328,373,174,1468,265,1559,1441,1451,1384,140;43;M
61548;1533,1332,1524,1482,1532,1700,1026,376,1559,1441,984,13,1434,1510,140;29;F
61564;702,1026,174,13,1451,1510,140,1517,917,1526,1416,23,1581,1524,1434;41;M
61657;1633,268,1328,1026,702,1482,1524,982,1021;36;M
61716;443,1344,173,1325,1322,1119,1604,1624,741,776,1482,268,1468,1510,140;37;M
61721;1021,1526,1328,265,192;11;F
61734;1482,776,443,1706,268,174;46;F
61742;1314,1526,1700,1633,1624,1482,1468,1110,451,1347,982,443,1344,776,16;38;F
61759;17,774,373,376,1441;66;F
61843;776,13,1,1347,702,1026,16,1633,1510,1706,1325,173,443;33;M
61846;1388,1700,1347,702,373,2,17,917,1581,1698,1441,444,3,1451,1434;19;F
61860;223,451,917,947,17,1604,1624,1482,1700,1633,376,394,2,1441,1314;64;F
61865;1624,17,774,1338,23,982,211,173,443,174,16,1468,1559,1441,984;60;F
61867;1624,17,826,1110,173,443,1700,1698,174,24,16,1468,376,774,451;21;F
61874;192;43;F
61895;1344,776,1441,373,1314,1604,774,1110,192,13,1487,1,702,1517,16;41;M
61907;192;10;F
61939;1706,1604,1624,1517,1338,1322,741,1482,124,702,24,1468,1441,1451,1434;34;M
61955;173,1110,1021,1517,1624,1338,1322,1325,1,129,23,1581,443,1388,1700;39;M
61976;584,741,129,982,443,556,124,1700,733,24,192,984;44;F
61979;995,917,1322,1325,409,129,982,443,1332,1295,867,896,988,1700,373;38;F
61983;174,733,268,1698,443,1325,1706,774,1624,223,129,1388,373,16,1451;38;F
61985;1328,174,984,1624,17,917,774,451,443,1633,1468,13,982,988,140;45;F
61999;1581,1295,896,1482,174,865,192,1314,1312,13;46;F
62004;1624,947,1119,223,409,1110,982,1344,443,1700,373,1698,16;36;F
62013;451,1322,776,373,1021,1526,1325,1524,1509,1532,702,1026,16,1559;46;F
62022;124,1700,1332,1344,982,1,223,1517,702,865,1468,24,554,13,1434;41;F
62024;1509,1482,1532,124,268,24,16,1633,1468,1451,1510,140,1322,834,1434;38;M
62028;1347,13,1509,1581,173,451,1624,917,1526,1434,140,1322,1325,1344,1468;37;M
62029;1322,741,1325,982,211,896,988,124,1700,373,16,1468,376,13,1510;47;F
62032;584,1344,443,556,1487,373,1698,376,394,1314,1441,1470,1451,1434,733;32;F
62035;1624,1698,24,376,2,13,1434,1604,17,1322,741,1700,394,1441,373;29;F
62039;1624,451,17,1322,1,129,1581,1332,733,16,1468,865,13,1434,586;44;F
62045;917,1325,1110,173,1581,443,776,1482,1532,1700,268,174,192,1470,1434;23;M
62066;1624,17,741,129,982,443,124,373,13;43;F
62085;1325,1322,917,1581,556,550,733;48;M
62086;867,776,988,1482,1532,1347,373,16,1468,22,376,984,13,1451,1434;33;F
62089;1322,1517,1,1581,1344,443,1482,702,16,1633,586;38;F
62095;1325,129,268,22,3;49;F
62111;1581,1434,826,382,982,512,408;53;F
62116;265,1441,1698,1700,774,1451,13,554,2,394,550,1328,1347,173,1330;44;F
62118;1434,586;35;F
62123;223,1322,776,1482,1700,373,1698,733,1608,394,1441,3,1451,1434,1510;38;F
62124;1119,451,1021,1322,129,1344,1524,776,1328,1468,265,1559,1470,13,1434;35;F
62134;917,451,1698,265,1470;32;F
62140;17,947,1119,568,223,1338,1581,1700,373,1698,828,376,394,554,1510;45;F
62150;995,1581,1332,550,174,16,1468,192,1559,1441,1470,444,1434,1510,733;36;M
62157;13,1451,1517,1021,741,1,173,1524,1388,124,702,1026,268,174,3;25;M
62159;774,568,1,995,733,13,1434,1608,865,1468,129,1322,223,1119,584;7;M
62167;1624,1021,1322,211,995,1332,776,1509,1482,1347,1328,16,1468,265,13;49;F
62178;1021,409,834,124,1026,1517,947,1119,1,129,1524,702,24,376,1441;38;F
62187;1359,1533,512,1524,776,834,1347,702,1026,174,1468,1314,3,13,1434;26;M
62192;443,1581,173,1325,1322,917,1517,1604,1624,741,124,1347,702,24,1451;40;M
62221;1510,129,1581,1388,3,1624,451,1482,13,16,1468,1517,1026,702,834;28;M
62222;917,774,1322,776,834,1482,376,1295,373,1698,733,13,1434,1312,1510;47;F
62223;268,1633,3,1510;34;M
62231;1416,443,776,1482,1532,1441,13,1510,947,223,1338,1325,1388,1700,1698;64;F
62233;223,1322,1325,443,1332,22,1434;46;F
62258;1624,1119,1110,1581,512,443,174,1633,1468,192,1470,13,1434,1510,140;48;M
62259;1517,1021,1,1524,36,702,1026,268,16,1633,1468,3,1434,140;39;M
62270;702,1026,1359,828,16,265,1559,1314,3,13,1451,1434,1510,1384,140;50;F
62284;1526,1706,129,173,1581,1524,1295,140,1312,1532,174,16,1468,1608,1434;42;F
62289;741,982,443,776,984,1698,733,24,16,1468,376,394,2,13,1451;34;F
62294;1322,129,1581,36,124,1487,1700,702,373,1698,268,860,865,2,1510;44;F
62309;16,1633,1468,865,1608,192,1510,1624,443,776,1482,1487,376,1441,1451;44;F
62317;1526,1322,1110,1581,443,1509,702,174,24,1633,1468,192,13,1510,140;44;F
62332;947,659,556,1470,1451,1510,834,129,1325,1322,1119,17,36,550,554;60;F
62334;1526,982,1509,265,1559,3,1434;46;F
62338;1524,1344,1338,1624,1517,1526,1322,1325,1,1581,702,174,16,13,1434;25;M
62343;17,1119,223,982,556,1700,373,828,140,408;36;F
62346;1332,659,834,36,124,1347,1026,1328,192,1468,1633,16,174,13,1451;28;M
62363;733,192,2,444,826,982,1344,443,1332,828,1633,1608,22,984,1434;44;F
62374;1624,1706,1325,1,1581,1332,1347,16,1468,265,1314,1441,13,1451,1434;35;F
62388;776,1581,129,1325,1526,1119,774,17,1604,1624,16,1633,1559,1314,13;23;M
62390;1344,1295,1388,268,1312,1559,1441,1332,36,173,23,129,174,376,394;41;F
62394;947,917,1021,173,443,1332,1524,834,1700,702,1026,1698,22,394,1441;26;F
62397;774,223,1322,1581,1344,1698,268,16,1468,394,554,13,1434,1312,1510;42;F
62401;265,1328,702,1524,1533,1322,1526,1021,1338,1581;35;M
62414;1624,947,1325,776,1509,1482,1698,1468,1441,13;34;F
62431;1468,192,1314,3,1510,23,1332,776,376;39;F
62432;1559,1509,1526,1261,1700,1698,1434,1384;48;F
62451;1470,1338,1110,129;37;F
62454;1110,23,1344,443,988,373,1633,444,984,1451,1510;25;F
62469;1322,774,1624,1604,1517,917,23,443,556,776,702,16,1468,1441,13;48;M
62478;774,223,1,982,995,1332,776,192,373,16,376,1314,13,1434,586;42;F
62479;1698,1441,1338,1517,1021,1,211,556,1524,36,702,1026,373,16,13;44;F
62485;1416,1517,774,1021,1322,1325,1509,36,702,1026,1559,1441,13,1451,1434;51;F
62490;1624,451,1482,1359,16,13,1434,586;61;F
62498;1325,776,1482,16,2,1434,1510,140;55;F
62510;584,1322,23,1581,443,1524,124,1700,1026,702,733,2,1441,1434;40;M
62517;16,22,394,1441,13,1624,17,173,443,776,1482,268,174,984,1510;47;F
62534;451,1328,16,1633,1468,1559,13;29;F
62542;1624,17,826,443,556,776,124,1698,24,1633,1468,192,265,1559,13;21;M
62544;1624,917,1322,1325,1581,834,1698,1468,2,1451,1510,140;47;F
62546;947,1119,826,1325,1322,1,173,1581,776,702,16,2,1441,13,1434;28;M
62547;1344,776,373,1698,268,24,16,1633,22,2,1441,1314,3,13,1451;62;F
62556;1328,373,1604,1322,1110,443,1388,1347,16,1468,13,1451,1624,1330,192;51;F
62569;1434,17,1559,1526,1328,1700,702,1517,1261,1021,1026,1698,409,982,1332;39;F
62571;982;36;M
62583;584,1624,17,947,568,223,451,1322,129,173,1581,1482,1700,1441,444;36;F
62589;17,917,826,776,1482,373,16,1633,1468,22,3,13,1451,1434,140;45;F
62597;1517,223,1,1021,1261,1338,124,1700,702,1026,1698,192,1384;37;M
62602;451,1328;30;M
62619;1468,1604,1517,1482,1359,265,1434,1510,947,223,1344,1295,1487,1470,1312;30;F
62621;1312,1517,1325,1533,1332,1295,1482,702,24,22,1451,1434,1510;27;F
62640;1624,982,173,1581,1487,1700,1698,1441,1510;50;F
62643;1604,1624,1119,1325,1110,1581,1344,1347,1698,373,174,16,1468,192,13;41;F
62647;1470,554,444,984,13,3,1451,1434,1312,1510,1384,140,408,268,586;31;M
62671;265,1434,1359,1533,1526,1021,1026,702,1524,1,1517;38;M
62696;1110,1344,443,1524,834,1509,1532,1347,1328,16,1633,1468,1559,1384,13;33;M
62709;1344,1482,1347,268,16,1468,376,1624,1322,1325,443,776,1633,1314,3;50;F
62719;1624,17,1325,129,776,834,2,1314,586;39;F
62721;1119,1624,774,1330,451,1322,173,1344,443,1347,174,265,1470,13,1451;43;F
62757;268,1468,1314,1624,1,1581,443,1482,1026,16,1633,376,2,1510,586;17;F
62763;776,36,1312,1624,947,1322,129,988,1700;44;F
62769;1325,1338,774,917,1624,17,1,1332,556,373,1698,376,394,1441,554;32;F
62793;702,1328,268,174,16,1468,1314,1441,13,1451,1434;27;F
62805;17,409,982,211,995,1332,867,863,896,988,860,865,22,444,984;69;F
62825;1416,173,1581,443,776,1509,1700,373,1698,1359,828,174,2,1441,13;43;F
62832;1384,223,947,1624,774,917,1517,17,1581,1295,1468,13,1451,1434,140;29;M
62838;1322,17,1624,917,988,1482,1487,1700,373,22,1559,1451,1434,1510,140;64;F
62857;917,451,1338,1322,741,1325,1110,982,556,1328,24,13,1330,265,1434;32;F
62873;1624,1604,774,451,1110,23,1533,1328,16,1468,265,1434;38;F
62879;1332,988,982;57;M
62880;394,554,1510,586;45;F
62900;1526,173,1509,1532,1700,1441,1559,1359;25;F
62919;1322,982,211,995,1581,556,776,1328,1359,16,22,265,984,13,1434;40;F
62922;140,1347,1700,1706,512,1624,1604,826,1322,1325,1581,1482,16,1468,865;43;M
62926;1388,373,1633,192,376,2,1314,1441,984,3,13,1451,1434,1312,1510;52;F
62959;129,268,1451;47;F
62987;1624,129,550,24,1434,865,124,223;43;F
63019;1700,1332,982,774,443,22,984;41;M
63027;1581,1441,1434,1698,1700,1509,1416,1526,1261;37;F
63032;1261,1416,1581,1700,1359,1441,1434;37;M
63036;1314,3,13,1624,774,1325,1110,443,776,1532,1388,1633,174,16,1468;30;F
63039;129,1434,556,1698,1470,554;30;F
63077;1633,1624,1604,826,1322,1706,1325,1581,512,1482,1700,1347,1468,865,140;43;F
63114;834,1338,1,1524,1700,702,1026,1698,1359,265;36;M
63126;1604,1624,826,1322,1706,1325,1581,512,1482,1700,1347,16,1468,865,140;8;M
63148;1581,1470,988,984;55;F
63162;1624,1604,826,1322,1706,1325,1581,512,1482,1700,1347,16,1468,865,140;11;F
63179;2,1,1325,774,917,1517,1338,1322,129,1344,556,1482,124,22,192;38;M
63182;860,22,988,865,1332,982;55;F
63184;268,3,1434,1330,140,1510,1468,16,1509,826,741,1526,774,1624,443;39;M
63195;211,982,1110,451,17,865,988,1700,373,1633,1468,22,2,984,444;49;F
63201;1119,129,834,550,1468,554,1451,1510,140,1328,265,1470;40;F
63213;584,733;43;F
63220;512,1700,16,1322,1533,1524,124,1026,702,24,1434;24;M
63287;1532,988,834,1524,129,409,1021,223,1119,947,584,1517,17,1526,1261;67;F
63296;1698,16,1468,376,444,984,1451,140,1624,1338,982,124,373,13,586;14;F
63323;394,265,1470,554;39;F
63378;1624,1517,741,1,443,124,1700,702,16,984,1434,586;40;M
63383;568,223,1330,776,988,174,1468,1608,265,1434,451,1322,1325,129,140;32;F
63390;1468,394,1441,444,1604,17,947,1325,1700,1451,1388,1698;33;F
63484;1384,1328,512,1322,1517,1338,1021,129,1581,1468,1026,702,36,834,1261;12;M
63507;1624,1119,1322,741,173,443,776,124,1608,1441,1451,444,984,586;11;M
63536;1624,373,192,140,1,443,1482,1347,828,3,1510;36;F
63551;1526,223,774,1604,1624,1021,1524,1509,1482,1026,1328,1359,16,265,1559;39;F
63561;1624,1526,1322,1416,1533,1524,1509,1532,1026,373,16,376,1559,13,1434;36;F
63564;1295,124,702,373,24,16,1468,1608,394,2,1441,984,3,13,1451;54;F
63573;17,1624,1517,1706,1325,1,1524,1388,1633,192,1314,3,13,1510,1434;30;M
63578;1347,1026,373,1698,16,1633,265,394,1559,1441,13,17,268,1510,1344;37;F
63584;1110,982,16,1633,3,1624,17,451,1325,173,443,1524,776,1482,1468;28;F
63585;223,1338,1322,863,1487,16,1633,1468,865,376,394,554;34;F
63595;741,1624,1581,1344,1524,1532,1347,1026,1328,16,1468,1434,1510,1384,865;20;M
63597;1624,774,1110,443,776,1509,124,1328,268,174,1468,1633,1559,13,1451;34;F
63617;741,1,982,124,702,24,16,1468,22,984,13,1434,1510,140,586;54;F
63632;443,1347,1328,268,174,16,1633,1468,265,1314,554,3,13,1434,140;50;M
63636;1624,774,1322,443,24,16,1633,1468,2,13,1451,1434,140;33;F
63659;124,702,16,2,1021,1526,1332,1524,1532,1328,1359,265,1559,1434,1384;41;F
63662;584,1338,1706,741,1325,443,124,16,24,1468,192,1559,3,13,1434;23;M
63671;1325,1533,1524,1532,1559;36;M
63714;17,947,774,776,373,1698,828,174,16,1468,192,394,1441;40;F
63716;1322,1700,550,2,1470,265;36;F
63719;1604,1344,443,982,1,774,550,733,22,376,265,1441,984,13,1451;50;M
63720;776,1532,1347,1119,917,1517,17,1624,16,1314,13,1451,1434,1510;21;M
63727;1700,1698,268,1633,586;40;F
63744;1451,13,394,376,192,1468,16,1698,373,382,917,947,17,1581,1700;39;F
63747;1322,1344,1359,13,1624,24,16,1517,1347,702,1468,297,1533,265,1434;43;M
63752;443,1344,1581,1325,1706,1322,1338,774,297,373,1698,828,1608,1441,1312;47;F
63753;1347,1624,1517,1021,1322,1325,443,1524,702,1026,24,16,1468,376,140;41;F
63791;1482,1633,1510;49;F
63793;982,867,1487,373,174,865;55;F
63805;1338,2,1451,1322,1,129,211,896,124,373,733,22,984,13,1434;37;M
63808;1624,17,774,982,443,1295,1482,1347,1698,1468,376,2,13;50;F
63811;1119,1325,1,173,1332,1524,867,863,702,733,174,394,984,3,1510;45;F
63821;1532,1487,1698,1359,1608,1559,1434,1510;36;F
63825;896,556,1344,1110,1325,1338,1119,1604,1624,774,1322,741,443,124,1451;35;F
63832;140,982,1261,568,1532,13,1533,1700,1698,1468,1434,223,1526,1524,1559;34;F
63835;16,3,13,1533,1604,1624,1526,1416,1532,1559;37;F
63856;192;39;F
63873;1624,741,702,1517,1322,1110;30;M
63883;917,1021,1526,1338,1533,1524,1532,1559;39;M
63888;1021,1119,1624,1524,776,16,13,1434;34;F
63897;1328,16,865,1698,828,268,1510,408,947,917,451,1487,1700,1559;64;F
63915;1517,1021,1,1581,1532,1347,1434,1110,173,1524,702,1026,174,13,1510;29;M
63921;1509,1482,1487,1624,394,1559,13,1434,140,443,1,774,1526,982,211;65;F
63930;1581,16,1608,192,13;66;F
63931;1526,1322,451,1604,1524,1482,1700,1328,1359,174,265,1559,2,1434,140;33;F
63941;1347,373,268,174,16,376,394,1559,2,1314,1441,13,1451,1434,1510;47;F
64017;17,1322,741,1325,211,173,124,24,16,376,2,1314,1441,984,3;33;M
64033;1624,774,451,1338,173,1468,16,1608,265,1559,1314,13,1451,1312,140;47;F
64051;1482,1517,223,741,982,24,16,1332,1347,702,192,376,2,984,13;39;F
64072;17,947,223,1416,1295,373,1698,1510,1441,1559;34;F
64075;376,1,741,947,1624,774,1110,982,443,16,1468,984,3,13,1510;38;F
64086;22,192,1559,1314,1470,554,140,1604,16,297,173,1119,174,3,1510;30;F
64087;1624,1517,451,1021,1325,1416,1,1524,1700,702,1026,1328,865,394,265;36;M
64091;1021,702,1026,1517,741,1344,1524,124,1347,24,16,1468,1314,13,1434;36;M
64115;1021,382,1325,1533,1581,1524,1509,1532,1700,702,1026,1559,13,1510,1384;38;F
64119;1338,1322,173,1581,443,1700,702,373,1698,268,2,1441,1470,140,408;47;F
64120;1624,1110,23,1451,268,1328,1330,774,741,443,1359,174,16,265,13;75;F
64144;265,1559,1314,140,1624,1517,1021,1325,982,1524,988,702,1026,16,1434;49;M
64156;1624,223,451,1330,129,1328,1359,265,1441,1434;46;F
64164;1325,776,1468,1608,1451,1510,1384,140,947,741,1581,834,1482,124,1441;21;M
64178;1110,1388,268,174,3,1451;31;M
64224;17,451,129,1581,896,1388,1328,373,1698,865,265,1441,554,3,1434;36;F
64238;1330,1482,1470,1451;60;F
64256;265,451,1021,1328,174,1559,1434,1384;29;M
64296;1322,1325,1581,443,1295,1532,1347,1698,16,1468,376,1559,13,1434,140;40;F
64308;1517,1581,702;39;M
64313;382,776,1441,1434,1581,834,124,24,192,1470,917,129,1698,376,1510;35;F
64339;1526,1533,1524,1509,1532,1026,1559,1384;39;M
64340;1451,140,947,451,1344,443,1524,1509,1482,1026,1328,373,1698,865,265;31;F
64366;1312,1434,13,988,776,1325,1119,1624,826,1322,1344,443,1482,174,140;40;F
64382;1119,1581,1344,776,834,1509,1482,1700,1347,702,16,1633,1468,192,394;35;M
64387;1434,1384,140,1509,702,16,265,1559,586,1021,1526,1524,1532,1328,1026;72;M
64396;988,896,1482,16,1532,1388,1700,1698,268,1468,192,1559,1441,13,1434;35;F
64414;129,409,1332,1295,896,863,1700,1698,22,394,554,1312,223,13,211;33;F
64416;409,1322,1526,774,1325,1110,443,867,988,1509,1468,376,984,3,13;49;F
64418;1344,265,1509,774,451,1526,409,982,443,1532,1359,1559,554,3,1434;28;F
64465;1624,826,1581,1295,1388,373,376,1314,1441,1312;66;F
64467;140,1633,1624,1517,451,826,1,174,1470,13;37;F
64468;1633,865,984,3,13,1312,1510,896,1344,1322,223,774,1624,982,1468;37;F
64475;36,24,1633,865,192,376,1700,1332,443,1110,23,1,741,1706,1119;42;M
64477;988,409,1,1021,451,1119,584,1328,1359,733,865,1608,860,265,408;41;F
64486;409,1487,860,1608,192,394,1312,1384,584,867,896,988,550,733,554;48;M
64493;1344,1581,1526,1330,568,774,451,1322,443,1347,1359,16,394,1434,13;40;M
64514;1468,192,984,140,17,1322,129,982,834,1700,268,1608,376,1314;37;M
64527;17,1261,556,1295,1700,1359,828,865,265,1441,984,13,1312,1510,586;76;F
64563;1,1388,1698,268,16,1633,1510,1604,17,129,1344,776,1482,376,3;39;F
64599;1604,1624,917,1344,443,1524,834,1509,1532,373,1698,16,1468,1441,13;44;M
64608;1517,917,741,1,443,702,13;35;M
64640;16,13,3,1388,1700;35;M
64644;1119,1434,140,1624,1517,1322,1,129,776,1482,124,702,16,13,1312;40;F
64653;268,1468,265,297,1517,917,1,1533,1581,1524,1532,702,1026,1359,586;30;M
64655;1344,443,1,741,1119,1624,1604,774,776,1328,268,16,1468,2,13;56;F
64661;1468,1608,124,1532,774,1509,1604,1706,1325,1110,1344,443,1347,1633,1559;35;M
64692;1624,774,1526,1482,16,1633,1468,192,376;39;F
64695;917,1468,1482,1434,376,1119,192,1325,451,1314,13;39;M
64699;1312;40;F
64720;917,1517,1526,129,982,1533,1344,1524,1509,1532,702,1026,1359,1559,1434;46;F
64726;1338,1322,1110,1344,1624,1325,268,16,1633,1468,13,1451,1434,1510,140;33;F
64731;1624,1509,1532,1700,1359,1633,376,1559,1314,1451,1434,1510,140;43;F
64734;702,373,776,443,1,741,1322,1338,1517,1624,13,1510,140,1468,1451;54;F
64745;17,1604,1624,1524,776,702,1026,1328,1698,1633,1468,376,265,1441,13;48;F
64752;741,1110,24,16,382,917,1604,443,1344,867,988,124,268,265,586;55;M
64758;1510,140,3,1,1581,1359,1468,265,1434,1517,1021,512,1700,702,1026;44;M
64784;1532,24,174,1482,776,1110,1624,774,173,443;32;F
64800;1119,223,1524,1482,36,124,1700,1347,702,1026,1328,1698,16,1608,376;38;M
64827;1698,1021,1322,1325,1416,1,1533,1524,1532,1700,1026,1434;35;F
64828;17,1482,36,268,16,1633,1468,2,1441,3,13,1451,1434,1510,140;47;M
64861;1624,1517,1526,1261,1322,1581,776,16,1468,2,13,1434,140;44;F
64884;774,1328,1487,1608,1322,1416,1295,1698,1359,1312;55;F
64887;17,917,556,776,896,1698,268,174,1468;25;F
64906;1416,129,1581,1700,1026,268,733,376,394,17,1261,1359,984,1510,1434;48;F
64911;828,376,3;41;F
64917;1581,917,1624,1706,1344,1332,776,1482,373,1633,192,376,1314,140,13;42;F
64923;1,826,451,584,1624,1322,373,444,1510,211,982,13,17,776,16;33;M
64934;1517,1322,741,1344,124,702,24,16,1434,140,586;45;M
64961;140,1325,1,1517,947,982,995,443,867,1700,702,860,192;47;F
64977;2,1434,1624,774,1338,1322,1706,443,556,1482,373,1468,192,13,140;55;F
65014;17,1322,1325,834,1608,22,376,3;34;M
65022;297,1624,17,451,1322,741,1325,23,1110,173,1482,124,268,1510,16;36;F
65032;129,1700,1581,1416,1261;39;M
65053;1441,984,512,408,382;48;M
65070;947,451,1526,1261,129,1533,896,1482,1532,1700,1359,268,733,1559,444;25;F
65071;394,16,702,124,1482,776,443,1110,774,1604,1624,13,1526,741,1344;43;M
65074;1434,1451,1468,16,1388,1581,1325,451,1624;35;F
65079;1533;50;F
65104;16,1328,1700,1338,1119,192,265,1314;44;F
65110;173,1344,1347,13,1624,1604,774,1,443,1706,16,1633,1468,192,1314;34;M
65122;512,382,408;36;M
65168;1314,16,24,1700,124,1482,834,776,982,1338,1119,702,192,1510,268;37;F
65197;1322,1338,947,1119,917,17,223,741,982,124,828,865,1608,394,140;40;F
65207;192,982,409,174,1510,23,1,1332,124,1700,22,984;41;M
65233;124,1700,702,373,1698,268,16,1468,22,376,394,2,1441,13,1510;45;F
65253;1338,173,444,1510,1384,408,1330;43;M
65269;129,173,1533,1581,1295,896,834,1509,1359,451,1526,1338,1,982,1698;42;F
65288;129,1533,1581,1295,1532,1700,373,550,733,16,192,984,1434,1312,1510;62;F
65308;1624,223,826,512,1344,1700,1347,24,1633,192,1510,408;38;F
65330;451,1322,129,1581,1470;34;F
65349;1604,13,1510,1624,1338,1322,1325,129,1581,702,16,1468,192,2,1314;39;M
65353;1021,1517,1624,1700,982,1524,702,1026,16,1633,1468,265,1441,13,140;46;F
65363;774,1624,1330,451,443,776,1532,1347,1328,16,1468,376,265,1559,13;31;F
65367;1624,1524,659,1509,1532,1347,373,733,16,1468,192,1559,1314,1441,13;37;M
65371;774,1021,1,1524,1295,702,1026,1359,828,1468,265;63;F
65392;1322,826,451,947,17,1441,1470;36;F
65422;1330,1624,774,741,443,1509,1482,1347,16,1633,1468,1559,3,13,1451;30;F
65424;1026,702,1509,1524,1533,1,1526,1021,917,1517,1604,265,1559,1451,140;40;F
65462;556,1700,1328,1698,550,1608,265,1441,554,984,13,408,586;35;F
65478;1624,1314,192;59;F
65501;443,776,1482,1328,268,16,1468,3,1451,1434,140;45;F
65516;376,1110,995,988,140,776,443,211,1338,947,17,556,3,13,1451;49;F
65526;1526,1532,1700,1328,1698,1359,1468,265,1384,1559;37;F
65549;444,1434,1510,1470,268,1359,1328,1581,17,1517,1119,1526,1338,1,173;35;F
65560;1624,774,1338,1325,1581,443,2;52;M
65567;1624,774,223,1,512,1344,443,1295,776,896,988,1482,373,268,1451;42;F
65575;584,1700,1468,1314,1384,550,733,16;39;M
65611;17,451,1388,1700,1328,174,1468,192,376,265,1314,3,1451;29;F
65631;1021,451,826,129,556,1328,373,1698,828,16,1633,1468,265,13,1434;50;M
65636;1517,1624,1322,1325,443,16,1468,22,376,13,1434,140;46;M
65642;1322,1706,1325,1581,443,1524,1482,1700,702,1698,174,1468,394,1441,1434;39;F
65648;36,1468,376,2,984,17,774,451,1526,173,443,1532,174,1559,1434;59;F
65658;1533,776,1347,702,1026,1633,265,1559,1604,17,1517,1021,1581,834,16;27;M
65681;1347,1482,776,1526,13;30;F
65706;1110,741,1119,774,1604,1624,1322,1581,988,24,16,1468,192,376,1434;31;F
65737;776,1487,394,2,1441,1434,1312;40;F
65766;1517,297,1624,1322,382,776,1532,702,16,1633,1468,192,1314,1470,13;36;M
65796;1581,1325,1559,1314,13,1434,1633,16,173,826,1517,1330,451,129,702;34;M
65798;1624,774,451,13,1510,140,1332,1347,24,16,1468,22,376;39;F
65825;834;38;M
65833;451,917,774,860,865,1608,265,1559,13,1526,129,1509,1532,1347,1026;41;F
65903;568,1110,1332,1468,1434,297,1119,1322,982,173,1581,174,16,22,140;37;M
65908;1482,36,1532,1026,702,1328,373,268,24,16,1468,22,376,1559,1451;41;M
65916;1517,1624,1604,1526,1509,1532,1700,1328,1359,733,1559,444,13,1510,1384;39;F
65939;1700,828,774,1338,1322,1706,982,1332,988,16,192,376,2,1441,984;47;F
65944;1388,586,443,268,702,776,1509,733,1470,1021,1,1328,1026,774,1451;35;M
65953;382,512,408;37;F
65973;1559,1524,1533,1021;36;F
65986;451,17,1604,1624,1328,268,733,174,865,1608,376,265,2,1559,1441;51;F
66010;1021,702,1026;46;M
66033;36,774,1517,1604,1119,451,1322,1,129,1581,776,702,268,16,1510;39;M
66045;1624,1604,774,776,1347,16,1468,1314,13;60;F
66048;451,1330,223,1517,17,1604,297,1624,1119,1700,1468,865,1314,1441,444;40;F
66131;1604,1517,1322,741,1325,24,16,1633,376,394,2,1314,1441,1451,1510;49;F
66152;129;34;F
66171;1332,1700,373,1698,828,550,860,22,376,2,1441,554,444,13,1451;53;F
66194;1624,741,776,1388,124,1347,174,24,16,1633,1468,1314,3;50;F
66196;982,1344,1332,1633,140,1624,1517,1,702,24,16,1468,394,2,13;43;F
66253;1468,1470,1608,2,1314,1441,1434,140,1624,834,1359,16,192,1559,13;39;F
66256;1532,1482,1509,776,741,451,1330,774,1604,1624,1110,1344,443,1451,586;36;F
66265;1322,917,297,451,1532,265,3;37;M
66266;917,1526,1325,1533,1524,1509,1532,1347,1026,1468,1559,13,140;32;M
66280;917,1338,129,1581,659,1700,16,865,192,2,1314,1441,1470,1451,1510;34;F
66288;1533,129,1322,568,774,917,443,1332,1295,16,1468,22,376,1559,1312;69;F
66309;826,1261,1119,917,774,1604,1624,451,776,1482,1532,16,1468,192,1314;34;F
66371;1524,834,1532,1026,1359,1470,140;35;M
66395;1624,917,741,1325,702,24,16,1468,376,1434;27;M
66445;982,211,124,1700,373,1698,268,828,865,22,2,1441,3,1434,1510;62;F
66447;741,23,1332,1524,124,24,16,376,2,13;60;F
66450;1517,1021,702,1026,268;51;M
66472;1468,268,702,1388,1332,1344,129,1,1624,443,1698,1314,13,1434,1510;53;F
66507;17,1119,451,23,1332,1295,1509,373,1359,268,376,554,984,1312,1510;22;F
66541;947,774,1706,1700,1347,174,16,1633,865,192,1314,1470,444,13,408;39;M
66548;1624,947,774,409,982,211,867,1347,394,2,1441;55;F
66571;382,1322,223,1119,947,1517,1314,1470,1451,702,373,1698,174,16,192;36;F
66581;1624,1524,988,702,1026,16,140,1510,1451,1559,834,1482,1119,409,129;39;F
66588;192;48;M
66590;1330,394,984;33;F
66593;1517,451,1526,982,443,896,36,1532,1328,16,1434,1700,1533,1559,1026;25;F
66613;373,268,16,865,394,444,140,17,1021,1581,512,702,1698,174,1470;33;F
66623;702,268,174,16,1633,1468,22,376,1559,1314,13,1451,1434,1510,140;18;M
66647;1526,1517,774,1021,982,1332,1524,988,702,1026,265,13,1451,1510,140;49;M
66650;17,1517,1,982,1524,1509,1532,1700,1347,702,24,1633,1468,265,1533;29;F
66669;443,1482,1347,373,268,376,394,3,13,1451,1604,1322,1344,776,1510;31;F
66670;451,1325,129,1532,1359,16,1434,140;27;M
66676;22,1633,16,174,1698,1482,173,1,1322,826,584,17,776,834,373;22;F
66685;443,867,863,1509,1328,1359,550,13,1510,1344,1524,1434,982,1110,1314;50;F
66732;586;63;F
66734;1526,1,1524,1026;22;M
66794;129,1470,1581;63;M
66802;1624,584,1338,741,409,124,733,24,16,1468,22,376,13,1434,140;36;M
66862;443,860,1451,1487,896,409,982,211,995,867,863,988,865,2,984;61;F
66868;1624,774,1344,776,1482,1532,1347,1328,16,1633,1468,265,13,140;48;M
66882;1441,1451,1434,1384,1604,1517,223,1526,1322,1533,1344,1524,1509,13,1468;46;F
66896;917,451,982,1581,776,1482,1532,1359,174,265,1559,984,1434,1510,140;34;F
66899;863,1524,443,982,1110,1,1322,1021,1517,1332,988,896,268,13,1344;44;F
66914;1119,1325,1624,741,140,1482,1344,1,443,268,17,917,776,1110,1510;45;M
66929;550,24,16,865,1434,140,1624,1604,1524,776,1482,702,1026,1468,265;40;M
66945;512,1700,1698;41;F
66957;1332,867,863,896,988,373,865,982;68;F
66976;17,1338,1,556,36,1700,373,1698;31;F
67032;24,16,1633,1468,192,376,265,1470,13,1434,1312,140,586,408,1451;18;F
67084;1468,1434,140,16,984,13,1510,1604,1322,1581,443,1347,1624,1451,982;68;M
67089;1,129,36,1388,1700,702,174,16,1559,2,3,13,1451,1434,586;40;F
67126;1021,1384,1338;31;M
67151;1434,1510,1119,1325,1,129,173,733,174;39;M
67156;444,1559,1344,1347,1,1604,16,776,1482,1509,451,265,982,1332,988;37;F
67175;1359,1314;45;F
67191;1509,1482,1110,741,826,1526,774,1604,1624,1119,451,1328,16,1468,265;33;M
67194;13,1468,16,24,1328,1347,1509,1344,1110,1624,741,443,124,268,1451;49;F
67203;1624,741,1110,1344,443,1509,124,1347,1328,268,24,16,1468,13,1451;66;M
67207;1624,741,1110,1344,443,1509,124,1347,1328,268,24,16,1468,13,1451;81;F
67222;1700,1338,1322,917,1,826,1119,173,36,174,16,1633,1468,1451,1434;46;F
67228;776,394,376,192,1633,1347,1700,867,1624,774,451,1706,129,1344,1332;43;F
67247;23,1,1706,1526,774,124,702,1359,174,1468,192,265,1559,1314,3;33;M
67248;1700,1441,1624,1604,1322,741,1,776,24,16,1633,1468,192,376,394;33;F
67263;173,1524,988,36,1026,702,174,22,1312,1510,917,1581,1487,373,1434;39;F
67264;826,1325,173,1482,1359,1633,1510,982,1581,1332,776,988,22,984,1434;46;F
67269;1526,1624,1604,774,1325,1,776,1026,1328,16,1468,265,1559,1314,13;49;M
67272;17,982,211,988,444,984;58;F
67273;1338,584,1517,1624,995,988,373,174,22,2,1314,1441,984,1451,1434;26;F
67277;1330,382,408,512,702,1517,1384,1526,1328,1524,1434,1026,1021,265;41;M
67278;1517,1021,1110,867,36,702,1026,1328,1359,174,265,2,1441,1434;33;M
67280;1624,16,512;20;M
67288;1330,1338,1322,1325,1332,1328;43;M
67304;1451,1517,1581,1524,702;34;M
67329;1338,1,129,1581,373,1698,16,1633,1468,192,1314;30;F
67334;382,1338,1119,917,1325,129,982,173,1581,512,834,1700,174,192,408;41;M
67361;1517,1330,1021,1526,382,512,1524,702,1026,1328,265,1434,1384,408;39;F
67395;1330,1338,1322,1325,1332,1328;11;M
67408;917,17,1322,1295,1388,124,373,1359,733,16,1468,192,1470,3,1451;23;F
67484;947,917,451,826,1,1487,1698,1633,16,192,394,2,1441,1314,1451;32;F
67488;1330,1338,1322,1325,1332,1328;17;M
67506;1604,917,1325,1,982,443,988,36,1388,373,1359,16,22,3,1451;40;F
67521;586;34;F
67548;1330,1338,1322,1325,1332,1328;47;F
67560;1325,223,1119,1624,1322,1344,443,988,828,16,1468,2,984,13,1434;52;F
67567;774,1330,451,1526,826,1325,1344,443,1509,1532,1347,1633,1468,1559,1510;21;M
67578;550,1332,947,1700,174,733,865,22,394,586,17,1698,268,1312,1510;39;F
67587;1517,917,1119,1,129,1524,988,124,702,174,192,394,444,1434,1510;36;M
67675;1509,1295,129,1338,1021,451,568,1517,1524,17,1119,982,1700,865,22;38;F
67682;1261,774,947,17,1624,741,834,124,733,24,16,1468,1608;46;M
67691;1700,1026,1328,1698,1359,174,16,376,265,1559,2,1441,1434,1510,1384;38;F
67694;584,1517,443,776,1482,702,1698,733,24,16,865,192,376,2,1434;33;F
67743;1322,129,1581,556,867,1509,702,1026,1359,174,16,1468,1314,444,1434;58;F
67746;1624,1604,917,1119,451,1706,1325,1,982,1344,443,776,268,16,1510;39;M
67775;382,1533,776,36,16,192,1559,1314,1470,1312,1510,1517,129,1581,702;45;M
67830;1322,741,1332,1524,702,174,16,1468,1608,1314,1510,1624,1517,982,173;20;M
67834;776,24,16,1468,13,1624,1517,1322,1325,982,1332,702,22,984,1434;51;M
67840;17,834,1330,265,1314,1110,1510,1487,1633,568,1344,24,554,1533,16;33;M
67887;1295,1482,1312,408,376,733,550,268,1332,982,409,1526,584,1510,1330;35;F
67889;22,826,1,556,1482,373,174,1468,1633;74;F
67902;1604,1624,1517,1322,741,1,124,1347,702,24,16,1468,13,140,586;40;F
67907;1119,443,776,1700,1698,1510,1468,1347,982,1,1325;45;M
67928;443,1344,173,1110,741,1526,1021,1119,774,947,1517,1,1700,376,1441;42;F
67948;17,982,988,984;46;F
67950;776,834,1482,1698,268,174,16,1633,1468,1441,13,1119,1325,1581,173;35;F
67966;1021,1526,1322,129,1581,1524,1532;42;F
67980;17;22;M
67991;1359,1295,1581,1338,451,947,1119,1322,1325,173,1700,1698,444,1434,1312;49;F
68012;1325,982,1624,741,1533,776,124,702,24,16,1468,984,13,1434,140;14;M
68051;1451,1434,297,826,1581,1021,1517,947,1338,556,702,1026,1698,828,1470;37;M
68060;1021,129,1533,174,24,382,1581,1524,702,1026,1359,192,1470,1434,1510;52;M
68079;1581,1,297,917;46;M
68081;1624,2,192,1633;30;F
68174;173,1110,1526,1119,774,1604,1624,451,826,1325,1,1633,1468,13,140;45;M
68195;173,1624,1119,24,1633,1434,1468,3,16,140,17,1338,124,741,13;38;F
68210;1332,376,265,568,451,129,1700,1026,192,1559,554,444,13,1434,1510;38;M
68216;1325,129,1482,16,1510,1332,1624,1,982,863,1700,24,860,22,984;13;F
68224;865,1468,16,1295,1,1624,1330,1526,129,982,863,1509,24,13,1312;16;F
68259;1706,1581,1344,1700,1698,1633;29;F
68288;584;32;M
68299;1322,382,1325,982,1332,1700,16,192,22,1314,1470,13,1434,1510,408;38;F
68317;1,129,776,834,36,1026,268,444,3,13,1434,140,1517,1524,702;37;M
68332;1517,1624,1119,174;37;M
68338;1517,774,1021,297,1,1524,36,702,1026,1328,1359,1468,265,13,1434;48;M
68339;741,376,774,896,124,1706,1482,1468,23,2,17,16,13,3,1314;46;F
68364;774,17,1624,1119,129,1344,443,1524,1532,376;36;F
68380;17,1517,1338,1322,741,1581,443,1524,776,124,702,1026,24,140,586;40;M
68389;1332,211,1,451,223,1119,774,17,1322,741,173,1344,124,24,22;35;F
68411;1624,17,947,1119,568,223,1,129,982,995,1581,373,1698,733,1441;32;F
68425;1347,268,376,1451;44;F
68431;17,988,982,586;69;F
68434;1344,13,1509,863,129,702,1026,1526,1330,1624,1,24,16,1468,733;44;M
68440;451,1533,373,16,1633,1314,984,3,13,1451;31;F
68461;988,173,917,1325,23,124,1359,1468,1559,444,1451,1434,1510,140,586;32;M
68560;702,16,1468,192,947,1624,741,982,24,865,984,124,1700,13,586;37;F
68570;1347,1468,1624,17,1325,982,1581,834,36,16,265,1441,1434,140,1698;47;F
68571;1,702,826,1344,13,24,1509,863,129,1526,1330,1624,16,1468,865;51;F
68586;1624,947,774,1119,826,1581,1344,443,1700,1328,1698,1633,192,265;40;F
68636;16,733,124,1532,443,1581,741,917,17,1517,1021,1322,1524,702,1026;37;M
68646;702,860,24,1509,863,129,1526,1330,1624,1,13,1312,16,1468,865;9;M
68709;982,211,995,443,988,1332,1295,1509,16,394,13,22,376,984,1312;55;F
68722;1700,1698;57;F
68728;1517,741,443,776,834,1482,36,1347,702,24,16,1633,1314,13,140;41;M
68752;1261;45;F
68768;1330,1119,917,1517,1624,1482,1328,16,1468,265,1314,13,1451,1434,140;44;F
68785;1347,1021,1526,826,1110,1328,1344,741,443,16,13,1,1517,702,265;37;M
68840;1482,124,1700,1347,702,24,16,1633,1468,192,1314,13,1451,1434,1510;46;F
68842;1330,1338,1322,1325,1332,1328;73;M
68852;1482,702,1434,265,1468,1359,1328,1347,1532,1509,1526,1021,1,1524,1026;43;M
68865;947,394,1510,17,1604,1416,1110,512,268,1559,1314,1441,13,408,2;49;F
68883;1624,1517,129,443,1524,776,373,268,13,1510,140;57;M
68890;1624,297,17,1119,451,1322,982,173,268,22,984,1434,13,1510;69;F
68898;1487,834,776,1325,1624,1517,1322,741,1581,1344,1482,124,24,1434,140;82;F
68916;129,867,863,1482,1700,1698,268,860,1633,865,394,1441,984,1434,1510;44;F
68920;124,702,1026,1328,268,174,16,1633,1468,376,265,984,1434,1510,140;16;F
68924;1624,1517,1338,741,702,13,17,774,1,173,174,16,2,1347,1344;32;M
68942;1325,1416,443,1524,1509,1532,1347,1026,1698,16,13,1451,1434,1510,1384;15;F
68952;265,1026,776,1524,443,1533,1416,1322,1021,1624,1526,1509,1532,1559,1510;68;F
68957;584,1532,1524,1332,443,982,1,1416,1325,1706,1338,1526,1021,17,1314;47;M
68962;1330,451,1325,995,776,1482,1532,16,192,376,1559,1314,1510,409,984;40;F
69051;17,1338,1,409,129,211,867,1295,896,36,22,376,1312,984;38;F
69064;1700;45;F
69069;192;9;M
69080;1633,1526,1624,1604,443,1532,16,1468,22,265,13,1451,1434,1510,24;66;M
69088;1325,1468,16,550,1698,1700,1517,17,409,896,1332,22,988,984,982;73;F
69098;776,1532,1388,1347,1359,268,24,16,1468,265,1559,3,13,1510,140;15;F
69113;1338,1706,982,1344,1332,776,1482,1698,268,828,1633,22,1441;39;F
69124;265,140,1384,702,124,36,1524,741,1338,1526,1604,1434,192,24,917;33;M
69126;451,1510,1517,1,702,268,1468,1328,192,554,1434,1604,129,265,1314;47;F
69127;443,1581,1347,1314,13;20;M
69134;1338,995,1698,1604,1468,826,982;63;F
69136;192;75;F
69141;1517,917,774,826,1322,702,268,1451,1434,1510,1110,1344,1524,1347,16;34;M
69163;1021,1604,297,373,1359,917,947,17,1322,1698,1434,140,1700,1526,1261;46;M
69213;1325,129,1581,988,1700,702,1328,1698,1468,22,265,1441,13,1434,1510;43;F
69215;1470;9;F
69220;140,1451,3,1441,1314,2,376,192,1347,776,1581,211,1110,1322,826;34;M
69233;1332,1295,36,124,1026,1698,174,16,1633,22,1314,13,1451,1312,1510;28;F
69237;17,1517,917,556,702,2,984;43;F
69240;192;44;M
69254;1416,451,17,1509,1532,1328,1026,1359,174,192,1559,1441,13,1451,140;43;F
69355;1532,124,1328,373,1698,733,16,376,2,1441,3,1451,1434,1384,1510;47;F
69386;774,776,1325,741,1624,1604,947,17,982,988,24,16,376,265,984;67;F
69416;36,1482,896,173,1119,17,1338,776,834,1700,586;57;F
69478;982,444,984,512,1021,173,988,1388,1026,1328,16,3,408,826,265;40;M
69528;17,1322,443,1482,373,1698,16,1468,376,394,2,1314,1441,13,1451;31;F
69542;1698,896,1344,1347,1624,373,1468,865,16,984,13,444,1441,2,394;38;F
69549;1119,17,1295,1700,1328,1698,550,1468,265,2,1441,554,13,1434,140;43;F
69604;774,443,1,982,995,1581,1332,988,702,16,1633,22,2,444,984;48;F
69605;702,1517,776,1624,1347,1344,1325,13,16,24,124,741,947,17,1338;23;F
69711;1,982,1581,1332,988,1347,702,1026,16,1633,1468,22,444,984,13;17;F
69719;1021,1526,1,1533,1532,174,1559,1384,17,124,1700,1698,1524,702,1261;43;F
69740;1482,1347,174,982,988,1624,1604,1322,1110,1581,16,1633,1468,1441,13;59;F
69791;140,173,826,1468,1532,1526,774,1604,1624,1330,451,1110,16;29;M
69793;917,1338,373,268,828,16,1434,140,17,1322,982,556,1700,1698;45;F
69811;1533,512,1021,1359,1510,1524,1026,1119,1110,192,1559,1517,451,702,297;36;M
69823;1388,982,17,947,1338,1325,512,1482,1700,373,1698,444,13,1451,1510;29;F
69834;1359,1517,1021,1533,1524,702,1026;36;M
69837;826,1,173,1581,1295,834,1700,174,16,1633,376,444,1510,1384,586;36;F
69876;1517,1021,1526,1322,1533,1524,1532,1700,702,1026,1328,1359,265,1559;41;M
69959;860,865,22,1510,3,1325,129,1332,1328,265,1441,1384;37;F
69965;140,13,376,1468,16,1347,776,443,1344,1581,1325,1322,774,1604,1624;61;F
69971;223,1119,1517,17,1526,129,1328,1359,1468,394,1314,554,1434,1510,1384;34;F
69979;2,1026,702,988,776,1524,1332,1344,1581,211,982,1110,774,947,1517;55;F
69996;1434,140,173,1,1624,1322,1325,1581,776,1700,16,1468,408,1470,1314;51;M
70004;1533,1524,896,1509,36,1532,1700,1026,865,1608,376,394,1559,554,586;39;F
70005;451,826,1482,1532,174,265,1510;44;M
70029;1434,741,1332,1295,124,702,174,24,16,1468,22,13,1312,140;49;F
70056;1451,984,376,22,24,702,995,982,409,1325,741,1322,774,917,1517;37;F
70071;659,23,1325,741,451,1347,1344,1119,1110,173,1581,896,554,984,1312;47;F
70072;834,124,1700,702,1026,1328,1359,174,16,265,1559,1314,13,1434,140;33;M
70121;741,776,988,124,1517,1325,211,982,1332,1524,867,702,24,22,984;46;F
70132;373,1359,444,984,1517,1021,1,982,1332,1524,988,1026,702,22,586;54;F
70147;17,1624,917,774,451,1322,1110,556,1482,373,1698,394,2,1441,1470;36;F
70156;1344,776,1509,1532,702,1026,16,1633,1468,376,13,1510,140,1434,1384;46;F
70175;1624,1517,1328,1347,702,24,1633,1468,1510;28;M
70177;1434,1384,129,1325,1338,1526,917,947,17,1517,1119,223,1,702,3;40;F
70188;774,741,1581,1344,443,124,1468,376,2,1314,13,1451,1434,1384,140;35;F
70189;1119,23,173,1344,1295,659,896,1700,1347,550,174,394,554,984,1312;46;M
70192;223,1624,1338,834,1026,1328,1510,1468,1633,140;37;F
70193;16,1633,1314,13,1434,140,1624,826,1581,1295,1388,373,1441,376,1312;30;M
70194;774,982,36,702,1328,733,16,1468,376,394,1314,1441,984,13,1434;40;F
70201;947,1021,409,173,1295,896,834,1532,1359,1698,373,828,550,16,1468;42;F
70222;1021,451,1119,1517,1,173,1581,512,1700,174,1608,192,1434,140;43;F
70268;1312,1700,1698;40;F
70295;1559,13,1510,1624,451,1322,982,1581,776,1347,1633,3,1451,140,1434;34;M
70313;776,702,1359,192,1314,1470,1510,140,1330,1581,1700,16,1468,265,1434;46;M
70404;22,702,1026,988,1524,1332,982,1,1021,1517,1359,373,444,984,586;55;M
70429;1517,1021,1,982,1332,1524,988,702,1026,373,1359,22,444,984,586;85;F
70440;1322,223,1624,1604,1517,774,1,1344,1700,1347,702,192,2,1314,13;49;F
70455;1624,451,1470,1434,16,834;29;M
70479;1604,1624,443,1482,1347,24,16,1633,1468,22,394,1314,1441,3,13;28;F
70480;1581,556,1332,834,124,1698,828,16,22,376,1314,3,13,1451,586;40;F
70481;1416,1,1581,36,702,1026,828,16,1559,1314,554,3,1451,13,586;31;F
70511;1322,1325,982,1581,1344,443,1482,1698,1468,1451,1510,556,1700,376,1434;31;F
70513;1332,1295,1700,702,373,1698,174,865,22,394,2,1441,984,1434,1312;43;F
70518;1700,1347,140,1510,174,268,988,826,1119,1517,1604,1624,1110,173,443;24;F
70519;1344,443,776,1509,1482,1347,1328,24,16,1633,1468,1559,1314,13,586;30;M
70544;1119,173,1344,443,776,1482,1700,733,174,16,1633,1468,22,376,265;34;F
70574;173,1524,702,1026,1328,268,174,1633,1468,265,1559,3,1451,1434,140;62;M
70588;1,741,1322,826,451,1330,1517,297,702,1026,1328,16,1468,1434,140;22;M
70660;586;45;M
70663;586;42;F
70671;373,1698,268,1608,1314,2,13,1510,1119,741,16,1633,1468,865,1441;36;F
70697;1119,1322,1581,512,1700,16;37;F
70699;1624,376,1338,702,394,826,741,1110,1344,16,1633,1468;29;M
70701;173,1325,741,382,1322,826,1517,1604,16,1434,1624,451,1338,1581,3;43;F
70705;1517,584,1021,1526,129,1533,1524,988,1509,1532,1700,1026,733,1559,1434;38;F
70727;586;42;M
70766;1487,1700,409,1,1416,1021,223,568,1119,17,373,1698,1441,554,586;35;M
70773;586;15;F
70822;1344,1,1624,1604,1347,16,1517,741,776,124,702,1434,140;46;F
70892;24,774,1624,1261,1581,1344,443,867,702,865,16,192,1559,984,13;46;F
70905;586;41;F
70910;982,1,1338,1526,1322,1533,556,1295,1509,1532,1700,1698,1359,1559,1434;47;F
70912;586;13;M
70946;586;13;F
70973;1517,23,1482,702,16,3,984;35;M
71021;265,1110,1328,1510,1624,1517,774,1021,443,1524,702,1026,22,376,1451;40;F
71029;947,1322,982,1347,1698,268,1633,1468,2,1441,984,3,13,1510,586;47;F
71044;1581,1532,984,1434,1559,1026,702,1700,896,1332,211,1,1517,1526,1524;35;M
71101;373,1330,1706,443,867,988,984;49;F
71107;917,774,1330,451,1,129,1581,1524,702,1026,1328,1359,265,13,1434;40;M
71167;1314,1559,376,173,1021,1604,1526,1261,129,1295,373,265,1441,1434,1312;39;F
71174;863,834,1487,268,1434,1312,1510,223,741,129,982,995,124,1700,373;40;F
71179;947,211,982,1295,1332,776,863,1698,733,24,16,865,2,984,1434;43;F
71206;24,223,586;37;F
71212;834,1700,1698,174,16,1624,1119,1322,129,1110,173;38;F
71231;129,1700;46;F
71232;774,1322,984,982,373,268,16,1468,1624,451,1325,776,1434,1510,140;46;F
71240;1533,1524,776,1509,1532,124,1487,1026,24,1468,1559,13,1434,1510,140;38;F
71266;17,1119,22,568,451,1322,1,129,982,173,1581,1332,984,1434,586;9;M
71284;568,129,982,1533,1332,988,1532,702,1026,733,1434,1312,192,1700,1261;39;M
71309;1325,1261,947,776,1624,1434,1510,140,13,373,1698,192,265,1314,1441;59;F
71327;16,1344,1322,1325,1434,1026,741,1,1517,1021,1524,124,702;46;M
71368;24,376,1510,1517,1021,741,1325,1,1524,776,124,702,1026,984,1434;45;F
71374;1119,382,129,173,512,1700,1633,1434,1312,408;12;M
71397;140,1434,1451,3,1633,24,268;28;F
71403;1119,451,1322,129,982,1581,1332,865,22,984,1434,586;5;F
71421;22,376,140,13,1119,1706,1110,173,512,1700,174,16,1468,1451,408;44;M
71456;1119,382,23,512,1344,1700,394,444,1312,408;8;M
71502;443,1344,124;35;F
71522;1700;21;M
71547;776,16;40;F
71549;1322,1388,124,16,3,1441;30;F
71569;1482,17,124,702,174,24,16,1633,1468,2,3,13,1451,1434,1510;34;F
71588;1524,776,1026,702,1359,174,16,1468,192,265,1559,444,1451,13,1434;27;M
71663;1021,1526,129,1524,1509,1532,1026,373,1698,1359,828,394,1559,1434,1384;43;F
71671;1700,1698;30;F
71698;1526,1517,1119,1021,982,173,1524,1700,702,1026,373,174,1608,1312,586;41;M
71700;826,1322,1110,1344,443,834,124,373,268,24,16,1468,3,1451,741;25;F
71723;774,568,1,1344,776,1700,2,1434,140,1322,702,192,394,16,1314;43;M
71762;984,1332,988,995,982;72;F
71765;1517,1021,1325,1533,1524,1509,1532,702,1026,1328,16,265,1559,13,1434;37;M
71796;16,265,13,1451;27;F
71818;1510,16,1700;44;M
71846;512,1581,1325,741,1322,826,1338,1021,17,124;22;M
71850;776,1482,124,268,16,1633,1468,376,13,1347,1344,1322,129,1510,140;41;F
71863;13,733,1698,124,834,776,443,1344,1110,741,1322,1338,774,17,1604;27;M
71907;124,173,1322,1119,1604,1624,1517,741,1,1344,1524,702,1698,13,1510;35;F
71950;16,173,1110,1,1322,826,17,1325,23,1581,1332,988,444,13,1510;29;F
71955;1581,1344,443,1295,896,988,1700,1698,865,22,2,1441,1312,741,124;39;F
71993;1451,702,1482,443,1624,741,1388,124,16,3,1434,140;28;F
72113;1624,1119,451,1325,1,173,1581,36,1026,174,1468,376,1470,1434,1510;53;F
72123;13,1559,16;24;M
72162;1624,1604,1325,443,1482,16,13,1451;49;F
72170;1330,1021,1524,1509,1532,1026,1328,373,1359,16,1468,265,1559,1470;36;F
72189;1021,1416,1524,1295,1026,1698,174,376,444,13,1451,1510;72;F
72191;443,1325,1322,17,1624,1510,1434,265,1328,1482,834,550,376,554,1451;44;F
72219;1482,1624,774,1119,826,1110,1344,1347,1328,16,1633,1468,265,1470,13;40;F
72220;1517,1330,1706,702,1633,1468,2,13;34;M
72254;984,1434,373,3,1451;31;F
72265;1026,702,1021,1517,1338,124,1700;32;M
72299;1468,1330,1328,1359,1532,1509,1021,1524,1026,1434,265,1559;5;F
72332;1468,1470,1330,1328,1359,1021,1524,1509,1532,1026,265,1559,1434;1;M
72340;982,211,863,1608,1312;83;F
72354;265;39;M
72383;1468,1330,1328,1359,1021,1524,1509,1532,1026,265,1559,1434,1470;71;F
72407;774,1347,1468,1344,1322,1,995,1517,16,2,13,17,982,988,984;47;F
72435;17,1624,1517,1,776,1700,1347,702,1026,373,16,1633,1468,3,13;27;F
72454;140,1624,774,1532,1604,947,1330,451,1526,443,265,2,1441,1434,554;56;F
72483;1624,1330,1526,982,1533,1332,896,1509,1532,1359,1559,1434;37;F
72490;1347,1510,1624,17,947,1,1110,173,1581,1700,268,174,1468,2,1441;33;F
72581;382,512,860,1470,408,1526,1322,443,1509,1532,16,1559,1261;43;F
72615;17,982,211,1332,988,984;60;M
72661;1482;38;M
72672;211,1581,1344,443,1524,896,36,1359,268,16,1468,265,554,984,586;31;F
72674;826,568,17,917,982,211,1332,896,988,124,24,1633,22,444,984;38;F
72691;584;41;F
72743;1517,451,1021,1338,982,1524,702,1026,1328,265,1559,1384;39;M
72832;1517,702,834,1698,1328,265;50;F
72847;451,173,776,1700,733,174,16,1633,376,394,2,1441,13,1451,1434;31;F
72850;1633,192;9;M
72874;947,1119,451,826,382,1325,173,1581,512,1698,1468,13,1434,1510,408;25;F
72881;1633,192;14;F
72904;1119,917,947,1517,1322,741,1,129,982,124,702,174,24,376,1441;40;F
72905;1517,834,24,1510,140;38;F
72920;1581,1344,1482,1700,1347,373,1559,1434,1624,1110,268,1633,1468,984,1510;33;F
72944;1344,1706,1633,1468,1434,1347,1332,1110,774,776,826,451,443,16,13;57;F
72952;1581,1,741,1322,1021,1119,917,1604,376,1559,1441,3,13,1451,124;37;F
72965;982,1332,1347,1633,22,265,1314,13,140;40;F
72996;1700,373,1698,192,1312;68;F
73037;1344,1624,1021,1526,1338,826,1509,702,1026,1468,1559,451,13,16,776;29;M
73056;774,1604,1322,1325,1624,451,1509,1532,1700,1347,1328,16,1468,1434,1510;27;M
73073;1517,1322,1325,1581,1347,16,2,13;47;F
73074;1624,1526,1416,1533,1524,1509,1532,1700,1026,1559;34;M
73103;211,982,129,17,1526,1416,995,1581,1509,373,22,1559,2,1384,140;39;M
73135;1468,192,3,1451,36,16,1624,1517,917,129,124,1700,702,1510,140;37;M
73177;1468,834,774,741,776,1482,124,1328,1698,24,16,265,1441,1434,586;44;F
73211;1604,982,173,1700,13,268,174,826,1110;50;F
73238;1322,1325,1110,36,376,3,1510;28;F
73247;1517,1624,1021,1526,1533,1509,36,1532,1026,1608,265,1559,1451,1434,1510;37;F
73286;982,995,1581,1026,1698,174,16,1468,22,376,265,394,1559,984,1312;47;F
73349;223,409,129,211,1332,1295,896,863,1700,1698,22,394,554,13,1312;11;M
73380;554,556,1344,1119,1312,223,1322,982,1295,863,988,373,16,376,394;31;F
73392;1624,917,774,741,1325,173,36,124,268,174,24,1468,1633,3,1510;43;M
73439;1021,1526,1322,1,982,1524,1509,1532,1700,1026,1359,265,1559,1434,1384;43;F
73445;13,984,1322,409,982,443,1332,988,124,24,16,865,22,394,2;36;M
73479;733,1468,13,1434,1,174,268,1482,443,1706,947,1633,376,394,1510;27;M
73490;1330,1700;37;F
73494;1330,1347,265,297,1604,451,23,443,1482,268,24,1633,1314,13,1510;55;M
73499;13,1624,1604,774,1330,451,826,776,1482,1347,1328,24,16,1633,1468;69;F
73501;1510,776,443,1482,1332,1325,982,17,268,984,3;47;M
73516;1517,409,211,867,896,733,1441,17,982,863,988,860,865,444,984;53;F
73569;1510,1434,1026,702,1482,776,1524,1021,451,917,1517,265;61;F
73595;1330,17,1347,1026,174,16,1468,265,1559,13,1434;21;M
73612;17,1119,1021,826,129,1581,1524,988,16,192;41;F
73614;1604,1706,129,173,1338,1119,917,826,1581,174,1633,192,1314,1434,1510;39;M
73616;1700,1698,828,174,22,192,1441,1434,17,982,211,173,1314,1470,1510;38;F
73686;774,917,584,17,1624,1510,140,1517,1322,23,1482,36,268,3,1451;25;M
73756;1524,834,36,1700,1328,1359,174,1468,865,192,265,1559,2,1314,1441;35;F
73776;268,1468,13,1325,982,1332,988,1633,376,1451,1510;48;F
73785;1633,192,376,1441,13,1451,1434,586;36;F
73819;1698,376,584,947,774,223,23,995,443,1332,896,1388,733,394,554;26;F
73895;1517,1533,1581,1532,702,1468,1384,1026,1524;27;M
73901;1021,1524,702,265;47;M
73914;1330,13,1510,1328,451,1526,1325,776,16,1468,265,1559,1434,140;41;M
73961;192;32;F
73964;1517,1338,1,1524,776,702,1026,174,24,16,1633,192,1434,1510,140;43;M
74013;443,1295,1700,550,733,984,1510,192;69;M
74014;223,568,129,1533,1524,834,1532,1700,1026,1328,550,16,1468,1559,1384;39;F
74015;173,982,867,834,1482,1698,828,1633,376,2,1624,17,1524,373,1468;24;F
74038;1314,192,129,382,1261,451,947,1517,1604,1119,1338,982,512,1700,702;41;F
74096;1261,408,140,1510,1434,1314,376,1608,1698,834,988,896,1533,1338,17;49;F
74152;659;43;F
74197;1524,776,36,124,702,24,16,1468,192,376,1314,444,3,1434,586;28;M
74229;16,124,373,376;23;F
74249;1468,1510,140,373,1604,1700,1526,1533,1524,1509,1532,1026,1559,13,1434;28;M
74275;140,1510,13,1314,376,22,1468,24,1482,776,1332,774,1624,16,982;30;M
74279;1,443,1524,1434,140,13,1517,1325,1021,917,702;34;M
74293;174,22,2,1441,1510,17,173,834,1700;21;F
74299;826,443,867,1698,16,1633,1608,376,394,1314,1441,1451,1434,1510,140;57;F
74357;443,1328,24,1633,376,265,140,1434,13,1468,16,1700,1482,776,1;39;M
74424;733,1468,22,140,1510,1312,1261,1021,24,16,1633,1608,3,13,1434;13;M
74460;1624,1526,1,443,1524,776,1509,1532,1026,16,1559,13,1451,1434,1510;23;F
74464;865,13,140,1624,409,982,1344,1332,776,988,16,22,376,984,741;72;F
74471;1624,1322,23,1509,1482,1388,1328,16,1633,1468,3,1451,1312,1510,140;53;F
74495;1314,140,408,1608,1338,17,1261,1322,382,1533,988,834,376,1470,1510;75;F
74514;1524,1344,1021,451,917,1517,776,129,1325,774,1604,1624,265,1434,140;57;F
74613;1261;50;F
74674;982,1332,1559,586;57;M
74743;1624,774,1526,1325,409,982,443,988,1509,1532,373,24,16,1468,1451;58;F
74787;1110,1322,826,1624,140,1451,1468,1633,1347,776,1332,443,982,1,774;33;F
74879;1517,17,1468,1451,1510,1434,3,373,702,1700,1487,443,1581,1322,1119;57;F
74880;1119,1110,173,1700,174,16,1468,1441,3,13,1451,140;57;M
74914;1434,13,1468,140,17,1517,1021,1,1482,1700,702,1026,1698,268,16;32;F
74954;1261,1581,1328,174,1468,22,192,2,1314,1470,13,1451,1434,1510,140;41;F
74974;1604,1624,17,1517,774,173,776,1482,1347,702,174,16,1468,13,1434;28;F
74996;1517,1330,451,1021,1332,702,1026,1328,16,22,376,265;36;F
75020;1359,268,174,16,1468,22,265,2,1314,13,1451,1434,140,1261,192;42;M
75047;776,1482,1700,1698,174,16,1468,192,2,984,13,124,24,22,1510;40;M
75080;17,1338,1,1110,1700,268,702,16,376,1441,444,984,13,1434,140;26;M
75089;1581,1532,1700,702,1026,174,16,192,265,1314,1434,1517,1021,1526,1509;37;F
75096;1604,1119,1434,13,1468,16,1482,776,1624,917,774,1581,140;22;F
75117;1624,1604,1330,451,1526,1328,1359,16,1559;30;M
75144;1624,1434,140,22,1330,1526,1332,988,1347,1328,13,1509,1338,211,265;57;F
75221;826,16,1624,174,173,13,1468,776,1524,443,1110,129,451,1119;44;M
75249;776,1524,1581,173,1325,1021,451,1330,774,917,1517,17,297,1624,1434;21;F
75275;1332,1295,896,1509,1482,268,174,16,1633,1468,192,376,1559,3,1451;37;F
75287;1624,17,774,1338,741,23,443,1482,24,16,1468,376,2,13,140;32;F
75330;1559,297,1021,1517,1533,1524,702,1026;36;M
75333;1416,1526,17,443,1524,1509,1532,1026,373,1359,1559,1441,13,1510,1384;32;F
75356;1261;43;M
75359;568,223,1261,382,129,1581,512,1344,1295,834,1700,174,192,3,451;38;F
75455;1347,1510,1330,1344,1,1314,13,826,16,1119,1468,297,702,1026,265;24;M
75505;1604,1624,17,1325,1,834,1482,268,16,1633,1468,192,3,13,1510;34;F
75570;443,1,1322,1526,1021,982,1344,1532,1026,1698,16,1559,13,1451;44;F
75571;1698,2,984,1510,17,774,1322,1,982,988,702,373,1468,192,13;46;F
75591;1624,1322,1325,1581,443,2,1451,1434,1510,140,982;73;F
75610;702,24,16,1633,3,1384,140,1468,1434;20;M
75634;982;57;M
75665;2,268,1698,1328,1700,1388,834,1581,173,1325,1322,947,584,17,3;40;F
75779;1322,1482,13,16,1347,776,1338,774,947,1604,1624,443,1388,1468,1451;57;F
75833;1517,1021,1,1344,1524,776,124,1700,702,1026,1698,1468;42;F
75861;1434,741,1322,1021,1624,1517,1526,1338,1524,834,1509,1482,1532,1026,1559;20;M
75866;1330,1624,774,1526,826,1110,1344,443,1509,1347,373,24,16,1468,376;24;F
75892;1482,1532,1347,24,16,1633,1468,376,1559,1314,3,13,1451,1510,140;35;F
75953;1328,1633,1314,1330,451,1604,1624,1325,1524,373,16,1468,22,1441,1434;14;F
76026;584,733;63;M
76030;1441,16,451,1119,1322,982,1581,1026,865,192,394,444,382,512,408;39;M
76066;1624,1604,1021,1526,982,211,1328,16,1468,265;18;F
76081;1322,443,1509,1532,1026,1468,16,1559,1434,13,140,1526,1021,1524,1624;53;F
76083;1470,13,1434,1517,917,1021,1322,1,1533,1524,702,192,140,17,1441;33;F
76094;1698,13,1510,741,896,1388,373,1633,16,24,1624,1441,3,1451,192;43;F
76103;774,1388,124,2;61;F
76119;584,733;59;F
76134;1624,1698,174,16,1608;32;M
76156;774,1,173,776,443,268,1347,174,16,1633,1468,376,13,1510,1451;49;F
76166;982,22,2,984,3;45;F
76175;444,140,17,584,947,774,568,451,443,1332,776,896,1509,192,2;38;F
76176;173,774,1604,917,1624,1322,741,1325,1347,1698,24,16,1633,13,1510;30;F
76198;1604,1468,1451,1624,774,451,982;40;M
76212;1624,1,982,995,443,1332,867,863,988,1633,22,2,1441,444,984;52;F
76247;1624,584,774,1322,1482,1347,373,733,16,1468,865,22,376,13,140;44;F
76268;741,826,568,774,1624,1451,443,1295,863,896,1700,373,828,24,192;13;F
76274;1700,1624,1322,741,23,867,124,24,984,1312,1510;49;F
76286;1384,16,1559,265,1328,1468,1482,776,443,129,1,1325,1526,451,1119;35;F
76290;584,733;25;F
76299;17,1325,1295,373,1468,22,3,13,1312,140;19;F
76437;1,776,1482,124,702,1314,1434,1338,867,373,733,1608,192,394,1517;40;F
76492;1624,1338,1,1524,834,16,1468,1441,13;25;M
76496;17,917,451,1295,776,988,1509,1482,1347,373,1359,1441,984;47;F
76529;1482,124,1347,1026,1328,1359,192,376,265,1559,1441,1434,1510,1330,702;39;M
76549;1325,982,129,23,173,896,1700,373,174,22,192,1434,140,917,1581;34;F
76740;1330,982,265,1328;75;F
76747;867,24,1633,1312,140,1338,1468,1510,16,1434,741,1;19;M
76750;211,863,1608,586,223,409,550;47;F
76761;17,947,1338,1322,741,1325,129,1581,834,1700,373,1698,1441,13,1434;26;F
76948;1633,1434,443,451,1330,982,995,1332,988,373;38;F
76965;192,1559,1314,1470,13,408,451,1,1110,23,982,1344,443,1347,16;44;F
76969;1119,1330,982,443,174,16,22,1441,3,1510,140,408;69;F
77000;1604,1624,1322,1581,988,1328,1468,265,13,1434,140;59;M
77145;443,16,22,444,984,13,1434,211,1706,1322,774,1624,982,1332,988;70;F
77154;1624,1322,451;29;M
77225;1509,451,1021,1526,1261,1026,1328,1468,265,1559,13,1451,1434,1510,140;8;F
77233;3,1451;38;F
77248;297;39;F
77269;1517,774,1021,1524,702,1026,16,265,1314,1510;65;M
77270;17,1322,13,1434,1441,376,1468,373,1698,1700,124,741,1338,947,1624;40;M
77302;1532,1509,124,1347,1328,268,174,24,16,1633,1468,22,265,1559,1314;32;M
77376;947,1581,1295,36,1698,1468,865,1559,1441,1312,1526,1338,982,995,1700;17;F
77380;1533,1581,1344,443,1524,1295,867,863,896,834,1700,702,865,265,984;52;M
77414;1604,1526,1330,16,13,265,917,1021,1325,443,1524,776,1509,1347,1328;41;M
77474;1314,376,1468,16,988,867,1332,443,211,982,1,1338,774,917,1604;31;F
77477;140,1510,36,1509,1524,1581,173,1517,1021,1,702,1026,174,1559,1261;47;M
77515;1633,984,1559,1314,1434,1510,1441,1359,1328,1332,1344,1624,1706,1325,1700;43;F
77517;1624,173,36,268,3,1510;34;M
77546;1624,982,211,1344,867,776,1509,1347,373,1698,16,1633,1468,1314,140;24;F
77547;584,443,733;48;M
77559;192,982;60;M
77620;1325,982,443,13,17,22;23;F
77656;1581,1700,1119,1706,1,173,1344,1524,124,268,1633,174;43;M
77745;17,584,917,1581,1559,1434,140;36;M
77747;982,192;8;F
77768;1700,702,1026,268,376,394,1451,1021,947,17,1517,1581,834,828,1434;31;F
77783;988,776,1344,1581,1325,1322,1624,17,1021,1526,1261,1533,1524,1532,1026;43;F
77793;982,192;14;F
77800;382,741,129,1581,512,834,124,24,192,1314,1441,1470,408;43;M
77826;174,297,1119,129,173,550,733,1581,982,584,984,1261,1328,265,1434;43;M
77832;192;43;F
77841;776,1110,451,1330,1509,1388,1328,16,1468,1624,443,556,1347,268,1451;51;F
77931;36,1532,1624,17,774,1021,1526,1261,1325,1581,1524,988,1509,1482,1468;14;F
77959;1509;39;M
77986;917,17,1624,1325,173,1524,268,174,16,1633,1468,2,13,1434,1510;36;F
77999;1021,1526,982,1524,1509,1532,1026,1328,1359,1468,265,1559,984,13,1434;59;F
78005;1261,1533,1581,1524,1509,1532,1026,1359,16,1468,265,1559,1314,13,1434;12;F
78011;1021,1526,1581,443,1524,1509,1359,16,1441,13,1434,140;43;F
78028;1322,17,382,741,129,124,1700,373,1698,828,860,394,1470,586,408;34;F
78029;1624,1517,1,1344,443,1347,24,16,1633,22,376,265,1314,13,1451;40;F
78059;1633,376,2,1441,3,1624,774,223,1,443,1482,268,1468,13,1451;62;F
78097;444,733,550,1706,834,373,1314;34;M
78143;1604,917,1322,741,129,1332,124;54;M
78168;129,1332,1700,1434;45;M
78182;1330,451,1526,826,741,1325,173,1344,776,124,1328,16,1608,1559,1314;35;M
78204;174,1119,1526,17,947,1021,1416,1524,1700,1026,1698,265,1441,1434,140;61;F
78223;947,1119,1021,1526,1416,1,1524,1700,1026,1698,174,265,1441,1434,140;66;M
78233;1524,1026,129,1487,1608;47;F
78237;1510,1633,1388,268,1482,1524,1581,1533,1110,1325,1021,451,1119,1517,297;19;F
78254;140,1441,947,1416,129,173,1700,1524,834,1026,1698,265,1559,1434,17;39;M
78260;1604,1517,1624,1325,1,982,443,1524,702,1026,3,984,13,1451,1434;55;F
78298;1021,1,982,1533,1524,988,1509,1532,124,702,1026,22,1559,984,1384;46;F
78308;1261;67;F
78325;1706,1581,1533,124,173,265,1021,1359,1524,1526,1698,1700;31;F
78328;1559,265,982,1110,774;46;F
78352;1700,702,1328,1698,1359,828,1468,1608,265,394,1559,1314,1441,13,1434;42;F
78377;1517,1021,1,1524,702,1026,1328,265,1434,140;46;M
78391;1325,129,444,984,409,982,211,995,1332,863,896,988,860,22,1434;37;F
78420;834,265,1559,1441,13,1338,1526,1021,451,774,947,1517,17,1604,1624;13;F
78421;1624,1338,1482,124,268,24,16,1633,1468,3,13,1434,1510,741,586;52;F
78424;917,1322,1,129,23,443,776,1482,702,124,1026,192,2,3,1434;39;M
78431;774,1344,776,988,1509,1487,702,1441,826,443,556,1698,16,1633,394;32;F
78447;774,1624,17,443,988,1482,268,1604,1468,1441,984,13,1434,1312,140;76;F
78469;1624,774,826,1325,1110,1344,443,1347,16,1633,1468,1559,1314,1451,13;34;F
78482;1325,741,17,373,24,16,1468,1633,192,1314,13,1451,1434,1510,140;17;F
78483;1482,1347,1328,1633,1624,774,451,826,443,24,16,1468,376,13,1451;48;F
78517;265,1347,1328,376,1314,1434,1510,1026,1532,1526,1261,1581,1021,1604,917;47;M
78521;1261;71;M
78525;451,373,1698,265,1328;31;F
78528;1119,192;15;M
78573;129,1332,834,1509,174,1608,22,265,1559,2,1441,13,3,1434,1384;38;M
78619;192;13;M
78671;443,1441,13,1434,297,1517,826,1524,776,1700,702,16,1633,1510,140;31;M
78674;1332,1482,1700,1347,16,1633,1468,22,376,394,1314,13,1451,1434,140;31;F
78679;1700,376,1314,568,1,982,1295,896,1482,702,16,394,1441,554,1510;30;F
78692;211,1526,1533,1524,1509,1532,1026,24,16,1633,1468,1559,13,1451,1434;45;F
78693;1295,1510,1119,982,1332,24,741;28;M
78708;16,1468,192;7;M
78715;1338,1482,1700,1441,1451,1434,1624,1698,1510;34;F
78723;192,586;40;F
78751;192;41;F
78763;1325,982,1581,1332,1482,1700,702,1328,1698,865,1441,984,1312,1510,140;43;F
78807;451,17,1604,1624,1526,1110,776,834,1509,1328,16,1468,265,1441,140;35;F
78811;982,1332,896,16,22,444;26;F
78880;394,1468,16,24,268,373,867,1325,17,702,1517,382,1,443,776;33;M
78886;1021,1322,1524,1532,702,16,1559,140,917,1526,1325,776,1026,265,1434;36;M
78895;896,1532,865,1608,376,554,982,1332,863,1509,22,394,1559,1441,984;43;F
78922;1434,16,863,776,1110,451,211,982,1332,1359,24,865,192,2,984;7;M
78923;1698,373,1487,1700,1468,865,192,394,1314,1441,1470,984,13;41;F
78935;1,741,1021,443,1344,174,1119,702,982,13,1517,1434,16,1509,1026;38;M
78964;568,451,1021,1261;64;F
78994;1700,1119,1526,1110,776,1347,1332,1328,1330,373,24,16,1633,1468,1608;40;M
79031;1482,211,982,988,1698,373,896,776,443,173,1110,451,774,17,297;40;F
79039;223,1021,1526,1261,1322,1,1533,1524,1509,702,1026,1359,1434,1384,140;46;F
79046;1347,1698;30;F
79104;1706,1325,867,995,863,865,982,1434,984,586;40;M
79106;917,982,1332,896,863,1509,1532,1608,22,376,394,1559,1441,554,984;8;M
79143;409,1624,584,917,568,223,1581,863,1700,373,376,1314,1441,444,1312;75;F
79159;192,1559,1441,1434,140,1633,24,865,1608,22,376,1314,1384,1451,13;41;M
79200;451,1322,1706,1325,443,988,1700,1359,174,22,1608,192,265,1434,984;38;F
79242;173,1581,1344,443,1388,1347,702,1328,373,1698,733,1468,265,13,1451;8;M
79255;1314,1468,774,1517,1624,1021,1524,776,702,1026,1328,16,265,13,1434;36;F
79258;1332,124,16,192,1344,17,1322,1706,1110,1388,1608,1314,444,408;36;M
79272;774,1526,1322,1581,1344,443,1295,1509,1347,1328,16,1468,394,1451,140;52;F
79275;1698,947,17,917,1338,741,124,373,268,192,376,2,1314,1470,1510;28;F
79282;16;27;M
79283;1021,1526,1416,1344,1524,1509,1532,124,1700,702,1026,1468,1559,13,1434;46;M
79320;1526,1338,834,1509,1482,124,1698,268,16,376,265,444,1384,140,408;18;M
79348;1119,1330,1526,1110,1332,776,373,24,16,1633,1468,1608,1700,1347,1328;11;M
79352;17,947,774,223,1581,1344,443,1332,268,1468,16,373;38;F
79380;1624,1604,917,1119,451,1706,1325,1,982,1344,443,776,268,16,1510;37;F
79383;1325,1624,17,1,36,1328,1359,16,1633,1468,1314,1441,13,1434;27;F
79427;774,982,211,1533,443,867,988,1482,1328,373,1359,376,265,1434,140;67;F
79492;1604,1110,1344,1468,16,451,1526,443,834,1328,265,2,984,13,1434;36;F
79513;917,774,1624,1604,1322,1110,1581,1344,443,1509,1468,16,1441,1451,13;30;F
79562;1,1482,702,1026,451,1526,776,1328,16,3,1359,265,1468,1451,1434;27;M
79569;1,443,896,1388,1698,16,1468,22,265,394,1559,1314,1441,13,3;27;F
79590;1624,17,451,1325,1581,776,1482,1532,16,1633,1468,22,13,1434,140;16;F
79616;140,1434,1451,13,3,1314,1468,1633,268,776,1581,1322,917,1604,1624;30;F
79633;1322,1526,1330,451,774,443,776,1482,124,1328,1468,1559,13,16,1434;30;F
79680;376,988,896,1344,1110,1325,223,568,1119,774,584,297,1624,1510,140;24;M
79700;17,584,556,702,1026,550,733,174,376,444,984,1384,140;27;M
79710;1633,1441,984,1700,1604,1338,1482,394,2,140,223,1698,268,1468,554;25;F
79749;1624,17,1119,1322,129,443,124,1700,268,1510;36;F
79759;512,1,826,1021,1624,776,834,1700,702,16,1633,1468,3,1451,1434;25;M
79777;211,863,1482,174,984,1312,140,129,1344,1332,124,1700,16,22,1510;43;F
79797;1344,124,1532,1509,982,917,24,1633,16,1468,192,2,444,984,1434;39;M
79839;984,1384;44;M
79841;982,984,1441,988;37;F
79843;1322,1338,584,1604,1624,17,947,917,129,1295,988,192,2,554,1510;31;F
79853;1322,1325,1533,1581,1344,1524,1482,1388,1347,702,1026,373,24,16,1468;24;M
79861;17,2,16;26;M
79876;1624,776,173,982,1517,1322,741,1325,1,129,124,373,268,24,1510;62;F
79906;1110,1344,1347,702,24,1633,1468;37;F
79984;1517,1021,702,1026;32;F
80051;16,865,265,1559,444,984,1434,140,1624,1604,223,1021,1526,1322,129;44;F
80069;917,1322,1021,1526,1261,1416,1533,1524,1509,1532,1026,265,1559,1510,1384;39;M
80106;1517,1624,826,1434,17,774,1322,1325,1,1581,1482,1698,1633,376,1338;28;M
80121;1110,947,982,1338,995,373,1441,192;30;F
80122;826,1330,451,1119,1624,23,1332,1524,702,174,1633,192,984,3,586;42;F
80161;1559,13,1434,140,297,1624,451;26;F
80163;584,733;32;M
80172;1468,129,1332,1026,1517,1524,702,376,22,1608,265,394,1314,1434;35;F
80258;1700,1524,826,451,1119,1517,1026,1633,265,1470,1434,1510,382,512,408;39;F
80280;265,129,1559,1526,1524,1510,1509,1384,1359,1026,1021;38;M
80283;776,1482,1328,174,444,13,1434,140,192,1526,1325,1581,1295,1509,1700;50;M
80295;173,174,1434,1,1524,1700,702,1026,394,1517;40;F
80311;1700,1328,376,2;41;F
80334;1330,1119,774,584,1624,1322,1325,1581,776,1700,373,16,1468,1451,1434;16;F
80348;443,1451,1110,1526;60;F
80359;1325,1509,1698,1359,3,1434,1510,1119,1604,741,1581,124,1700,1451,1384;39;F
80395;1532,36,776,1581,1,1325,1526,1021,1517,1604,1624,1524,1559,3,13;34;F
80428;1510,1700,1110,1261,443,1524,834,1532,1026,265,1559,1434,1312;47;M
80490;1295,1700,373,1468;18;F
80530;1322,1706,1110,173,1581,1482,1698,828,174,1633,265,13,1434,1510,586;51;M
80535;1524,443,1581,1110,1325,741,1322,1517,451,1021,1328,268,265,1451,1434;33;M
80537;1526,173,1581,1700,1026,1451,1434,1510;46;M
80544;1330,1344,1347,1328,1359,1559,1314,1434,1468,1532,1509,776,1526,1604,1624;37;M
80569;1517,1119,1338,382,741,173,129,982,124,1700,702,174,192,1470,586;36;F
80590;140,1510,1624,17,451,1338,173,776,1482,36,1328,268,1468,376,265;36;M
80680;1322,1,834,1482,124,24,22,3,1451,1434;29;M
80687;1624,1604,774,826,1325,173,443,373,16,1468,1314,13,1451,140;18;F
80735;1526,1624,1021,1533,1524,1532,1026,1328,1359,1468,265,2,1441,13;59;F
80806;1338,1384,17,1559,1581,1524,834,1700,702,1517,1021,1261,1026;43;F
80892;173,1344,1524,36,702,1026,373,1698,268,174,1468,376,265,1441,1434;44;F
80926;223,826,1322,382,129,173,1581,512,1524,1700,702,16,1633,13,408;41;F
80936;1434,13,3,16,1347,1388,1581,1,1322,451,1624;39;F
81011;1624,17,1604,774,1110,1581,443,1509,268,394,376,1468,16,1347,1344;59;F
81054;16,376,1468,741,451,1119,774,2,1314,1434,13;34;F
81055;741,124,586;11;M
81065;741,124,586;42;M
81072;1624,17,741,211,1581,124,24,16,444,1451,1510,140,586;13;M
81074;129,1581,1509,1482,124,702,733,16,1468,376,394,1441,13,1434,1510;36;M
81105;1532,124,1347,1328,373,174,24,16,1468,1608,265,1559,1314,13,1451;36;F
81174;1325,1344,408,1338,741,1,129,1581,443,1524,124,1608,1314,1434,1384;30;F
81182;373,268,865,192,1470,554,140,17,834,1698,828,1468,2,1441,1434;25;F
81190;982,1604,896,1347,268,24,16,1633,1468,376,1559,984,13,1451,1312;50;F
81215;1328,1517,1344,443,1468,702,1482,1325,1322,774,1624,1347,24,13,1451;32;M
81234;947,995,867,659,550,733,860,16,394,1,129,982,1581,265,444;40;F
81260;1604,584,741,982,211,1581,863,124,702,733,16,1468,192,1314,140;46;M
81358;192;43;M
81365;13,1451,140,1312,268,1347,124,896,443,1344,211,982,1325,1322,223;13;F
81379;826,1325,1,1110,1581,443,776,1482,1700,16,1633,1468,13,1451,140;29;F
81403;776,984,917,1325,129,982,1344,556,1482,1633,1468,376,13,1510,586;40;F
81428;1526,1416,129,211,1533,443,1332,867,863,1509,1532,1700,1698,1559,1451;49;F
81451;1434,265,1524,1021,702,1325;39;M
81466;568,1338,741,1344,1332,1487,1347,373,1698,16,1633,1468,376,394,1314;22;F
81468;3,16,443,741,223,13,982,896,1344,1110,1325,1322,1624,1451,1312;47;M
81469;947,776,834,1482,1700,1328,550,376,265,1441,554,13,1451,140,586;69;F
81478;1328,373,1698,1359,828,376,265,2,1314,1441,554,984,13,1451,140;71;F
81491;1325,982,173,1332,1322,451,1119,1328,174,22,265,1441,444,984,1434;32;F
81504;140,16,550,995,1416,1325,1021,1526,982,443,702,1328,265,444,1434;42;M
81552;1517,1581,1344,443,776,1482,36,1487,1347,702,1468,22,376,1441,13;47;M
81658;982,1524,1509,1700,1026,1328,373,1359,1608,22,265,1559,984,1434,1312;45;M
81687;1633,268,1344,36,1482,192,3;38;M
81694;192,1;9;M
81776;373,16,774,23,173,443,776,988,1482,376,1559,984,3,297,1;35;M
81799;1,192;41;F
81801;1482,268,24,394,1559,1624,826,443,776,16,1633,1468,1451;26;F
81811;1110,1533,556,1524,1509,1532,1026,1328,1359,268,174,265,1451,1434,1510;48;F
81837;741,211,1332,896,124,24,16,984;30;F
81854;1604,1021,1526,1533,1524,776,1509,1532,1347,702,1026,1468,376,1559,1434;30;M
81857;192;6;M
81874;1468,776,1451,1510,984,265,1328,1482,1624,1330,774,982,443,1332,140;44;F
81928;1524,988,865,36,702,1026,373,268,733,550,22,1559,444,984,1451;41;F
81953;1624,741,443,124,702,24,1510;61;M
81954;1110,1325,297,17,1119,451,826,1322,173,1700,174,860,1441,1434,1510;41;M
81956;550,2,1510,1434,3,1470,192,1468,1633,733,1698,1344,1604,382,774;37;F
82011;982,988,1700,268,1633,22,3;46;F
82058;982,1700,268,1633,22,3;11;M
82064;1524,1533,982,1110,1322,1330,451,1517,1021,1482,1532,1026,1468,3,1384;20;M
82068;982,13;43;F
82130;917,1021,1261,1322,129,1581,1524,265,1434,1510;38;M
82141;982,834,1700,268,16,1633,1434;15;M
82180;373,1468,1451,140,1624,917,1322,1325,409,1581,776,1482,1347,16,1633;35;F
82232;1325,741,982,867,36,124,702,1026,24,22,2,1441;29;F
82255;1,443,867,36,1700,702,373,1698,24,16,22,376,394,2,13;30;F
82295;1487,1700,702,1026,373,376,394,1441,554,984,1451,1434,1312,140,586;44;F
82314;984,1451,13,1468,1359,1347,556,1581,982,774,1330,443,1328,265,140;76;F
82316;1021,1526,1347,1509,1532,265,1559,1328,1330;36;F
82325;741,1332,1633,1559,1510,1517,1021,1338,36,834,124,702,373,268,1384;34;M
82406;174,129,451,1624,1119,1330,1526,173,1581,443,776,1509,1532,124,1328;76;M
82423;451,1,1110,1344,443,1482,24,776,1347,268,16,1633,1468,376,1314;12;F
82427;1325,1344,373,984,1468,1451,140,774,982,1332,1482,124,268,22,376;27;F
82438;173,982,129,1,741,1526,1021,1119,1517,1624,1434,1510,568,1332,22;40;F
82444;1325,1322,17,129,192,2;42;F
82453;1581,1624,17,774,1,982,373,268,16,1468,1314,1441,3,1451,1510;25;F
82501;409,982,1332,659,988,1700,408,1451,1470,1608,826,1322,512;41;M
82504;550,733,174,24,22,376,13,1451,140,443,776,1700,1698,16,1468;41;M
82518;863,1119,129,982,995,1581,1524,867,702,373,860,865,984,1434,586;38;F
82539;451,1322,741,982,1581,443,988,124,373,16,1468,444,984,13,1510;69;F
82544;1524,265,984;38;F
82566;774,443,995,982,988,268,984,1510;56;F
82586;982,1441,1434,140,17,988,1482,984;51;F
82607;1325,512,443,1700,373,1698,733,1468,265,394,554,13,1312,1510,140;44;F
82634;409,584,1330,1482,1487,733,376,408,17,1698,1608,192,1434,1312,140;46;F
82642;1314,1470,1434,1510,1624,1119,451,382,1581,512,1344,1700,1698,984,408;46;F
82661;1119,17,917,1322,741,129,443,373,268,192,2,13,1434;40;F
82664;265;4;M
82666;192,129;38;M
82686;1517,211,16,1,124,1700,702,22,1434,774,741,982,1332,988,984;51;F
82713;265;2;M
82852;826,129,1608,192,408;40;M
82857;1434,1624,1604,1517,774,1021,129,1,1524,702,1026,1328,16,1468,13;35;M
82871;1517,1330,451,443,1347,702,376;32;M
82886;1482,1026,1359,265,1559,140,1624,1526,1325,1524,776,1509,1532,1468,13;46;F
82910;1706,982,1344,1332,394,1441,774,174,586;45;F
82950;1624,1325,1,1533,1700,702,192;10;M
82966;1624,451,1482,774,1330,1526,1322,776,1388,124,1328,192,265,1451,1510;62;F
82978;211,867,863,860,865;74;F
82984;1624,1526,1322,1325,1416,1700,1328,1359,1468,1559,13,1434,1384;32;M
83067;373,982,995,556,1332,867,863,988,860,865,444,984,17,409,211;41;F
83207;1322,129,982,1533,1524,1532,1026,373,1698,1359,828,1468,22,1559,192;40;F
83254;1524,1328,1330,1322,1,982,776,896,988,16,1468,13,1451,1434,1510;47;F
83363;173,1110,1517,1700,1347,702,1698,16,1468,22,1322,741,1325,982,443;41;M
83374;1624,1604,1325,443,733,16,22,376,2,1314,1441,984,444,13,140;33;M
83396;1633,702,443,1581,1,741,1322,917,268,16,1468,394,13,1451,1510;37;F
83403;1510,1322,982,373,1698,268,22,1517,917,1,702,443,776,16,1468;37;F
83413;1624,1517,826,1,173,1581,1700;65;F
83417;584,733;56;M
83418;443,13,1532,741,774,826,1633,24,1468,1344,1110,1526,1604,1624,16;44;F
83464;776,1509,1532,1328,24,16,1633,1468,140,408,1325,834,1608,1312,586;13;M
83478;265,1608,1359,1328,1026,702,17,1517,451,1021,1325,1,1533,1524,834;39;M
83525;382,512,408;41;F
83545;550,376,140,1510,984,1468,16,733,702,995,982,1338,1119,917,1026;38;M
83591;1581,1,1325,774,1604,1624,1517,741,124,1347,702,16,1468,13,1451;40;M
83594;409,982,988,22,3,984;31;F
83611;1517,451,1,443,1524,702,1026,268,1470,1434,1510;30;M
83643;584,733;45;M
83705;382,741,982,443,896,1532,1347,16,1608,192,265,1470,13,1434,140;19;F
83781;16,1559,13,1510,140,586,1624,917,1325,129,1332,1347,1468,1608;47;M
83818;1509,1581,1526,1517,1624,17,1021,1322,1325,1524,776,834,16,265,1328;41;F
83913;988,373,1698,376,394,1441,1451,140;36;F
83921;1624,1517,1119,1325,1,982,443,1347,702,24,16,1633,1468,984,13;34;F
83926;1624,1604,1110,1509,24,1468,1559,13,1434,995;40;M
83941;984,1434,1510,140,947,659,1482,733,16,376,1451,297,409,982,896;17;F
84015;774,409,1332,896,988,36,1700,373,268,174,984,13,1434,1510,192;42;F
84020;995;41;F
84089;1295,776,1482,36,1347,1698,1359,733,174,1608,376,13,2,1441,1510;73;F
84104;1416,1526,129,1524,1509,1532,702,1026,1328,16,265,1559,1470,13,1434;42;F
84105;1517,1330,1021,1526,382,512,1524,702,1026,1328,1434,1384,408,265;11;M
84131;1700,863,867,443,1581,995,409,1325,451,223,774,1604,1624,982,865;50;F
84153;554,1441,896,776,1322,1338,1517,1604,1314,1468,1700,1524,1344,982,1;27;F
84158;1517,1330,1021,1526,382,512,1524,702,1026,1328,265,1434,1384,408;13;F
84201;443,1532,1509,1347,776,1482,1633,16,1468,1322,774,1344,1110,1314,1451;40;F
84207;373,17,1533,556,1524,376,1700,1026,733,394,1559,984,1451,1434,124;39;M
84219;741,1581,556,1700,373,733,394,2,554,984,13,1434,586;46;F
84249;409,140,568,17,982,211,995,867,863,896,988,860,865,444,984;46;F
84278;741,443,1524,1482,124,702,1026,268,174,24,16,1633,1468,13,1510;33;M
84315;1328,702,1347,1482,776,1524,443,1,1325,1517,1624,741,124,16,376;39;F
84323;1384,1344,556,1332,659,896,988,36,1700,702,373,1698,268,828,174;36;F
84406;373,828,554,1451,1312,1441,17,947,223,409,1295,896,988,376,394;24;F
84426;774,1604,1624,1526,982,1509,1532,16,1608,376,1559,1314,13,1312,586;49;F
84433;1026,702,16,1633,1434,1604,17,1338,982,556,373,1468,376,1624,1110;28;F
84539;1328,1384,1510,1359,268,451,774,1624,443,1344,13,776,1,1330;39;M
84543;947,1344,1524,1332,1468,376,1441,13,1451,140,1;36;F
84548;17,129;45;M
84558;376,2,1434,223,1261,1322,982,896,1482,1532,1700,1026,1328,1698,1559;36;F
84573;984,659,741,774,947,995,863,1532,1347,1468,1624,982,1328,550,554;26;F
84598;211,443,988,1532,192,1314,984,17,659,896,1482,1509,1328,265,1559;38;M
84620;1624,297,1604,774,1526,1110,443,1524,1509,1532,1026,16,1468,13,1451;36;F
84677;1526,982,1524,863,1509,1482,1532,1328,865,22,192,265,1441,1470,984;35;F
84699;774,223,995,1344,443,1700,1347,373,16,1633,1441,554,408,1468,13;52;F
84777;451,982,1524,1026,268,1441;41;M
84780;917,1388,3;54;F
84782;982,2,211,741,1322,1524,988,124,24,16,1633,984,13,1434,140;20;F
84797;1604,741,1110,982,1344,1332,988,659,1347,1328,550,1468,1314,554,1434;56;F
84798;1325,1581,776,1509,1532,1347,1328,268,24,16,1633,1468,1559,1434,1510;53;M
84809;1322,1468,1482,409,443,1347,24,1451,1624,1604,947,917,1119,1344,1;27;F
84830;140,1624,1347,1698,268,733,550,174,16,1468,865,1608,192,1470,13;42;M
84872;1559,1434,982,1533,1344,443,1532;70;F
84894;1322,211,1581,556,1332,1698,268,22,394,2,1441,444,984,1434,1510;50;F
85014;1624,1604,1517,1021,1322,1581,1524,1700,702,1026,1468,265,13,1434,140;72;F
85021;741,1338,774,1604,1624,776,1388,373,16,1633,1468,265,3,1451,408;16;F
85052;1581,1524,1509,1482,16,1633,1468,3,13,382,129,512,776,1700,268;39;F
85079;17,584,774,1526,1322,1325,409,982,443,988,1509,1532,1468,13,1434;36;M
85107;174,1314,1470,140,1559,1700,1388,1532,988,443,982,1325,1706;71;M
85119;265,192,223,947,129,1416,1510,1338,1332,1330,1328,1325,1322;40;M
85128;776,1347,1328,1468,13,1624,774,1,443,1332,394,1314,3,1451,1510;35;F
85137;1526,451,774,1604,1624,1581,1509,1532,1026,1328,268,16,1633,1468,265;31;M
85152;2,982,211,1322,741,1524,988,124,24,16,1633,984,13,1434,140;48;F
85193;776,1581,173,1,1604,1325,129,1332,834,1700,268,174,16,3,13;45;F
85194;1509,443,1325,568,1604,1624,1510,451,1581,1633,1468,376,394,444,3;27;M
85207;1624,1338,1322,129,982,192,444;34;F
85218;741,1338,1119,917,1698,192,376,394,1314,1441,3,1451,1434,1312,1510;38;F
85220;1581,776,1482,1532,1700,16,1633,1468,1608,22,1559,1441,13,1434,140;26;M
85223;24,1633,1314;74;M
85254;556,659,1700,1328,1698,16,1468,376,265,394,444,984,13,1451,1510;44;F
85256;741,1325,982,1344,443,1332,988,1532,1700,1347,373,174,1559;42;F
85267;1338,3,982,1330,451,774,1325,1517,17,741,124,2,13,1434,140;35;M
85280;376,2,211,988,1322,741,1524,124,24,16,1633,984,13,1434,140;48;M
85306;1698,376,394,443,1581,173,982,1338,1021,451,1119,774,776,988,373;38;F
85316;1441,1604,776,268,443,1510,17;37;M
85325;1624,1604,17,16,1468,2,13;48;F
85347;1624,451,1261,1322,129,1581,1332,776,834,702,1559,140,1338,741,124;44;F
85408;1434,1559,268,373,1347,1509,776,1344,826,1330,451,774,17,1624,1510;28;F
85425;17,1,173,1581,1524,1633,3,512,702,1026,268,1517,1021,36,586;26;M
85458;192;44;F
85478;1384,1021,774,1517,1526,1338,409,982,211,995,1332,1524,988,834,22;18;M
85480;129,1,297,1344,1700,16,1633,2,1451,1510,124,741,13,140,443;28;F
85492;192;14;F
85508;17,1295,373,1608,22,984,1312,3;24;F
85519;192;9;M
85561;1604,1021,1524,36,702,1026,1328,1359,24,16,1633,1468,265,1434,140;40;F
85610;223;33;M
85639;947,1119,1338,382,556,1388,1700,373,1698,16,865,2,1441;30;F
85645;373,1482,1338,741,1,776,124,1487,24,376,394,1441,13,1451,140;37;F
85652;1338,451,1624,741,776,124,373,24,1468,376,394,1441,13,1451,140;41;F
85678;1388,1532,1482,834,988,443,1344,982,1110,1325,741,1706,1322,1434,140;45;F
85728;1384,1624,17,917,1338,1322,382,741,1325,1482,1026,16,192,1470,1451;33;M
85747;211,982,947,297,1119,451,1416,1110,173,1524,863,865,1328,1468,265;35;M
85751;1604,1338,376,984,1314,1451,140,1624,826,1509,1700,1698,1468,584,834;22;M
85764;1338,1322,1434,1312,1295,1482,373,16,140,917,1533,1559,1510;21;F
85814;1359,376,394,1441,444;33;M
85822;917,124,1700,1698,16,2,1441,1434,1510,995,1332,22,988,982;61;F
85838;947,211,1347,24,16,1468,376,2,1441,3,13,1451,1434,1510,140;66;F
85864;1624,17,1526,826,1110,1344,443,1347,24,16,1633,1468,394,376,13;22;F
85897;1698,867,1524,995,211,982,23,1,1416,1338,1021,917,947,584,17;25;F
85929;1604,1526,443,1509,1482,1347,1532,1359,1559,13,1451;62;M
85948;1624,451,1325,1581,1388,16,1468,1451,1434;41;M
85995;174,16,1633,394,1510,297,1119,451,1110,173;36;F
86015;1624,1604,17,451,1322,1,129,173,1581,776,1328,373;49;F
86025;1338,1524,36,702,1468;36;M
86066;36,1347,702,1026,1359,828,16,376,2,1434,982,556,1332,1328,265;44;F
86091;444,586,896,1487,1700,702,550,1510,917,1119,863,860,1633,865,192;41;F
86126;1559,1510,776,443,1026,265,1509,1604,1344,1434,1698,174,173,947,373;33;F
86165;1482,556,1581,173,774,1624,451,741,1325,124,1347,24,1468,1314,13;36;F
86177;268,1119,1517,1338,1482,1700,1441,1322,1325,1110,173,443,124,1468,1510;30;F
86185;36,1451,382,512,408;38;F
86188;1261,512;46;M
86209;1604,1325,776,13,1434,140,1624,774,1322,1581,1524,1482,36,16,1468;52;F
86291;917,1581,1524,16;27;M
86292;1468,268,1328,16,1559,1434,1330,451,1119,917,1624,1604,1509,265,13;44;M
86296;1434,444,1416,1533,129,1524,1384,1509,1559;34;F
86298;774,1532,268,16,1509,443,451,1526,1624,1604,1328,265,1559,13,1434;76;F
86335;865,984,1451,140,586;58;F
86339;982,211,1344,443,1332,1482,124,702,22,376,2,1314,1441,3,13;51;F
86355;1,173,1581,1332,1524,988,834,1482,36,702,174,22,1441,984,1434;43;F
86356;1604,1624,1509,1347,1328,1451,1434,140,917,1559,776,443,1110,1322,1526;52;F
86364;1119,23,173,1581,776,1487,1328,828,550,174,376,2,1441,1698,554;27;M
86396;2;33;M
86416;408,1624,223,826,1325,409,1110,443,1295,776,1468,1441,554,1451,140;35;F
86419;1604,1624,774,1110,1344,443,776,1482,1347,268,16,1633,1468,13,1451;57;F
86427;1624,382,512,1468,1451,408;9;M
86444;896,1700,1510,1119,382,443,863,1487,550,860,865,192,1470,408,586;10;F
86491;451,982,1295,988,373,24,22,394,1314,984,1434,1510;37;F
86514;13,1261,129,982,211,1332,867,36,1700,702,733,22,376,1441,984;42;F
86542;1624,17,451,1526,1533,1344,443,1482,1509,1532,1347,16,1468,3,1434;20;F
86547;834,1470,1344,1510,297,1119,1110,173,174,568,995,409,22,984,982;47;M
86563;1332,268,1441,984,1451,586;64;M
86592;1624,1325,1344,1509,1532,16,1468,3,13,1384;26;F
86654;16,1633,1468,22,2,1314,1441,554,984,13,1451,1434,1312,1510,140;50;F
86661;867,863,860,865;58;M
86667;586;25;M
86669;982,409,1261,568,774,947,223,1338,443,828,550,865,1608,394,444;48;F
86679;1624,774,1,443,659,702,828,16,1468,22,376,394,2,1451,1434;46;F
86695;13,394,376,1468,1633,16,1482,776,443,1119,774,1604,1624,373,584;40;F
86715;1261,1021,1533,1524,776,1509,1347,1328,265,1434,1384,1559;39;F
86736;1526,867,776,1532,702,1026,1328,373,16,22,265,1559,1314,13,1434;65;F
86774;22,376,1559,1451,984,865,174,702,443,1110,129,1,1322,1517,1261;54;M
86824;776,1451,1624,774,826,23,1344,443,1482,16,1633,1468,1314,3,13;27;M
86874;659,776,896,826,443,1482,36,1347,1698,268,16,1633,1468,13,1451;27;F
86875;451,1325,982,443,834,124,1347,268,16,1468,265,1559,984,13,1451;22;M
86876;776,1344,173,1110,826,1624,443,1482,16,1633,1468,13,1451,1510,140;29;F
86920;297;38;M
86940;1261;10;M
87031;863,865,860,867;20;F
87132;1604,826,1110,1344,443,1347,373,16,1441,1,23,988,1700,733,1314;32;M
87145;586,451,741,1110,982,211,1344,443,896,863,24,860,376,984,13;55;F
87156;702,174,16,1633,1314,1388,3,1604,1624,774,443,268,1468,13,1451;53;F
87192;17,584,409,982,211,995,867,863,896,988,860,865,444,984;20;F
87193;741,23,982,211,1581,443,268,24,394,984,13,1517,129,124,702;35;M
87205;702,174,16,1633,1314,1388,3,1604,1624,774,443,268,1468,13,1451;54;M
87211;444,13;33;M
87226;1700,1441,1314,13,376,3,2,443,17,896,23,1698,982,1,1633;26;M
87230;1026,1359,265,1328,2,1517,1021,1526,1,1533,1524,702,1261,1441,1559;55;F
87312;1526,1261,1110,1533,1344,443,1532,124,1700,1347,1359,24,16,1468,1559;41;F
87334;774,1261,741,988,828,1468,1441,13;53;F
87344;17,584,947,917,774,568,1526,834,124,1700,1698,192,2,1314,586;28;M
87351;863,988,865,554,13,1517,741,409,982,1332,124,702,24,16,22;34;F
87366;774,1344,1468,1314,13,1624,129,982,268,1510,867,863,865,860,192;46;M
87376;1325,1026,268,174,16,1468,192,265,1559,1314,13,1451,1434,1510,140;60;M
87448;1624,1604,17,1322,1706,211,982,1581,1332,1295,896,192,1314,1441,984;49;F
87473;1581,1700,268,1510,17,1470;66;F
87493;586;34;F
87522;1344,1347,24,1468,17,451,1338,23,1314,1700,1698,22,2,1441,1384;40;M
87528;1110,23,1482,828,24,16,1633,140;39;F
87565;947,1325,741,1,776,36,124,373,24,394,376,192;41;F
87581;1110,776,896,1482,1388,124,373,1698,174,1451,3,443,1344,512,382;36;F
87616;982;65;M
87618;1482,1347,1468,1451,1510,774,1,1110,1344,702,1698,268,828,376,394;45;F
87624;17,1330,982;37;F
87646;444,1338;51;F
87654;17,917,1021,1322,1416,129,1533,1581,1524,1532,1359,265,1441,13,1434;43;F
87667;1624,1604,1482,192;48;F
87677;451,774,1119,17,129,1344,1524,1482,268,174,192,376,1559,3,1434;3;F
87725;1624,1604,947,1322,23,982,1581,1295,867,1359,192,22,394,1434,140;50;M
87728;947,1604,1624,1581,1344,896,988,1434,1312,451,373,174,24,16,192;50;M
87742;982,1524,776,1021,1526,1322,1110,1532,1026,1328,16,265,1559,1434,1384;49;M
87756;140,774,451,826,1110,1581,512,443,1388,268,1633,1468,3,13,1451;63;F
87802;23,1,741,1338,774,947,1624,192;12;M
87810;174,1633,22,1510,1451,1110,982,1344,1332;39;M
87811;512,36,124,702,586;33;F
87837;774,1604,1698,24,1559,1624,1517,556,834,1482,702,373,1468,13,1434;39;F
87857;265,173;32;F
87920;1517,774,192,3,984,1312,1510;8;M
87951;1,1581,512,1344,556,988,1700,16,1451,917,1325,443,1026,265,1434;42;F
88003;173,140,1322,268;57;M
88013;947,1526,1416,1,1524,1509,702,1026,1698,1359,16,1559,2,1441,13;30;F
88104;1604,1517,1526,1706,982,173,1524,1509,702,1026,1328,1468,1559,1434,984;49;F
88110;1332,1604,1624,584,129,1482,124,1700,1698,865,192,394,1441,554,1510;38;F
88151;554,1314,1559,394,265,376,22,1328,443,1344,1,1526,451,1604,1624;30;F
88158;1338,1416,1,36,1026,702,373,1698,865,376,394,1441,984,13,1384;33;F
88160;1624,1110,1344,776,1482,1347,860,16,1633,1468,376,1314,13;23;M
88196;173,1344,556,1532,1559,984,1517,1021,982,1524,1509,1700,1347,702,1026;52;M
88284;512,1700,373,1359,16,1633,1468,865,192,265,1470,13,1434,586,140;44;F
88295;1119,1338,1322,1325,1581,776,702,373,268,1468,1441,13,1434,1510,140;66;F
88318;776,1526,451,917,1604,1624,826,741,1344,1633,1581,443,124,24,586;36;F
88364;373,1295,1581,1624,826;49;M
88384;394,1559,2,1314,1441,984,1510,140,13;21;F
88414;1344,774,1110,443,1482,1347,702,268,16,1468,1608,376,2,1441,13;36;F
88481;1624,17,741,1325,124,24;33;F
88483;1482,1624,1604,774,826,1322,741,776,702,174,24,16,1633,1468,13;31;M
88491;741,826,1526,774,702,17,1624,1295,776,1509,24,1633,1468,444,13;32;M
88501;1119,988,36,550,733,16,140,1510,702,268,173,1517,1524,1388,451;33;M
88502;1604,1517,917,1330,451,741,982,1344,776,124,16,1468,3,1434,1451;29;M
88511;1338,1,556,776,1482,36,124,1608,1441,1434,373,1698,828,860,1451;45;F
88527;223,1330,129,982,1344,443,988,1328,1468,22,376,265,444,984,1510;40;F
88536;1021,1526,1325,1533,1509,1532,702,1026,1559,13,1434;22;M
88537;826,1581,1295,1388,373,376,1314;18;M
88545;1119,1344,1332,1698,1510;36;F
88617;192;46;M
88642;129,1468,192;51;F
88653;1604,1633,1510,1110,1322,36,373,16,1,211,443,24,1468,1608,140;45;M
88682;173,174,394,1347,1344,1110,1119,297;39;F
88689;1344,1482,1532,1700,702,1328,1698,1359,268,1468,1559,1441,13,1434,140;48;M
88706;1482,1532,124,1347,702,1026,174,24,16,1633,1468,2,13,1434,140;39;M
88822;373,192;9;M
88835;1261;51;M
88897;408,140,1384,1510,1441,265,1532,1509,1524,982,1416,1338,1468,268,1526;41;F
88901;1700,16,192;38;F
88921;826,1706,1344,776,1482,1532,1347,1633,1624,1604,1110,268,1468,1451,1510;46;F
88946;1624,1468,265,1314,13;38;F
88986;867,863,860,865;21;M
89054;1624,451,1338,1325,1,1581,1344,1524,834,1347,1026,16,1468,192,13;43;F
89057;173,1110,1119,36,1517,1021,1,1524,702,1026,1328;38;F
89074;741,124,2,1441,1434,1533,982,1325,1322,223,947,702,1517,13,1;36;F
89120;13,1388,373,268,1,443,376,3,1451;34;F
89123;1332,1344,995,982,1110,1322,451,774,584,17,1624,376,394,554,1434;36;F
89130;1110,443,659,776,988,1482,16,1468,376,1559,554,3,13,1451,140;20;F
89139;867,512,1533,129,1325,1706,1322,223,1604,1624,1468,13,1434,1526,1261;42;M
89176;1110,1517,1119,1021,1,1524,36,1328,702,1026;6;F
89214;774,1624,917,443,1388,1347,1698,268,1468,1608,22,1314,1441,984,13;37;F
89220;1322,1,1110,1581,776,828,1468,1314,1451,1434,140,443,36,702,16;51;F
89239;1624,917,1517,1119,1021,1,1110,173,1533,1524,36,1328,702,1026;14;M
89312;584,947,23,995,863,1698,373;38;F
89350;776,1482,1026,24,1633,1314,1441,13,140,1322,1,36,702,16,1468;53;M
89352;860,865,409,1110,22,1344,863,988,373,24,16,376,13,2,1451;7;F
89367;1468,376,394,1441,1434,1624,1517,1119,1110,1581,124,702,24,865,586;49;M
89391;1624,984,774,1110,982,1344,443,867,1509,1532,1487,1347,16,13,1451;54;F
89393;1021,1526,1322,1,982,1524,1509,1532,1700,1026,1359,265,1559,1434,1384;14;F
89414;192,1314,13,140,408,1470,1312,1021,1416,1524,1700,1026,1328,265,1434;49;F
89449;2,376,702,1700,1332,982,1,1325,917,1633,192,13,1510,1434,140;38;F
89459;995,409,1322,451,947,223,1700,1698,1359,1468,192,2,1314,13,1434;59;F
89488;211,774,982,1344,443,1026,865,376,265,1559,1441,444,984,13,1434;39;F
89502;984,1510,408,140,373,1347,1344,982,1110,1,223,774,947,1604,1624;53;M
89604;1624;44;F
89606;1581,1344,1388,1347,702,376,265,1328,24,16,1468,13,1451,1434,140;35;F
89631;1434,1344,1470,1322,1325,129,268,1021,173,265,1624,16,1468,1451,443;37;F
89660;1338,988,1698,192,1314;63;F
89665;995;58;F
89671;1624,17,947,774,211,1332,863,373,733,16,1468,376,2,1441,1510;49;F
89675;1295,947,1416,1,1700,1608,1441;51;F
89741;1322,1110,1581,776,1468,1559,13,443,1344,1332,1532,1604,1526,1509,1434;37;F
89757;1533,1524,1509,1624,1322,1482,702,826,443,16,13,1434,1510,776,1633;21;M
89827;584,947,1526,1322,1416,443,556,1532,1026,373,550,376,1559,1441,1434;76;F
89846;1517,584,774,1021,1526,1261,1524,776,1509,16,265,1559,13,1434,140;16;M
89868;1624,917,1119,741,1325,129,173,776,124,174,24,394,984,140;41;M
89870;124,1328,16,140,1482,443,1,1325,741,17,702,1026,373,3,1451;30;F
89877;947,917,129,1581,443,1700,1347,1328,1359,1468,265,376,2,1314,1441;68;F
89879;1021,451,223,1119,1261,1344,556,1524,1026,1328,376,265,1559,13,1434;41;F
89885;1608,211,867,124,1700,865,1441,947,917,1322,776,16,192,1314,1510;46;F
89975;443,1347,140,1451,13,984,16,24,373,702,124,988,1332,741,1434;53;M
89989;984,988,1517,1608,702,24,140,1338,443,124,741,982,1332,22,1624;40;F
89994;129,173,1344,834,124,373,174,24,16,1633,1314,444,984,1434,1510;39;F
90003;192,1021,834,36,568,860,865,1608,394,1384,947,1416,373,1441,1261;39;M
90006;192,22,1314,13,3,984,1451,140;24;F
90010;1517,917,1021,1325,1,512,1524,36,702,1026,1328,376,265,1559,1434;40;F
90022;1330,774,16,1624,451,1526,1344,443,1347,1328,1468,265,1559,13,1434;46;F
90072;1119,512,1295,1700,174,16,192,1314,984,444,1434,1312,1384,408,1470;10;M
90099;1624,1119,1,409,982,995,988,1700,702,1026,1441,1510;36;F
90131;1559,982,1344,1110,443,1533,774,13,1468,1314,140,1347,1338,1325,16;32;M
90140;1533,1581,443,1295,702,1328,1359,16,1633,865,265,554,1451,1434,1312;34;F
90145;554,1312,828,373,988,896,863,867,1295,556,443,1322,451,584,394;35;F
90185;741,1295,124,702,1451,140;42;F
90220;1517,1119,382,1325,129,512,1295,834,1700,373,174,1559,1441,1434,408;18;F
90234;23,174,1633,1468,394,1441,1510,1624,1119,451,826,1,129,1434,140;33;M
90252;774,947,1,1332,1700,373,376,2,1441,444,984,13,1312,408,586;49;F
90255;376,1451,1332,1344,268,1119,173,982,984,2,860,867,409,568,995;40;F
90264;17,1384,984,394,1359,1026,1700,1532,1509,988,512,1581,995,173,1261;11;M
90276;1533,1581,36,16,2,1,17,1261;42;M
90281;1509,1532,1347,1559,1314,13,1624,451,1344,1332,776,24,16,1633,1468;35;F
90299;1026,1509,16,1434,1517,13,982,702,1119,174,1344,443,1021,741,1;36;F
90307;776,1533,173,1325,1706,1322,451,774,17,1517,1624,1328,1330,265,1434;43;F
90309;988,984,17,774,776,268;63;F
90312;776,1110,982,1119,1624,1517,451,1,1524,1347,1328,16,265,13,140;35;M
90351;1700,1533,1,1416,1338,1021,947,17,1261,129,834,1698,265,1451,1384;34;F
90352;1328,1359,550,192,394,1441,554,1434,1322,1021,568,129,1581,265,1470;38;F
90369;1021,1,23,1533,1524,1482,1347,702,1328,16,1468,1314,13;34;M
90379;1624,826,1581,1295,1388,373,376,1314,1441,1312;30;F
90388;1698,1468,140,1624,17,1338,1322,741,211,556,124,1700,702,373,24;55;F
90402;17,947,1416,129,1332,995,556,896,1698,733,1559,2,1441,984,1384;49;F
90408;1509,834,826,1526,1021,1604,1624,1517,1,1524,702,1026,16,1633,1468;33;F
90443;1624,17,947,451,1322,1,982,1388,1026,1698,16,2,1441,3,13;48;F
90444;1624,826,1581,1295,1388,373,376,1314,1441,1312;32;M
90453;1517,1021,1,129,1524,702,1026,1261;57;M
90483;1312,408;43;M
90492;173,512,1295,1700,174,1470,444,984,1312,408;8;M
90493;376,1314,1451,140,1344,1624,774,1526,776,1347,24,16,1633,1468,13;24;M
90515;129,1524,834,1388,1026,1328,268,550,24,1633,376,265,2,984,3;47;M
90524;1,173,1524,1509,1532,1700,1026,268,174,265,1559,1470,1434;33;M
90547;1624,1517,1021,1,1344,443,1524,36,1347,702,1026;76;M
90570;17,774,776,36,268;71;M
90617;1338,1,1524,124,16,192;43;F
90687;1468,1026,1482,1524,1344,1021,223,1119,1517,1604,1624,512,382,1700,408;41;M
90694;17,1325,1,129,1344,776,834,1700,1347,702,550,174,24,16,586;41;M
90714;409,1110,982,13,1021,776,1482,451,1,1624,1359,268,174,16,1633;26;M
90723;1624,1322,741,124,1700,24,16,1633,1468,13;16;M
90724;1322,1110,1344,443,1509,1482,1388,268,174,1468,17,16,776,13,1434;20;M
90778;1434,1533,265;35;M
90787;917;45;F
90801;373,1698,733,16,1468,865,22,376,394,1559,2,1441,554,984,13;44;M
90812;17,1624,1021,826,373,24,265,140,867,834,1700,1328,192,376,394;39;F
90820;1581,443,863,1700,702,1698,174,1468,865,394,1441,554,984,13,1510;72;F
90864;741,1,173,1581,1344,443,834,124,702,828,24,1468,3,1434,140;30;M
90867;776,1332,443,1510,268,17;36;F
90869;1624,1604,917,774,1581,776,1482,1347,373,16,1468,376,1314,984,1451;46;F
90904;382,1,129,13,1312,174,896,124,556,409,173,1295,554,1441,1451;24;F
90926;1468;48;M
90951;1624,774,776,1698;48;F
90955;947,1698,1441;45;F
90966;443,1698,174,22,376,394,1441,444,988,984,1325,982,211,995,268;46;F
91021;1633,1468,22,1314,774;51;M
91028;1,1482,1624,774,776,16,1468,265,140,1441,13,1451,1604,1322,1581;52;M
91049;1470;41;M
91065;826,1325,1624,1604,16,1347,982,995,776,988,268,1633,13,1434,376;14;F
91071;1581,444,512,865,982,268,550,733,1608,192,1510;36;F
91095;1700,1119,451,1021,1322,173,1524,776,1532,192,265,1559;30;F
91100;1604,774,1,173,1344,1332,776,36,1347,1698,174,1633,2,1441,13;28;F
91130;512,173,1,1325,1322,1338,1119,1517,1624,382,192,1441,3,1295,1470;12;M
91205;982,988;53;F
91206;1517,917,1322,1325,1581,1482,702,192,984,1510;39;M
91225;512,1581,1325,382,1322,1517,1604,1624,1347,702,1468,192,376,3,140;43;M
91227;1434,1468,1509,1581,1261,1624,1517,1021,1526,1524,1700,702,1026,1328,265;43;M
91261;17,1604,1700,702,1026,1698,22,192,265,1559,2,1441,1434,1312,140;62;F
91282;192,1633,268,741,1706,1119,1517;34;M
91291;1517,1119,1021,1,1110,173,1524,36,702,1026,1328;11;M
91293;774,1322,1325,776,1482,268,1434;63;M
91324;1451;51;F
91391;982,1312,741,173,443,1332,1482,1359,268,22,376,140,13,1434,1451;26;F
91398;1021,702,1026,1359,828,1633,1468,1608,192,376,984,1434,1312;44;M
91450;1624,451,1526,1332,1509,1532,1468,22,1559,1510;42;F
91459;1517,1581,1384,1338,556,1332,124,1700,373,1698,828,733,16,376,1510;56;F
91464;1624,1517,1119,1524,702,16,1633,1468,192,13,586;31;M
91487;1517,17,917,741,1325,1,173,1581,512,556,1524,268,174,1441,1434;20;F
91492;1482,776,1344,1,1322,947,297,1624,17,774,1295,268,13,1510,140;37;F
91524;1021,1526,1261,1533,1524,1026,1328,1359,265,1559,13,1434,1384;10;F
91530;1624,1344,1347,1314,13;33;M
91543;1021,1526,1322,1,173,1524,776,834,1482,1532,1700,702,1026,1328,174;39;M
91559;17,1526,1322,129,1532,373,1698;41;F
91567;1021,1261,1533,1524,265,1559,1434,1384,586;4;M
91569;512,1700,373,1698,1359,192,394,1470,1434,408,1604,917,1322,382,129;45;F
91574;192,1314,1451,776,1482,1328,265;39;F
91592;1698,17,917,1526,982,1524,1509,1532;53;F
91635;1332,867,863,988,1698,550,192,1470,409,982,860,865,22,444,984;52;F
91642;140,1384,444,1559,174,733,550,1026,1532,776,1524,173,1325,1261,1700;43;M
91667;1322,826,774,1604,1624,1325,776,1482,16,1468,13,1451,1434,1510,140;27;M
91676;409,988,984,982;59;F
91723;1604,1524,124,1026,1359,268,1633,1470,1468,16,13,1434,24,1517,702;34;M
91740;376,1581,1110,129,1,1325,382,1261,568,917,947,1517,17,297,1470;50;F
91758;1533,1532,1700,1559;38;F
91807;702,1532,443,917,1330,1,776,140,834,173,1325,451,17,16,1510;28;M
91823;192;8;M
91835;917,451,1700,373,1698,16,1633,376,394,1559,1441,1451;25;F
91848;1624,17,1322,1325,1581,776,124,24,16,1468,376,13;50;F
91859;1322,1325,1581,443,776,1482,1347,16,1633,1468,2,1451,1434,1510,140;40;M
91887;129,1325,451,1510,297,1119,1110,173,174;33;M
91899;192;11;M
91902;192;70;M
91906;1698,1434,408,917,826,1322,1325,1581,512,1388,1700,376,2,3,1451;35;M
91908;1624,1517,1344,776,1347,702,1026,1328,24,16,1468,265,1314,13,1434;30;F
91910;1119,129,173,1698,174,1608,192,376,1470;30;F
91989;211,1533,512,1524,896,834,1026,268,702,24,22,1470,984,1510,1384;42;M
92003;834,1700,1021,1338,1026,1517,36,702,192;46;F
92018;192;39;M
92054;129,22,984,17;44;F
92055;1526,1416,982,211,867,988,1509,1532,373,550,733,1559,2;43;F
92065;741,409,982,995,1332,867,988,1487,860,865,1608,22,1470,444,984;26;M
92070;1344,1332,1295,22,984,1312,192,174,988,568,373,24,1468,2,444;40;F
92091;1434,1526,1,1532,1700;74;M
92094;584,733;52;M
92128;1700,1347,1698,24,16,1633,1468,865,22,192,1559,2,1441,1434,1510;31;F
92134;982,1524,702,733,376,265,394,3,1384;39;M
92147;774,1322,373,174,1633,1608,192,13,1510,1624,17,124,1698,1314;48;F
92156;774,1322,1,1509,550,265,984,1451,1434,1526,129,1328,1559,1384,554;46;F
92177;17,1332,1359,1700,1526,1021,1119,1517,1624,265,1384,1559,2,1434,1261;47;F
92194;17,774,23,443,124,1347,702,776,268,192,2,1314,1441,13,140;72;F
92209;1624,1517,826,1110,443,1332,1524,702,1633,3;37;M
92256;17,1581,1344,1482,702,1026,174,2,268,16,192,376,1451,140,3;35;M
92263;17,1325,443,1332,1295,834,36,268,733,865,22,1441,13,1312,1510;45;F
92325;1338,1322,1110,443,1532,1700,1026,1698,1633,1468,1559,1314,13,1451,1384;16;M
92330;1119,1604,917,1706,1325,443,1332,1388,268,865,1608,3,13,1451,586;59;F
92338;1344,1347,733,1470,13,1510,1119,443,1332,1700,174,16,1468,1633,192;35;F
92375;1624,947,223,741,982,36,124,702,1698,24,1608,192,13,1434,1510;38;F
92401;376,1441,13,451,1322,409,556,867,863,988,1700,373,1698,1312,1434;62;M
92441;774,826,1344,443,867,776,1509,1482,1347,373,268,16,1468,1451,13;49;F
92465;896,776,17,584,1322,982,211,995,1482,268,265,1441,1434,1510,140;37;F
92507;1021,1509,733,982,1533,1524,1532,702,1026,373,1359,1559,444,984,1434;44;F
92564;863,659,443,1533,995,409,1325,17,584,947,1119,568,223,1526,1261;9;F
92572;1517,1526,382,1110,1524,776,1633,1468,265,1434,1021,982,702,1510,408;31;F
92593;22,376,554,984,13,140,408,1624,443,776,268,16,1468,3,1451;40;F
92617;409,982,995,1332,867,863,988,1487,550,860,865,22,554,444,984;81;F
92623;1,1325,1526,917,17,1261,1509,1532,702,1026,376,265,1559,1434,1384;71;M
92634;16,1633,1468,376,265,1314,984,3,13,1451,1510,140,1624,774,373;23;F
92753;774,1325,211,22,1434,17,982;48;F
92760;995,1624,17,774,1581,1344,443,373,16,1633,1468,22,192,13,1451;38;F
92782;1325,223,568,1322,129,1344,443,1295,984,1700,373,1698,550,865,192;40;F
92801;917,1330,1322,1325,1328,16,1468,265,13,1434;32;M
92811;1119,451,129,173,1344,776,1482,1468,1451,443,1347,1698,16,376,3;39;M
92878;1517,1,982,443,702;41;F
92888;1624,774,1021,1526,826,1533,1524,1509,1026,1328,1468,192,265,1510;39;F
93012;1026,140,1510,1021,917;33;M
93026;776,774,17,268;76;M
93033;1325,1338,17,1624,443,733,16,376,2,3,13,1451,774,451;34;F
93059;1700,1328,1359,265,140;42;F
93071;17,451,1110,982,173,867,1700,1328,1698,16,22,265,1559,1441,13;29;F
93091;1434,140,1510,443,982,1526,1026,1509,1021,265;32;M
93121;982,173,1332,988,268,1434,1526,1322,1416,443,376,2,1441,1451,1510;30;F
93130;17,774,1322,982,1581,776,834,1700,1698,268,1633,376,394,3,1312;44;F
93147;192,1624,17,774,982,443,1295,394,2,1314,1441,984,13,1312,140;45;F
93164;1468,1441,3,1434,1510,1526,776,917,1330,556,1328,1359,16,265,1451;56;F
93169;860,995,982;79;F
93180;1624,451,1338,826,1,1532,124,1347,1328,1633,192,1559,1314,1470,1510;19;F
93190;17,917,1119,451,1581,443,556,1295,988,1698,1359,2,1441,13,1510;57;F
93237;984,174,451,223,1517,1624,1338,741,1,373,1698,24,22,376,3;25;F
93282;1624,1526,1328,1119,1110,1021,776,774,451,268,265,174,173,16,13;40;M
93303;443,1581,1698,192;39;F
93307;1532,776,512,1533,1517,1604,1021,1526,1325,129,1581,1524,1328,1359,1470;35;M
93319;17,1624,741,23,173,702,1314,1451,140;29;M
93347;947,1338,1,982,1581,556,776,36,1487,1328,1698,22,394,1441,13;57;F
93353;1338,17,1526,1416,1,1524,834,1509,1532,1026,373,1698,1559,1441,1384;44;F
93366;867,174,16,1468,865,22,192,265,394,2,1441,13,1451,1434,1510;33;F
93367;1624,1604,1517,741,1581,443,124,702,373,24,16,1468,13,1510;25;F
93368;1021,741,1,124,1700,702,1698,1633,1338,826,1581,1532,24,2,1441;54;F
93390;1110,1388,373,174,860,192,554,1451;33;F
93448;1698,22,140,382,451,774,1624,741,776,1700,1347,1468,192,13,1434;44;F
93470;1482,1510,140,1624,223,1487,1359,174,1608,192,265,394,1314;41;F
93517;1322,982,1581,1388,1700,702,828,16,265,1434,1510,140,408;54;F
93524;1330,451,1322,173,1524,1700,702,1328,174,16,1468,265,1434,13,1451;35;F
93547;867,860,984,982;79;M
93550;1526,776,1509,1532,1328,16,1468,1559,265;40;M
93555;1344,124,382,741,23,373,1359,376,1470,192,129,1441,1434,1312,140;49;M
93580;1510,1604,17,774,1624,741,1,23,982,443,702,268,24,16,376;47;M
93584;1624,826,1388,1581,1295,373,376,1314,1441,1312;41;F
93619;774,451,409,776,1532,1698,733,16,1559,1384,1468,1328,443,376,982;36;F
93627;129,297,917,443,896,1509;48;F
93640;1119,1510,1604,1633,1328,1325,1344,776,24,16,1468,1559,268,451,1314;39;M
93655;1559,1314,741,1604,1624,774,1325,1110,443,1347,16,1468,1451,1434,140;34;F
93700;1325,982,834,265,1434;45;F
93748;556,373,376,1441,13,140,1312,129,1332,1700,1698,1359,16,265,192;48;F
93783;1325,1,173,1581,1524,776,1509,1347,1026,16,1633,1468,13,1434,140;30;M
93795;1482,1322,1706,1110,982,443,867,776,1347,1698,16,444,13,1451,140;22;F
93799;211,1581,443,1700,16,984,13,1434,1510,1524,1026,1021;29;F
93848;1110,211,1026,1312,984,702,834,1581,173,451,1021,1,982,1332,174;45;F
93853;17,1517,774,1338,1325,1416,1,129,1110,173,124,1700,1347,1482,702;31;F
93859;584,917,568,173,1581,512,556,1295,896,834,1700,1698,174,376,1434;25;M
93860;556,1524,1295,988,1698,984;48;F
94003;1441,376,1468,16,1026,702,36,1482,776,1524,1110,1021,917,1517,17;31;M
94014;568,129,982,988,860,444,984;38;F
94031;140,17,1624,982,995,1581,1344,1332,867,1482,16,22,192,444,1434;38;M
94049;1624,982,834,1388,1468,1451;15;F
94053;17,917,1526,1338,1322,1416,173,1509,1700,16,376,1559,1441,13,1384;43;F
94065;1624,584,1322,173,1344,1700,1468,776,1328,16,865,13,265;29;M
94080;1624,774,1344,776,1482,376,394,13,140;44;F
94089;988,1509,124,1347,1698,24,1468,1441,140,174,1624,1604,17,451,16;67;F
94125;1451,3,1314,1468,451,1322,1706,741,173,1482,124,1700,174,24,1633;29;F
94131;1338,382,512,1700,408;41;F
94137;1338,1517,17,1604,23,1344,1509,124,1700,702,1328,16,1468,444,1384;22;M
94178;1604,451,826,1325,1110,1581,443,1482,1347,1698,1633,1468,984,1434,1312;44;F
94188;297,17,409,129,896,988,1532,376,554;23;F
94190;774,584,1604,1624,17,947,223,1325,834,373,16,586,1441,2,394;39;F
94195;192,1470,373,1604,1261,1322,1325,512,1332,1700;54;M
94215;174,24,16,1633,1468,22,192,265,394,1559,2,1314,1441,1451,13;29;F
94217;917,947,451,382,129,173,512,1700,1698,174,865,265,1441,1510,408;33;F
94220;774,947,1624,1119,826,1110,776,1509,1482,1344,1347,16,1633,1468,376;39;M
94248;776,1434,1451,13,1441,1314;49;F
94281;265,1434,13,1468,16,1359,1509,443,1110,1,741,1325,1526,917,1021;47;M
94301;774,17,394,13,1451,1510,373,268,828,733,16,1468,865,376;49;F
94306;443,13,1470,2,1633,16,1532,1581,1110,1,1624,408,1441,834;37;M
94316;1526,826,1,1344,443,1524,1633,13,1434,1581,1700,16,265,140,586;37;M
94320;451,1261,1110,173,443,1347,1451,1624,1468,1314;27;F
94361;1604,1119,568,173,1533,1581,512,1295,1312,1434,2,1700,373,1698;27;F
94366;1482,1604,1312,1295,984,1332,1451,3,776,1344,268,36,1510,17,443;34;M
94385;1384,265,586;32;F
94402;1347,24,16,13,140,1604,917,1322,1,512,1344,702,192,1314,1434;45;M
94405;17,947,373,733,16,376,394,1441;25;F
94422;1119,917,1524,776,1482,1532,1700,1328,1633,1468,22,265,1559,1314,408;19;M
94430;1441,394,947,373,1325,1482,16,13,1633,443,376,1,3,1510,140;34;F
94539;211,982,1110,1,1322,826,1526,451,774,947,17,1624,556,1332,174;44;F
94554;947,1624,17,1482,1698,268,1468,1441,1434,140,586;55;F
94569;1388,1487,373,1698,268,16,865,376,265,1441,3,1451,1434,1384,140;23;F
94629;1312,140,23,129,1322,1261,1526,223,733,192,394,443,702,1468,1510;37;F
94641;1322,774,1517,1624,826,1325,1,1581,867,776,1700,373,1698,1468,3;47;F
94669;702,1328,1698,268,1524,1532,1026,16,1559,1441,3,1451,1510,1384,140;45;F
94688;3;28;F
94715;1314,16,192;45;F
94718;1624,1021,1526,1322,1,1533,1524,1509,1482,1532,1559,2,13,1434,140;34;F
94746;556,1532,1700,1026,860,865,376,394,1559,3,13,1451,1434,1510,140;45;F
94756;1700,702,1026,1328,1359,174,24,860,16,1633,1468,192,265,1470,1434;14;F
94810;173,512,834,174,408;52;M
94811;297,17,917,409,896,988,1509,1532,1510;47;M
94852;1526,1624,982,1533,1581,1509;54;F
94880;1524,1633,192,265,1559,1624,1330,451,1526,1325,124,13,174,1110,1328;29;F
94944;1468,1581,995,1624,917,443,1482,1700,1698,268,1633,22,1434,140;19;F
94993;1026,702,1517,774,451,826,1,1110,443,1524,1328,16,1633,1468,13;41;M
94996;1110,1344,174,192,1470,265,1026,1526,1021,1517,1604,826,1581,1468,1608;35;M
95062;917,774,1338,1581,1344,443,1332,1295,1700,1347,1698,268,1468,13,1451;47;F
95079;17,556,776,896,1700,1698,1468,376;29;F
95093;173,124,1608,1328,1509,776,1110,1526,174,16,1468,265,3,13,1451;47;F
95118;1510,1441,376,1468,1332,1322,982,896,1633,22,192;50;F
95141;17,917,1338,1325;26;M
95148;129,702,1,1325,1021,223,1359,1312,140,1581,1533,982,1322,1026,192;45;M
95184;373,1698,860,394,1314,1510,140,947,211,1487,1441,444,17,568,984;46;F
95188;1026,702,1347,36,834,1524,1332,173,982,1,741,1706,1517,1604,1624;72;M
95244;896,1608,2,444,1312,1384,586,741;15;M
95269;1509,1532,17,1526,1021,1,1524,828,373,1559,3,1384,265,1328,1330;33;F
95297;1624,1322,741,173,1509,1328,1468,13,1434;54;F
95321;451,1330,917,297,1322,173,1533,1524,702,1026,1359,376,1559,13,1434;19;M
95344;702,1347,1388,124,1482,776,443,1344,23,1,741,774,1517,1624,1706;33;M
95350;173,24,865,394,586;45;F
95359;16,1470;36;F
95366;1110,1581,1524,1482,36,1347,1698,373,1633,192,1314,1470,13,1451,408;8;F
95441;376,1468,16,1332,1338,1526,1330,1624,1322,1,1451,982;37;M
95457;192;44;F
95498;1524,36,124,1347,702,1026,373,1698,1633,1468,192,1314,1470,13,408;42;M
95500;774,982,173,1581,1332,1468,376,265,140,17,1325,1482,1328,16,22;45;F
95517;1526,1509,1532,1347,16,1468,1559,1451;39;F
95534;268,265,444;27;M
95631;173,24,865,394,586;10;M
95638;140,409,211,556,867,1487,1698,192,376,265,1314,444,1434,982,984;14;F
95644;1119,947,584,17,568,223,1338,556,373,733,2,1441,554,1451,1698;44;F
95647;828;22;M
95670;826,382,1633,1624,1581,512,1344,443,834,1700,174,16,13,1312,408;49;M
95709;1325,1624,451,1322,1110,173,1532,1698,174,16,1559,1119,1700,1434,265;37;F
95766;173,24,865,394,586;8;M
95769;1314,1468,1344,1322,741,896,834,1700,376,394,2,3,1451,1510,1384;49;F
95797;129,1700,865,192,140;57;F
95800;223,1021,1325,211,995,1533,1581,1332,1524,1482,36,702,1026,1359,13;47;F
95804;1338,382,1,1581,512,268,1700,1698,22,1470,1451,1624,16,13,1517;39;F
95830;1330,774,1604,1624,1517,451,702,1026,1328,16,1633,1468,984,13,1434;37;M
95872;173,24,865,394,586;18;F
95930;774,1344,1110,443,776,1509,1532,1347,24,16,1468,1559,1314,13,1451;29;F
95932;17,1322,443,1524,1509,1388,1359,1559,1441,554,3,1434,1510;40;F
95946;173,24,865,394,586;47;M
95966;1559,774,1330,451,1344,1509,1700,140,1624,1604,1347,24,1468,13,16;24;M
95978;1624,584,1119,129,982,1332,1698,733,16,865,1608,22,265,376,1510;39;F
95981;1021,1526,129,1524,863,1509,702,1026,265,174,860,1468,865,376,1434;38;M
96001;826,1110,776,1482,1328,16,1468,376,1314,13,1509,1633,1451;19;F
96010;982,1581,556,659,834,124,1700,702,373,1633,1468,394,1441,984,586;40;M
96014;140,13,1524,1517,1325,1,1482,1700,702,1026,1328,268,16,1608,1510;27;M
96015;776,1604,774,1509,1526,1624,826,1581,1295,1388,373,376,1314,1441,1312;51;F
96092;1700,702,268,24,1314,1517,1344,443,124,1698,16,13,1451,1434,140;36;M
96100;917,223,741,129,982,1698,22,586;35;F
96122;774,1468,376,23,982,211,443,556,1347,550,16,1633,984,13,1451;53;F
96142;1119,1526,1325,1509,36,1532,702,1026,733,174,16,394,1559,376,1434;43;M
96143;22,373,268,129,1434,140,1510,702,1332,1581,211,826,1;46;F
96146;917,1322,741,1325,1,173,1581,1524,124,702,2,1441,1434;39;M
96167;1633,1468,192,265,1314,1441,554,444,984,3,1451,1434,1510,140,586;26;F
96251;1119,1533,1328,1359,1434,1384,917,223,1261,1325,265;44;F
96252;1624,1700,16,376,13,408;28;M
96265;917,1338,1325,1581,556,867,124,828,733,2,1441;31;F
96276;1344,443,556,1524,1295,834,1509,1482,1532,1700,1328,828,1468,1559,1441;46;F
96281;1119,1624,826,1295,124,1347,1328,24,16,1633,1468,394,1559,2,13;41;M
96293;192,1510,1434,13,984,174,268,373,1700,36,988,896,1332,409,774;45;M
96300;409,1706,1325,1322,129,982,211,995,1581,1332,867,988,1487,22,984;63;F
96306;211,1344,988,1482,1700,1026,373,268,1633,1468,1608,265,3,13,1451;37;F
96324;1330,1021,1526,173,1509,1482,1532,1328,1026,1559,1359;60;F
96335;1,826,1330,1434,265,1468,1328,1026,1532,1604,1021,1533,1524;40;M
96338;1021,1581,443,1524,1347,1328,24,16,1468,376,265,394,1559,1451,140;38;F
96356;1624,451,1526,1,443,1509,1532,1347,1328,16,1468,376,1559,1314,13;29;M
96393;1517,1,1524,702,1026,174,13;47;F
96405;1482,1624,982,211,1344,988,1347,1633,13;36;F
96413;174,17,1119,451,1338,1110,173,1700,1698,16,1608,408;36;F
96478;512,834,1482,1388,1700,16,1468,865,376,1441,444,3,1451,1510,140;22;M
96503;192;6;F
96576;173,1434,140,702,1633,1325,1624,1604,1110,1482,16,1468,13,776,1510;51;M
96580;192;7;M
96587;1344,1524,988,1509,1532,1487,1700,702,1026,865,1559,984,1434,140,586;36;F
96620;409,982,173,995,1332,776,268,1633,1468,865,22,984,3,13,1510;33;F
96631;1526,1509,1532,1700,268,16,1633,1468,1559,13,1434,140;53;M
96634;1700,1633,2,13,1434,1312,1510,1624,17,1706,982,1332,444,512,408;46;F
96659;1624,1604,1581,443,1344,1468,776,1482,1347,268,1633,3,1451;27;M
96667;1624,863,1312,1604,917,982,1581,1295,192,1314;46;F
96698;1624,1604,741,1325,1344,443,124,373,24,16,376,394,1451,1434,586;50;F
96737;1,982,211,1332,863,1482,268,174,860,16,1633,376,554,984,1510;40;F
96741;550,444,13,17,584,917,1322,409,1581,733,22,2,1434,1510,140;20;M
96750;556,867,1328,1517,1526,1110,1608,702,1482,1532,1700,1347,1698,1633,1434;23;F
96765;192;41;M
96780;376,1347,1332,1581,1624,774,1322,1325,982,988,22,13,1434,1510,140;62;F
96810;1524,1344,1581,995,211,23,129,1,741,1325,382,1338,1526,223,702;27;M
96814;23,982,211,867,776,268,988,1482,124,1347,1328,16,1468,984,13;80;F
96836;1328,394,1526,1524,834,1532,702,1026,1359,265,1559,1441,554,1510,1384;36;M
96858;1,1524,1482,1517,702,16,1468,13,1434;34;M
96895;826,1468,1517,1026,1,129,1524,702,36,1451,268,1510,1344,776,1482;46;F
96947;1517,947,1119,1,124,702,2,1441,3,13;38;F
96948;408,268,865,192,22,1559,1624,211,1581,867,659,1700,1633,1468,140;20;M
96978;265,1434,1510,140,1526,23,1533,1524,1509,1532,1700,16,1468,1559,1441;34;F
96991;741,376,1110,1344,443,1482,1347,268,16,1633,1468,1314,13,1451,140;46;F
97026;1314,13,1344,1110,1604,140,1482,774,1624,443,776,268,16,1468,1451;36;M
97070;382,1110,982,173,512,174,1633,22,192,1441,1470,444,984,13,408;7;F
97072;1624,1517,1,982,1332,1524,36,1468,192,1314,13,586;38;F
97080;512,733,1608,408,1510,1470,265,1700,23,1706,382,451,1332,776,36;13;M
97090;1624,1119,1,1344,443,1633,1468;52;M
97099;451,1021,1526,1322,1,1524,1328,1359,16,1468,265,1559,13,1434,1384;41;F
97107;1322,1706,988,376,140,408;51;M
97132;1332,124,1700,702,1698,174,16,1468,3,13,1434,1510,140,408,586;71;F
97151;834,36,124,1700,1347,702,16,865,1434,586,1698,24,1468,1608,192;35;F
97163;1624,826,1581,1295,1388,373,376,1314,1441,1312;59;M
97164;140,1517,1021,1,1524,36,1026,702,1119,1470,192,382,13,1441,3;34;M
97178;1624,1700,702,984,13,1,982,16,834,192,1441,1517,1021,1524,444;7;M
97225;382,512,408;47;F
97290;1451,1510,17,1517,947,1325,1581,1344,443,556,776,1482,268,828,22;49;F
97309;776,896,1700,16,2,984,140,1624,17,982,1482,1698,1468,22,13;26;F
97325;988,984,1338,741,995,443,834,124,1441,140,1,1482,1633;46;M
97357;17,826,1,1581,1482,1698,733,376,2,586;31;F
97405;443,124,373,1359,268,24,16,1468,1608,192,1470,984,1434,140,408;45;M
97408;409,13,140,16,1314;67;F
97434;297,776,1482,23,409,865,988,1110,659;46;M
97456;1633,733,550,860,1434,1388,865,776,1482,1532,268,192,1314;28;F
97460;1470;48;F
97478;265;48;F
97532;586;39;F
97543;1021,1261,129,1332,1524,1532,1700,1328,1698,1359,16,265,394,1559,1384;38;F
97544;1624,826,1581,1295,1388,373,376,1314,1441,1312;43;M
97589;1338,174,1434,13,702,1325,1517,16;56;M
97593;1322,741,1581,1388,124,2,3;30;M
97596;1526,826,776,1509,1532,1633,1468,1559,1314,13;36;M
97598;24,826,16,140,1314,984,982,828,774,451,376,1698,1700,1624,1338;33;M
97626;24,16,1468,376,140,129,1,223,1604,741,211,1487,1700,1608,1559;10;M
97659;17,1624,1347,1468,1706,1,826,776,382,512,1441,1434,408;19;M
97698;192;6;M
97708;1624,774,451,1526,776,1509,1532,1347,24,16,1633,1468,1559,1314,13;37;F
97782;826,1468,1517,1026,1,129,1524,702,36,1451,268,1510,1344,776,1482;44;M
97785;1261,512,1332,1524,896,834,1482,1359,265,394,1559,1470,1434,1384,408;5;F
97794;173,995,1581,1487,1359,865,192,1608,984,1434;44;F
97829;1517,1624,1604,223,124,1700,702,1468,1608,376,1487,863,211,129,741;9;M
97843;13,774,982,443,223,947,1700,917,1325,1,129,373,1698,16,1434;36;M
97856;3,451,1330,1517,1624,173,1,826,1119,512,1524,174,1468,13;40;F
97916;774,1344,443,556,776,1482,1347,828,16,1633,1468,376,394,984,1434;56;F
97949;1581,1344,776,1700,828,1517,1322,741,124,1698,24,16,1633,1468,13;27;M
97954;1517,1322,741,36,124,702,828,24,16,1468,1608,1314,13,1510,140;43;F
97998;1434,140,408,1581,982,129,917,1517,1604,1624,863,211,741,24,1608;45;F
98010;1295,1312;53;F
98012;1021,1524,1624,1517,1325,1,776,1482,36,702,1026,1314,1451,1434,140;32;M
98022;1322,917,174,1468,1441,947,451;29;F
98033;1322,1604,1624,1517,1338,1325,741,1,1581,1344,124,24,1434,1510,140;65;M
98048;774,1517,1624,741,1581,776,1328,1347,36,16,1468,265,1314,1451,140;14;M
98079;1624,451,741,1,1344,776,24,16,1633,1468,376,1559,1314,1470,13;30;F
98083;1604,17,774,451,1322,1482,702,373,22,376,1441,13,1451,1434,140;68;F
98119;863,297,1110,443,1119,451,409,982,211,173,896,988,174,865,984;49;F
98142;584,376,1384,223,1261,129,556,373,1698,1359,394,1559,554,1434,1510;41;F
98148;451,774,1344,443,1482,1347,174,1633,1468,22,984,13,1451,1510,140;39;F
98189;23,1581,702,22,13,1434,1510,140,586;25;M
98192;774,1330,451,1325,173,988,174,443,776,1328,1441,984,1434,1510,140;58;F
98195;13,1633,1468,24,1328,776,1517,1624,1604,1434,702,917;44;M
98233;1,1026,129,1524,826,1468,702,1517,36,1451,268,1510,1344,776,1482;11;M
98320;451,1021,1706,1,982,512,1524,1700,702,1026,1328,174,265,1434,408;27;M
98333;373,1338,1119,917,947,774,173,1332,988,376,394,1314,984,1312,1510;46;F
98350;124,733,24,16,22,1559,1314,1441,444,13,1451,1510;17;F
98359;1332,1322,1021,1517,1524,1700,1026,1434,1312,1510,1384;42;F
98400;776,1700,1698,1624,1330,451,826,1322,702,1328,174,16,1468,265,13;29;M
98402;192;43;M
98434;1295,1312;47;F
98484;1526,1509,13,1604,774,1330,451,826,1110,1344,1347,268,16,1633,1468;28;F
98494;17,23,373,733,1441,1451,443;45;M
98509;1533,443,1524,776,1509,1532,1700,1347,702,1026,1328,174,13,1434,1510;73;F
98555;1624,17,774,443,373,16,268;36;F
98630;1434,1468,733,268,1026,702,834,776,1524,1517,1604;31;M
98636;1322,982,443,1332,896,1388,988,834,550,22,265,444,984,13;54;F
98657;1388,1700,1698,268,860,16,1468,865,2,1624,982,896,394,1441,1451;41;F
98660;192;43;F
98670;140,1624,297,451,1533,443,36,376,265,1451,1517,1021,1524,702,1026;47;M
98717;192;9;M
98727;1509,1532,1026,1359;32;M
98744;1110,1322,1119,1604,1384,1434,1451,1468,16,1700,834,1338,17,1624,1698;46;F
98762;1624,982,1332,1482,1700,1487,24,1608,22,376,1559,2,984,1510,140;36;F
98789;192;11;F
98804;774,1604,1624,1517,741,443,1332,124,702,24,1468,13,1451,22,1314;34;F
98828;1344,1509,1451,1434,17,1624,1322,741,1110,1482,124,24,1468,1314,13;33;M
98872;23,1633,1314,1344,776,863,1482,702,16,1468,376,1517,659,1347,268;50;M
98889;1,1119,1322,23,1581,443,776,1482,1700,376,265,1441,13,1434,140;78;F
98928;17,774,223,1344,268,192,1559,1441;27;F
98929;16,22,13,984,1312,140,1510,1434,1604,1517,1,1524,1533,1482,1468;42;M
98933;1312,1110,173,268,24,1633,1468,376,140,13,1314,394,1344,16,192;44;F
98937;1624,774,451,826,982,443,1347,24,16,1633,1468,1559,1314,13,586;40;M
98952;584,409,1328,373,828,860,16,265,394,554,984;34;F
98984;16,1470;7;M
98988;17,917,1338,23,173,556,776,896,1482,2,554,13,1451,1510;28;F
99028;1604,268,16,140,1468,297,1624,1322,1325,1344,443,1482,1532,3,1451;21;F
99036;451,826,1110,1344,443,776,1482,1347,1328,268,24,16,1633,1468,376;53;F
99046;443,1344,1604,297,394,733,988,1581,1,1325,774,1338,776,16,376;23;F
99129;17,1021,1338,1325,1,1581,22,834,36,1700,702,268,1441,1434,408;23;M
99178;584,17,947,982,1581,443,1332,867,988,1700,1698,268,22,2,1441;51;F
99183;1434,1451,1441,1624,1604,1338,443,896,1482,1487,1698,1359,265;21;F
99197;1509,451,1330,16,1344,1110,774,1624,1604,443,776,1347,268,1314,1468;60;F
99201;1,982,173,1581,1332,776,834,36,702,16,1633,1468,376,1434,13;47;F
99202;1624,1517,1119,1338,1,129,1524,1347,702,1026,174,173,16;40;M
99203;1517,1,173,1524,702,444,984;39;M
99220;1347,702,268,16,1608,13,1451,140,1604,1021,1434,265,1509,1328,1026;41;M
99222;1624,1604,223,382,512,373,408;44;F
99242;702,1026,1517,36;36;M
99310;984,17,223,1526,1261,1416,129,1532,1026,174,1468,265,1559,1434,1510;44;F
99311;1524,1344,1,382,1119,1604,1624,1322,826,1325,1633,192;39;M
99331;1322,2,984,140,1532,1359,550,733,16,1468,1559,1314,13,1434,863;29;F
99345;1624,776,1482,376,1468,1633,16,24,268,1347,443,1344,1110,826,451;58;M
99351;947,917,1021,1338,1322,1325,129,1581,1698,1468,22,265,2,1441,1434;57;F
99401;1347,268,24,16,3,1434,917,1624,1322,741,982,443,124;33;F
99464;1624,173,124,702,16,1633,1468,1559,1314,1441,13,1451,1434;45;F
99478;129,1332,1526,1261,982,1533,988,1532,1359,1608,265,1559,1451,1434;43;F
99497;1110,409,917,1322,982,834,550,265,984;32;F
99544;776,1119,1624,1451,1559,13,1330,451,1328,1468,376,265,1470,1384,140;36;M
99571;1119,1416,129,995,1524,1509,373,865,1608,192,394,1559,554,1312,1510;36;F
99600;373,1608,1441,1470,1322,382,1581,834,1328,192,265,1434,586;39;M
99624;1517,1338,1,1581,1524,1347,174,16,22,13,1434,140,1510,702,268;50;F
99627;1119,1330,1526,1110,1332,776,1700,1347,1328,373,24,16,1468,1608,265;39;F
99641;702,1468,376,1624,774,741,982,1344,776,22,1347,24,1633,984,13;54;F
99644;16,1470;8;M
99671;1624,1325,1533,776,702,16,1468,376,1434;17;M
99672;1325,443,776,1509,1482,124,16,1468,3,1451,1434,1510,1524,1026,1021;36;F
99691;702,1328,265,1441,1434,1510,1384,140;43;F
99727;947;29;F
99729;1700,1633,1451,1434,1509,1359,1624,1604,1,443,1347,702,1328,1468,13;39;F
99752;1332,1533,982,129,409,1416,1325,1526,223,1119,947,1517,17,1510,140;6;F
99780;1110,1344,1332,776,988,1482,1633,22,1434,16,1468,984,24,982,443;32;F
99788;1624,1517,982,1344,1332,896,124,1700,702,24,865,554,1434;7;M
99793;1624,776,1633,774,443,1468,13;40;M
99807;22,376,1559,2,13,1434,1510,140;27;M
99849;124;20;M
99900;1119,1330,1526,1110,1332,776,1700,1347,1328,373,16,1633,1468,1608,265;9;F
99908;774,1624,17,1322,741,1509,1482,1698,24,1468,1608,1314,13,1434,140;23;F
99956;129,173,443,776,124,1347,24,16,1468,376,2,1441,13,1434,140;34;M
99963;1482,1532,1026,1359,1633,1468,140,1110,1344,1347,702,24,265,984,1434;31;M
99989;265,1509,1110,1526,1344,1347,1624,826,443,776,1482,16,1633,1468,1451;34;F
99991;192;2;F
100011;1517,741,1,1344,863,124,1347,702,1026,24,865,22,376,13,586;40;F
100030;1119,1330,1526,1110,1332,776,1700,1347,1328,373,16,1633,1468,1608,265;7;M
100050;1451,1434,1510,140,13,984,776,443,982,1,1322,774,17,268,3;61;F
100075;702,408,1624,741,211,863,124,24,860,865,22,192,1470,984,586;38;M
100084;17,1517,947,917,741,1,409,1344,443,373,1698,1468,376,2,1451;29;F
100100;1510,917,1533,1524,1509,16,1451;33;F
100124;1119,1330,1526,1110,1332,776,1700,1347,1328,373,16,1633,1468,1608,265;2;M
100138;16,22,376,1441,1451,140,17,1517,741,982,702,1698,2,984,1510;54;F
100173;1517,1021,1526,1524,1509,1532,1026,1328,1359,265,1559,1434,826,1330,1261;44;M
100179;173,1325,1322,1119,947,584,1624,17,774,124,1700,1698,1314,13,1510;27;F
100225;1624,774,1110,1344,1524,776,1509,1482,1347,1026,16,1468,3;34;M
100234;1325,917,129,1524,834,1700,702,1026,394,1559,2,1451,1434,1384,140;31;F
100270;223,13,1314,1633,16,988,826,1526,774,1624,1110,1344,1482,1347,1468;62;F
100359;297,17,1526,443,1295,776,1388,1700,268,1322,1325,1581,3,1434,1510;33;M
100391;1119,1021,1322,1,129,1110,1344,1332,1524,1026,865,265,1434,1510,1384;39;M
100460;1322,17,982,896,988,22,376,394,2,1441;46;F
100464;1451,1468,1700,834,988,1581,211,982,947,1624,1517,1322,1325,1,702;26;M
100516;1517,36,1532,702,1026,24,16,1468,1559,1314,13,1451,1434,1510,140;36;M
100522;140,443,776,1482,1347,268,16,1633,1468,192,376,394,1314,13,1451;30;F
100564;1706,443,702,174,1633,1468,376,13,1510;41;M
100593;550,265,554,1451,1312;42;F
100596;982,776,1482,36,1388,124,702,268,24,16,1468,22,3,1510,140;36;F
100645;451,1325,1110,776,702,268,174,1633,1468,265,13,1451,1434,140;32;F
100713;774,1604,1624,1526,776,741,1482,1532,124,24,16,1559,13;59;F
100715;1,1347,1026,24,140,13,1468,1633,16,174,702,1524,443,1344,1119;32;M
100726;568,741,1384,984,444,192,947,17,1441;29;M
100811;1526,1325,443,867,1388,16,1314,3,13,1451,1384,586;25;F
100838;1517,17,1633,1314,1434;29;M
100851;1344,1532,1347,1468,1559,1624,1526,982,1509,16,140,1434,13,1608,1487;65;M
100856;1633,1468,376,394,1314,1510,140,408,826,13,451,1470,16,1434,776;31;F
100857;826,1526,1624,1604,741,1110,1344,443,1347,16,1633,1468,376,1314,1451;36;M
100870;1559,2,1451,1312,1384,1021,129,1344,1524,1509,1532,1487,1026,373,1698;50;F
100917;896,1344,1624,1517,223,982,1332,124,1700,702,24,1468,865,22,1434;5;F
101015;1624,1468,1451,586;31;F
101064;173,1344,443,776,1509,1347,1328,268,24,16,1633,1468,13,140,451;36;F
101074;1110,1325,1624,1119,382,1,982,443,834,702,1698,16,1468,192,1314;48;F
101080;988,376,394,2,1608,1388,776,1344,443,1110,1322,13,1451,1510,140;44;M
101137;1384,1347,1344,211,774,1526,1416,443,556,1524,867,1509,1532,1026,1559;49;F
101154;1633,1482,776,1468,265,1314,13,1451,1624,741,1344,124,1328,16,3;31;M
101169;917,451,1524,1295,1338,826,1,16,1633,1700,512,382;23;M
101198;36,1624,776,124,373,268,22,1510,1441,17,741,982,211,1332,988;50;F
101224;702,1388,1532,1482,1624,834,1700,1698,1451,140,376,265,394,1441,1510;32;F
101241;1517,1524,702;40;M
101264;444,1312,1510,556,1332,1026,174,1700,1524,1344,982,1526,1021,1328,265;43;F
101270;1624,1338,1325,1698,828,1468,1441,1451,1434;26;F
101272;1,1533,1524,1532,1026,13,1451;39;M
101327;863,865,860,867;26;F
101335;1604,1517,1624,297,1468,376,394;38;M
101407;1624,741,1,1581,512,124,1700,1347,702,24,1633,1608,1314,1434,408;27;M
101444;451,1322,1325;32;M
101512;1,444,1468,1325,1332,1624,1322,982,451,1700,702,268,16,13,1510;36;M
101527;192,376,1314,140,1384,1434,13,774,1624,408;47;M
101538;774,1322,1325,1110,1698,16,394,13,1451,1434;28;F
101567;17,917,124,1451,1434,741,867,863,865,860;49;F
101570;17,1624,36,702,373,1698,174,865,192,394,2,1314;30;F
101578;1347,1482,776,1581,1325,1322,917,1624,1517,741,1,124,702,1510,140;37;M
101597;1482,16,1468,22,376,1441,13,1451,1434,140,586;33;F
101626;394,297,1517,1119,1021,1322,1,1110,173,1524,36,702,1026,174;60;F
101651;1624,1322,1581,373,1633,1314,1441,1451,1510;29;F
101665;451,1526,826,443,776,1532,1359,1468,265,1559,1434;34;F
101682;834,376,1021,1526,1416,512,1509,1532,1328,1359,265,1559,1441,1434,408;36;M
101687;1468,192,1314,3,13,1434,1510,140,1322,741,129,443,702,24,16;33;F
101720;376,22,1608,1468,1359,1698,1347,1388,1532,1624,268,16,1441,3,140;32;F
101729;1700,982,1261,1526;41;F
101752;1322,1,1533,1581,834,1388,1698,16,192,394,1559,1314,1441,1470,1434;30;F
101764;1509,1482,1328,1698,1359,550,733,24,16,1633,1468,265,1559,13,1434;32;M
101771;1295,988,124,1700,1347,702,24,16,1468,1608,22,1559,13,1434,1312;51;M
101789;776,1482,24,13;43;M
101792;947,1119,1532,443,1344,659,834,129;40;M
101795;451,129,982,1581,1344,443,776,1482,1388,702,16,376,984,1434,408;68;F
101800;1526,129,1533,1344,1524,1482,1347,1026,550,16,1559,1451,1434,1312,1384;34;F
101811;13,1510,586,1624,1604,1119,1110,1344,443,1347,24,16,1468,1434,140;37;M
101847;1510,140,1517,584,1325,1,1581,1332,1388,702,1328,373,22,265,1434;42;F
101860;1517,917,1021,1,1581,1524,834,36,702,1026,174,265,1434,1384,140;27;M
101945;1322,1,1482,702,174,16,1434,140;25;F
102051;443,1524,1509,1532,702,1026,1359,22,1559,13,3,1451,1434,1510,140;89;F
102078;129,982,834,1700,373,1698,550,1608,192,394,2,1314,1441,444,984;29;F
102096;1700,776,1119,774,1338,1706,741,124,24,13,140;37;F
102121;36,1517,17,1604,1624,1581,776,702,1328,24,16,1633,1468,1314,13;35;M
102174;1021,1330,1,1026,982,443,556,1524,1347,1328,373,1470,265,1559,1451;37;F
102186;741,1110,1344,776,896,1509,1388,1347,702,1468,1633,16,13,3,1451;31;M
102193;776,1482,124,1328,24,1633,1468,3,1434,917,443,16,265,2,1451;28;F
102201;733,16,1468,394,2,984,13,1434,947,376,1451,1384,140;25;F
102210;1517,376,1434,140,702,36,17,443,1338,741;29;M
102219;1559,13,1434,702,1026,1359,586;71;F
102235;586;39;M
102242;451,774,947,1624,1119,1330,129,1328,1698,1359,16,1468,376,265,13;38;F
102253;917,1330,129,982,995,1581,443,1344,1295,988,702,373,174,16,444;22;M
102262;1624,17,373;23;F
102263;741,917,1581,443,988,1388,1700,373,174,192,265,1470,1434,1510,408;48;M
102285;1347,1510,1468,1332,1325,1624,1322,982,451,1700,702,268,826,16,13;32;F
102326;376,1624,947,774,568,741,1325,982,1344,443,1332,1295,988,1700,394;37;F
102332;1581,1700,1698,16,376,265,1559,2,1314,1441,3,13,1451,1434,140;52;F
102356;1021,1325,1,1581,1524,834,702,1026,1328,1468,265;31;M
102374;192,1314;42;M
102408;774,1624,826,443,1,1524,776,1482,36,1347,16,1633,1468,376,13;33;F
102423;16,1468,376,3;27;F
102486;1325,1524,1482,702,1633,1314,13,1434,1510,140;42;M
102510;129,443,268,16,1633,1468,22,192,394,1314,3,13,1434,1510,140;41;F
102518;140,867,776,1347,373,1624,1604,774,1322,741,124,16,1468,13,1434;32;F
102537;1325,774,1624,947,451,826,1322,1581,1700,373,268,828,1633,1441,1434;68;F
102542;1624,1026,373,24,1608,865,22,376,1314,1441,444,1559,13,1451,1510;30;F
102562;17,947,173,834;29;M
102565;1314,741,1624,1604,1344,443,124,1347,268,24,16,1633,1468,3,13;30;F
102593;17,982,984,733,1532,1559,1434,1451,376,1468,1338,1526,1624,1344,1533;32;F
102608;1482,1468,192;38;F
102610;174,733,1700,776,1332,443,1344,982,129,1325,1322,1338,1119,1624,16;22;F
102678;1624,451,1021,776,1509,1328,268,16,1468,265,1559,1314,13,1434,586;32;M
102689;1624,17,1581,1332,408,3;20;F
102691;1314,13,1434,140,1624,917,1322,1110,1581,1344,443,1482,1359,16,1468;33;F
102710;140,17,584,774,451,1322,982,443,776,1700,16,1468,376,3,988;36;F
102729;1604,1624,1338,826,409,1700,16,1633,1608,1441,3,13,373,1698,268;36;F
102746;1482,1700,1328,373,1698,1359,16,865,22,376,265,2,1314,1441,13;70;F
102756;1338,1526,1021,451,17,1624,826,1581,1295,1388,373,376,1314,1441,1312;35;M
102769;1261;36;M
102792;1325,1416,1581,556,834,1700,1468,1434,1261,1322,1509,1532,1359,1559,1384;36;M
102815;1110,1026,1,443,1482,36,1347,702,16,1468,376,394,1314,13,1451;34;F
102841;1524,834,1482,36,1468,1608,22,17,917,1330,443,1359,1441,1451,1434;44;M
102848;1524,702,1026,1328,1359,268,1468,1633,16,24,265,1559,1314,13,1434;36;M
102850;17,1517,1338,1,443,1026,373,1328,174,16,265;32;F
102896;268,265,1441,13,1384,1624,17,451,1021,1338,1,702,1026,1633,1468;33;M
102903;1604,1624,774,1110,1344,443,1388,268,16,1633,1468,13,1451,140,586;73;F
102908;1119,451,1338,1344,443,896,1482,1468,22,376,984,13,1434;34;M
102921;834,1482,36,124,702,1026,1698,24,16,1633,1468,192,1314,13,1434;32;F
102925;568,774,917,1624,17,1325,1581,443,1482,1328,373,174,192,1434,586;61;F
102963;1482,1487,394,1633,268,36,1510,17;44;F
102992;408,1700,1581,982,1,702,373,268;20;F
102997;1441,13,1510,1451,865,24,1347,1110,1322,1338,451,1604,1624,741,124;61;F
103005;1608,22,1559,13;30;F
103026;16,1633,1624,1482,1347,373,13,1451,451,1526,443,776,1509,1532,1468;17;F
103115;1624,1517,451,1338,1,1110,1344,834,702,1698,174,586,1559,13,1384;35;M
103139;17,1261,826,1344,1468,1314,16;30;F
103153;774,1517,1624,776,1482,1347,373,16,1633,1468,2,1314,1441,1510,1384;31;M
103172;1624,917,1322,1325,982,1581,988,1468,192,1434,13;34;F
103190;1344,443,776,1347,268,16,1633,22,192,376,1314,13,1434,1510,140;77;F
103193;1470;51;M
103203;1388,124,702,1026,1328,1359,550,860,16,865,1559,13,140,265,1434;35;F
103221;1325,173,1581,1388,1700,373,1359,268,174,1559,3,1451;25;F
103229;776,443,1344,1325,1706,826,1119,1624,451,1322,1110,173,1581,1608,1470;41;F
103299;1624,17,947,774,1338,1,834,1026,1698,16,1468,22,2,1441,13;32;F
103316;1624,917,1330,741,443,1524,1388,124,1700,1026,373,268,16,376,3;28;F
103328;1359,174,24,16,1633,1468,22,376,265,1559,554,13,1451,1434,140;20;F
103354;297,1322,1517,1119,1021,1,1110,173,1524,36,1026,702,174,394;62;M
103365;1624,774,451,1332,1347,16,1468,22,376,13,1510,140;42;M
103413;1021,451,774,1604,1624,129,982,1344,1332,1700,22,984,1434,1510,140;39;M
103431;1119,1624,917,1021,1322,129,1581,1328,1468,265,2,1451,1434,1312,1510;51;F
103446;1295,1312,1510;50;F
103492;1706,741,1532,124,1347,1328,24,16,1633,1468,265,1559,1314,1510,1434;17;M
103506;1119,826,1110,173,512,36,174,16,22,376,1559,3,13,1451;31;F
103550;373,1698,860,376,2,394,1441,554,984,1344,1482,36,16,192,1314;32;F
103624;1624,1468,1633,16,24,174,373,1347,17,774,2,1441,1451;31;F
103643;192,1026,1434,1526,16,1559,1451,1261,382,124,1700,373,1698,268,1441;20;F
103669;1581,776,36,124,16,1633,1468,192,2,1314,1441,13,1434,1510,140;35;F
103680;1700,373,1698,174,16,1633,1468,2,1314,1441,1451,1434,1510,140,1470;24;F
103695;774,1624,1330,451,1344,443,1347,1328,16,1468,265,2,13,1434,586;79;F
103706;834,1325,1608,22,1451,1624,1517,1,129,776,1482,984,982,1322,1332;39;F
103787;192,376,1559,2,1441,3,1451,1434,140,1517,1524,867,1388,1700,702;32;M
103792;1509,834,988,776,982,1624,1119,1517,1526,741,1,129,443,1524,268;39;F
103868;1325,1322,1338,17,1624,1517,741,129,443,124,702,22,444,984,586;40;M
103891;1624,17,947,129,863,550,1468,865,192,376,1559,1314,1441,1470,984;8;F
103903;16,1633,265,394,1434,297,917,223,982,443,1295,124,24;33;F
103947;1338,834,1482,1698,444,13,1468,17,1624,774,1,1700,1633,1434;13;M
103962;1119,1,1581,1700,702,174,1633,1468,192,1314,1441,13,586;42;F
103999;1325,1581,1441,1482,702,1468,984,1384,586,741,834,373,733,24,444;29;M
104015;1624,982,211,173,995,1332,988,174,16,1633,1468,1470,984,1434,1384;39;M
104036;1388,16,1559,1510,1524,702,1517,1468,1526,1604,1509,443,1434,1021,1328;28;F
104082;947,1119,1624,17,1581,1509,1700,1698,860,1314,1441,1470,984,1312,140;68;F
104098;17,1,1581,834,1700,702,1026,1328,1468,2,1314,1441,984,1434;29;M
104140;443,982,1110,741,826,1526,1517,774,16,776,265;34;M
104168;1624,1633,1468,1314,1451,140;33;F
104177;982,211,1332,896,988,16,1468,22,984,13;30;M
104187;1700,124,129,774,1517,17,1624,1468,1510,741,443,776,24,16,586;42;F
104211;774,451,1325,556,1559,1434,1510,140;56;F
104271;947,17,1322,1325,23,443,776,16,1468,265,2,1441,13,1451,1434;46;F
104272;124,2,394,741,774,1604,1624,1517,1325,702,24,16,22,376,140;31;F
104290;1624,1517,568,1322,1325,1,1524,834,702,1026,24,16,2,1434,140;32;M
104294;1110,409,1325,382,1322,826,1338,1624,1604,1119,451,1700,1328,268,265;39;F
104297;1325,988,1441,16,1698,1295,1581,129,17,947,1322,373,1434;45;F
104399;1470;39;F
104413;774,741,376,394,13,586;29;F
104443;1470;22;F
104482;1021,1526,1533,1468,1524,1509,1388,1532,1347,1359,16,13,1451,1434,140;32;M
104490;1344,1581,129,774,1624,1322,1325,1332,268,1468,376,394,3,13,1510;45;F
104522;584,1322,741,1110,1581,1532,550,733,394,1441,444,1434,1510,140,586;41;M
104559;1451,140,1526,1624,917,1261,1322,1325,129,1581,1328,265,16,1314,1434;35;F
104581;211,443,988,1332,1510,1,982,2,947,1698,1633,265,1441,13,1434;42;F
104645;17,409,982,211,443,1482,1700,1698,1633,865,265,2,984,13,1434;48;F
104655;1468,1698,1347,443,1344,1110,1706,1624,1451;30;F
104682;1388,373,1698,828,192,1314,1470,3,13,1451,1434,1510,408,140;39;F
104729;265,1314,774,1322,1325,129,1581,1328,373,860,1468,376,394,13,1434;35;M
104739;1517,1526,1322,556,988,1532,1524,867,1700,1026,1698,1359,860,865,1434;43;M
104761;1624,1604,1517,917,451,1021,173,1524,1509,1388,124,702,3;28;M
104765;1517,1581;40;F
104784;776,124,16,1468,1314,1441,13,1624,917,774,1338,1325,1581;38;F
104789;1624,1332,1524,1700,16,984,1510,22,265,995,988,702,13,1434,982;45;F
104820;1517,1325,741,1,129,1581,443,1524,124,1700,702,586;41;F
104831;774,741,124,268,174,24,16,1633,1468,192,1314,3,13,1451,586;43;F
104849;774,173,174,16,984,13,1624,1330,451,129,1468,394;39;M
104851;774,1119,1700,1347,865,1,23,1344,443,1332,776,1328,376,265,1451;70;M
104869;1026,1347,1482,1524,443,1344,1526,1604,13,376,1468,702,774,1517,1624;33;M
104898;1482,124,140,1338,1344,1332,659,1328,174,22,376,265,1434;28;F
104960;140,1,1325,17,1332,124,1700,16,1698,22,1604,947,1338,982,1468;69;F
104997;1624,1526,443,1509,1532,16,376,1451;42;F
105017;1021,1261,834,124,1700,1026,192,1441,1384;47;F
105028;1322,1325,1110,1344,1332,1388,1700,1347,373,1698,1633,192,1314,1441,1434;34;F
105068;1021,1624,17,1517,917,1325,1581,124,702,1026,1468,1441,1434,1510,140;34;F
105079;17,584,982,834,36,1700,702,1698,550,733,1468,984;25;M
105111;1624,1119,774,1330,451,129,173,174,1468,394,984,13;40;F
105129;1698,211,568,947,17,982,776,896,1482,1700,373,733,2,984,140;52;F
105142;1517,1021,702,1698,265,1624,17,1325,1700,1347,1328,16,1633,1468,13;18;M
105200;1581,1332,1295,1482,1026,1633,1608,2,1434,1510,1698,13,982,16,1700;24;F
105204;1624,774,1119,1330,451,129,173,174,16,1468,394,984,13;9;M
105220;586;27;M
105234;1624,17,1517,774,741,129,443,1295,124,1700,24,16,1468,1510,586;9;F
105240;1624,1119,1,1110,982,173,443,1347,24,1633,984;71;F
105262;702,1328,1468,13,17,1,174,16,140,512,408,173,382,776,297;36;M
105327;1624,774,1119,1330,451,129,173,174,16,1468,394,984,13;6;F
105330;1338,1604,443,776,1347,373,1698,16,1468,376,1314,13,1451,1434,140;35;F
105333;1624,17,1517,774,741,129,443,1295,124,1700,24,16,1468,1510,586;4;M
105372;556,1482,1388,16,192,2,1314,1441,3,13,1451,140;56;F
105379;1119,451,129,1110,173,1332,1482,1700,1698,174,22,444,13,1510;34;F
105405;1330,1021,1322,443,1524,988,124,1700,16,1468,1559,1441,13,1434,1510;30;F
105415;129,776,1482,373,1359,16,1468,140,192,1325,124,1322,1581,1434,1510;47;M
105422;1314,1441,1470,13,1434,1510,140,776,1624,451,1322,1328,16,1468,192;37;F
105432;1509,776,443,1344,1604,1624,451,1338,1110,896,1482,1532,1328,1633,1468;29;M
105443;1517,1604,1624,1526,1322,1524,1482,1700,702,1359,268,16,1468,1441,13;28;M
105445;917,1021,1526,1322,776,1532,1026,1328,373,1359,265,1559,13,1434,1510;69;F
105458;1434,1312,774,1322,1581,1482,702,373,1359,268,376,265,3,1510,140;26;F
105466;1706,1700,1698,1468,394,1441,1451,140;31;F
105515;268,23,1388,443,1581,1325,568,584,17,550,1559,13,1434,140,1510;30;F
105516;865,394,554,3,13,1482,1633,376,1604,776,443,1451,1344,17,1510;38;F
105520;1487,863,834,1482,1347,373,1698,174,16,1633,1468,1608,376,2,1441;60;F
105521;947,584,17,1338,1322,1325,443,1482,733,16,1468,22,376,1434,140;30;F
105534;1482,1,1338,568,917,17,1322,1325,982,192,1314,1451,1434,1510,140;34;F
105541;265,2,1434,408,17,1517,917,451,826,173,1581,556,373,1698,1470;38;F
105544;17,1338,741,1110,1344,834,1482,124,24,16,1633,1468,13,1451,1510;16;F
105553;140,1312,265,896,1524,1344,982,1325,17,451,1322,1,129,1332,1434;33;M
105557;982,1332,268,124,22,265,984,1517,1021,1524,1532,1487,1026,1359,1608;55;M
105597;1470;39;M
105639;917,1261,826,1325,982,1700,1698,828,174,394,1470,444,984,1510,586;39;F
105673;373,1698,1468,1434,1330,1526,1509,1700,1328,265;40;F
105675;774,917,741,1325,173,443,124,174,24,13,1468,2,1434,1510,140;54;F
105701;1325,451,173,556,834,124,733,174,16,1633,1468,376,13,1434,1510;39;M
105777;1608,1261,568,774,1526,947,1532,1698,828,1468,865,394,1441,13,1434;54;M
105785;1517,1526,1338,1700,1698;22;F
105790;1344,1295,373,16,1468,192,2,1314,1441,1470,13,1434,1312,1510,140;33;F
105808;1624,1633,17,568,451,826,443,867,776,174,16,1468,22,444,1451;26;M
105832;1338,16,1384;44;M
105836;1470;10;F
105870;826,1338,451,917,1624,1604,741,1,1581,124,16,1468,13,1434,140;48;F
105886;1604,265,1559,13,1384,1517,1021,1526,1261,1,1524,1509,702,1026,1434;39;M
105908;1470;10;F
105937;140,1119,568,774,917,947,1624,223,1322,1295,776,1468,1314,554,1451;23;F
106022;17,702,174,24,16,1633,376,1314,1441,984,13,1451,1434,1510,140;26;F
106056;17,774,443,776,1482,174,16,1468,376,1441,444,3,13,1451,140;20;F
106070;1700,140,1624,1604,741,982,1332,988,124,702,24,1633,1468,22,13;41;F
106087;988,568,409,192,124,140,984,982,1347,1322,896,1359,1110,443,265;58;F
106131;917,774,741,1325,409,1110,443,867,776,124,24,16,1468,192,1434;57;F
106151;1119,1416,995,867,1532,174,376,2,3,129,982,988,1328,265,13;35;F
106209;444,1434,140,17,568,1,984,451,982,1581,1332,867,373,22,1470;19;F
106225;1624,451,1325,1524,1347,1,1526,1344,1509,1532,16,1468,1559,774,1261;38;F
106271;1624,1604,774,1526,1322,1524,265,1559,1434;31;M
106288;702,1509,443,741,1604,1624,1322,1325,1581,776,1482,1388,124,1468,1451;29;F
106304;1526,1,443,373,16;31;F
106310;550,1470;56;F
106324;1526,1604,17,1261,1322,129,1533,1532,1328,1359,265,1559,1314,1434;47;M
106330;17,1322,1110,982,443,1295,896,1509,373,550,394,1470,13,1451,1510;25;F
106346;1451,1434,1312,988,373,1482,896,867,1295,1322,1325,268,733,376,1510;25;F
106376;1624,1344,24,1468,13,982,16,443,896,988,1633,865,554,3,1451;48;F
106394;1322,1338,1021,451,1330,1119,584,17,1624,774,1325,173,443,376,1451;27;F
106399;451,1526,1261,982,1533,776,1532,1347,24,16,1633,1468,1559,1434,1510;37;M
106433;1608,16,550,1700,776,1581,211,1322,1332,834,1328,265,554,3,1451;67;F
106450;1330,1328,774,451,443,265;17;M
106461;1110,23,1344,443,776,1347,16,1633,1468,192,1559,3,13,1451,1434;34;F
106469;223,776,512,382,408,1700,1698,373,394,444;47;F
106544;1322,1700,1347,16,1468,1624,1581,192,376,1314,1441,13,1434,140;57;F
106569;268,174,24,16,1633,1468,192,265,1559,1314,1470,13,1434,1384,140;32;M
106570;192,774,1119,1,23,1344,443,1332,776,1347,1328,865,376,265,1451;71;F
106591;192,1604,1624,774,826,1295,1700,1347,373,1359,1468,16,1314,13,1312;11;M
106595;1119,1338,826,409,1110,129,211,173,1533,443,834,268,1,1325,1322;9;M
106633;1482,36,1347,702,16,1633,1468,22,2,1441,984,13,1451,1434,1510;31;F
106634;16,1325,1322,1604,741,1,443,124,702,24,1633,1468,13,1434,140;56;M
106646;947,129,1332,988,1482,24,860,865,22,376,394,444,984,1510,586;37;F
106684;826,1325,1581,512,443,1295,1509,1482,1532,1633,1468,265,1314,1451,140;19;M
106685;1517,443,1524,1509,1026,16,376,265,1451,1434;39;F
106729;1470;8;F
106733;917,774,741,1325,409,1110,443,867,776,124,24,16,1468,192,1434;61;M
106756;1330,1328,774,451,443,265;51;F
106803;1468,1517,1119,1338,1,173,1532,1700,702,1026,1698,268,174,1314,1510;31;F
106805;1434,702,1026,550,1624,1517,947,774,223,1021,36,1487,1698,2,1441;49;F
106818;834,1581,173,1517,1624,17,1338,741,1325,1633,1468,1441,1510,1700,1698;32;M
106821;917,1338,1,173,1344,443,834,1388,1700,1698,373,828,394,1441,1451;13;F
106825;17,1322,1325,409,1700,1633,22,1434,1441,984,982,211,995,1332,988;48;F
106836;1434,988,1110,1624,774,1338,1322,1325,1,982,211,1581,443,1700,16;55;F
106840;1119,451,1021,1322,1325,1110,1581,1700,1026,1328,550,733,1468,265,1434;40;M
106878;1517,451,1,1347,702,24,1633,22,192;50;M
106906;394,984,1451,140,1021,1322,173,776,1328,1698,265,1434,17,451,1325;30;F
106915;1322,1434,988,373,1698,733,16,1468,1608,22,376,394,984,584,995;29;F
106977;1330,1328,774,451,443,265;53;M
107012;774,1604,1325,443,556,1295,896,1347,1698,828,16,1434,1344,1314;54;F
107018;1470;2;F
107020;1517,17,3,2,24,702,1325;26;M
107047;1,947,1624,774,826,982,1581,776,702,174,1633,3,13,1451,1510;31;F
107102;1633,408,1700,834,867,443,1110,1338,917,947,17,376,1441,1384;27;F
107114;867,776,1441,13,1434,1510,140,17,774,1482,1347,16,1468,376,1451;41;F
107119;896,988,834,373,1698,828,174,16,1468,376,2,1441,1434,1384,140;27;F
107136;1604,774,1338,1322,1332,1347,24,16,376,140,917,741,982,1581,124;56;F
107154;1510,1322,1338,451,917,17,1517,741,124,702,16,22,376,1441,3;26;F
107164;211,995,896,373,865,1608,394,1441,140,2;43;F
107180;1119,1110,556,988,373,1468,22,13;30;F
107192;1314,982,211,1344,1332,988,1700,733,16,1468,192,2,1441,444,984;31;F
107201;1347,1328,1633,1451,140,1624,774,451,826,1110,1344,16,1468,1470,13;60;F
107258;1700,408,512,382;43;M
107292;982,443,988,36,376,22,865,1468,16,1328,1470,1441,13,984,554;37;F
107311;1526,265,36,443,776,1434,1624,1021,982,995,1524,1026,1328,733;46;M
107341;16,1633,1624,774,1110,1344,443,1509,1347,1328,1314,13,1451;39;F
107359;1526,556,1509,1532,1328,268,174,16,1468,265,1559,13,140,1434,1510;76;F
107412;1581,776,1328;65;F
107439;376,268,124,1482,1332,982,140,1468,984,373,1344,1624,774,1325;27;M
107450;1698,1359,24,16,1633,1468,1608,22,376,265,394,1314,554,984,586;35;F
107455;1509,1559,1330,1526,1359,1434,265,1026,702,1524,1533,1,1021,1517;5;M
107475;451,1624,947,1119,1330,443,1482,1451,1344,174,1468;55;F
107516;774,568,1328,1698,1359,16,1633,376,265,394,13,1434,1312,140,1468;28;F
107524;1,173,1344,443,1026,1698,16,376,394,2,1314,3,13,1510,140;59;F
107546;1434,1604,1624,774,451,702,1330,443,1524,1026,1328,1468,1608,1559,13;25;M
107561;584,733;88;M
107571;1624,1604,774,1325,1581,1344,443,1482,1347,16,1468,1314,13,1451,140;65;M
107641;1624,1,129,23,1344,1332,1700,702,1468,394,1314,554,444,984,1510;34;F
107653;1119,982,1509,1532,1026,16,1468,22,394,1559,2,1441,984,1434,1510;37;F
107663;1624,982,1434,1,1110,173,443,1468,265,13;59;M
107688;1388,1700,1347,373,268,174,24,16,1633,1468,376,1314,3,13,1451;25;F
107698;1624,1604,173,556,124,1347,702,1698,174,24,16,1468,22,1441,1434;64;F
107704;265,1434,140,1624,17,1119,451,1322,1,173,443,373,1451,1510,1700;24;M
107795;373,268;37;F
107796;1604,1322,741,1,443,124,702,24,16,1633,1468,376,13,1434,140;54;F
107805;1604,1110,1344,443,140,1624,451,1021,1322,1325,1524,1328,1468,1434,265;32;F
107810;584,733;56;M
107816;140,1434,265,586;56;F
107866;995,211,896,1487,373,1698,376,394,1441,984,982,568,444,1510,140;57;M
107905;382,512,1700,408;3;F
107923;376,1314,13,1624,947,826,443,1482,394,774,1344,1347,16,1468,586;34;F
107948;776,443,1344,1581,982,1,1325,741,1322,774,917,1604,17,1517,1624;31;F
107964;1434,1510,1110,1344,268;37;M
107987;174,3,586;54;M
108003;268,444,382,512,1700,408;7;M
108009;140,568,584,982,211,443,1322,863,733,16,376,554,3,1434,1510;49;F
108018;1119,451,1338,826,1322,1325,129,173,1698,268,174,16,1468,1314,1441;34;F
108021;1526,826,1706,1110,741,1482,1347,1633,1468,1451,1624,1344,16,13,1510;35;F
108032;1330,1344,1604,451,1526,1322,1325,443,1524,1347,1468,265,1559,1434,140;38;M
108035;982,443,988,995,1347,376,1510,984;63;M
108086;1388,1532,1482,826,1468,1509,443,1110,1624,1526,1344;25;F
108182;1261;49;M
108184;1604,1517,774,1322,741,1,443,1332,776,124,1347,702,373,1451,1434;37;M
108192;1532,297,1,1110,1533,1344,1347,373,268,733,24,1633,376,1451,1510;21;F
108209;1526,1261,1416,1295,1487,1700,1698,1359,394,1559,1441,13,1312,1510,1384;7;F
108238;1532,297,373,1,1110,1533,1344,867,1347,1359,268,733,24,1633,376;23;M
108252;1526,1517,1624,1604,1119,1330,451,1325,702,268,16,1633,1468,1314,1510;4;M
108279;1344,1295,988,1347,13,1451,1434,1624,1604,1322,1482,1633,1468,1441,1510;30;F
108311;982,995,556,1332,988,1487,984,774,776,1482,16,376,394,13,1510;40;F
108332;1624,741,1581,1344,124,1347,702,24,1633,16,1468,3,13,1510,586;30;M
108336;124,1347,947,1698,1510,774,1338,1322,373,733,394,2,917,443,1451;54;F
108356;382,512,1700,268,444,408;9;M
108367;382,512,1700,268,444,408;37;F
108412;23,1344,443,1332,867,988,124,702,24,16,1468,22,376,1434,140;56;M
108413;1261;44;F
108441;1581,382,512,408;47;M
108458;1517,1021,1,1533,1524,702,1026,265,1434,1359,1526,1330,1559,1509;37;F
108462;265,774,826,776,1509,1532,1559,1344,1624,1347,16,1468,1314,1451,13;37;M
108471;1517,1,1533,1524,702,1026,265,1434,1330,1526,1021,1509,1359,1559;2;M
108499;1261,129,1581,1332,1532,1700,268,1468,22,1559,1441,1451,1434,1312,140;33;F
108545;17,1624,988,36,1026,268,16,1468,1559,140,443,1451,373,376,394;30;F
108551;1347,1509,776,297,451,1338,1624,774,733,16,1510,17,982,443,192;13;M
108602;586,3,1451;41;M
108603;443,776,1322,1,129,173,36,373,16,376,3,1451,13,140,124;26;F
108616;1517,1624,826,1325,1,1581,1524,1347,702,1026,16,1633,1468,13,1510;28;M
108621;1526,1,1110,1533,1344,1509,1468,982,1581,443,776,1347,1698,394,13;24;F
108636;947,451,1700,1314,17,409,865,860,22,984,444,988,896,982,568;70;F
108662;1698,1434,1384,1026,702,512,1624,1604,382,1524,1482,1700,1347,1468,408;17;M
108671;741,1,211,982,1332,988,124,702,24,16,22,2,984,13,1434;12;F
108692;1347,1624,774,223,1110,982,129,443,776,373,268,16,1468,1608,376;49;F
108712;1581,1533,173,982,1110,741,826,268,174;49;M
108724;1026,1328,373,1359,733,16,1468,1559,1441,444,3,13,1451,1434,140;27;F
108730;443,776,24;54;F
108787;17,1416,1434,265,1559,2,1441;73;M
108802;1604,1624,140,1434,1451,13,1468,16,733,1698,702,124,1338,584,1517;29;M
108803;382,1295,834,733,1608,192;32;M
108832;1347,988,1468,1,140,129,984,22,36,1332,982;38;F
108844;1119,1021,1524,1509,36,1532,1700,373,16,1633,1468,192,376,1510,1470;36;F
108854;1384,1312,394,1359,1700,1487,1509,1295,1416,1261,1526,1021,947,17,1604;4;F
108861;1509,1388,1344,443,1110,741,451,1624,1347,268,174,16,1468,1559,1451;33;F
108875;451,1021,1322,1,129,1581,1328,1608,265,1434,36,834;24;M
108897;1434;22;F
108906;1119,451,1338,826,1325,1110,173,1328,268,174,16,1633,1468,192,1314;38;F
108939;443,1332,124,373,16,192,376,2,1314,1470,554,3,13,1434;39;F
108976;223,1021,1526,1533,1524,1509,36,1532,1700,1026,1698,828,376,1559,13;43;F
108977;1,1322,16,376,1604,1624,1344,443,776,1388,1468,192,1314,13,1451;63;F
108995;1,1416,1338,443,834,1700,1698,733,16,1559,394,984,444,1384,1510;19;M
109001;1624,1604,1517,1119,1021,1526,1338,382,512,1344,1524,1700,1468,1384,408;14;F
109002;702,1328,1698,550,174,3,140,297,568,1338,1322,443,124,268,376;41;M
109043;1533,443,776,1509,1700,1328,24,16,1633,1468,376,265,1314,13,1434;20;F
109092;1559,3,1434,1706,1338,1604,1624,1526,1322,1344,1524,1509,1468,1441,1451;30;F
109120;129,982,1332,1312,586,1,1295,1700,174,1510,297,173,1524,1026,702;48;F
109127;24,1700,1624,1604,17,947,774,1338,741,776,124,1633,1468,586,1698;35;F
109134;1524,1487,16,1468,1314,1434,140,584,1700,1698,733,376,265,1441,984;34;F
109142;947,1441,1470;37;M
109166;1517,741,124,702,24;45;M
109172;1510,984,265,834,1332,1533,1624,1261,982,211,828,1608,376,394,1559;42;F
109177;1581,982,1,741,1338,1526,1021,1624,774,1110,1482,702,16,1468,1451;47;F
109218;409,1624,17,451,826,982,373,1698,1608,376,1441,984,13,1434,1510;37;F
109229;1021,1026,140,13,1559,174,1524,1581,173,1,1325,1322,1526,451,1624;51;F
109256;776,1482,1608,584,1322,1325,409,129,982,1332,733,444,984,1510,586;50;M
109277;556,867,896,1482,124,702,1347,373,24,16,984,1451,1434,1510,140;41;F
109288;1624,1,982,1110,173,443,265,1468,13,1434;58;F
109294;512,1624,1604,1517,1021,1338,1322,382,1524,1482,1700,1026,1698,1468,408;6;F
109329;376,984,1434,22,1559,140,1624,947,451,982,211,373,1468,394,1441;48;F
109356;1322,129,1533,1581,1295,1359,865,1441,1510,917,1328,1559,984,1312,1434;38;F
109379;1698,1517,741,13;39;F
109401;36,1,1604,17,1624,451,1338,826,1347,1633,1468,376,1314,3,13;28;M
109429;1482,16,1468,1434,140,586,451,1325,1581,776,1328,24,265,1470;32;M
109445;1347,702,1026,373,16,1468,865,192,394,1559,1470,444,3,13,1434;35;F
109494;834,1532,702,1026,1328,373,1698,174,24,16,1633,1468,192,376,1470;1;M
109497;1441,1470;59;F
109554;1,1524,776,36,1700,702,1026,268,16,1314,1441,984,1434,1510,586;68;M
109562;1338,17,741,16,1328,1026,1441,2,554,1434,984,1510;37;F
109608;1624,774,1706,1325,1110,443,776,1482,268,1468,13;39;F
109609;1451;34;F
109625;1314,1517,1021,1533,1524,1509,1532,1700,702,1026,1359,265,1559,1434,1384;48;M
109633;443,376,16,394,13,1344,1,451,192,1110;49;F
109644;1330,451,568,1119,917,223,1581,1295,867,988,896,1700,860,1434,1312;35;F
109648;1624,774,1110,443,776,16,1633,1468,394,13;40;F
109653;1328,1026,702,1509,826,1330,1624,1604,1517,1021,1533,1581,1524,834,376;30;F
109654;988,1509,1328,550,733,265,1559;33;F
109675;1624,1261,1533,1344,1524,828,860,1608,376,265,394,1559,984,13,1510;10;M
109712;1624,1322,1325,129,776,16;31;F
109713;1526,1021,1604,1624,16,1468,265,1434,297,1119,451,1110,982,173,174;34;F
109730;17,1517,1021,1526,1,1533,1581,443,1524,702,1026;41;M
109732;382,1119,1110,173,174,16,223,13,451,826,512,1700,1510,408;49;F
109744;1698,443,268,733,192,394,23,16,3;35;M
109753;1700,1330,1021,1026,1698;31;M
109776;1344,1581,23,1110,1706,1021,568,1119,774,192,394,2,1441,3,1434;48;F
109795;1441,1470;3;M
109796;1517,1021,834,702,408,140,1510,1434,1328,1451;37;M
109811;659,1295,443,1581,1110,1,1416,1325,1706,826,1338,1261,1526,568,1604;25;F
109839;1416,982,211,1332,863,896,988,1026,860,865,22,376,1559,1441,554;49;M
109866;297,1517,1021,1325,1,1524,702,1026,174,1468,1434,1510;35;M
109870;17,947,1021,1526,1416,1581,1533,1524,896,1509,1532,1026,1698,174,1559;53;F
109871;1338,17,741,1026,1328,16,394,1441,984,1510;36;M
109884;23,1338,947,584,774,1119,1526,1261,1416,1700,174,1559,984,1451,586;38;F
109927;860,984,988,863,867,1332,982,1322,896,995,211,409,1434,865,444;42;M
109930;1330,1021,776,1434,1510,1261,265,174,173,129;33;F
109936;1624,16,1468,13,1312,408;28;M
109956;1624,1261,982,1524,834,1482,1026,1328,828,1608,394,1559,984,1510;5;M
109970;1624,1524,776,1559;35;F
109988;995,173,982,1322,1119,584,17,373,1698,1633,394,984,3,13,1451;29;F
110004;1624,568,1526,1110,982,1344,1347,1468,376,17,947,223,1581,1532,1700;27;M
110027;1119,1330,988,1559,1312,1110,1344,1332,1295,1388,16,1468,1451,1434,376;26;M
110039;917,409,1110,988,1698,394,1119,982,1328,174,1384,1338,173,192,1330;52;M
110057;192,13,1441,1510;41;F
110095;1338,1322,1482,373,1633,1468,376,265,2,1314,1441,13,1451,1434,140;26;F
110098;1021,129,1581,1524,1700,702,1026,1328,174,265,1434,1312,1384,140,408;42;M
110110;1468,1314;30;M
110148;17,947,1338,1,1581,1698,828,2,1441,3;47;F
110160;741,702,1698,13,1441,140;44;F
110176;1604,1624,1119,1526,1110,443,124,1347,268,24,16,1633,1468,1441,1451;34;F
110179;1344,1119,1325,1509,702,140,17,1110,982,1581,834,22,1559,1434,1510;46;F
110194;1517,1328,834,702,451,443,376,174,173,129,23,268,1344,1510,1;41;M
110252;896,1482,1347,373,1633,1468,22,376,394,1314,1441,3,13,1451,140;29;F
110262;1322,36,1328,550,265,1470,586;70;M
110272;1624,1021,1,1533,1524,1328,1359,265,1441,1434;33;M
110291;268,24,16,1633,1468,376,1559,1314,13,1510,140,1624,1325,443,1451;42;F
110307;373,741,17,1,982,1332,863,124,1700,702,1698,268,22,984,1510;32;F
110327;568,1624,917,1119,382,1344,192,1470,13,443,1700,1328,174,265,1434;50;F
110359;1325,1,211,1581,776,834,1482,124,1700,702,1698,24,16,22,2;46;F
110375;140,174,173,1110,1119,984,36,1332,982,129,1,1468,22,988,1347;39;M
110382;917,409,129,982,995,1332,988,1700,1698,865,444,984;44;F
110392;297,1517,1604,1624,774,1021,1,1524,702,1026,1468,13,1451,1434,1261;40;F
110405;1416,1526,982,211,1332,863,896,988,1509,860,1608,22,1441,554,984;6;F
110410;1322,409,995,36,834,1487,1347,702,733,1633,1608,1441,444,984,140;38;M
110462;16,1468,192,265,2,1314,1441,13,1434,140,1517,1021,1,834,702;32;M
110492;17,1332,373,1698,22,376,2,1441;31;F
110497;1517,774,1325,1,443,556,1482,702,1698,828,174,16,1468,13,1451;60;F
110503;1624,1524,1532,702,1026,1328,24,1468,265,1434;21;M
110507;297,1322,774,568,1325,129,982,1524,776,1700,124,1026,702,373,1608;37;F
110541;173,1110,1325,1322,826,451,774,917,584,13,1451,1434,1384,140,408;34;F
110561;376,1388,1482,834,776,443,1344,1110,1325,1322,1526,774,1604,1624,140;30;F
110583;982,1110,1119,774,1624,129,1344,443,1482,1347,373,268,16,1468,1451;12;F
110590;1468,1624,774,451,741,1325,443,776,1482,124,24,16,1633,1451;51;F
110592;382,1526,1,129,512,1532,702,265,1021,1533,1524,1509,1700,1026,1559;39;F
110627;917,774,1021,1533,1332,1524,896,1482,702,1026,16,1559,1451,1384,140;40;M
110639;297,1119,1322,173,512,776,174,16,1468,1451,140;35;F
110650;1119,223,1,129,173,1581,556,1700,1698,1359,828,394,1441,3,13;40;F
110672;1698,1328,826,1624,774,223,451,1110,173,1581,556,896,1700,1633,586;53;F
110757;1451,1434,1510,140,1624,1325,1581,776,16,1633,1468,192,376;37;F
110769;192,124;31;M
110792;741,826,16,24,265,1526;46;M
110801;1021,382,741,443,1524,1700,192,1470,1434,1,702,1026,1328,16,265;37;M
110806;1624,1604,774,1119,1526,16,1633,1468,776,268,24,1559,1314,13,1510;70;M
110810;1434,867,984,741,568,896,863,124,24,13,140,16,17,988,982;26;F
110858;1119,1526,1,173,1524,124,702,268,828,174,16,192,265,1559,1510;35;F
110859;17,1517,1524,1482,702,373,1698,828,16,1468;29;F
110868;982,1,1624,1110,1344,776,1482,1532,16,1468,1314,140;23;F
110908;1532,1700,1026,1328,174,1468,192,265,1559,1314,1441,984,1434,1510,1384;42;F
110912;1119,297,451,1322,1325,1,1110,173,1344,988,1482,1347,702,174,1633;31;F
110938;1325,376,1468,776,1110,23,896,988,1482,1487,174,394,13,1451,1312;24;M
110939;1119,1604,1624,1482,1468,1517,1021,1526,1533,1524,1509,1532,702,1026,1559;26;F
110944;774,223,1021,1,443,1524,1608,1698,1482,1322,1388,733,376,554,1312;35;F
110969;129,192;45;M
111100;741,1322,1624,774,1604,451,1526,443,1509,1532,1468,265,1559,13,1451;45;M
111146;451,826,1110,1344,443,1509,1482,1388,1328,16,1468,376,1559,3,1451;32;M
111167;265,16,702,1700,1581,1416,1021,1526,1261,1524,1509,1532,1026,1359,1559;42;M
111186;211,1581,1332,834,268,828,1468,1608,265,1559,1441,1434,1510,1384,140;20;F
111226;1624,1338,129,834,702,268,1633,1119,173,174,3,1482;30;M
111266;826,1110,443,988,1509,174,1468,16,1633,22,376,265,3,13,1451;69;F
111303;443,268,373,394,1581;20;F
111320;443,173,1110,1624,223,1706,1482,1347,1328,1510,140,382,512,1700,408;74;M
111337;1330,451,1328,24,1604,1526,1322,1509,1532,16,1468,1559,1314;34;M
111392;13,140,586,984,1322,1,173,1388,776,1482,443,376,268,16,3;35;M
111432;451,1388;30;M
111433;1470;44;F
111450;268,3,733,1330,1706,1347,1344,1468,1624,774,1110,443,24,1451,13;55;M
111465;984,13,1451,1434,140,1517,741,124,702,24;31;M
111466;451,1526,1322,173,1581,1524,702,1328,1359,16,1468,22,2,13,140;42;F
111472;173,556,124,1347,174,24,16,1468,192,376,394,1441,1470,13,1510;37;F
111496;1524,1526,982,1261;40;M
111497;917,1322,1325,1,129,23,1581,1482,1026,373,268,16,1633,192,1510;57;F
111507;1325,1581,1344,443,268,16,1633,376,394,2,1441,3,13,1510,140;29;M
111510;443,1487,1451,140,408,896,1295,1581,1322,1261,568,584,373,16,1468;17;F
111544;1624,776,1509,1482,1347,1328,24,16,1633,1468,3,13,1451,140;26;F
111548;1325,1322,1526,451,1517,1119,1021,1509,36,1328,174,16,265,1314,1510;34;M
111576;16;25;M
111631;1119,17,1604,1624,774,223,451,1482,373,16,22,376,394,1314,1441;44;F
111659;834,36,1532,1700,1026,1328,373,1359,174,1468,1451,1434,1510,1384,586;37;F
111712;774,443,1482,1633,376,1314,140;34;M
111732;16,265,13,1434,129,1,1119,1517,1604,1021,1524,1330,1261,1328,1359;35;F
111740;1,451,1624,1325,268,16,1468,376,13,1451,1510,382,1700,512,408;17;M
111754;1604,774,1322,1509,24,1468,1434,1624,1526,1261,1328,16,265,1451;49;M
111794;776,834,702,443,1517,774,1,129,173,1344,1328,268,174,376,1510;34;F
111798;13,1532,1526,982,1434,1330,1509,1021,1261,443,1328,1524,1700,1026,1359;36;M
111815;1026,1322,1,23,982,776,834,1482,1700,1633,1468,13,1434,1510,140;15;F
111832;1532,1347,24,192,140,408,1524,1700,1119,1526,1509,1328,16,1468,1314;30;F
111833;174,140,1526,1021,1604,1624,129,1110,173,1533,1509,16,1468,265,1434;76;F
111858;140,451,1119,774,1624,17,1021,1526,129,1533,1524,1509,1532,1700,1559;35;F
111955;1624,774,1526,1322,741,776,1482,124,1328,1359,24,16,1468,1434,140;35;M
111961;16,1470;36;M
111966;1482,16,1468,140,1434,13,1559,1532,1509,1524,1533,982,1322,1526,223;34;M
111974;1624,1604,741,776,1482,124,1347,24,16,1468,1314,13,1451;31;M
112015;1604,1624,376,776,1482,36,1700,1698,174,16,1633,1468,22,1314,13;37;F
112037;917,173,982,1110,1706,741,1325,1624,1338,1,988,394,16,1468,376;37;M
112048;17,982,863,865,984,1119,451,1470,1384,140,1110,1344,1332,268,192;50;M
112071;1624,17,774,451,826,1344,443,1347,268,550,733,24,1468,13,140;26;M
112094;1526,982,1524,1261;41;F
112110;1624,1261,659,550,1470,554;32;F
112115;834,1482,124,1487,702,373,268,16,1468,22,394,3,13,1451,1434;43;F
112117;1526,1524,776,1509,1482,1532,702,373,268,1468,265,394,1559,1434;39;F
112141;1510,1434,13,2,376,16,24,268,702,1700,124,443,173,1,741;37;M
112156;1700,124,443,982,1322,774,1526,1338,741,1509,1532,24,16,22,1434;25;F
112163;268,3,733,1510,1451,776,17,443,140,124,741,1338,1624,1388,1468;35;M
112170;394,947,1604,451,268,1624,17,409,443,776,373,16,1468,13,1451;14;F
112224;1581,1314,16,268,1026,702,1482,776,1524,1344,982,1,1517,1021,917;32;F
112225;1526,826,1322,776,896,1509,1532,1328,373,1698,16,1633,1468,376,13;10;M
112250;1482,1347,1698,268,16,3,1624,1119,451,1261,1,1110,173,443,550;52;F
112252;1604,947,1624,140,1510,13,376,1468,1633,16,268,1347,36,776,1344;28;M
112277;982,1526,1524,1261;12;F
112283;1312,1700,223,568,917,1624,826,1581,1295,1388,373,376,1314,1441,444;44;F
112288;1338,1526,1021,451,1119,1517,1624,1,1468,376,1441,13,1451,1312,1510;27;F
112295;382,512,1344,443,1524,1700,702,1026,16,1468,1470,13,1510,408;51;F
112311;1624,1338,1325,1700,1347,16,1633,1468,376,1510;35;M
112312;17,947,1119,1330,1261,1295,1559,1441,1451,1312,1384,586;47;F
112329;1295,1332,451,1624,17,1110,23,173,1344,1700,1347,174,192,1312;41;F
112334;774,1322,1325,1581,16,1468,1434;23;M
112346;1110,1344,1314,192,16,1328,1026,1524,1581,1,1021,917,1517,36,702;32;M
112397;1533,1,1261,774,1325,1026,373,1470,917,451,826,129,1581,1332,140;41;F
112421;1119,173,129,36,268,1451,1312,1322,1325,1,1295,373,1698,174,1434;43;F
112453;1021,1261,1416,443,659,373,1359,828,550,265,1470,554,586;47;M
112454;1332,1524,776,896,1026,1328,1359,1608,22,2,1441,17,1021,1526,1509;41;F
112471;1347,16,1344,1110,826,1526,774,1604,1624,1468,1517,1021,1524,702,1026;39;M
112516;584,774,1021,1,1581,1524,1026,1359,733,16,1468,1559,1470,1451,1384;28;F
112538;174,1110,741,376,1468,1314,13,1434,140,1604,1624,774,1344,1482,16;52;F
112543;17,1624,451,1119,917,1330,1604,776,1509,1328,1510,140,586;23;M
112560;1608,394,2,1441,1434,173,776,834,1468,16,265,1314,444,1384,192;42;M
112594;774,1338,1322,382,1325,1581,36,1700,1698,268,16,1468,192,376,1441;36;M
112624;982,1526,1524,1261;2;F
112626;1624,382,995,1581,512,1524,1487,16,1633,265,444,984,408;47;M
112664;1344,1347;50;F
112669;1021,826,173,512,1524,1482,1026,702,1633,1,982,1332,22,444,984;20;M
112670;16,1468,2,1441,13,1434,1510,1624,17,774,451,173,1700,22,265;35;F
112737;826,1526,1624,774,1119,982,1332,1347,702,1633,1468,13,1434,1510,586;30;F
112740;1698,1700,1434,211,1532,988,16,1468,1526,982,1332,1509,22,265,13;41;F
112764;17,1338,211,988,834,268,733,394,984;25;M
112805;16,17,36,192,1517,917,1322,741,1468,1581,124,702,24,1434,1510;30;F
112813;451,1021,1526,129,834,702,1026,1328,1359,174,24,16,192,265,2;41;M
112816;1624,1517,443,1482,36,702,1026,1328,1359,16,1468,265,1434;33;M
112829;774,1604,1624,17,947,834,36,124,373,1698,174,1633,1468,1,556;37;F
112833;1110,1338,1624,774,1322,826,211,1581,1344,443,556,174,1633,1468,1441;48;F
112835;1700,1344,129,1,223,394,13,1312;18;F
112915;1510,1441,2,376,1468,828,1698,1487,1388,556,443,173,211,982,774;61;F
112916;1021,1526,382,1,129,1533,512,1524,1509,1532,1700,702,1026,265,1559;7;F
112961;1322,702,1434,774,174,982,1332,13;42;F
113004;1526,982,1524,1261;;M
113034;1517,124,586;40;M
113037;443,826,451,917,1624,1517,1021,1526,1325,1,1532,1700,1510,1026,1524;69;M
113057;568,741,982,443,1295,896,988,124,1700,702,24,22,984;32;F
113068;1532,373,16,1470,444,13,826,409,982,1581,1344,865,1434,408,140;32;F
113075;1624,1517,774,1526,1347,1026,702,24,16,1633,1559,13,1434,1384;33;F
113091;223,1325,1700,373,174,860,1633,1468,376,265,394,1314,1470,984,13;36;F
113092;129,556;52;M
113093;1524,124,1347,702,1026,24,16,1468,13,1510,140,36,192,394,1384;46;F
113104;1624,297,1604,774,826,1325,1110,1581,443,1332,776,1468,13,1510,1347;20;F
113120;1468,13,140,1470;46;M
113127;512,129,192,1470,1434,1510,140,702,1026,917,741,1325,982,1581,1332;27;M
113147;16,982,36,733,1,443,1624,1706,1325,702,1698,444,1451,1434,13;38;F
113148;1624,1482,1581,173,1110,1119,129,1328,1359,268,376,1559,984,1434,140;45;M
113161;1021,1526,382,1,129,1533,512,1524,1509,1532,1700,702,1026,265,1559;41;M
113188;982,1524,1526,1261;9;M
113251;1322,826,1526,1021,17,1624,776,1532,1700,373,268,16,1633,1468,22;26;M
113252;1325,1,174,17,982,867,988;64;F
113264;1314;45;F
113305;1624,1344,373,550,984,1434,223,988,554,409,1581,17,896,376,394;23;F
113312;1416,129,1533,1524,776,1509,1482,702,1026,1359,16,1468,1559,1434,140;33;F
113321;451,1624,1344,1509,1482,1532,1700,1347,1359,16,1468,376,984,1510,265;39;M
113328;1441,13,1451,1624,17,774,1,1344,443,776,1347,16,1633,1468,376;44;F
113360;1021,1526,382,1,129,1533,512,1524,1509,1532,1700,702,1026,265,1559;9;M
113376;1261;42;M
113407;1338,223,1119,1604,1624,947,1344,1332,733,192,376,394,554,13,1510;33;F
113412;1526,1261,1416,443,1524,776,1509,1532,1700,1328,268,1468,1451,1434,1510;38;M
113416;394,1119,982,556,1700,828;57;F
113425;1344,1347;16;F
113447;774,17,1604,776,1482,1700,1328,265,2,1441,13,1434,1261,451,1624;43;F
113450;1328,265,1347,443,1344,1110,1624,297,23,1482,1700,373,16,394,1510;28;F
113470;1624,1119,982,1295,1470,1021,1524,1700,702,1026,268,174,984,1312,1510;43;F
113471;1604,1624,917,17,1322,1325,1,373,1698,733,16,376,1441,1434,408;27;F
113498;1388,1295,223,568,917,1624,826,1581,1700,373,376,1314,1441,554,1312;17;M
113521;1344,1110,1,741,451,1517,17,1624,556,1347,1700,16,1468,1441,13;49;M
113529;1119,1110;22;M
113577;1624,17,584,1119,826,1322,1110,988,1532,733,1633,1468,984,13,1434;26;F
113578;1322,443,1698,1434,865,223,982,124,373,24,1633,16,1468,13,140;29;F
113585;947,17,1604,1119,1261,1328,376,265,1559,1434;36;F
113589;1441,1451,223,568,774,947,1608,1261,741,129,1295,863,36,1312,586;48;F
113628;17,1332,896,988,1700,373,1698,16,22,376,2,984,1451,1510,140;24;F
113656;1526,774,1624,1328,268,24,1633,1468,1559,1314,444,13,1451,1434,140;35;M
113660;17,1332,896,988,1700,373,1698,16,22,376,2,984,1451,1510,140;54;F
113663;1110,173,1581,1344,443,1524,659,776,1487,1347,174,16,265,1470,13;62;F
113667;1261;41;F
113704;1604,1624,1517,774,1,1110,443,1509,1532,1347,702,1026,16,1633,13;39;F
113707;443,1,1624,1517,1021,1526,1110,1344,1700,1347,702,1026,268,1633,1559;42;M
113718;947,451,1338,373,1698,22,376,1559,1441,1434,13;36;F
113744;1295,982,373,917,1322,129,1581,1359,16,1468,1608,1312,1510,140,408;36;M
113748;741,173,1344,36,24,2,1441,16,13;21;M
113821;1330,1325,1482,36,1359,826,1,1328,268,16;34;F
113830;382,3,408;52;F
113923;409,982,995,1332,1700,373,1698,860,865,22,394,444,984,586;40;M
113953;1322,1325,1,129,1524,1482,1700,702,1328,174,265,1434,140,1510,586;41;F
113989;982,1021,1517,1,1332,1524,867,36,702,1026,1698,828,1314,1441,984;43;F
113993;409,1325,1338,1021,917,947;27;M
114004;733,174,1468,192,1700,124,1325,1322,1604,1624,741,16,140,586;34;F
114024;297,917,1021,173,1533,1581,1524,1388,702,1026,1359,16,1441,1434,1384;29;M
114090;1624;32;M
114094;1021,1526,129,982,1524,1700,1026,265,3;36;F
114097;373,1624,1517,774,1021,1322,982,1581,1524,1388,702,1698,16,1470,1434;42;F
114104;1581,995,1604,1322,1325,982,1332,268,828,3;50;F
114105;1517,774,826,382,512,1633,444,984,13,408,586;40;M
114137;1510,394;29;F
114143;1434,1384,451,774,17,1526,1322,211,1344,1482,1359,1608,265,13,1510;27;F
114145;1624,1,1517,917,1322,741,1581,36,124,702,24,16,1468,13,1434;32;F
114151;443,776,865,1517,17,1698,174,24,16,1468,22,394,2,1510,192;44;M
114179;917,409,1533,896,988,1700,984,1624,1604,982,1344,1509,1532,1487,1608;65;F
114196;1509,265,13,17,1517,1021,1526,1325,1,1533,1581,1524,1359,1559,1434;29;F
114198;16,1559,1624,17,1517,774,1,443,1524,702,1026,1468,1314,13,1451;33;F
114216;774,1119,826,382,512,860,408;35;F
114226;1119,129,1581,1698,268,3,1451,586;47;F
114231;1261;13;M
114238;1624,774,1604,1325,982,1581,1344,1434,124,1347,702,16,1468,13,140;32;M
114287;1526,451,1330,1119,1604,1624,1344,1509,1482,1347,1468,192,1559,1314,13;31;M
114336;1604,17,1517,1338,741,1325,1,1524,834,124,24,16;34;M
114347;265,1434,1517,1533,1021,1,1524,702,1026;33;M
114349;443,297,1119,1330,1325,1,1110,173,1344,702,1026,1328,174,1559;11;F
114351;451,826,1706,1,1700,702,268,174,16,1468,1314,13,1434,1510,140;29;M
114354;1261;10;M
114363;1325,1,982,173,867,863,988,550,174;64;M
114376;1261;42;M
114378;394,174,173,297,1119,1110;42;F
114380;1468,265,394,1559,2,1314,1441,554,444,13,1451,1434,1510,1384,140;27;F
114454;124,1624,1604,17,917,1325,1,443,1388,16,1633,1468,3,13,1434;24;F
114533;1624,1110,1524,1700,702,1328,1633,1468,376,265,1384;37;F
114547;24,1330,211,16,1468,265,1559,13,1624,1604,774,451,1322,776,1328;32;M
114568;1119,1110;28;F
114570;1322,1119,1110;28;M
114588;774,1698,1559,1441,1510,1384,1021,1526,173,443,1524,1509,1482,1532,1026;74;F
114590;860,1624,451,947,409,129,211,1482,124,1700,174,865,394,1559,1441;42;F
114601;1451,1510,1021,1526,1633,1608,1441,1468,1698,1700,443,1110,1624,1338,1344;57;F
114629;443,13,140,1624,774,1119,173,1581,1509,1532,1347,373,1698,16,1468;28;F
114664;265,1468,1110,140,1451,13,776,443,1,1325,1322,1021,451,774,1624;29;M
114671;1,1295,1482,124,1700,702,1026,373,1698,24,16,394,1633,1468,1434;28;F
114696;982,995,443,1524,1482,1532,1347,394,1624,1604,1468,444,984,13,1451;20;F
114712;1325,1322,1021,1330,917,1624,774,1526,1509,1532,1328,16,1468,265,1559;27;M
114716;1347,1559,192,13,1624,297,774,223,1,1110,443,988,1468,1314,1510;31;F
114733;382,512,408;38;F
114734;741,1110,1344,13,1624,774,443,1468,1633,16,1451;10;F
114735;1347,1624,774,1,1344,443,776,24,16,1633,1468,376,1314,13,1451;17;M
114767;382,512,3,408;57;M
114769;1624,776,1482,1700,268,16,1633,1468,1451;33;M
114806;1338,1322,1581,1344,776,124,1347,1468,1624,1604,741,1482,16;26;M
114845;1517,1119;40;F
114867;1,774,1624,124,1347,702,16,1633,1468,376,13,1451,1434,1510,140;35;M
114912;2,826,211,1468,17,451,1110,982,867,988,1700,373,1633,444,984;51;M
114938;995,444,984,2,1468,1633,373,1700,988,865,17,451,1110,982,211;13;F
114952;826,1468,17,451,1110,982,211,867,988,1700,373,1633,865,2,984;13;M
114962;1517,1021,129,1332,1524,702,1026,1468,1608,22,376,265,394,1314,1434;6;M
114987;1021,1526,1110,1344,1524,1509,1532,1347,1026,373,16,1468,1559,1441;33;F
114993;24,16,1633,1468,13,1451,1026,702,36,1482,776,1524,1,774,1517;33;F
115000;1325,1,129,1344,1332,776,1482,1700,702,1328,174,265,1434,1510,140;11;F
115003;554,129,834,586;44;M
115021;382,512,860,1468,444,408;9;M
115028;702,1328,24,1633,13,140,1119,1526,1344,776,1532,16,1468,1559,1451;41;F
115063;297,17,947,1624,443,988,1482,373,16,1633,376,394,984,13;29;F
115070;1,129,982,1344,1332,834,1700,1698,865,376,265,554,444,984,1434;11;F
115127;1021,1526,1524,988,1509,1482,702,268,174,16,1633,1468,265,1559,13;70;F
115151;140,1332,268,1468,376,3;46;M
115166;1021,1526,1322,1,982,1524,1509,1532,1700,1026,1359,265,1559,1434,1384;39;M
115234;1510,1434,1451,1468,268,1328,1700,1532,1509,776,1524,443,1416,1261,1526;38;F
115251;1624,17,23,1344,988,702,733,1468,376,394,2,13,1434;35;F
115262;776,584,1604,297,741,443,124,1700,17,1338,1322,3,140;25;M
115266;1517,1021,129,1332,1524,702,1026,1468,1608,22,376,265,394,1314,1434;3;F
115278;382,512,408;10;M
115304;1624,1325,1,23,867,988,36,702,16,1633,1468,1314,13,1510;34;M
115318;1325,23,3,1434,776,16,1633,1468,1314,774,13,1624,1482,268,1510;43;M
115327;382,512,408;49;F
115329;382,512,13,408;7;F
115337;1624,1706,1325,173,1524,174,1633,1468,13,776,1581,826,451,16,1434;31;M
115353;1119,1604,1509,443,1344,1110,376,1517,1021,1,1524,36,702,1026,13;32;M
115372;1328,373,174,16,1468,265,1434,1384,586;25;M
115443;774,1110,1344,443,776,1482,1700,1347,1698,268,16,1468,22,394,13;52;F
115444;826,984,382,982,512,408;40;M
115454;451,1633,1470;41;F
115504;1624,774,1526,1110,1344,443,776,1532,1347,1328,268,24,16,265,1510;49;M
115506;1532,1328,24,1633,1468,265,1559,1314,13,1451,1110,1517,1524,1021,1026;24;M
115514;17,741,1,982,1332,863,124,1700,702,373,1698,268,22,984,1510;33;M
115521;1517,1,982,995,1524,988,702,1026,1468,444,984,13;35;F
115523;1322,1526,584,1434,16,13,24,140,124,17,741,376,443;26;M
115528;17,1,834,1482,373,1698,174,1633,376,394,1441;32;F
115545;1328,1468,265,13,1451,1434,1510,140,1119,774,982,174,129,1344,1332;9;F
115554;297,451,1604,1119,173,174;40;M
115556;36,1700,1026,268,174,16,1633,1468,376,1441,3,13,1434,1312,1384;28;M
115577;826,741,1344,443,1509,1532,1347,268,24,1633,1468,1314,3,13,1451;47;F
115677;1624,1517,741,982,1344,1332,896,124,1700,702,24,1468,865,22,1434;40;M
115678;36,124,1347,702,174,24,16,1633,1468,192,376,394,1314,13,1510;36;F
115718;1524,1700,1328,1698,16,1633,13,1451,1434,1510,140;24;F
115721;382,512,408;8;F
115723;22,265,2,1470,984,140,1314,826,173,1347,174,16,376,1441,13;33;M
115725;1347,36,834,896,1332,1344,995,982,1110,129,223,568,1119,947,1604;6;F
115731;451,1526,741,1325,982,173,995,1332,834,1509,1608,394,1559,984,586;40;M
115751;1468,16,174,1026,702,1509,1524,1526,1021,451,1119,1517,17,1604,1624;77;M
115911;1526,774,1532,24,16,1468,13,1624,1325,1110,1347,1633,3,1451,140;34;M
115914;451,223,568,17,1330,1332,1295,896,36,1700,373,22,376,1312,1510;29;F
115968;1,129,1110,173,443,556,1332,834,373,1698,174,3,1451,1434,140;41;F
116227;1581,1510,1482,1451,1359,1322,1325,982,834,1328,1332,265,140,13;70;F
116232;192;70;F
116236;1700,1698,1608,995,984,982,834,1332,865,376,733,173,129,192,22;66;F
116238;1700,1698,1608,995,984,982,834,1332,865,376,733,173,129,192,22;67;M
116242;1441,1322,1314,774,1110,174,173,124,192,23,17;65;F
116244;1624,1509,1510,1468,1434,1359,988,982,1347,1344,408,265,140,16,13;77;M
116249;1325,192;44;F
116263;192;65;M
116264;192;67;F
99999987890;556,376,17,774,1487,394,741,129,173,373,174,1441,1559,1330;37;F